
import type { LucideIcon } from 'lucide-react';

export type NavItem = {
  title: string;
  href: string;
  icon: LucideIcon;
  label?: string;
};

export type ContentType = 'pdf' | 'video' | 'audio' | 'image' | 'software' | 'service';

export type ContentItem = {
  id: string;
  title: string;
  description: string;
  price: number;
  type: ContentType;
  thumbnail: string;
  previewUrl: string;
  fullContentUrl: string;
  creatorId: string;
  creatorName: string;
  salesCount: number;
  createdAt: string;
  isLocked?: boolean;
};

export type Transaction = {
  id: string;
  userId: string;
  contentId?: string;
  amount: number;
  type: 'purchase' | 'payout' | 'deposit';
  status: 'pending' | 'completed' | 'failed';
  paymentMethod: string;
  timestamp: string;
  description?: string;
};

export type UserWallet = {
  balance: number;
  currency: string;
};

export type Notification = {
  id: string;
  title: string;
  description: string;
  timestamp: Date;
  read: boolean;
  variant?: 'default' | 'destructive';
};
