
import type { ContentItem, Transaction, UserWallet } from './types';

export const currentUserWallet: UserWallet = {
  balance: 45800,
  currency: 'TZS'
};

export const contentItems: ContentItem[] = [
  {
    id: 'c1',
    title: 'Bongo Flava Pro Drum Kit (TZ Pack 2024)',
    description: 'The exact kicks, snares, and percussion used in Dar es Salaam\'s biggest hits. Unlock the authentic Tanzanian sound.',
    price: 8500,
    type: 'audio',
    thumbnail: 'https://picsum.photos/seed/bongo/600/400',
    previewUrl: 'https://picsum.photos/seed/bongo-blur/600/400',
    fullContentUrl: 'https://example.com/drum-kit.zip',
    creatorId: 'u1',
    creatorName: 'Producer S2Kizzy',
    salesCount: 1420,
    createdAt: '2023-10-01T10:00:00Z',
  },
  {
    id: 'c2',
    title: 'Form 4 Physics Practical Guide (Necta Verified)',
    description: 'Complete step-by-step guide for Necta practicals. Boost your score with verified methods and sample answers.',
    price: 1500,
    type: 'pdf',
    thumbnail: 'https://picsum.photos/seed/edu-notes/600/400',
    previewUrl: 'https://picsum.photos/seed/edu-notes-blur/600/400',
    fullContentUrl: 'https://example.com/physics-practical.pdf',
    creatorId: 'u2',
    creatorName: 'Ticha Mussa',
    salesCount: 3450,
    createdAt: '2023-11-15T14:30:00Z',
  },
  {
    id: 'c3',
    title: 'Modern Swahili House Plan (3 Bedroom)',
    description: 'Detailed architectural drawings optimized for Tanzanian plot sizes and coastal climate. Ready for submission.',
    price: 150000,
    type: 'pdf',
    thumbnail: 'https://picsum.photos/seed/house/600/400',
    previewUrl: 'https://picsum.photos/seed/house-blur/600/400',
    fullContentUrl: 'https://example.com/house-plan.pdf',
    creatorId: 'u3',
    creatorName: 'Kazi Architect',
    salesCount: 45,
    createdAt: '2023-12-05T09:15:00Z',
  },
  {
    id: 'c4',
    title: 'Python for Beginners Swahili Course',
    description: 'Jifunze kodingi kwa lugha ya Kiswahili kuanzia mwanzo kabisa. Mwalimu anafundisha kwa lugha yetu.',
    price: 5000,
    type: 'video',
    thumbnail: 'https://picsum.photos/seed/code/600/400',
    previewUrl: 'https://picsum.photos/seed/code-blur/600/400',
    fullContentUrl: 'https://example.com/python-swahili.mp4',
    creatorId: 'u4',
    creatorName: 'Elimu Tech',
    salesCount: 56,
    createdAt: '2024-01-10T11:45:00Z',
  }
];

export const transactionHistory: Transaction[] = [
  {
    id: 't1',
    userId: 'current-user',
    contentId: 'c1',
    amount: -8500,
    type: 'purchase',
    status: 'completed',
    paymentMethod: 'M-Pesa',
    timestamp: '2024-02-15T09:30:00Z',
    description: 'Bongo Flava Pack'
  },
  {
    id: 't2',
    userId: 'current-user',
    amount: 50000,
    type: 'deposit',
    status: 'completed',
    paymentMethod: 'Tigo Pesa',
    timestamp: '2024-02-14T15:00:00Z',
    description: 'Wallet Top-up'
  }
];
