'use client';

import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Progress } from '@/components/ui/progress';
import { ShieldCheck, Target, TrendingDown } from 'lucide-react';

interface ChallengeOverviewProps {
  profitTarget: number;
  maxDrawdown: number;
  dailyDrawdown: number;
  currentProfit: number;
  currentMaxDrawdown: number;
  currentDailyDrawdown: number;
}

export function ChallengeOverview({
  profitTarget,
  maxDrawdown,
  dailyDrawdown,
  currentProfit,
  currentMaxDrawdown,
  currentDailyDrawdown,
}: ChallengeOverviewProps) {
  const profitProgress = (currentProfit / profitTarget) * 100;
  const maxDrawdownProgress = (currentMaxDrawdown / maxDrawdown) * 100;
  const dailyDrawdownProgress = (currentDailyDrawdown / dailyDrawdown) * 100;

  const formatCurrency = (value: number) =>
    new Intl.NumberFormat('en-TZ', { style: 'currency', currency: 'TZS', minimumFractionDigits: 0 }).format(value);

  return (
    <Card>
      <CardHeader>
        <CardTitle className="font-headline flex items-center gap-2">
          <ShieldCheck className="h-6 w-6 text-accent" />
          Challenge Progress
        </CardTitle>
      </CardHeader>
      <CardContent className="space-y-6">
        <div>
          <div className="flex justify-between items-center mb-1">
            <p className="text-sm font-medium flex items-center gap-2">
              <Target className="h-4 w-4" />
              Profit Target
            </p>
            <p className="text-sm">
              {formatCurrency(currentProfit)} / <span className="text-muted-foreground">{formatCurrency(profitTarget)}</span>
            </p>
          </div>
          <Progress value={profitProgress} />
        </div>
        <div>
          <div className="flex justify-between items-center mb-1">
            <p className="text-sm font-medium flex items-center gap-2">
              <TrendingDown className="h-4 w-4" />
              Max Drawdown
            </p>
            <p className="text-sm">
              {formatCurrency(currentMaxDrawdown)} / <span className="text-muted-foreground">{formatCurrency(maxDrawdown)}</span>
            </p>
          </div>
          <Progress value={maxDrawdownProgress} indicatorClassName="bg-destructive" />
        </div>
        <div>
          <div className="flex justify-between items-center mb-1">
            <p className="text-sm font-medium flex items-center gap-2">
              <TrendingDown className="h-4 w-4" />
              Daily Drawdown
            </p>
            <p className="text-sm">
              {formatCurrency(currentDailyDrawdown)} / <span className="text-muted-foreground">{formatCurrency(dailyDrawdown)}</span>
            </p>
          </div>
          <Progress value={dailyDrawdownProgress} indicatorClassName="bg-destructive" />
        </div>
      </CardContent>
    </Card>
  );
}
