
'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { 
  Compass, 
  LayoutDashboard, 
  PlusCircle, 
  Wallet, 
  History, 
  Settings,
  Zap,
  Code,
  TrendingUp,
  Store
} from 'lucide-react';
import { cn } from '@/lib/utils';
import type { NavItem } from '@/lib/types';
import { Button } from './ui/button';

const navItems: NavItem[] = [
  { title: 'Dashboard', href: '/dashboard', icon: LayoutDashboard },
  { title: 'Marketplace', href: '/explore', icon: Compass },
  { title: 'My Storefront', href: '#', icon: Store },
  { title: 'Monetize New', href: '/create', icon: PlusCircle },
  { title: 'Wallet', href: '/wallet', icon: Wallet },
  { title: 'Developer API', href: '/developer', icon: Code },
  { title: 'Analytics', href: '#', icon: TrendingUp },
];

export function AppSidebar() {
  const pathname = usePathname();

  return (
    <div className="flex h-full max-h-screen flex-col gap-2">
      <div className="flex h-16 items-center border-b px-4 lg:px-6">
        <Link href="/" className="flex items-center gap-2 font-bold font-headline">
          <div className="bg-primary text-white p-1.5 rounded-lg shadow-sm">
            <Zap className="h-5 w-5 fill-white" />
          </div>
          <span className="text-xl">Lipia<span className="text-primary">/</span></span>
        </Link>
      </div>
      <div className="flex-1 overflow-auto py-4">
        <nav className="grid items-start px-2 text-sm font-medium lg:px-4 gap-2">
          {navItems.map((item) => (
            <Link key={item.title} href={item.href}>
              <Button
                variant={pathname === item.href ? 'default' : 'ghost'}
                className={cn('w-full justify-start rounded-2xl h-11', {
                  'bg-primary text-white hover:bg-primary/90 shadow-lg shadow-primary/10': pathname === item.href,
                })}
              >
                <item.icon className={cn('mr-3 h-5 w-5', pathname === item.href ? 'text-white' : 'text-muted-foreground')} />
                {item.title}
              </Button>
            </Link>
          ))}
        </nav>
      </div>
      <div className="mt-auto p-4 border-t space-y-4">
          <div className="bg-primary/5 rounded-2xl p-4 border border-primary/10">
            <p className="text-xs font-bold text-primary uppercase mb-1">MaaS Tier</p>
            <p className="text-sm font-bold">Growth Infrastructure</p>
            <div className="mt-2 h-1.5 w-full bg-primary/10 rounded-full overflow-hidden">
                <div className="h-full w-3/4 bg-primary"></div>
            </div>
            <p className="text-[10px] text-primary/70 mt-1">75% of transaction quota used</p>
          </div>
          <Link href="/settings">
             <Button variant="ghost" className="w-full justify-start rounded-xl h-10">
                <Settings className="mr-3 h-5 w-5 text-muted-foreground" />
                Settings
             </Button>
          </Link>
      </div>
    </div>
  );
}
