
import Link from 'next/link';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';
import { ArrowRight, Zap, Wallet, ShieldCheck, Sparkles, Code, Layout, TrendingUp, Lock, Globe } from 'lucide-react';
import Image from 'next/image';
import { cn } from '@/lib/utils';

export default function Home() {
  return (
    <div className="flex flex-col min-h-screen">
      <header className="container mx-auto px-4 sm:px-6 lg:px-8 py-6 flex justify-between items-center z-50">
        <div className="flex items-center gap-2">
           <div className="bg-primary text-white p-2 rounded-xl shadow-lg shadow-primary/20">
             <Zap className="h-6 w-6 fill-white" />
           </div>
          <h1 className="text-2xl font-bold font-headline text-foreground tracking-tight">Lipia<span className="text-primary">/</span></h1>
        </div>
        <nav className="hidden md:flex items-center gap-8">
           <Link href="/explore" className="text-sm font-semibold hover:text-primary transition-colors">Marketplace</Link>
           <Link href="#" className="text-sm font-semibold hover:text-primary transition-colors">Paywall API</Link>
           <Link href="#" className="text-sm font-semibold hover:text-primary transition-colors">Pricing</Link>
        </nav>
        <div className="flex items-center gap-4">
          <Link href="/dashboard" passHref>
            <Button variant="ghost" className="font-semibold rounded-xl">Login</Button>
          </Link>
          <Link href="/dashboard" passHref>
            <Button className="bg-primary hover:bg-primary/90 text-white rounded-xl shadow-lg shadow-primary/20 px-6 font-bold h-11">
              Start Monetizing
            </Button>
          </Link>
        </div>
      </header>

      <main className="flex-grow">
        {/* HERO SECTION - Infrastructure Positioning */}
        <section className="relative pt-20 pb-32 md:pt-32 md:pb-48 overflow-hidden">
           <div className="absolute inset-0 bg-[radial-gradient(circle_at_top_right,rgba(37,99,235,0.08),transparent)]"></div>
           <div className="absolute top-1/4 -left-20 w-96 h-96 bg-primary/5 rounded-full blur-3xl opacity-50"></div>
          
          <div className="container mx-auto px-4 sm:px-6 lg:px-8 text-center relative z-10">
            <div className="inline-flex items-center gap-2 px-4 py-1.5 rounded-full bg-primary/10 text-primary text-sm font-bold mb-8 animate-in fade-in slide-in-from-bottom-4 duration-700">
              <Globe className="h-4 w-4" /> <span>Monetization Infrastructure for East Africa</span>
            </div>
            
            <h2 className="text-5xl md:text-8xl font-bold font-headline text-foreground tracking-tighter max-w-5xl mx-auto leading-[0.9] mb-10">
              Lock Content. <br />
              <span className="text-primary">Print Revenue.</span>
            </h2>
            
            <p className="max-w-2xl mx-auto text-xl text-muted-foreground leading-relaxed mb-12">
              Lipia/ is the SaaS paywall infrastructure enabling creators, schools, and media houses to monetize digital assets via instant mobile money triggers.
              <span className="block font-bold text-foreground mt-4">Plug-and-play monetization for the digital economy.</span>
            </p>

            <div className="flex flex-col sm:flex-row justify-center gap-4 mb-24">
              <Link href="/dashboard" passHref>
                <Button size="lg" className="px-12 h-16 rounded-2xl text-xl font-bold bg-primary hover:bg-primary/90 shadow-2xl shadow-primary/30 transition-all hover:scale-105">
                  Get Started Free
                </Button>
              </Link>
              <Link href="#" passHref>
                <Button size="lg" variant="outline" className="px-12 h-16 rounded-2xl text-xl font-bold border-2 hover:bg-primary/5 transition-all">
                  View API Docs
                </Button>
              </Link>
            </div>

            {/* PRODUCT SHOWCASE - The Curiosity Trigger */}
            <div className="relative max-w-6xl mx-auto rounded-[3rem] p-1 bg-gradient-to-br from-primary/20 to-primary/5 shadow-2xl overflow-hidden group">
                <div className="bg-white rounded-[2.8rem] overflow-hidden relative">
                    <div className="absolute inset-0 z-20 flex flex-col items-center justify-center p-8">
                        <div className="bg-white/40 backdrop-blur-2xl p-10 rounded-[2.5rem] border border-white/40 shadow-2xl space-y-6 max-w-lg text-center">
                            <div className="h-20 w-20 bg-primary rounded-3xl flex items-center justify-center mx-auto shadow-xl transform group-hover:rotate-12 transition-transform duration-500 pulse-glow">
                                <Lock className="h-10 w-10 text-white" />
                            </div>
                            <div className="space-y-2">
                                <h3 className="text-3xl font-bold font-headline tracking-tight text-foreground">Curiosity Engine</h3>
                                <p className="text-muted-foreground font-medium">Blurred previews trigger an impulsive "Mental Itch." Use our UI widgets to convert curiosity into instant revenue.</p>
                            </div>
                            <Button className="w-full h-14 rounded-2xl bg-primary text-white font-bold text-lg">
                               Lipia 1,000 TZS to Reveal
                            </Button>
                        </div>
                    </div>
                    <Image 
                        src="https://picsum.photos/seed/lipia-saas/1200/800" 
                        alt="Lipia Dashboard Preview" 
                        width={1200}
                        height={800}
                        className="w-full opacity-60 blur-[35px] scale-105 object-cover aspect-video"
                    />
                </div>
            </div>
          </div>
        </section>

        {/* MaaS MODULES */}
        <section className="py-32 bg-white">
          <div className="container mx-auto px-4 sm:px-6 lg:px-8">
            <div className="text-center mb-24 max-w-3xl mx-auto space-y-4">
              <h3 className="text-4xl md:text-5xl font-bold font-headline tracking-tight">Monetization-as-a-Service</h3>
              <p className="text-xl text-muted-foreground">Stop building payment logic. Start scaling your earnings.</p>
            </div>
            
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
              {[
                { icon: Code, title: "Paywall API", desc: "Lock any file, link, or digital tool with a single API call.", color: "bg-blue-50 text-blue-600" },
                { icon: Layout, title: "Unlock Widgets", desc: "Drop-in UI components for blur-to-reveal and pay-per-view.", color: "bg-orange-50 text-orange-600" },
                { icon: Wallet, title: "Wallet Ledger", desc: "Automated revenue management, splits, and creator payouts.", color: "bg-green-50 text-green-600" },
                { icon: TrendingUp, title: "Growth Analytics", desc: "Track conversions, sales velocity, and fan retention metrics.", color: "bg-purple-50 text-purple-600" },
              ].map((mod, idx) => (
                <div key={idx} className="bg-card p-10 rounded-[2.5rem] border hover:shadow-xl transition-all group">
                  <div className={cn("h-16 w-16 rounded-2xl flex items-center justify-center mb-8 transition-transform group-hover:scale-110", mod.color)}>
                    <mod.icon className="h-8 w-8" />
                  </div>
                  <h4 className="text-2xl font-bold mb-4">{mod.title}</h4>
                  <p className="text-muted-foreground leading-relaxed">{mod.desc}</p>
                </div>
              ))}
            </div>
          </div>
        </section>

        {/* CTA - THE SaaS OFFER */}
        <section className="py-32">
            <div className="container mx-auto px-4 sm:px-6 lg:px-8">
                <div className="lipia-gradient rounded-[4rem] p-16 md:p-32 text-center text-white relative overflow-hidden shadow-[0_40px_80px_rgba(37,99,235,0.2)]">
                    <div className="absolute top-0 right-0 w-[600px] h-[600px] bg-white/10 rounded-full blur-[120px] -mr-64 -mt-64"></div>
                    <div className="relative z-10 max-w-4xl mx-auto space-y-10">
                        <h3 className="text-5xl md:text-7xl font-bold font-headline tracking-tighter leading-none">Ready to automate your monetization?</h3>
                        <p className="text-2xl text-white/90 font-medium italic">Join the next generation of African digital businesses scaling with Lipia/ Infrastructure.</p>
                        <div className="flex flex-col sm:flex-row justify-center gap-6 pt-6">
                            <Link href="/dashboard" passHref>
                                <Button size="lg" className="bg-white text-primary hover:bg-white/90 h-20 px-16 rounded-[2rem] text-2xl font-bold shadow-2xl">
                                    Start Now
                                </Button>
                            </Link>
                            <Link href="#" passHref>
                                <Button size="lg" variant="outline" className="border-2 border-white text-white hover:bg-white/10 h-20 px-16 rounded-[2rem] text-2xl font-bold">
                                    API Docs
                                </Button>
                            </Link>
                        </div>
                    </div>
                </div>
            </div>
        </section>
      </main>

      <footer className="bg-card border-t py-24">
        <div className="container mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid grid-cols-1 md:grid-cols-4 gap-16 mb-20 text-center md:text-left">
                <div className="col-span-1 md:col-span-2 space-y-8">
                    <div className="flex items-center gap-2 justify-center md:justify-start">
                        <div className="bg-primary text-white p-1.5 rounded-lg">
                            <Zap className="h-6 w-6" />
                        </div>
                        <span className="text-3xl font-bold font-headline tracking-tight text-foreground">Lipia<span className="text-primary">/</span></span>
                    </div>
                    <p className="text-xl text-muted-foreground max-w-md leading-relaxed">
                        The Paywall & Unlock Infrastructure for East Africa. Built to power the next million creators and digital businesses.
                    </p>
                </div>
                <div className="space-y-6">
                    <h6 className="font-bold text-lg">Infrastructure</h6>
                    <ul className="space-y-4 text-muted-foreground font-medium text-lg">
                        <li><Link href="#" className="hover:text-primary">Paywall API</Link></li>
                        <li><Link href="#" className="hover:text-primary">Unlock Widgets</Link></li>
                        <li><Link href="#" className="hover:text-primary">Wallet Ledger</Link></li>
                        <li><Link href="#" className="hover:text-primary">SaaS Tiers</Link></li>
                    </ul>
                </div>
                <div className="space-y-6">
                    <h6 className="font-bold text-lg">Platform</h6>
                    <ul className="space-y-4 text-muted-foreground font-medium text-lg">
                        <li><Link href="/explore" className="hover:text-primary">Marketplace</Link></li>
                        <li><Link href="#" className="hover:text-primary">Storefronts</Link></li>
                        <li><Link href="#" className="hover:text-primary">Creator Payouts</Link></li>
                        <li><Link href="#" className="hover:text-primary">Support</Link></li>
                    </ul>
                </div>
            </div>
            <div className="pt-12 border-t flex flex-col md:flex-row justify-between items-center gap-6 text-muted-foreground font-medium">
                <p>&copy; {new Date().getFullYear()} Lipia/ Infrastructure. Built in Dar es Salaam.</p>
                <div className="flex items-center gap-2">
                    <ShieldCheck className="h-5 w-5 text-green-500" />
                    <span>M-Pesa / Tigo Pesa Secured Checkout</span>
                </div>
            </div>
        </div>
      </footer>
    </div>
  );
}
