import { TradeTerminal } from '@/components/trade-terminal';
import { Suspense } from 'react';
import { Skeleton } from '@/components/ui/skeleton';

export default function TradeTerminalPage() {
  return (
    <div>
      <div className="mb-8">
        <h1 className="text-3xl font-bold font-headline">Trade Terminal</h1>
        <p className="text-muted-foreground">
          A real-time view of the trade simulation engine.
        </p>
      </div>
      <Suspense fallback={<Skeleton className="h-96 w-full" />}>
        <TradeTerminal />
      </Suspense>
    </div>
  );
}
