import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from '@/components/ui/table';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { leaderboardData } from '@/lib/data';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';
import Image from 'next/image';

export default function LeaderboardPage() {
  const formatCurrency = (value: number) =>
    new Intl.NumberFormat('en-TZ', { style: 'currency', currency: 'TZS', minimumFractionDigits: 0 }).format(value);

  return (
    <Card>
      <CardHeader>
        <CardTitle className="font-headline text-3xl">Leaderboard</CardTitle>
        <CardDescription>Top performing traders on the platform.</CardDescription>
      </CardHeader>
      <CardContent>
        <Table>
          <TableHeader>
            <TableRow>
              <TableHead className="w-[80px]">Rank</TableHead>
              <TableHead>Trader</TableHead>
              <TableHead>Win Rate</TableHead>
              <TableHead className="text-right">Profit</TableHead>
            </TableRow>
          </TableHeader>
          <TableBody>
            {leaderboardData.map((trader) => (
              <TableRow key={trader.rank}>
                <TableCell>
                  <Badge variant={trader.rank <= 3 ? "default" : "secondary"} className={
                    trader.rank === 1 ? "bg-primary text-primary-foreground" : 
                    trader.rank === 2 ? "bg-gray-400 text-white" : 
                    trader.rank === 3 ? "bg-amber-600 text-white" : ""
                  }>
                    #{trader.rank}
                  </Badge>
                </TableCell>
                <TableCell>
                  <div className="flex items-center gap-3">
                    <Avatar>
                      <AvatarImage src={`https://i.pravatar.cc/40?u=${trader.name}`} />
                      <AvatarFallback>{trader.name.charAt(0)}</AvatarFallback>
                    </Avatar>
                    <div className="font-medium">{trader.name}</div>
                    <Image data-ai-hint="flag" src={`https://flagcdn.com/w20/${trader.country.toLowerCase()}.png`} width={20} height={15} alt={`${trader.country} flag`} />
                  </div>
                </TableCell>
                <TableCell>{trader.winRate}%</TableCell>
                <TableCell className="text-right font-semibold text-green-600">{formatCurrency(trader.profit)}</TableCell>
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </CardContent>
    </Card>
  );
}
