# **App Name**: Swahili Trader

## Core Features:

- User Onboarding: Allow users to sign up via email and phone, with 2FA options for enhanced security.
- Dashboard: Display a dashboard with an overview of the user's simulated trading account, including balance, profit/loss, and challenge progress.
- Challenge Simulator: Enable users to participate in simulated trading challenges with real-market data and predefined rules. Rules enforcement will be handled as a tool by an LLM.
- Progress Notifications: Provide users with notifications on their challenge progress, including alerts on drawdown breaches and profit targets achieved.
- Payment Simulation: Simulate M-Pesa, Tigo Pesa, and Airtel Money, enabling the 'purchase' of a challenge.
- Leaderboard: Create a leaderboard displaying top-performing traders to foster engagement and competition.
- Swahili Challenge Names: Use an LLM to ensure culturally relevant names for each challenge

## Style Guidelines:

- Primary color: Warm gold (#FFD700) to evoke prosperity and success, aligning with the trading theme. 
- Background color: Desaturated gold (#F5F5DC) to provide a subtle, sophisticated backdrop that doesn't distract from the data.
- Accent color: Copper (#B87333) as an analogous color, for highlighting key interactive elements and important information.
- Font pairing: 'Poppins' (sans-serif) for headlines to give a precise contemporary feel and 'PT Sans' (sans-serif) for body text, to balance modernity with readability. 
- Use financial and gamified icons. Currency symbols (Tanzanian Shilling), charts, trophies, and badges in a flat design style to complement the app's modern look.
- Clean, data-driven layout with a focus on readability and user experience. Use of cards and well-defined sections to organize information.
- Subtle animations for challenge progress and payout status to add a touch of gamification and visual feedback.