'use client';

import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { ChartContainer, ChartTooltip, ChartTooltipContent } from '@/components/ui/chart';
import { Area, AreaChart, CartesianGrid, XAxis, YAxis } from 'recharts';

interface EquityChartProps {
  data: { date: string; equity: number }[];
}

const chartConfig = {
  equity: {
    label: 'Equity',
    color: 'hsl(var(--chart-1))',
  },
};

export function EquityChart({ data }: EquityChartProps) {
    const formatCurrency = (value: number) =>
    new Intl.NumberFormat('en-TZ', { currency: 'TZS', style: 'currency' }).format(value);

  return (
    <Card>
      <CardHeader>
        <CardTitle className="font-headline">Equity Curve</CardTitle>
        <CardDescription>Your account equity over time.</CardDescription>
      </CardHeader>
      <CardContent>
        <ChartContainer config={chartConfig} className="h-64 w-full">
          <AreaChart data={data} margin={{ top: 5, right: 20, left: 20, bottom: 5 }}>
            <CartesianGrid strokeDasharray="3 3" vertical={false} />
            <XAxis dataKey="date" tickLine={false} axisLine={false} tickMargin={8} tickFormatter={(value) => value.slice(5)} />
            <YAxis
              tickLine={false}
              axisLine={false}
              tickMargin={8}
              tickFormatter={(value) => formatCurrency(Number(value))}
            />
            <ChartTooltip
              cursor={false}
              content={<ChartTooltipContent 
                labelFormatter={(label, payload) => payload?.[0]?.payload.date}
                formatter={(value) => formatCurrency(Number(value))}
                indicator="dot" />}
            />
            <defs>
              <linearGradient id="fillEquity" x1="0" y1="0" x2="0" y2="1">
                <stop offset="5%" stopColor="var(--color-equity)" stopOpacity={0.8} />
                <stop offset="95%" stopColor="var(--color-equity)" stopOpacity={0.1} />
              </linearGradient>
            </defs>
            <Area
              type="monotone"
              dataKey="equity"
              stroke="var(--color-equity)"
              fillOpacity={1}
              fill="url(#fillEquity)"
              strokeWidth={2}
            />
          </AreaChart>
        </ChartContainer>
      </CardContent>
    </Card>
  );
}
