
'use client';

import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Wallet, ShoppingBag, TrendingUp, Users } from 'lucide-react';

interface DashboardOverviewProps {
  balance: number;
  totalSales: number;
  totalRevenue: number;
  activeFollowers: number;
}

const StatCard = ({ title, value, icon: Icon, isCurrency = true }: { title: string, value: number, icon: any, isCurrency?: boolean }) => {
  const formatValue = (val: number) =>
    isCurrency
      ? new Intl.NumberFormat('en-TZ', { style: 'currency', currency: 'TZS', minimumFractionDigits: 0 }).format(val)
      : val.toLocaleString();

  return (
    <Card className="border-none shadow-md bg-card/50 backdrop-blur-sm">
      <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
        <CardTitle className="text-sm font-medium text-muted-foreground">{title}</CardTitle>
        <div className="p-2 bg-primary/10 rounded-xl">
           <Icon className="h-4 w-4 text-primary" />
        </div>
      </CardHeader>
      <CardContent>
        <div className="text-2xl font-bold font-headline">{formatValue(value)}</div>
      </CardContent>
    </Card>
  );
};

export function DashboardOverview({ balance, totalSales, totalRevenue, activeFollowers }: DashboardOverviewProps) {
  return (
    <div className="grid gap-4 grid-cols-1 sm:grid-cols-2 lg:grid-cols-4">
      <StatCard title="Wallet Balance" value={balance} icon={Wallet} />
      <StatCard title="Total Revenue" value={totalRevenue} icon={TrendingUp} />
      <StatCard title="Content Sold" value={totalSales} icon={ShoppingBag} isCurrency={false} />
      <StatCard title="Fans & Followers" value={activeFollowers} icon={Users} isCurrency={false} />
    </div>
  );
}
