
import { NextRequest, NextResponse } from 'next/server';

/**
 * @fileOverview Lipia/ SaaS Verification API
 * Endpoint for external clients (like PHP/cPanel apps) to verify 
 * if a provided accessToken is valid and hasn't expired.
 */

export async function GET(request: NextRequest) {
  const searchParams = request.nextUrl.searchParams;
  const token = searchParams.get('token');
  const apiKey = searchParams.get('key');

  // Security check: Validate API Key
  // In production, this would check against a Firestore 'apiKeys' collection
  if (!apiKey || !apiKey.startsWith('pk_live')) {
    return NextResponse.json({ 
        valid: false, 
        error: "Invalid or missing API key" 
    }, { status: 401 });
  }

  // Verification Logic:
  // In production, this would query Firestore for:
  // query(collection(db, 'purchases'), where('accessToken', '==', token))
  // Then check the 'expiresAt' timestamp.

  // Mock verification for demonstration
  if (token && token.length > 20) {
    return NextResponse.json({
      valid: true,
      contentId: "c12345",
      verifiedAt: new Date().toISOString()
    });
  }

  return NextResponse.json({ 
    valid: false, 
    error: "Token expired or invalid" 
  }, { status: 400 });
}
