
'use client';

import { useUser, useCollection, useFirestore } from '@/firebase';
import { query, collection } from 'firebase/firestore';
import { ContentCard } from '@/components/content-card';
import { Skeleton } from '@/components/ui/skeleton';
import { History } from 'lucide-react';

export default function PurchasesPage() {
  const { user } = useUser();
  const db = useFirestore();

  const purchasesQuery = user && db 
    ? query(collection(db, 'users', user.uid, 'purchases'))
    : null;

  const { data: purchases, loading } = useCollection(purchasesQuery);

  return (
    <div className="space-y-8">
      <div>
        <h1 className="text-3xl font-bold font-headline">My Library</h1>
        <p className="text-muted-foreground">All the content you've successfully unlocked.</p>
      </div>

      {loading ? (
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            {[1, 2, 3].map(i => <Skeleton key={i} className="aspect-video w-full rounded-3xl" />)}
        </div>
      ) : !purchases || purchases.length === 0 ? (
        <div className="py-20 text-center border-2 border-dashed rounded-3xl flex flex-col items-center justify-center space-y-4">
          <History className="h-12 w-12 text-muted-foreground/30" />
          <p className="text-muted-foreground">You haven't purchased any content yet.</p>
        </div>
      ) : (
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
          {purchases.map((item) => (
            <ContentCard key={item.id} item={item as any} />
          ))}
        </div>
      )}
    </div>
  );
}
