
'use client';

import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Button } from '@/components/ui/button';
import { Code, Copy, Terminal, ShieldCheck, Zap, Globe } from 'lucide-react';
import { useToast } from '@/hooks/use-toast';

export default function DeveloperPage() {
  const { toast } = useToast();

  const copyToClipboard = (text: string) => {
    navigator.clipboard.writeText(text);
    toast({
      title: "Copied to clipboard",
      description: "You can now paste this into your project.",
    });
  };

  const phpSnippet = `<?php
// Lipia/ PHP Integration SDK (cPanel Optimized)
// Place this at the top of any file you want to lock.

$LIPIA_API_KEY = "your_api_key_here";
$CONTENT_ID = "c12345"; // The ID of the content in your Lipia/ dashboard

// 1. Check if user already has an access token in their session
session_start();
if (!isset($_SESSION['lipia_token'])) {
    // 2. Redirect to Lipia/ Paywall
    $redirect_url = "https://lipia.co.tz/unlock/" . $CONTENT_ID . "?callback=" . urlencode("https://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
    header("Location: " . $redirect_url);
    exit;
}

// 3. Verify token status with Lipia/ API
$verify_url = "https://lipia.co.tz/api/v1/verify?token=" . $_SESSION['lipia_token'] . "&key=" . $LIPIA_API_KEY;
$response = file_get_contents($verify_url);
$result = json_decode($response, true);

if (!$result['valid']) {
    unset($_SESSION['lipia_token']);
    header("Refresh:0");
    exit;
}

// Access Granted - Render your protected content below...
?>
<h1>Welcome to your premium content!</h1>`;

  return (
    <div className="space-y-8 pb-10">
      <div className="flex flex-col md:flex-row md:items-center justify-between gap-4">
        <div>
          <h1 className="text-3xl font-bold font-headline">Developer API</h1>
          <p className="text-muted-foreground">Build monetization directly into your own apps and websites.</p>
        </div>
        <Button variant="outline" className="rounded-xl">
          <Globe className="mr-2 h-4 w-4" /> API Documentation
        </Button>
      </div>

      <div className="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <Card className="lg:col-span-2 rounded-[2.5rem] border-none shadow-xl shadow-primary/5">
          <CardHeader>
            <div className="flex items-center justify-between">
              <div className="space-y-1">
                <CardTitle className="font-headline text-2xl">PHP SDK Integration</CardTitle>
                <CardDescription>Perfect for cPanel, WordPress, or custom PHP sites.</CardDescription>
              </div>
              <Button size="icon" variant="ghost" onClick={() => copyToClipboard(phpSnippet)}>
                <Copy className="h-4 w-4" />
              </Button>
            </div>
          </CardHeader>
          <CardContent>
            <div className="bg-slate-950 rounded-2xl p-6 font-mono text-sm text-slate-300 overflow-x-auto">
              <pre>{phpSnippet}</pre>
            </div>
          </CardContent>
        </Card>

        <div className="space-y-6">
          <Card className="rounded-[2.5rem] border-none shadow-xl shadow-primary/5 bg-primary text-primary-foreground">
            <CardHeader>
              <CardTitle className="font-headline text-xl">Your API Keys</CardTitle>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-1">
                <p className="text-xs font-bold opacity-70 uppercase">Publishable Key</p>
                <div className="bg-white/10 p-3 rounded-xl flex items-center justify-between font-mono text-xs overflow-hidden">
                  <span className="truncate mr-2">pk_live_51Pq...3jL9</span>
                  <Copy className="h-3 w-3 shrink-0 cursor-pointer" onClick={() => copyToClipboard('pk_live_51Pq3jL9')} />
                </div>
              </div>
              <div className="space-y-1">
                <p className="text-xs font-bold opacity-70 uppercase">Secret Key</p>
                <div className="bg-white/10 p-3 rounded-xl flex items-center justify-center font-mono text-xs italic">
                  <span>••••••••••••••••</span>
                </div>
              </div>
              <Button variant="secondary" className="w-full rounded-xl">Reveal Secret Key</Button>
            </CardContent>
          </Card>

          <Card className="rounded-[2.5rem] border-none shadow-xl shadow-primary/5 p-6 space-y-4">
            <h4 className="font-bold flex items-center gap-2">
              <ShieldCheck className="h-5 w-5 text-primary" />
              SaaS Infrastructure
            </h4>
            <div className="space-y-3">
              {[
                { title: "Webhook Reliability", desc: "99.9% uptime on payment callbacks." },
                { title: "Global CDN", desc: "Fast token verification from any server." },
                { title: "M-Pesa Native", desc: "Optimized for East African payment rails." },
              ].map((item, i) => (
                <div key={i} className="space-y-1">
                  <p className="text-sm font-bold">{item.title}</p>
                  <p className="text-xs text-muted-foreground">{item.desc}</p>
                </div>
              ))}
            </div>
          </Card>
        </div>
      </div>
    </div>
  );
}
