import { challenges } from '@/lib/data';
import { ChallengeCard } from '@/components/challenge-card';
import { Suspense } from 'react';
import { Skeleton } from '@/components/ui/skeleton';

function ChallengeCardSkeleton() {
    return (
      <div className="flex flex-col space-y-3">
        <Skeleton className="h-[125px] w-full rounded-xl" />
        <div className="space-y-2">
          <Skeleton className="h-4 w-4/5" />
          <Skeleton className="h-4 w-3/5" />
        </div>
        <Skeleton className="h-10 w-full" />
      </div>
    );
  }

export default function ChallengesPage() {
  return (
    <div>
        <div className="mb-8">
            <h1 className="text-3xl font-bold font-headline">Choose Your Challenge</h1>
            <p className="text-muted-foreground">Select a challenge that fits your trading style and get funded.</p>
        </div>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {challenges.map((challenge) => (
          <Suspense key={challenge.id} fallback={<ChallengeCardSkeleton />}>
            <ChallengeCard challenge={challenge} />
          </Suspense>
        ))}
      </div>
    </div>
  );
}
