module.exports = {

"[project]/node_modules/fast-deep-equal/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
// do not edit .js files directly - edit src/index.jst
module.exports = function equal(a, b) {
    if (a === b) return true;
    if (a && b && typeof a == 'object' && typeof b == 'object') {
        if (a.constructor !== b.constructor) return false;
        var length, i, keys;
        if (Array.isArray(a)) {
            length = a.length;
            if (length != b.length) return false;
            for(i = length; i-- !== 0;)if (!equal(a[i], b[i])) return false;
            return true;
        }
        if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
        if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
        if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
        keys = Object.keys(a);
        length = keys.length;
        if (length !== Object.keys(b).length) return false;
        for(i = length; i-- !== 0;)if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
        for(i = length; i-- !== 0;){
            var key = keys[i];
            if (!equal(a[key], b[key])) return false;
        }
        return true;
    }
    // true if both NaN, false otherwise
    return a !== a && b !== b;
};
}}),
"[project]/node_modules/json-schema-traverse/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
var traverse = module.exports = function(schema, opts, cb) {
    // Legacy support for v0.3.1 and earlier.
    if (typeof opts == 'function') {
        cb = opts;
        opts = {};
    }
    cb = opts.cb || cb;
    var pre = typeof cb == 'function' ? cb : cb.pre || function() {};
    var post = cb.post || function() {};
    _traverse(opts, pre, post, schema, '', schema);
};
traverse.keywords = {
    additionalItems: true,
    items: true,
    contains: true,
    additionalProperties: true,
    propertyNames: true,
    not: true,
    if: true,
    then: true,
    else: true
};
traverse.arrayKeywords = {
    items: true,
    allOf: true,
    anyOf: true,
    oneOf: true
};
traverse.propsKeywords = {
    $defs: true,
    definitions: true,
    properties: true,
    patternProperties: true,
    dependencies: true
};
traverse.skipKeywords = {
    default: true,
    enum: true,
    const: true,
    required: true,
    maximum: true,
    minimum: true,
    exclusiveMaximum: true,
    exclusiveMinimum: true,
    multipleOf: true,
    maxLength: true,
    minLength: true,
    pattern: true,
    format: true,
    maxItems: true,
    minItems: true,
    uniqueItems: true,
    maxProperties: true,
    minProperties: true
};
function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
    if (schema && typeof schema == 'object' && !Array.isArray(schema)) {
        pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
        for(var key in schema){
            var sch = schema[key];
            if (Array.isArray(sch)) {
                if (key in traverse.arrayKeywords) {
                    for(var i = 0; i < sch.length; i++)_traverse(opts, pre, post, sch[i], jsonPtr + '/' + key + '/' + i, rootSchema, jsonPtr, key, schema, i);
                }
            } else if (key in traverse.propsKeywords) {
                if (sch && typeof sch == 'object') {
                    for(var prop in sch)_traverse(opts, pre, post, sch[prop], jsonPtr + '/' + key + '/' + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
                }
            } else if (key in traverse.keywords || opts.allKeys && !(key in traverse.skipKeywords)) {
                _traverse(opts, pre, post, sch, jsonPtr + '/' + key, rootSchema, jsonPtr, key, schema);
            }
        }
        post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
    }
}
function escapeJsonPtr(str) {
    return str.replace(/~/g, '~0').replace(/\//g, '~1');
}
}}),
"[project]/node_modules/fast-uri/lib/scopedChars.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const HEX = {
    0: 0,
    1: 1,
    2: 2,
    3: 3,
    4: 4,
    5: 5,
    6: 6,
    7: 7,
    8: 8,
    9: 9,
    a: 10,
    A: 10,
    b: 11,
    B: 11,
    c: 12,
    C: 12,
    d: 13,
    D: 13,
    e: 14,
    E: 14,
    f: 15,
    F: 15
};
module.exports = {
    HEX
};
}}),
"[project]/node_modules/fast-uri/lib/utils.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const { HEX } = __turbopack_context__.r("[project]/node_modules/fast-uri/lib/scopedChars.js [app-rsc] (ecmascript)");
const IPV4_REG = /^(?:(?:25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.){3}(?:25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)$/u;
function normalizeIPv4(host) {
    if (findToken(host, '.') < 3) {
        return {
            host,
            isIPV4: false
        };
    }
    const matches = host.match(IPV4_REG) || [];
    const [address] = matches;
    if (address) {
        return {
            host: stripLeadingZeros(address, '.'),
            isIPV4: true
        };
    } else {
        return {
            host,
            isIPV4: false
        };
    }
}
/**
 * @param {string[]} input
 * @param {boolean} [keepZero=false]
 * @returns {string|undefined}
 */ function stringArrayToHexStripped(input, keepZero = false) {
    let acc = '';
    let strip = true;
    for (const c of input){
        if (HEX[c] === undefined) return undefined;
        if (c !== '0' && strip === true) strip = false;
        if (!strip) acc += c;
    }
    if (keepZero && acc.length === 0) acc = '0';
    return acc;
}
function getIPV6(input) {
    let tokenCount = 0;
    const output = {
        error: false,
        address: '',
        zone: ''
    };
    const address = [];
    const buffer = [];
    let isZone = false;
    let endipv6Encountered = false;
    let endIpv6 = false;
    function consume() {
        if (buffer.length) {
            if (isZone === false) {
                const hex = stringArrayToHexStripped(buffer);
                if (hex !== undefined) {
                    address.push(hex);
                } else {
                    output.error = true;
                    return false;
                }
            }
            buffer.length = 0;
        }
        return true;
    }
    for(let i = 0; i < input.length; i++){
        const cursor = input[i];
        if (cursor === '[' || cursor === ']') {
            continue;
        }
        if (cursor === ':') {
            if (endipv6Encountered === true) {
                endIpv6 = true;
            }
            if (!consume()) {
                break;
            }
            tokenCount++;
            address.push(':');
            if (tokenCount > 7) {
                // not valid
                output.error = true;
                break;
            }
            if (i - 1 >= 0 && input[i - 1] === ':') {
                endipv6Encountered = true;
            }
            continue;
        } else if (cursor === '%') {
            if (!consume()) {
                break;
            }
            // switch to zone detection
            isZone = true;
        } else {
            buffer.push(cursor);
            continue;
        }
    }
    if (buffer.length) {
        if (isZone) {
            output.zone = buffer.join('');
        } else if (endIpv6) {
            address.push(buffer.join(''));
        } else {
            address.push(stringArrayToHexStripped(buffer));
        }
    }
    output.address = address.join('');
    return output;
}
function normalizeIPv6(host) {
    if (findToken(host, ':') < 2) {
        return {
            host,
            isIPV6: false
        };
    }
    const ipv6 = getIPV6(host);
    if (!ipv6.error) {
        let newHost = ipv6.address;
        let escapedHost = ipv6.address;
        if (ipv6.zone) {
            newHost += '%' + ipv6.zone;
            escapedHost += '%25' + ipv6.zone;
        }
        return {
            host: newHost,
            escapedHost,
            isIPV6: true
        };
    } else {
        return {
            host,
            isIPV6: false
        };
    }
}
function stripLeadingZeros(str, token) {
    let out = '';
    let skip = true;
    const l = str.length;
    for(let i = 0; i < l; i++){
        const c = str[i];
        if (c === '0' && skip) {
            if (i + 1 <= l && str[i + 1] === token || i + 1 === l) {
                out += c;
                skip = false;
            }
        } else {
            if (c === token) {
                skip = true;
            } else {
                skip = false;
            }
            out += c;
        }
    }
    return out;
}
function findToken(str, token) {
    let ind = 0;
    for(let i = 0; i < str.length; i++){
        if (str[i] === token) ind++;
    }
    return ind;
}
const RDS1 = /^\.\.?\//u;
const RDS2 = /^\/\.(?:\/|$)/u;
const RDS3 = /^\/\.\.(?:\/|$)/u;
const RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/u;
function removeDotSegments(input) {
    const output = [];
    while(input.length){
        if (input.match(RDS1)) {
            input = input.replace(RDS1, '');
        } else if (input.match(RDS2)) {
            input = input.replace(RDS2, '/');
        } else if (input.match(RDS3)) {
            input = input.replace(RDS3, '/');
            output.pop();
        } else if (input === '.' || input === '..') {
            input = '';
        } else {
            const im = input.match(RDS5);
            if (im) {
                const s = im[0];
                input = input.slice(s.length);
                output.push(s);
            } else {
                throw new Error('Unexpected dot segment condition');
            }
        }
    }
    return output.join('');
}
function normalizeComponentEncoding(components, esc) {
    const func = esc !== true ? escape : unescape;
    if (components.scheme !== undefined) {
        components.scheme = func(components.scheme);
    }
    if (components.userinfo !== undefined) {
        components.userinfo = func(components.userinfo);
    }
    if (components.host !== undefined) {
        components.host = func(components.host);
    }
    if (components.path !== undefined) {
        components.path = func(components.path);
    }
    if (components.query !== undefined) {
        components.query = func(components.query);
    }
    if (components.fragment !== undefined) {
        components.fragment = func(components.fragment);
    }
    return components;
}
function recomposeAuthority(components) {
    const uriTokens = [];
    if (components.userinfo !== undefined) {
        uriTokens.push(components.userinfo);
        uriTokens.push('@');
    }
    if (components.host !== undefined) {
        let host = unescape(components.host);
        const ipV4res = normalizeIPv4(host);
        if (ipV4res.isIPV4) {
            host = ipV4res.host;
        } else {
            const ipV6res = normalizeIPv6(ipV4res.host);
            if (ipV6res.isIPV6 === true) {
                host = `[${ipV6res.escapedHost}]`;
            } else {
                host = components.host;
            }
        }
        uriTokens.push(host);
    }
    if (typeof components.port === 'number' || typeof components.port === 'string') {
        uriTokens.push(':');
        uriTokens.push(String(components.port));
    }
    return uriTokens.length ? uriTokens.join('') : undefined;
}
;
module.exports = {
    recomposeAuthority,
    normalizeComponentEncoding,
    removeDotSegments,
    normalizeIPv4,
    normalizeIPv6,
    stringArrayToHexStripped
};
}}),
"[project]/node_modules/fast-uri/lib/schemes.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const UUID_REG = /^[\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12}$/iu;
const URN_REG = /([\da-z][\d\-a-z]{0,31}):((?:[\w!$'()*+,\-.:;=@]|%[\da-f]{2})+)/iu;
function isSecure(wsComponents) {
    return typeof wsComponents.secure === 'boolean' ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === 'wss';
}
function httpParse(components) {
    if (!components.host) {
        components.error = components.error || 'HTTP URIs must have a host.';
    }
    return components;
}
function httpSerialize(components) {
    const secure = String(components.scheme).toLowerCase() === 'https';
    // normalize the default port
    if (components.port === (secure ? 443 : 80) || components.port === '') {
        components.port = undefined;
    }
    // normalize the empty path
    if (!components.path) {
        components.path = '/';
    }
    // NOTE: We do not parse query strings for HTTP URIs
    // as WWW Form Url Encoded query strings are part of the HTML4+ spec,
    // and not the HTTP spec.
    return components;
}
function wsParse(wsComponents) {
    // indicate if the secure flag is set
    wsComponents.secure = isSecure(wsComponents);
    // construct resouce name
    wsComponents.resourceName = (wsComponents.path || '/') + (wsComponents.query ? '?' + wsComponents.query : '');
    wsComponents.path = undefined;
    wsComponents.query = undefined;
    return wsComponents;
}
function wsSerialize(wsComponents) {
    // normalize the default port
    if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === '') {
        wsComponents.port = undefined;
    }
    // ensure scheme matches secure flag
    if (typeof wsComponents.secure === 'boolean') {
        wsComponents.scheme = wsComponents.secure ? 'wss' : 'ws';
        wsComponents.secure = undefined;
    }
    // reconstruct path from resource name
    if (wsComponents.resourceName) {
        const [path, query] = wsComponents.resourceName.split('?');
        wsComponents.path = path && path !== '/' ? path : undefined;
        wsComponents.query = query;
        wsComponents.resourceName = undefined;
    }
    // forbid fragment component
    wsComponents.fragment = undefined;
    return wsComponents;
}
function urnParse(urnComponents, options) {
    if (!urnComponents.path) {
        urnComponents.error = 'URN can not be parsed';
        return urnComponents;
    }
    const matches = urnComponents.path.match(URN_REG);
    if (matches) {
        const scheme = options.scheme || urnComponents.scheme || 'urn';
        urnComponents.nid = matches[1].toLowerCase();
        urnComponents.nss = matches[2];
        const urnScheme = `${scheme}:${options.nid || urnComponents.nid}`;
        const schemeHandler = SCHEMES[urnScheme];
        urnComponents.path = undefined;
        if (schemeHandler) {
            urnComponents = schemeHandler.parse(urnComponents, options);
        }
    } else {
        urnComponents.error = urnComponents.error || 'URN can not be parsed.';
    }
    return urnComponents;
}
function urnSerialize(urnComponents, options) {
    const scheme = options.scheme || urnComponents.scheme || 'urn';
    const nid = urnComponents.nid.toLowerCase();
    const urnScheme = `${scheme}:${options.nid || nid}`;
    const schemeHandler = SCHEMES[urnScheme];
    if (schemeHandler) {
        urnComponents = schemeHandler.serialize(urnComponents, options);
    }
    const uriComponents = urnComponents;
    const nss = urnComponents.nss;
    uriComponents.path = `${nid || options.nid}:${nss}`;
    options.skipEscape = true;
    return uriComponents;
}
function urnuuidParse(urnComponents, options) {
    const uuidComponents = urnComponents;
    uuidComponents.uuid = uuidComponents.nss;
    uuidComponents.nss = undefined;
    if (!options.tolerant && (!uuidComponents.uuid || !UUID_REG.test(uuidComponents.uuid))) {
        uuidComponents.error = uuidComponents.error || 'UUID is not valid.';
    }
    return uuidComponents;
}
function urnuuidSerialize(uuidComponents) {
    const urnComponents = uuidComponents;
    // normalize UUID
    urnComponents.nss = (uuidComponents.uuid || '').toLowerCase();
    return urnComponents;
}
const http = {
    scheme: 'http',
    domainHost: true,
    parse: httpParse,
    serialize: httpSerialize
};
const https = {
    scheme: 'https',
    domainHost: http.domainHost,
    parse: httpParse,
    serialize: httpSerialize
};
const ws = {
    scheme: 'ws',
    domainHost: true,
    parse: wsParse,
    serialize: wsSerialize
};
const wss = {
    scheme: 'wss',
    domainHost: ws.domainHost,
    parse: ws.parse,
    serialize: ws.serialize
};
const urn = {
    scheme: 'urn',
    parse: urnParse,
    serialize: urnSerialize,
    skipNormalize: true
};
const urnuuid = {
    scheme: 'urn:uuid',
    parse: urnuuidParse,
    serialize: urnuuidSerialize,
    skipNormalize: true
};
const SCHEMES = {
    http,
    https,
    ws,
    wss,
    urn,
    'urn:uuid': urnuuid
};
module.exports = SCHEMES;
}}),
"[project]/node_modules/fast-uri/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const { normalizeIPv6, normalizeIPv4, removeDotSegments, recomposeAuthority, normalizeComponentEncoding } = __turbopack_context__.r("[project]/node_modules/fast-uri/lib/utils.js [app-rsc] (ecmascript)");
const SCHEMES = __turbopack_context__.r("[project]/node_modules/fast-uri/lib/schemes.js [app-rsc] (ecmascript)");
function normalize(uri, options) {
    if (typeof uri === 'string') {
        uri = serialize(parse(uri, options), options);
    } else if (typeof uri === 'object') {
        uri = parse(serialize(uri, options), options);
    }
    return uri;
}
function resolve(baseURI, relativeURI, options) {
    const schemelessOptions = Object.assign({
        scheme: 'null'
    }, options);
    const resolved = resolveComponents(parse(baseURI, schemelessOptions), parse(relativeURI, schemelessOptions), schemelessOptions, true);
    return serialize(resolved, {
        ...schemelessOptions,
        skipEscape: true
    });
}
function resolveComponents(base, relative, options, skipNormalization) {
    const target = {};
    if (!skipNormalization) {
        base = parse(serialize(base, options), options) // normalize base components
        ;
        relative = parse(serialize(relative, options), options) // normalize relative components
        ;
    }
    options = options || {};
    if (!options.tolerant && relative.scheme) {
        target.scheme = relative.scheme;
        // target.authority = relative.authority;
        target.userinfo = relative.userinfo;
        target.host = relative.host;
        target.port = relative.port;
        target.path = removeDotSegments(relative.path || '');
        target.query = relative.query;
    } else {
        if (relative.userinfo !== undefined || relative.host !== undefined || relative.port !== undefined) {
            // target.authority = relative.authority;
            target.userinfo = relative.userinfo;
            target.host = relative.host;
            target.port = relative.port;
            target.path = removeDotSegments(relative.path || '');
            target.query = relative.query;
        } else {
            if (!relative.path) {
                target.path = base.path;
                if (relative.query !== undefined) {
                    target.query = relative.query;
                } else {
                    target.query = base.query;
                }
            } else {
                if (relative.path.charAt(0) === '/') {
                    target.path = removeDotSegments(relative.path);
                } else {
                    if ((base.userinfo !== undefined || base.host !== undefined || base.port !== undefined) && !base.path) {
                        target.path = '/' + relative.path;
                    } else if (!base.path) {
                        target.path = relative.path;
                    } else {
                        target.path = base.path.slice(0, base.path.lastIndexOf('/') + 1) + relative.path;
                    }
                    target.path = removeDotSegments(target.path);
                }
                target.query = relative.query;
            }
            // target.authority = base.authority;
            target.userinfo = base.userinfo;
            target.host = base.host;
            target.port = base.port;
        }
        target.scheme = base.scheme;
    }
    target.fragment = relative.fragment;
    return target;
}
function equal(uriA, uriB, options) {
    if (typeof uriA === 'string') {
        uriA = unescape(uriA);
        uriA = serialize(normalizeComponentEncoding(parse(uriA, options), true), {
            ...options,
            skipEscape: true
        });
    } else if (typeof uriA === 'object') {
        uriA = serialize(normalizeComponentEncoding(uriA, true), {
            ...options,
            skipEscape: true
        });
    }
    if (typeof uriB === 'string') {
        uriB = unescape(uriB);
        uriB = serialize(normalizeComponentEncoding(parse(uriB, options), true), {
            ...options,
            skipEscape: true
        });
    } else if (typeof uriB === 'object') {
        uriB = serialize(normalizeComponentEncoding(uriB, true), {
            ...options,
            skipEscape: true
        });
    }
    return uriA.toLowerCase() === uriB.toLowerCase();
}
function serialize(cmpts, opts) {
    const components = {
        host: cmpts.host,
        scheme: cmpts.scheme,
        userinfo: cmpts.userinfo,
        port: cmpts.port,
        path: cmpts.path,
        query: cmpts.query,
        nid: cmpts.nid,
        nss: cmpts.nss,
        uuid: cmpts.uuid,
        fragment: cmpts.fragment,
        reference: cmpts.reference,
        resourceName: cmpts.resourceName,
        secure: cmpts.secure,
        error: ''
    };
    const options = Object.assign({}, opts);
    const uriTokens = [];
    // find scheme handler
    const schemeHandler = SCHEMES[(options.scheme || components.scheme || '').toLowerCase()];
    // perform scheme specific serialization
    if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
    if (components.path !== undefined) {
        if (!options.skipEscape) {
            components.path = escape(components.path);
            if (components.scheme !== undefined) {
                components.path = components.path.split('%3A').join(':');
            }
        } else {
            components.path = unescape(components.path);
        }
    }
    if (options.reference !== 'suffix' && components.scheme) {
        uriTokens.push(components.scheme, ':');
    }
    const authority = recomposeAuthority(components);
    if (authority !== undefined) {
        if (options.reference !== 'suffix') {
            uriTokens.push('//');
        }
        uriTokens.push(authority);
        if (components.path && components.path.charAt(0) !== '/') {
            uriTokens.push('/');
        }
    }
    if (components.path !== undefined) {
        let s = components.path;
        if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
            s = removeDotSegments(s);
        }
        if (authority === undefined) {
            s = s.replace(/^\/\//u, '/%2F') // don't allow the path to start with "//"
            ;
        }
        uriTokens.push(s);
    }
    if (components.query !== undefined) {
        uriTokens.push('?', components.query);
    }
    if (components.fragment !== undefined) {
        uriTokens.push('#', components.fragment);
    }
    return uriTokens.join('');
}
const hexLookUp = Array.from({
    length: 127
}, (_v, k)=>/[^!"$&'()*+,\-.;=_`a-z{}~]/u.test(String.fromCharCode(k)));
function nonSimpleDomain(value) {
    let code = 0;
    for(let i = 0, len = value.length; i < len; ++i){
        code = value.charCodeAt(i);
        if (code > 126 || hexLookUp[code]) {
            return true;
        }
    }
    return false;
}
const URI_PARSE = /^(?:([^#/:?]+):)?(?:\/\/((?:([^#/?@]*)@)?(\[[^#/?\]]+\]|[^#/:?]*)(?::(\d*))?))?([^#?]*)(?:\?([^#]*))?(?:#((?:.|[\n\r])*))?/u;
function parse(uri, opts) {
    const options = Object.assign({}, opts);
    const parsed = {
        scheme: undefined,
        userinfo: undefined,
        host: '',
        port: undefined,
        path: '',
        query: undefined,
        fragment: undefined
    };
    const gotEncoding = uri.indexOf('%') !== -1;
    let isIP = false;
    if (options.reference === 'suffix') uri = (options.scheme ? options.scheme + ':' : '') + '//' + uri;
    const matches = uri.match(URI_PARSE);
    if (matches) {
        // store each component
        parsed.scheme = matches[1];
        parsed.userinfo = matches[3];
        parsed.host = matches[4];
        parsed.port = parseInt(matches[5], 10);
        parsed.path = matches[6] || '';
        parsed.query = matches[7];
        parsed.fragment = matches[8];
        // fix port number
        if (isNaN(parsed.port)) {
            parsed.port = matches[5];
        }
        if (parsed.host) {
            const ipv4result = normalizeIPv4(parsed.host);
            if (ipv4result.isIPV4 === false) {
                const ipv6result = normalizeIPv6(ipv4result.host);
                parsed.host = ipv6result.host.toLowerCase();
                isIP = ipv6result.isIPV6;
            } else {
                parsed.host = ipv4result.host;
                isIP = true;
            }
        }
        if (parsed.scheme === undefined && parsed.userinfo === undefined && parsed.host === undefined && parsed.port === undefined && parsed.query === undefined && !parsed.path) {
            parsed.reference = 'same-document';
        } else if (parsed.scheme === undefined) {
            parsed.reference = 'relative';
        } else if (parsed.fragment === undefined) {
            parsed.reference = 'absolute';
        } else {
            parsed.reference = 'uri';
        }
        // check for reference errors
        if (options.reference && options.reference !== 'suffix' && options.reference !== parsed.reference) {
            parsed.error = parsed.error || 'URI is not a ' + options.reference + ' reference.';
        }
        // find scheme handler
        const schemeHandler = SCHEMES[(options.scheme || parsed.scheme || '').toLowerCase()];
        // check if scheme can't handle IRIs
        if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
            // if host component is a domain name
            if (parsed.host && (options.domainHost || schemeHandler && schemeHandler.domainHost) && isIP === false && nonSimpleDomain(parsed.host)) {
                // convert Unicode IDN -> ASCII IDN
                try {
                    parsed.host = URL.domainToASCII(parsed.host.toLowerCase());
                } catch (e) {
                    parsed.error = parsed.error || "Host's domain name can not be converted to ASCII: " + e;
                }
            }
        // convert IRI -> URI
        }
        if (!schemeHandler || schemeHandler && !schemeHandler.skipNormalize) {
            if (gotEncoding && parsed.scheme !== undefined) {
                parsed.scheme = unescape(parsed.scheme);
            }
            if (gotEncoding && parsed.host !== undefined) {
                parsed.host = unescape(parsed.host);
            }
            if (parsed.path) {
                parsed.path = escape(unescape(parsed.path));
            }
            if (parsed.fragment) {
                parsed.fragment = encodeURI(decodeURIComponent(parsed.fragment));
            }
        }
        // perform scheme specific parsing
        if (schemeHandler && schemeHandler.parse) {
            schemeHandler.parse(parsed, options);
        }
    } else {
        parsed.error = parsed.error || 'URI can not be parsed.';
    }
    return parsed;
}
const fastUri = {
    SCHEMES,
    normalize,
    resolve,
    resolveComponents,
    equal,
    serialize,
    parse
};
module.exports = fastUri;
module.exports.default = fastUri;
module.exports.fastUri = fastUri;
}}),
"[project]/node_modules/ajv-formats/dist/formats.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatNames = exports.fastFormats = exports.fullFormats = void 0;
function fmtDef(validate, compare) {
    return {
        validate,
        compare
    };
}
exports.fullFormats = {
    // date: http://tools.ietf.org/html/rfc3339#section-5.6
    date: fmtDef(date, compareDate),
    // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
    time: fmtDef(getTime(true), compareTime),
    "date-time": fmtDef(getDateTime(true), compareDateTime),
    "iso-time": fmtDef(getTime(), compareIsoTime),
    "iso-date-time": fmtDef(getDateTime(), compareIsoDateTime),
    // duration: https://tools.ietf.org/html/rfc3339#appendix-A
    duration: /^P(?!$)((\d+Y)?(\d+M)?(\d+D)?(T(?=\d)(\d+H)?(\d+M)?(\d+S)?)?|(\d+W)?)$/,
    uri,
    "uri-reference": /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,
    // uri-template: https://tools.ietf.org/html/rfc6570
    "uri-template": /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,
    // For the source: https://gist.github.com/dperini/729294
    // For test cases: https://mathiasbynens.be/demo/url-regex
    url: /^(?:https?|ftp):\/\/(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)(?:\.(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu,
    email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
    hostname: /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,
    // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
    ipv4: /^(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)\.){3}(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)$/,
    ipv6: /^((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$/i,
    regex,
    // uuid: http://tools.ietf.org/html/rfc4122
    uuid: /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,
    // JSON-pointer: https://tools.ietf.org/html/rfc6901
    // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
    "json-pointer": /^(?:\/(?:[^~/]|~0|~1)*)*$/,
    "json-pointer-uri-fragment": /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,
    // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
    "relative-json-pointer": /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/,
    // the following formats are used by the openapi specification: https://spec.openapis.org/oas/v3.0.0#data-types
    // byte: https://github.com/miguelmota/is-base64
    byte,
    // signed 32 bit integer
    int32: {
        type: "number",
        validate: validateInt32
    },
    // signed 64 bit integer
    int64: {
        type: "number",
        validate: validateInt64
    },
    // C-type float
    float: {
        type: "number",
        validate: validateNumber
    },
    // C-type double
    double: {
        type: "number",
        validate: validateNumber
    },
    // hint to the UI to hide input strings
    password: true,
    // unchecked string payload
    binary: true
};
exports.fastFormats = {
    ...exports.fullFormats,
    date: fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d$/, compareDate),
    time: fmtDef(/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i, compareTime),
    "date-time": fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\dt(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i, compareDateTime),
    "iso-time": fmtDef(/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i, compareIsoTime),
    "iso-date-time": fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i, compareIsoDateTime),
    // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
    uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
    "uri-reference": /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
    // email (sources from jsen validator):
    // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
    // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'wilful violation')
    email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i
};
exports.formatNames = Object.keys(exports.fullFormats);
function isLeapYear(year) {
    // https://tools.ietf.org/html/rfc3339#appendix-C
    return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
const DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
const DAYS = [
    0,
    31,
    28,
    31,
    30,
    31,
    30,
    31,
    31,
    30,
    31,
    30,
    31
];
function date(str) {
    // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
    const matches = DATE.exec(str);
    if (!matches) return false;
    const year = +matches[1];
    const month = +matches[2];
    const day = +matches[3];
    return month >= 1 && month <= 12 && day >= 1 && day <= (month === 2 && isLeapYear(year) ? 29 : DAYS[month]);
}
function compareDate(d1, d2) {
    if (!(d1 && d2)) return undefined;
    if (d1 > d2) return 1;
    if (d1 < d2) return -1;
    return 0;
}
const TIME = /^(\d\d):(\d\d):(\d\d(?:\.\d+)?)(z|([+-])(\d\d)(?::?(\d\d))?)?$/i;
function getTime(strictTimeZone) {
    return function time(str) {
        const matches = TIME.exec(str);
        if (!matches) return false;
        const hr = +matches[1];
        const min = +matches[2];
        const sec = +matches[3];
        const tz = matches[4];
        const tzSign = matches[5] === "-" ? -1 : 1;
        const tzH = +(matches[6] || 0);
        const tzM = +(matches[7] || 0);
        if (tzH > 23 || tzM > 59 || strictTimeZone && !tz) return false;
        if (hr <= 23 && min <= 59 && sec < 60) return true;
        // leap second
        const utcMin = min - tzM * tzSign;
        const utcHr = hr - tzH * tzSign - (utcMin < 0 ? 1 : 0);
        return (utcHr === 23 || utcHr === -1) && (utcMin === 59 || utcMin === -1) && sec < 61;
    };
}
function compareTime(s1, s2) {
    if (!(s1 && s2)) return undefined;
    const t1 = new Date("2020-01-01T" + s1).valueOf();
    const t2 = new Date("2020-01-01T" + s2).valueOf();
    if (!(t1 && t2)) return undefined;
    return t1 - t2;
}
function compareIsoTime(t1, t2) {
    if (!(t1 && t2)) return undefined;
    const a1 = TIME.exec(t1);
    const a2 = TIME.exec(t2);
    if (!(a1 && a2)) return undefined;
    t1 = a1[1] + a1[2] + a1[3];
    t2 = a2[1] + a2[2] + a2[3];
    if (t1 > t2) return 1;
    if (t1 < t2) return -1;
    return 0;
}
const DATE_TIME_SEPARATOR = /t|\s/i;
function getDateTime(strictTimeZone) {
    const time = getTime(strictTimeZone);
    return function date_time(str) {
        // http://tools.ietf.org/html/rfc3339#section-5.6
        const dateTime = str.split(DATE_TIME_SEPARATOR);
        return dateTime.length === 2 && date(dateTime[0]) && time(dateTime[1]);
    };
}
function compareDateTime(dt1, dt2) {
    if (!(dt1 && dt2)) return undefined;
    const d1 = new Date(dt1).valueOf();
    const d2 = new Date(dt2).valueOf();
    if (!(d1 && d2)) return undefined;
    return d1 - d2;
}
function compareIsoDateTime(dt1, dt2) {
    if (!(dt1 && dt2)) return undefined;
    const [d1, t1] = dt1.split(DATE_TIME_SEPARATOR);
    const [d2, t2] = dt2.split(DATE_TIME_SEPARATOR);
    const res = compareDate(d1, d2);
    if (res === undefined) return undefined;
    return res || compareTime(t1, t2);
}
const NOT_URI_FRAGMENT = /\/|:/;
const URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
function uri(str) {
    // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
    return NOT_URI_FRAGMENT.test(str) && URI.test(str);
}
const BYTE = /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/gm;
function byte(str) {
    BYTE.lastIndex = 0;
    return BYTE.test(str);
}
const MIN_INT32 = -(2 ** 31);
const MAX_INT32 = 2 ** 31 - 1;
function validateInt32(value) {
    return Number.isInteger(value) && value <= MAX_INT32 && value >= MIN_INT32;
}
function validateInt64(value) {
    // JSON and javascript max Int is 2**53, so any int that passes isInteger is valid for Int64
    return Number.isInteger(value);
}
function validateNumber() {
    return true;
}
const Z_ANCHOR = /[^\\]\\Z/;
function regex(str) {
    if (Z_ANCHOR.test(str)) return false;
    try {
        new RegExp(str);
        return true;
    } catch (e) {
        return false;
    }
} //# sourceMappingURL=formats.js.map
}}),
"[project]/node_modules/ajv-formats/dist/limit.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.formatLimitDefinition = void 0;
const ajv_1 = __turbopack_context__.r("[project]/node_modules/ajv/dist/ajv.js [app-rsc] (ecmascript)");
const codegen_1 = __turbopack_context__.r("[project]/node_modules/ajv/dist/compile/codegen/index.js [app-rsc] (ecmascript)");
const ops = codegen_1.operators;
const KWDs = {
    formatMaximum: {
        okStr: "<=",
        ok: ops.LTE,
        fail: ops.GT
    },
    formatMinimum: {
        okStr: ">=",
        ok: ops.GTE,
        fail: ops.LT
    },
    formatExclusiveMaximum: {
        okStr: "<",
        ok: ops.LT,
        fail: ops.GTE
    },
    formatExclusiveMinimum: {
        okStr: ">",
        ok: ops.GT,
        fail: ops.LTE
    }
};
const error = {
    message: ({ keyword, schemaCode })=>(0, codegen_1.str)`should be ${KWDs[keyword].okStr} ${schemaCode}`,
    params: ({ keyword, schemaCode })=>(0, codegen_1._)`{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`
};
exports.formatLimitDefinition = {
    keyword: Object.keys(KWDs),
    type: "string",
    schemaType: "string",
    $data: true,
    error,
    code (cxt) {
        const { gen, data, schemaCode, keyword, it } = cxt;
        const { opts, self } = it;
        if (!opts.validateFormats) return;
        const fCxt = new ajv_1.KeywordCxt(it, self.RULES.all.format.definition, "format");
        if (fCxt.$data) validate$DataFormat();
        else validateFormat();
        function validate$DataFormat() {
            const fmts = gen.scopeValue("formats", {
                ref: self.formats,
                code: opts.code.formats
            });
            const fmt = gen.const("fmt", (0, codegen_1._)`${fmts}[${fCxt.schemaCode}]`);
            cxt.fail$data((0, codegen_1.or)((0, codegen_1._)`typeof ${fmt} != "object"`, (0, codegen_1._)`${fmt} instanceof RegExp`, (0, codegen_1._)`typeof ${fmt}.compare != "function"`, compareCode(fmt)));
        }
        function validateFormat() {
            const format = fCxt.schema;
            const fmtDef = self.formats[format];
            if (!fmtDef || fmtDef === true) return;
            if (typeof fmtDef != "object" || fmtDef instanceof RegExp || typeof fmtDef.compare != "function") {
                throw new Error(`"${keyword}": format "${format}" does not define "compare" function`);
            }
            const fmt = gen.scopeValue("formats", {
                key: format,
                ref: fmtDef,
                code: opts.code.formats ? (0, codegen_1._)`${opts.code.formats}${(0, codegen_1.getProperty)(format)}` : undefined
            });
            cxt.fail$data(compareCode(fmt));
        }
        function compareCode(fmt) {
            return (0, codegen_1._)`${fmt}.compare(${data}, ${schemaCode}) ${KWDs[keyword].fail} 0`;
        }
    },
    dependencies: [
        "format"
    ]
};
const formatLimitPlugin = (ajv)=>{
    ajv.addKeyword(exports.formatLimitDefinition);
    return ajv;
};
exports.default = formatLimitPlugin; //# sourceMappingURL=limit.js.map
}}),
"[project]/node_modules/ajv-formats/dist/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
const formats_1 = __turbopack_context__.r("[project]/node_modules/ajv-formats/dist/formats.js [app-rsc] (ecmascript)");
const limit_1 = __turbopack_context__.r("[project]/node_modules/ajv-formats/dist/limit.js [app-rsc] (ecmascript)");
const codegen_1 = __turbopack_context__.r("[project]/node_modules/ajv/dist/compile/codegen/index.js [app-rsc] (ecmascript)");
const fullName = new codegen_1.Name("fullFormats");
const fastName = new codegen_1.Name("fastFormats");
const formatsPlugin = (ajv, opts = {
    keywords: true
})=>{
    if (Array.isArray(opts)) {
        addFormats(ajv, opts, formats_1.fullFormats, fullName);
        return ajv;
    }
    const [formats, exportName] = opts.mode === "fast" ? [
        formats_1.fastFormats,
        fastName
    ] : [
        formats_1.fullFormats,
        fullName
    ];
    const list = opts.formats || formats_1.formatNames;
    addFormats(ajv, list, formats, exportName);
    if (opts.keywords) (0, limit_1.default)(ajv);
    return ajv;
};
formatsPlugin.get = (name, mode = "full")=>{
    const formats = mode === "fast" ? formats_1.fastFormats : formats_1.fullFormats;
    const f = formats[name];
    if (!f) throw new Error(`Unknown format "${name}"`);
    return f;
};
function addFormats(ajv, list, fs, exportName) {
    var _a;
    var _b;
    (_a = (_b = ajv.opts.code).formats) !== null && _a !== void 0 ? _a : _b.formats = (0, codegen_1._)`require("ajv-formats/dist/formats").${exportName}`;
    for (const f of list)ajv.addFormat(f, fs[f]);
}
module.exports = exports = formatsPlugin;
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = formatsPlugin; //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/get-port/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const net = __turbopack_context__.r("[externals]/net [external] (net, cjs)");
class Locked extends Error {
    constructor(port){
        super(`${port} is locked`);
    }
}
const lockedPorts = {
    old: new Set(),
    young: new Set()
};
// On this interval, the old locked ports are discarded,
// the young locked ports are moved to old locked ports,
// and a new young set for locked ports are created.
const releaseOldLockedPortsIntervalMs = 1000 * 15;
// Lazily create interval on first use
let interval;
const getAvailablePort = (options)=>new Promise((resolve, reject)=>{
        const server = net.createServer();
        server.unref();
        server.on('error', reject);
        server.listen(options, ()=>{
            const { port } = server.address();
            server.close(()=>{
                resolve(port);
            });
        });
    });
const portCheckSequence = function*(ports) {
    if (ports) {
        yield* ports;
    }
    yield 0; // Fall back to 0 if anything else failed
};
module.exports = async (options)=>{
    let ports;
    if (options) {
        ports = typeof options.port === 'number' ? [
            options.port
        ] : options.port;
    }
    if (interval === undefined) {
        interval = setInterval(()=>{
            lockedPorts.old = lockedPorts.young;
            lockedPorts.young = new Set();
        }, releaseOldLockedPortsIntervalMs);
        // Does not exist in some environments (Electron, Jest jsdom env, browser, etc).
        if (interval.unref) {
            interval.unref();
        }
    }
    for (const port of portCheckSequence(ports)){
        try {
            let availablePort = await getAvailablePort({
                ...options,
                port
            }); // eslint-disable-line no-await-in-loop
            while(lockedPorts.old.has(availablePort) || lockedPorts.young.has(availablePort)){
                if (port !== 0) {
                    throw new Locked(port);
                }
                availablePort = await getAvailablePort({
                    ...options,
                    port
                }); // eslint-disable-line no-await-in-loop
            }
            lockedPorts.young.add(availablePort);
            return availablePort;
        } catch (error) {
            if (![
                'EADDRINUSE',
                'EACCES'
            ].includes(error.code) && !(error instanceof Locked)) {
                throw error;
            }
        }
    }
    throw new Error('No available ports found');
};
module.exports.makeRange = (from, to)=>{
    if (!Number.isInteger(from) || !Number.isInteger(to)) {
        throw new TypeError('`from` and `to` must be integer numbers');
    }
    if (from < 1024 || from > 65535) {
        throw new RangeError('`from` must be between 1024 and 65535');
    }
    if (to < 1024 || to > 65536) {
        throw new RangeError('`to` must be between 1024 and 65536');
    }
    if (to < from) {
        throw new RangeError('`to` must be greater than or equal to `from`');
    }
    const generator = function*(from, to) {
        for(let port = from; port <= to; port++){
            yield port;
        }
    };
    return generator(from, to);
};
}}),
"[project]/node_modules/source-map/lib/base64.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ var intToCharMap = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'.split('');
/**
 * Encode an integer in the range of 0 to 63 to a single base 64 digit.
 */ exports.encode = function(number) {
    if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
    }
    throw new TypeError("Must be between 0 and 63: " + number);
};
/**
 * Decode a single base 64 character code digit to an integer. Returns -1 on
 * failure.
 */ exports.decode = function(charCode) {
    var bigA = 65; // 'A'
    var bigZ = 90; // 'Z'
    var littleA = 97; // 'a'
    var littleZ = 122; // 'z'
    var zero = 48; // '0'
    var nine = 57; // '9'
    var plus = 43; // '+'
    var slash = 47; // '/'
    var littleOffset = 26;
    var numberOffset = 52;
    // 0 - 25: ABCDEFGHIJKLMNOPQRSTUVWXYZ
    if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
    }
    // 26 - 51: abcdefghijklmnopqrstuvwxyz
    if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
    }
    // 52 - 61: 0123456789
    if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
    }
    // 62: +
    if (charCode == plus) {
        return 62;
    }
    // 63: /
    if (charCode == slash) {
        return 63;
    }
    // Invalid base64 digit.
    return -1;
};
}}),
"[project]/node_modules/source-map/lib/base64-vlq.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 *
 * Based on the Base 64 VLQ implementation in Closure Compiler:
 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
 *
 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of Google Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */ var base64 = __turbopack_context__.r("[project]/node_modules/source-map/lib/base64.js [app-rsc] (ecmascript)");
// A single base 64 digit can contain 6 bits of data. For the base 64 variable
// length quantities we use in the source map spec, the first bit is the sign,
// the next four bits are the actual value, and the 6th bit is the
// continuation bit. The continuation bit tells us whether there are more
// digits in this value following this digit.
//
//   Continuation
//   |    Sign
//   |    |
//   V    V
//   101011
var VLQ_BASE_SHIFT = 5;
// binary: 100000
var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
// binary: 011111
var VLQ_BASE_MASK = VLQ_BASE - 1;
// binary: 100000
var VLQ_CONTINUATION_BIT = VLQ_BASE;
/**
 * Converts from a two-complement value to a value where the sign bit is
 * placed in the least significant bit.  For example, as decimals:
 *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
 *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
 */ function toVLQSigned(aValue) {
    return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
}
/**
 * Converts to a two-complement value from a value where the sign bit is
 * placed in the least significant bit.  For example, as decimals:
 *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
 *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
 */ function fromVLQSigned(aValue) {
    var isNegative = (aValue & 1) === 1;
    var shifted = aValue >> 1;
    return isNegative ? -shifted : shifted;
}
/**
 * Returns the base 64 VLQ encoded value.
 */ exports.encode = function base64VLQ_encode(aValue) {
    var encoded = "";
    var digit;
    var vlq = toVLQSigned(aValue);
    do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
            // There are still more digits in this value, so we must make sure the
            // continuation bit is marked.
            digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
    }while (vlq > 0)
    return encoded;
};
/**
 * Decodes the next base 64 VLQ value from the given string and returns the
 * value and the rest of the string via the out parameter.
 */ exports.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
    var strLen = aStr.length;
    var result = 0;
    var shift = 0;
    var continuation, digit;
    do {
        if (aIndex >= strLen) {
            throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
            throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
    }while (continuation)
    aOutParam.value = fromVLQSigned(result);
    aOutParam.rest = aIndex;
};
}}),
"[project]/node_modules/source-map/lib/util.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ /**
 * This is a helper function for getting values from parameter/options
 * objects.
 *
 * @param args The object we are extracting values from
 * @param name The name of the property we are getting.
 * @param defaultValue An optional value to return if the property is missing
 * from the object. If this is not specified and the property is missing, an
 * error will be thrown.
 */ function getArg(aArgs, aName, aDefaultValue) {
    if (aName in aArgs) {
        return aArgs[aName];
    } else if (arguments.length === 3) {
        return aDefaultValue;
    } else {
        throw new Error('"' + aName + '" is a required argument.');
    }
}
exports.getArg = getArg;
var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
var dataUrlRegexp = /^data:.+\,.+$/;
function urlParse(aUrl) {
    var match = aUrl.match(urlRegexp);
    if (!match) {
        return null;
    }
    return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
    };
}
exports.urlParse = urlParse;
function urlGenerate(aParsedUrl) {
    var url = '';
    if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ':';
    }
    url += '//';
    if (aParsedUrl.auth) {
        url += aParsedUrl.auth + '@';
    }
    if (aParsedUrl.host) {
        url += aParsedUrl.host;
    }
    if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
    }
    if (aParsedUrl.path) {
        url += aParsedUrl.path;
    }
    return url;
}
exports.urlGenerate = urlGenerate;
/**
 * Normalizes a path, or the path portion of a URL:
 *
 * - Replaces consecutive slashes with one slash.
 * - Removes unnecessary '.' parts.
 * - Removes unnecessary '<dir>/..' parts.
 *
 * Based on code in the Node.js 'path' core module.
 *
 * @param aPath The path or url to normalize.
 */ function normalize(aPath) {
    var path = aPath;
    var url = urlParse(aPath);
    if (url) {
        if (!url.path) {
            return aPath;
        }
        path = url.path;
    }
    var isAbsolute = exports.isAbsolute(path);
    var parts = path.split(/\/+/);
    for(var part, up = 0, i = parts.length - 1; i >= 0; i--){
        part = parts[i];
        if (part === '.') {
            parts.splice(i, 1);
        } else if (part === '..') {
            up++;
        } else if (up > 0) {
            if (part === '') {
                // The first part is blank if the path is absolute. Trying to go
                // above the root is a no-op. Therefore we can remove all '..' parts
                // directly after the root.
                parts.splice(i + 1, up);
                up = 0;
            } else {
                parts.splice(i, 2);
                up--;
            }
        }
    }
    path = parts.join('/');
    if (path === '') {
        path = isAbsolute ? '/' : '.';
    }
    if (url) {
        url.path = path;
        return urlGenerate(url);
    }
    return path;
}
exports.normalize = normalize;
/**
 * Joins two paths/URLs.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be joined with the root.
 *
 * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
 *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
 *   first.
 * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
 *   is updated with the result and aRoot is returned. Otherwise the result
 *   is returned.
 *   - If aPath is absolute, the result is aPath.
 *   - Otherwise the two paths are joined with a slash.
 * - Joining for example 'http://' and 'www.example.com' is also supported.
 */ function join(aRoot, aPath) {
    if (aRoot === "") {
        aRoot = ".";
    }
    if (aPath === "") {
        aPath = ".";
    }
    var aPathUrl = urlParse(aPath);
    var aRootUrl = urlParse(aRoot);
    if (aRootUrl) {
        aRoot = aRootUrl.path || '/';
    }
    // `join(foo, '//www.example.org')`
    if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
            aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
    }
    if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
    }
    // `join('http://', 'www.example.com')`
    if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
    }
    var joined = aPath.charAt(0) === '/' ? aPath : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);
    if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
    }
    return joined;
}
exports.join = join;
exports.isAbsolute = function(aPath) {
    return aPath.charAt(0) === '/' || urlRegexp.test(aPath);
};
/**
 * Make a path relative to a URL or another path.
 *
 * @param aRoot The root path or URL.
 * @param aPath The path or URL to be made relative to aRoot.
 */ function relative(aRoot, aPath) {
    if (aRoot === "") {
        aRoot = ".";
    }
    aRoot = aRoot.replace(/\/$/, '');
    // It is possible for the path to be above the root. In this case, simply
    // checking whether the root is a prefix of the path won't work. Instead, we
    // need to remove components from the root one by one, until either we find
    // a prefix that fits, or we run out of components to remove.
    var level = 0;
    while(aPath.indexOf(aRoot + '/') !== 0){
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
            return aPath;
        }
        // If the only part of the root that is left is the scheme (i.e. http://,
        // file:///, etc.), one or more slashes (/), or simply nothing at all, we
        // have exhausted all components, so the path is not relative to the root.
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
            return aPath;
        }
        ++level;
    }
    // Make sure we add a "../" for each component we removed from the root.
    return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
}
exports.relative = relative;
var supportsNullProto = function() {
    var obj = Object.create(null);
    return !('__proto__' in obj);
}();
function identity(s) {
    return s;
}
/**
 * Because behavior goes wacky when you set `__proto__` on objects, we
 * have to prefix all the strings in our set with an arbitrary character.
 *
 * See https://github.com/mozilla/source-map/pull/31 and
 * https://github.com/mozilla/source-map/issues/30
 *
 * @param String aStr
 */ function toSetString(aStr) {
    if (isProtoString(aStr)) {
        return '$' + aStr;
    }
    return aStr;
}
exports.toSetString = supportsNullProto ? identity : toSetString;
function fromSetString(aStr) {
    if (isProtoString(aStr)) {
        return aStr.slice(1);
    }
    return aStr;
}
exports.fromSetString = supportsNullProto ? identity : fromSetString;
function isProtoString(s) {
    if (!s) {
        return false;
    }
    var length = s.length;
    if (length < 9 /* "__proto__".length */ ) {
        return false;
    }
    if (s.charCodeAt(length - 1) !== 95 /* '_' */  || s.charCodeAt(length - 2) !== 95 /* '_' */  || s.charCodeAt(length - 3) !== 111 /* 'o' */  || s.charCodeAt(length - 4) !== 116 /* 't' */  || s.charCodeAt(length - 5) !== 111 /* 'o' */  || s.charCodeAt(length - 6) !== 114 /* 'r' */  || s.charCodeAt(length - 7) !== 112 /* 'p' */  || s.charCodeAt(length - 8) !== 95 /* '_' */  || s.charCodeAt(length - 9) !== 95 /* '_' */ ) {
        return false;
    }
    for(var i = length - 10; i >= 0; i--){
        if (s.charCodeAt(i) !== 36 /* '$' */ ) {
            return false;
        }
    }
    return true;
}
/**
 * Comparator between two mappings where the original positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same original source/line/column, but different generated
 * line and column the same. Useful when searching for a mapping with a
 * stubbed out mapping.
 */ function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
    var cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
    }
    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
        return cmp;
    }
    return strcmp(mappingA.name, mappingB.name);
}
exports.compareByOriginalPositions = compareByOriginalPositions;
/**
 * Comparator between two mappings with deflated source and name indices where
 * the generated positions are compared.
 *
 * Optionally pass in `true` as `onlyCompareGenerated` to consider two
 * mappings with the same generated line and column, but different
 * source/name/original line and column the same. Useful when searching for a
 * mapping with a stubbed out mapping.
 */ function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
    var cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
    }
    cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0) {
        return cmp;
    }
    return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
function strcmp(aStr1, aStr2) {
    if (aStr1 === aStr2) {
        return 0;
    }
    if (aStr1 === null) {
        return 1; // aStr2 !== null
    }
    if (aStr2 === null) {
        return -1; // aStr1 !== null
    }
    if (aStr1 > aStr2) {
        return 1;
    }
    return -1;
}
/**
 * Comparator between two mappings with inflated source and name strings where
 * the generated positions are compared.
 */ function compareByGeneratedPositionsInflated(mappingA, mappingB) {
    var cmp = mappingA.generatedLine - mappingB.generatedLine;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = strcmp(mappingA.source, mappingB.source);
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.originalLine - mappingB.originalLine;
    if (cmp !== 0) {
        return cmp;
    }
    cmp = mappingA.originalColumn - mappingB.originalColumn;
    if (cmp !== 0) {
        return cmp;
    }
    return strcmp(mappingA.name, mappingB.name);
}
exports.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
/**
 * Strip any JSON XSSI avoidance prefix from the string (as documented
 * in the source maps specification), and then parse the string as
 * JSON.
 */ function parseSourceMapInput(str) {
    return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ''));
}
exports.parseSourceMapInput = parseSourceMapInput;
/**
 * Compute the URL of a source given the the source root, the source's
 * URL, and the source map's URL.
 */ function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
    sourceURL = sourceURL || '';
    if (sourceRoot) {
        // This follows what Chrome does.
        if (sourceRoot[sourceRoot.length - 1] !== '/' && sourceURL[0] !== '/') {
            sourceRoot += '/';
        }
        // The spec says:
        //   Line 4: An optional source root, useful for relocating source
        //   files on a server or removing repeated values in the
        //   “sources” entry.  This value is prepended to the individual
        //   entries in the “source” field.
        sourceURL = sourceRoot + sourceURL;
    }
    // Historically, SourceMapConsumer did not take the sourceMapURL as
    // a parameter.  This mode is still somewhat supported, which is why
    // this code block is conditional.  However, it's preferable to pass
    // the source map URL to SourceMapConsumer, so that this function
    // can implement the source URL resolution algorithm as outlined in
    // the spec.  This block is basically the equivalent of:
    //    new URL(sourceURL, sourceMapURL).toString()
    // ... except it avoids using URL, which wasn't available in the
    // older releases of node still supported by this library.
    //
    // The spec says:
    //   If the sources are not absolute URLs after prepending of the
    //   “sourceRoot”, the sources are resolved relative to the
    //   SourceMap (like resolving script src in a html document).
    if (sourceMapURL) {
        var parsed = urlParse(sourceMapURL);
        if (!parsed) {
            throw new Error("sourceMapURL could not be parsed");
        }
        if (parsed.path) {
            // Strip the last path component, but keep the "/".
            var index = parsed.path.lastIndexOf('/');
            if (index >= 0) {
                parsed.path = parsed.path.substring(0, index + 1);
            }
        }
        sourceURL = join(urlGenerate(parsed), sourceURL);
    }
    return normalize(sourceURL);
}
exports.computeSourceURL = computeSourceURL;
}}),
"[project]/node_modules/source-map/lib/array-set.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ var util = __turbopack_context__.r("[project]/node_modules/source-map/lib/util.js [app-rsc] (ecmascript)");
var has = Object.prototype.hasOwnProperty;
var hasNativeMap = typeof Map !== "undefined";
/**
 * A data structure which is a combination of an array and a set. Adding a new
 * member is O(1), testing for membership is O(1), and finding the index of an
 * element is O(1). Removing elements from the set is not supported. Only
 * strings are supported for membership.
 */ function ArraySet() {
    this._array = [];
    this._set = hasNativeMap ? new Map() : Object.create(null);
}
/**
 * Static method for creating ArraySet instances from an existing array.
 */ ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
    var set = new ArraySet();
    for(var i = 0, len = aArray.length; i < len; i++){
        set.add(aArray[i], aAllowDuplicates);
    }
    return set;
};
/**
 * Return how many unique items are in this ArraySet. If duplicates have been
 * added, than those do not count towards the size.
 *
 * @returns Number
 */ ArraySet.prototype.size = function ArraySet_size() {
    return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
};
/**
 * Add the given string to this set.
 *
 * @param String aStr
 */ ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
    var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
    var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
    var idx = this._array.length;
    if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
    }
    if (!isDuplicate) {
        if (hasNativeMap) {
            this._set.set(aStr, idx);
        } else {
            this._set[sStr] = idx;
        }
    }
};
/**
 * Is the given string a member of this set?
 *
 * @param String aStr
 */ ArraySet.prototype.has = function ArraySet_has(aStr) {
    if (hasNativeMap) {
        return this._set.has(aStr);
    } else {
        var sStr = util.toSetString(aStr);
        return has.call(this._set, sStr);
    }
};
/**
 * What is the index of the given string in the array?
 *
 * @param String aStr
 */ ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
    if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
            return idx;
        }
    } else {
        var sStr = util.toSetString(aStr);
        if (has.call(this._set, sStr)) {
            return this._set[sStr];
        }
    }
    throw new Error('"' + aStr + '" is not in the set.');
};
/**
 * What is the element at the given index?
 *
 * @param Number aIdx
 */ ArraySet.prototype.at = function ArraySet_at(aIdx) {
    if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
    }
    throw new Error('No element indexed by ' + aIdx);
};
/**
 * Returns the array representation of this set (which has the proper indices
 * indicated by indexOf). Note that this is a copy of the internal array used
 * for storing the members so that no one can mess with internal state.
 */ ArraySet.prototype.toArray = function ArraySet_toArray() {
    return this._array.slice();
};
exports.ArraySet = ArraySet;
}}),
"[project]/node_modules/source-map/lib/mapping-list.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2014 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ var util = __turbopack_context__.r("[project]/node_modules/source-map/lib/util.js [app-rsc] (ecmascript)");
/**
 * Determine whether mappingB is after mappingA with respect to generated
 * position.
 */ function generatedPositionAfter(mappingA, mappingB) {
    // Optimized for most common case
    var lineA = mappingA.generatedLine;
    var lineB = mappingB.generatedLine;
    var columnA = mappingA.generatedColumn;
    var columnB = mappingB.generatedColumn;
    return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
}
/**
 * A data structure to provide a sorted view of accumulated mappings in a
 * performance conscious manner. It trades a neglibable overhead in general
 * case for a large speedup in case of mappings being added in order.
 */ function MappingList() {
    this._array = [];
    this._sorted = true;
    // Serves as infimum
    this._last = {
        generatedLine: -1,
        generatedColumn: 0
    };
}
/**
 * Iterate through internal items. This method takes the same arguments that
 * `Array.prototype.forEach` takes.
 *
 * NOTE: The order of the mappings is NOT guaranteed.
 */ MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
    this._array.forEach(aCallback, aThisArg);
};
/**
 * Add the given source mapping.
 *
 * @param Object aMapping
 */ MappingList.prototype.add = function MappingList_add(aMapping) {
    if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
    } else {
        this._sorted = false;
        this._array.push(aMapping);
    }
};
/**
 * Returns the flat, sorted array of mappings. The mappings are sorted by
 * generated position.
 *
 * WARNING: This method returns internal data without copying, for
 * performance. The return value must NOT be mutated, and should be treated as
 * an immutable borrow. If you want to take ownership, you must make your own
 * copy.
 */ MappingList.prototype.toArray = function MappingList_toArray() {
    if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
    }
    return this._array;
};
exports.MappingList = MappingList;
}}),
"[project]/node_modules/source-map/lib/source-map-generator.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ var base64VLQ = __turbopack_context__.r("[project]/node_modules/source-map/lib/base64-vlq.js [app-rsc] (ecmascript)");
var util = __turbopack_context__.r("[project]/node_modules/source-map/lib/util.js [app-rsc] (ecmascript)");
var ArraySet = __turbopack_context__.r("[project]/node_modules/source-map/lib/array-set.js [app-rsc] (ecmascript)").ArraySet;
var MappingList = __turbopack_context__.r("[project]/node_modules/source-map/lib/mapping-list.js [app-rsc] (ecmascript)").MappingList;
/**
 * An instance of the SourceMapGenerator represents a source map which is
 * being built incrementally. You may pass an object with the following
 * properties:
 *
 *   - file: The filename of the generated source.
 *   - sourceRoot: A root for all relative URLs in this source map.
 */ function SourceMapGenerator(aArgs) {
    if (!aArgs) {
        aArgs = {};
    }
    this._file = util.getArg(aArgs, 'file', null);
    this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
    this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
    this._sources = new ArraySet();
    this._names = new ArraySet();
    this._mappings = new MappingList();
    this._sourcesContents = null;
}
SourceMapGenerator.prototype._version = 3;
/**
 * Creates a new SourceMapGenerator based on a SourceMapConsumer
 *
 * @param aSourceMapConsumer The SourceMap.
 */ SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
    var sourceRoot = aSourceMapConsumer.sourceRoot;
    var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot: sourceRoot
    });
    aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
            generated: {
                line: mapping.generatedLine,
                column: mapping.generatedColumn
            }
        };
        if (mapping.source != null) {
            newMapping.source = mapping.source;
            if (sourceRoot != null) {
                newMapping.source = util.relative(sourceRoot, newMapping.source);
            }
            newMapping.original = {
                line: mapping.originalLine,
                column: mapping.originalColumn
            };
            if (mapping.name != null) {
                newMapping.name = mapping.name;
            }
        }
        generator.addMapping(newMapping);
    });
    aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
            sourceRelative = util.relative(sourceRoot, sourceFile);
        }
        if (!generator._sources.has(sourceRelative)) {
            generator._sources.add(sourceRelative);
        }
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
            generator.setSourceContent(sourceFile, content);
        }
    });
    return generator;
};
/**
 * Add a single mapping from original source line and column to the generated
 * source's line and column for this source map being created. The mapping
 * object should have the following properties:
 *
 *   - generated: An object with the generated line and column positions.
 *   - original: An object with the original line and column positions.
 *   - source: The original source file (relative to the sourceRoot).
 *   - name: An optional original token name for this mapping.
 */ SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
    var generated = util.getArg(aArgs, 'generated');
    var original = util.getArg(aArgs, 'original', null);
    var source = util.getArg(aArgs, 'source', null);
    var name = util.getArg(aArgs, 'name', null);
    if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
    }
    if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
            this._sources.add(source);
        }
    }
    if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
            this._names.add(name);
        }
    }
    this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source: source,
        name: name
    });
};
/**
 * Set the source content for a source file.
 */ SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
    var source = aSourceFile;
    if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
    }
    if (aSourceContent != null) {
        // Add the source content to the _sourcesContents map.
        // Create a new _sourcesContents map if the property is null.
        if (!this._sourcesContents) {
            this._sourcesContents = Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
    } else if (this._sourcesContents) {
        // Remove the source file from the _sourcesContents map.
        // If the _sourcesContents map is empty, set the property to null.
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
            this._sourcesContents = null;
        }
    }
};
/**
 * Applies the mappings of a sub-source-map for a specific source file to the
 * source map being generated. Each mapping to the supplied source file is
 * rewritten using the supplied source map. Note: The resolution for the
 * resulting mappings is the minimium of this map and the supplied map.
 *
 * @param aSourceMapConsumer The source map to be applied.
 * @param aSourceFile Optional. The filename of the source file.
 *        If omitted, SourceMapConsumer's file property will be used.
 * @param aSourceMapPath Optional. The dirname of the path to the source map
 *        to be applied. If relative, it is relative to the SourceMapConsumer.
 *        This parameter is needed when the two source maps aren't in the same
 *        directory, and the source map to be applied contains relative source
 *        paths. If so, those relative source paths need to be rewritten
 *        relative to the SourceMapGenerator.
 */ SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
    var sourceFile = aSourceFile;
    // If aSourceFile is omitted, we will use the file property of the SourceMap
    if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
            throw new Error('SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' + 'or the source map\'s "file" property. Both were omitted.');
        }
        sourceFile = aSourceMapConsumer.file;
    }
    var sourceRoot = this._sourceRoot;
    // Make "sourceFile" relative if an absolute Url is passed.
    if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
    }
    // Applying the SourceMap can add and remove items from the sources and
    // the names array.
    var newSources = new ArraySet();
    var newNames = new ArraySet();
    // Find mappings for the "sourceFile"
    this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
            // Check if it can be mapped by the source map, then update the mapping.
            var original = aSourceMapConsumer.originalPositionFor({
                line: mapping.originalLine,
                column: mapping.originalColumn
            });
            if (original.source != null) {
                // Copy mapping
                mapping.source = original.source;
                if (aSourceMapPath != null) {
                    mapping.source = util.join(aSourceMapPath, mapping.source);
                }
                if (sourceRoot != null) {
                    mapping.source = util.relative(sourceRoot, mapping.source);
                }
                mapping.originalLine = original.line;
                mapping.originalColumn = original.column;
                if (original.name != null) {
                    mapping.name = original.name;
                }
            }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
            newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
            newNames.add(name);
        }
    }, this);
    this._sources = newSources;
    this._names = newNames;
    // Copy sourcesContents of applied map.
    aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
            if (aSourceMapPath != null) {
                sourceFile = util.join(aSourceMapPath, sourceFile);
            }
            if (sourceRoot != null) {
                sourceFile = util.relative(sourceRoot, sourceFile);
            }
            this.setSourceContent(sourceFile, content);
        }
    }, this);
};
/**
 * A mapping can have one of the three levels of data:
 *
 *   1. Just the generated position.
 *   2. The Generated position, original position, and original source.
 *   3. Generated and original position, original source, as well as a name
 *      token.
 *
 * To maintain consistency, we validate that any new mapping being added falls
 * in to one of these categories.
 */ SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
    // When aOriginal is truthy but has empty values for .line and .column,
    // it is most likely a programmer error. In this case we throw a very
    // specific error message to try to guide them the right way.
    // For example: https://github.com/Polymer/polymer-bundler/pull/519
    if (aOriginal && typeof aOriginal.line !== 'number' && typeof aOriginal.column !== 'number') {
        throw new Error('original.line and original.column are not numbers -- you probably meant to omit ' + 'the original mapping entirely and only map the generated position. If so, pass ' + 'null for the original mapping instead of an object with empty or null values.');
    }
    if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        // Case 1.
        return;
    } else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated && aOriginal && 'line' in aOriginal && 'column' in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        // Cases 2 and 3.
        return;
    } else {
        throw new Error('Invalid mapping: ' + JSON.stringify({
            generated: aGenerated,
            source: aSource,
            original: aOriginal,
            name: aName
        }));
    }
};
/**
 * Serialize the accumulated mappings in to the stream of base 64 VLQs
 * specified by the source map format.
 */ SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
    var previousGeneratedColumn = 0;
    var previousGeneratedLine = 1;
    var previousOriginalColumn = 0;
    var previousOriginalLine = 0;
    var previousName = 0;
    var previousSource = 0;
    var result = '';
    var next;
    var mapping;
    var nameIdx;
    var sourceIdx;
    var mappings = this._mappings.toArray();
    for(var i = 0, len = mappings.length; i < len; i++){
        mapping = mappings[i];
        next = '';
        if (mapping.generatedLine !== previousGeneratedLine) {
            previousGeneratedColumn = 0;
            while(mapping.generatedLine !== previousGeneratedLine){
                next += ';';
                previousGeneratedLine++;
            }
        } else {
            if (i > 0) {
                if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
                    continue;
                }
                next += ',';
            }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
            sourceIdx = this._sources.indexOf(mapping.source);
            next += base64VLQ.encode(sourceIdx - previousSource);
            previousSource = sourceIdx;
            // lines are stored 0-based in SourceMap spec version 3
            next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
            previousOriginalLine = mapping.originalLine - 1;
            next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
            previousOriginalColumn = mapping.originalColumn;
            if (mapping.name != null) {
                nameIdx = this._names.indexOf(mapping.name);
                next += base64VLQ.encode(nameIdx - previousName);
                previousName = nameIdx;
            }
        }
        result += next;
    }
    return result;
};
SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
    return aSources.map(function(source) {
        if (!this._sourcesContents) {
            return null;
        }
        if (aSourceRoot != null) {
            source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
    }, this);
};
/**
 * Externalize the source map.
 */ SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
    var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
    };
    if (this._file != null) {
        map.file = this._file;
    }
    if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
    }
    if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
    }
    return map;
};
/**
 * Render the source map being generated to a string.
 */ SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
    return JSON.stringify(this.toJSON());
};
exports.SourceMapGenerator = SourceMapGenerator;
}}),
"[project]/node_modules/source-map/lib/binary-search.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ exports.GREATEST_LOWER_BOUND = 1;
exports.LEAST_UPPER_BOUND = 2;
/**
 * Recursive implementation of binary search.
 *
 * @param aLow Indices here and lower do not contain the needle.
 * @param aHigh Indices here and higher do not contain the needle.
 * @param aNeedle The element being searched for.
 * @param aHaystack The non-empty array being searched.
 * @param aCompare Function which takes two elements and returns -1, 0, or 1.
 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
 *     closest element that is smaller than or greater than the one we are
 *     searching for, respectively, if the exact element cannot be found.
 */ function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
    // This function terminates when one of the following is true:
    //
    //   1. We find the exact element we are looking for.
    //
    //   2. We did not find the exact element, but we can return the index of
    //      the next-closest element.
    //
    //   3. We did not find the exact element, and there is no next-closest
    //      element than the one we are searching for, so we return -1.
    var mid = Math.floor((aHigh - aLow) / 2) + aLow;
    var cmp = aCompare(aNeedle, aHaystack[mid], true);
    if (cmp === 0) {
        // Found the element we are looking for.
        return mid;
    } else if (cmp > 0) {
        // Our needle is greater than aHaystack[mid].
        if (aHigh - mid > 1) {
            // The element is in the upper half.
            return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        // The exact needle element was not found in this haystack. Determine if
        // we are in termination case (3) or (2) and return the appropriate thing.
        if (aBias == exports.LEAST_UPPER_BOUND) {
            return aHigh < aHaystack.length ? aHigh : -1;
        } else {
            return mid;
        }
    } else {
        // Our needle is less than aHaystack[mid].
        if (mid - aLow > 1) {
            // The element is in the lower half.
            return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        // we are in termination case (3) or (2) and return the appropriate thing.
        if (aBias == exports.LEAST_UPPER_BOUND) {
            return mid;
        } else {
            return aLow < 0 ? -1 : aLow;
        }
    }
}
/**
 * This is an implementation of binary search which will always try and return
 * the index of the closest element if there is no exact hit. This is because
 * mappings between original and generated line/col pairs are single points,
 * and there is an implicit region between each of them, so a miss just means
 * that you aren't on the very start of a region.
 *
 * @param aNeedle The element you are looking for.
 * @param aHaystack The array that is being searched.
 * @param aCompare A function which takes the needle and an element in the
 *     array and returns -1, 0, or 1 depending on whether the needle is less
 *     than, equal to, or greater than the element, respectively.
 * @param aBias Either 'binarySearch.GREATEST_LOWER_BOUND' or
 *     'binarySearch.LEAST_UPPER_BOUND'. Specifies whether to return the
 *     closest element that is smaller than or greater than the one we are
 *     searching for, respectively, if the exact element cannot be found.
 *     Defaults to 'binarySearch.GREATEST_LOWER_BOUND'.
 */ exports.search = function search(aNeedle, aHaystack, aCompare, aBias) {
    if (aHaystack.length === 0) {
        return -1;
    }
    var index = recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare, aBias || exports.GREATEST_LOWER_BOUND);
    if (index < 0) {
        return -1;
    }
    // We have found either the exact element, or the next-closest element than
    // the one we are searching for. However, there may be more than one such
    // element. Make sure we always return the smallest of these.
    while(index - 1 >= 0){
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
            break;
        }
        --index;
    }
    return index;
};
}}),
"[project]/node_modules/source-map/lib/quick-sort.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ // It turns out that some (most?) JavaScript engines don't self-host
// `Array.prototype.sort`. This makes sense because C++ will likely remain
// faster than JS when doing raw CPU-intensive sorting. However, when using a
// custom comparator function, calling back and forth between the VM's C++ and
// JIT'd JS is rather slow *and* loses JIT type information, resulting in
// worse generated code for the comparator function than would be optimal. In
// fact, when sorting with a comparator, these costs outweigh the benefits of
// sorting in C++. By using our own JS-implemented Quick Sort (below), we get
// a ~3500ms mean speed-up in `bench/bench.html`.
/**
 * Swap the elements indexed by `x` and `y` in the array `ary`.
 *
 * @param {Array} ary
 *        The array.
 * @param {Number} x
 *        The index of the first item.
 * @param {Number} y
 *        The index of the second item.
 */ function swap(ary, x, y) {
    var temp = ary[x];
    ary[x] = ary[y];
    ary[y] = temp;
}
/**
 * Returns a random integer within the range `low .. high` inclusive.
 *
 * @param {Number} low
 *        The lower bound on the range.
 * @param {Number} high
 *        The upper bound on the range.
 */ function randomIntInRange(low, high) {
    return Math.round(low + Math.random() * (high - low));
}
/**
 * The Quick Sort algorithm.
 *
 * @param {Array} ary
 *        An array to sort.
 * @param {function} comparator
 *        Function to use to compare two items.
 * @param {Number} p
 *        Start index of the array
 * @param {Number} r
 *        End index of the array
 */ function doQuickSort(ary, comparator, p, r) {
    // If our lower bound is less than our upper bound, we (1) partition the
    // array into two pieces and (2) recurse on each half. If it is not, this is
    // the empty array and our base case.
    if (p < r) {
        // (1) Partitioning.
        //
        // The partitioning chooses a pivot between `p` and `r` and moves all
        // elements that are less than or equal to the pivot to the before it, and
        // all the elements that are greater than it after it. The effect is that
        // once partition is done, the pivot is in the exact place it will be when
        // the array is put in sorted order, and it will not need to be moved
        // again. This runs in O(n) time.
        // Always choose a random pivot so that an input array which is reverse
        // sorted does not cause O(n^2) running time.
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        // Immediately after `j` is incremented in this loop, the following hold
        // true:
        //
        //   * Every element in `ary[p .. i]` is less than or equal to the pivot.
        //
        //   * Every element in `ary[i+1 .. j-1]` is greater than the pivot.
        for(var j = p; j < r; j++){
            if (comparator(ary[j], pivot) <= 0) {
                i += 1;
                swap(ary, i, j);
            }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        // (2) Recurse on each half.
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
    }
}
/**
 * Sort the given array in-place with the given comparator function.
 *
 * @param {Array} ary
 *        An array to sort.
 * @param {function} comparator
 *        Function to use to compare two items.
 */ exports.quickSort = function(ary, comparator) {
    doQuickSort(ary, comparator, 0, ary.length - 1);
};
}}),
"[project]/node_modules/source-map/lib/source-map-consumer.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ var util = __turbopack_context__.r("[project]/node_modules/source-map/lib/util.js [app-rsc] (ecmascript)");
var binarySearch = __turbopack_context__.r("[project]/node_modules/source-map/lib/binary-search.js [app-rsc] (ecmascript)");
var ArraySet = __turbopack_context__.r("[project]/node_modules/source-map/lib/array-set.js [app-rsc] (ecmascript)").ArraySet;
var base64VLQ = __turbopack_context__.r("[project]/node_modules/source-map/lib/base64-vlq.js [app-rsc] (ecmascript)");
var quickSort = __turbopack_context__.r("[project]/node_modules/source-map/lib/quick-sort.js [app-rsc] (ecmascript)").quickSort;
function SourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
        sourceMap = util.parseSourceMapInput(aSourceMap);
    }
    return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
}
SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
    return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
};
/**
 * The version of the source mapping spec that we are consuming.
 */ SourceMapConsumer.prototype._version = 3;
// `__generatedMappings` and `__originalMappings` are arrays that hold the
// parsed mapping coordinates from the source map's "mappings" attribute. They
// are lazily instantiated, accessed via the `_generatedMappings` and
// `_originalMappings` getters respectively, and we only parse the mappings
// and create these arrays once queried for a source location. We jump through
// these hoops because there can be many thousands of mappings, and parsing
// them is expensive, so we only want to do it if we must.
//
// Each object in the arrays is of the form:
//
//     {
//       generatedLine: The line number in the generated code,
//       generatedColumn: The column number in the generated code,
//       source: The path to the original source file that generated this
//               chunk of code,
//       originalLine: The line number in the original source that
//                     corresponds to this chunk of generated code,
//       originalColumn: The column number in the original source that
//                       corresponds to this chunk of generated code,
//       name: The name of the original symbol which generated this chunk of
//             code.
//     }
//
// All properties except for `generatedLine` and `generatedColumn` can be
// `null`.
//
// `_generatedMappings` is ordered by the generated positions.
//
// `_originalMappings` is ordered by the original positions.
SourceMapConsumer.prototype.__generatedMappings = null;
Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
    configurable: true,
    enumerable: true,
    get: function() {
        if (!this.__generatedMappings) {
            this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
    }
});
SourceMapConsumer.prototype.__originalMappings = null;
Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
    configurable: true,
    enumerable: true,
    get: function() {
        if (!this.__originalMappings) {
            this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
    }
});
SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
    var c = aStr.charAt(index);
    return c === ";" || c === ",";
};
/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */ SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    throw new Error("Subclasses must implement _parseMappings");
};
SourceMapConsumer.GENERATED_ORDER = 1;
SourceMapConsumer.ORIGINAL_ORDER = 2;
SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
SourceMapConsumer.LEAST_UPPER_BOUND = 2;
/**
 * Iterate over each mapping between an original source/line/column and a
 * generated line/column in this source map.
 *
 * @param Function aCallback
 *        The function that is called with each mapping.
 * @param Object aContext
 *        Optional. If specified, this object will be the value of `this` every
 *        time that `aCallback` is called.
 * @param aOrder
 *        Either `SourceMapConsumer.GENERATED_ORDER` or
 *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
 *        iterate over the mappings sorted by the generated file's line/column
 *        order or the original's source/line/column order, respectively. Defaults to
 *        `SourceMapConsumer.GENERATED_ORDER`.
 */ SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
    var context = aContext || null;
    var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
    var mappings;
    switch(order){
        case SourceMapConsumer.GENERATED_ORDER:
            mappings = this._generatedMappings;
            break;
        case SourceMapConsumer.ORIGINAL_ORDER:
            mappings = this._originalMappings;
            break;
        default:
            throw new Error("Unknown order of iteration.");
    }
    var sourceRoot = this.sourceRoot;
    mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
            source: source,
            generatedLine: mapping.generatedLine,
            generatedColumn: mapping.generatedColumn,
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name: mapping.name === null ? null : this._names.at(mapping.name)
        };
    }, this).forEach(aCallback, context);
};
/**
 * Returns all generated line and column information for the original source,
 * line, and column provided. If no column is provided, returns all mappings
 * corresponding to a either the line we are searching for or the next
 * closest line that has any mappings. Otherwise, returns all mappings
 * corresponding to the given line and either the column we are searching for
 * or the next closest column that has any offsets.
 *
 * The only argument is an object with the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.  The line number is 1-based.
 *   - column: Optional. the column number in the original source.
 *    The column number is 0-based.
 *
 * and an array of objects is returned, each with the following properties:
 *
 *   - line: The line number in the generated source, or null.  The
 *    line number is 1-based.
 *   - column: The column number in the generated source, or null.
 *    The column number is 0-based.
 */ SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
    var line = util.getArg(aArgs, 'line');
    // When there is no exact match, BasicSourceMapConsumer.prototype._findMapping
    // returns the index of the closest mapping less than the needle. By
    // setting needle.originalColumn to 0, we thus find the last mapping for
    // the given line, provided such a mapping exists.
    var needle = {
        source: util.getArg(aArgs, 'source'),
        originalLine: line,
        originalColumn: util.getArg(aArgs, 'column', 0)
    };
    needle.source = this._findSourceIndex(needle.source);
    if (needle.source < 0) {
        return [];
    }
    var mappings = [];
    var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions, binarySearch.LEAST_UPPER_BOUND);
    if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === undefined) {
            var originalLine = mapping.originalLine;
            // Iterate until either we run out of mappings, or we run into
            // a mapping for a different line than the one we found. Since
            // mappings are sorted, this is guaranteed to find all mappings for
            // the line we found.
            while(mapping && mapping.originalLine === originalLine){
                mappings.push({
                    line: util.getArg(mapping, 'generatedLine', null),
                    column: util.getArg(mapping, 'generatedColumn', null),
                    lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
                });
                mapping = this._originalMappings[++index];
            }
        } else {
            var originalColumn = mapping.originalColumn;
            // Iterate until either we run out of mappings, or we run into
            // a mapping for a different line than the one we were searching for.
            // Since mappings are sorted, this is guaranteed to find all mappings for
            // the line we are searching for.
            while(mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn){
                mappings.push({
                    line: util.getArg(mapping, 'generatedLine', null),
                    column: util.getArg(mapping, 'generatedColumn', null),
                    lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
                });
                mapping = this._originalMappings[++index];
            }
        }
    }
    return mappings;
};
exports.SourceMapConsumer = SourceMapConsumer;
/**
 * A BasicSourceMapConsumer instance represents a parsed source map which we can
 * query for information about the original file positions by giving it a file
 * position in the generated source.
 *
 * The first parameter is the raw source map (either as a JSON string, or
 * already parsed to an object). According to the spec, source maps have the
 * following attributes:
 *
 *   - version: Which version of the source map spec this map is following.
 *   - sources: An array of URLs to the original source files.
 *   - names: An array of identifiers which can be referrenced by individual mappings.
 *   - sourceRoot: Optional. The URL root from which all sources are relative.
 *   - sourcesContent: Optional. An array of contents of the original source files.
 *   - mappings: A string of base64 VLQs which contain the actual mappings.
 *   - file: Optional. The generated file this source map is associated with.
 *
 * Here is an example source map, taken from the source map spec[0]:
 *
 *     {
 *       version : 3,
 *       file: "out.js",
 *       sourceRoot : "",
 *       sources: ["foo.js", "bar.js"],
 *       names: ["src", "maps", "are", "fun"],
 *       mappings: "AA,AB;;ABCDE;"
 *     }
 *
 * The second parameter, if given, is a string whose value is the URL
 * at which the source map was found.  This URL is used to compute the
 * sources array.
 *
 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
 */ function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
        sourceMap = util.parseSourceMapInput(aSourceMap);
    }
    var version = util.getArg(sourceMap, 'version');
    var sources = util.getArg(sourceMap, 'sources');
    // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
    // requires the array) to play nice here.
    var names = util.getArg(sourceMap, 'names', []);
    var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
    var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
    var mappings = util.getArg(sourceMap, 'mappings');
    var file = util.getArg(sourceMap, 'file', null);
    // Once again, Sass deviates from the spec and supplies the version as a
    // string rather than a number, so we use loose equality checking here.
    if (version != this._version) {
        throw new Error('Unsupported version: ' + version);
    }
    if (sourceRoot) {
        sourceRoot = util.normalize(sourceRoot);
    }
    sources = sources.map(String)// Some source maps produce relative source paths like "./foo.js" instead of
    // "foo.js".  Normalize these first so that future comparisons will succeed.
    // See bugzil.la/1090768.
    .map(util.normalize)// Always ensure that absolute sources are internally stored relative to
    // the source root, if the source root is absolute. Not doing this would
    // be particularly problematic when the source root is a prefix of the
    // source (valid, but why??). See github issue #199 and bugzil.la/1188982.
    .map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
    });
    // Pass `true` below to allow duplicate names and sources. While source maps
    // are intended to be compressed and deduplicated, the TypeScript compiler
    // sometimes generates source maps with duplicates in them. See Github issue
    // #72 and bugzil.la/889492.
    this._names = ArraySet.fromArray(names.map(String), true);
    this._sources = ArraySet.fromArray(sources, true);
    this._absoluteSources = this._sources.toArray().map(function(s) {
        return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
    });
    this.sourceRoot = sourceRoot;
    this.sourcesContent = sourcesContent;
    this._mappings = mappings;
    this._sourceMapURL = aSourceMapURL;
    this.file = file;
}
BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
/**
 * Utility function to find the index of a source.  Returns -1 if not
 * found.
 */ BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
    var relativeSource = aSource;
    if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
    }
    if (this._sources.has(relativeSource)) {
        return this._sources.indexOf(relativeSource);
    }
    // Maybe aSource is an absolute URL as returned by |sources|.  In
    // this case we can't simply undo the transform.
    var i;
    for(i = 0; i < this._absoluteSources.length; ++i){
        if (this._absoluteSources[i] == aSource) {
            return i;
        }
    }
    return -1;
};
/**
 * Create a BasicSourceMapConsumer from a SourceMapGenerator.
 *
 * @param SourceMapGenerator aSourceMap
 *        The source map that will be consumed.
 * @param String aSourceMapURL
 *        The URL at which the source map can be found (optional)
 * @returns BasicSourceMapConsumer
 */ BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
    var smc = Object.create(BasicSourceMapConsumer.prototype);
    var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
    var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
    smc.sourceRoot = aSourceMap._sourceRoot;
    smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(), smc.sourceRoot);
    smc.file = aSourceMap._file;
    smc._sourceMapURL = aSourceMapURL;
    smc._absoluteSources = smc._sources.toArray().map(function(s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
    });
    // Because we are modifying the entries (by converting string sources and
    // names to indices into the sources and names ArraySets), we have to make
    // a copy of the entry or else bad things happen. Shared mutable state
    // strikes again! See github issue #191.
    var generatedMappings = aSourceMap._mappings.toArray().slice();
    var destGeneratedMappings = smc.__generatedMappings = [];
    var destOriginalMappings = smc.__originalMappings = [];
    for(var i = 0, length = generatedMappings.length; i < length; i++){
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping;
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
            destMapping.source = sources.indexOf(srcMapping.source);
            destMapping.originalLine = srcMapping.originalLine;
            destMapping.originalColumn = srcMapping.originalColumn;
            if (srcMapping.name) {
                destMapping.name = names.indexOf(srcMapping.name);
            }
            destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
    }
    quickSort(smc.__originalMappings, util.compareByOriginalPositions);
    return smc;
};
/**
 * The version of the source mapping spec that we are consuming.
 */ BasicSourceMapConsumer.prototype._version = 3;
/**
 * The list of original sources.
 */ Object.defineProperty(BasicSourceMapConsumer.prototype, 'sources', {
    get: function() {
        return this._absoluteSources.slice();
    }
});
/**
 * Provide the JIT with a nice shape / hidden class.
 */ function Mapping() {
    this.generatedLine = 0;
    this.generatedColumn = 0;
    this.source = null;
    this.originalLine = null;
    this.originalColumn = null;
    this.name = null;
}
/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */ BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    var generatedLine = 1;
    var previousGeneratedColumn = 0;
    var previousOriginalLine = 0;
    var previousOriginalColumn = 0;
    var previousSource = 0;
    var previousName = 0;
    var length = aStr.length;
    var index = 0;
    var cachedSegments = {};
    var temp = {};
    var originalMappings = [];
    var generatedMappings = [];
    var mapping, str, segment, end, value;
    while(index < length){
        if (aStr.charAt(index) === ';') {
            generatedLine++;
            index++;
            previousGeneratedColumn = 0;
        } else if (aStr.charAt(index) === ',') {
            index++;
        } else {
            mapping = new Mapping();
            mapping.generatedLine = generatedLine;
            // Because each offset is encoded relative to the previous one,
            // many segments often have the same encoding. We can exploit this
            // fact by caching the parsed variable length fields of each segment,
            // allowing us to avoid a second parse if we encounter the same
            // segment again.
            for(end = index; end < length; end++){
                if (this._charIsMappingSeparator(aStr, end)) {
                    break;
                }
            }
            str = aStr.slice(index, end);
            segment = cachedSegments[str];
            if (segment) {
                index += str.length;
            } else {
                segment = [];
                while(index < end){
                    base64VLQ.decode(aStr, index, temp);
                    value = temp.value;
                    index = temp.rest;
                    segment.push(value);
                }
                if (segment.length === 2) {
                    throw new Error('Found a source, but no line and column');
                }
                if (segment.length === 3) {
                    throw new Error('Found a source and line, but no column');
                }
                cachedSegments[str] = segment;
            }
            // Generated column.
            mapping.generatedColumn = previousGeneratedColumn + segment[0];
            previousGeneratedColumn = mapping.generatedColumn;
            if (segment.length > 1) {
                // Original source.
                mapping.source = previousSource + segment[1];
                previousSource += segment[1];
                // Original line.
                mapping.originalLine = previousOriginalLine + segment[2];
                previousOriginalLine = mapping.originalLine;
                // Lines are stored 0-based
                mapping.originalLine += 1;
                // Original column.
                mapping.originalColumn = previousOriginalColumn + segment[3];
                previousOriginalColumn = mapping.originalColumn;
                if (segment.length > 4) {
                    // Original name.
                    mapping.name = previousName + segment[4];
                    previousName += segment[4];
                }
            }
            generatedMappings.push(mapping);
            if (typeof mapping.originalLine === 'number') {
                originalMappings.push(mapping);
            }
        }
    }
    quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
    this.__generatedMappings = generatedMappings;
    quickSort(originalMappings, util.compareByOriginalPositions);
    this.__originalMappings = originalMappings;
};
/**
 * Find the mapping that best matches the hypothetical "needle" mapping that
 * we are searching for in the given "haystack" of mappings.
 */ BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
    // To return the position we are searching for, we must first find the
    // mapping for the given position and then return the opposite position it
    // points to. Because the mappings are sorted, we can use binary search to
    // find the best mapping.
    if (aNeedle[aLineName] <= 0) {
        throw new TypeError('Line must be greater than or equal to 1, got ' + aNeedle[aLineName]);
    }
    if (aNeedle[aColumnName] < 0) {
        throw new TypeError('Column must be greater than or equal to 0, got ' + aNeedle[aColumnName]);
    }
    return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
};
/**
 * Compute the last column for each generated mapping. The last column is
 * inclusive.
 */ BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
    for(var index = 0; index < this._generatedMappings.length; ++index){
        var mapping = this._generatedMappings[index];
        // Mappings do not contain a field for the last generated columnt. We
        // can come up with an optimistic estimate, however, by assuming that
        // mappings are contiguous (i.e. given two consecutive mappings, the
        // first mapping ends where the second one starts).
        if (index + 1 < this._generatedMappings.length) {
            var nextMapping = this._generatedMappings[index + 1];
            if (mapping.generatedLine === nextMapping.generatedLine) {
                mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
                continue;
            }
        }
        // The last mapping for each line spans the entire line.
        mapping.lastGeneratedColumn = Infinity;
    }
};
/**
 * Returns the original source, line, and column information for the generated
 * source's line and column positions provided. The only argument is an object
 * with the following properties:
 *
 *   - line: The line number in the generated source.  The line number
 *     is 1-based.
 *   - column: The column number in the generated source.  The column
 *     number is 0-based.
 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
 *     closest element that is smaller than or greater than the one we are
 *     searching for, respectively, if the exact element cannot be found.
 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
 *
 * and an object is returned with the following properties:
 *
 *   - source: The original source file, or null.
 *   - line: The line number in the original source, or null.  The
 *     line number is 1-based.
 *   - column: The column number in the original source, or null.  The
 *     column number is 0-based.
 *   - name: The original identifier, or null.
 */ BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
    var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
    };
    var index = this._findMapping(needle, this._generatedMappings, "generatedLine", "generatedColumn", util.compareByGeneratedPositionsDeflated, util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND));
    if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
            var source = util.getArg(mapping, 'source', null);
            if (source !== null) {
                source = this._sources.at(source);
                source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
            }
            var name = util.getArg(mapping, 'name', null);
            if (name !== null) {
                name = this._names.at(name);
            }
            return {
                source: source,
                line: util.getArg(mapping, 'originalLine', null),
                column: util.getArg(mapping, 'originalColumn', null),
                name: name
            };
        }
    }
    return {
        source: null,
        line: null,
        column: null,
        name: null
    };
};
/**
 * Return true if we have the source content for every source in the source
 * map, false otherwise.
 */ BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
    if (!this.sourcesContent) {
        return false;
    }
    return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
    });
};
/**
 * Returns the original source content. The only argument is the url of the
 * original source file. Returns null if no original source content is
 * available.
 */ BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
    if (!this.sourcesContent) {
        return null;
    }
    var index = this._findSourceIndex(aSource);
    if (index >= 0) {
        return this.sourcesContent[index];
    }
    var relativeSource = aSource;
    if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
    }
    var url;
    if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        // XXX: file:// URIs and absolute paths lead to unexpected behavior for
        // many users. We can help them out when they expect file:// URIs to
        // behave like it would if they were running a local HTTP server. See
        // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
            return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) {
            return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
    }
    // This function is used recursively from
    // IndexedSourceMapConsumer.prototype.sourceContentFor. In that case, we
    // don't want to throw if we can't find the source - we just want to
    // return null, so we provide a flag to exit gracefully.
    if (nullOnMissing) {
        return null;
    } else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
    }
};
/**
 * Returns the generated line and column information for the original source,
 * line, and column positions provided. The only argument is an object with
 * the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.  The line number
 *     is 1-based.
 *   - column: The column number in the original source.  The column
 *     number is 0-based.
 *   - bias: Either 'SourceMapConsumer.GREATEST_LOWER_BOUND' or
 *     'SourceMapConsumer.LEAST_UPPER_BOUND'. Specifies whether to return the
 *     closest element that is smaller than or greater than the one we are
 *     searching for, respectively, if the exact element cannot be found.
 *     Defaults to 'SourceMapConsumer.GREATEST_LOWER_BOUND'.
 *
 * and an object is returned with the following properties:
 *
 *   - line: The line number in the generated source, or null.  The
 *     line number is 1-based.
 *   - column: The column number in the generated source, or null.
 *     The column number is 0-based.
 */ BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
    var source = util.getArg(aArgs, 'source');
    source = this._findSourceIndex(source);
    if (source < 0) {
        return {
            line: null,
            column: null,
            lastColumn: null
        };
    }
    var needle = {
        source: source,
        originalLine: util.getArg(aArgs, 'line'),
        originalColumn: util.getArg(aArgs, 'column')
    };
    var index = this._findMapping(needle, this._originalMappings, "originalLine", "originalColumn", util.compareByOriginalPositions, util.getArg(aArgs, 'bias', SourceMapConsumer.GREATEST_LOWER_BOUND));
    if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
            return {
                line: util.getArg(mapping, 'generatedLine', null),
                column: util.getArg(mapping, 'generatedColumn', null),
                lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
            };
        }
    }
    return {
        line: null,
        column: null,
        lastColumn: null
    };
};
exports.BasicSourceMapConsumer = BasicSourceMapConsumer;
/**
 * An IndexedSourceMapConsumer instance represents a parsed source map which
 * we can query for information. It differs from BasicSourceMapConsumer in
 * that it takes "indexed" source maps (i.e. ones with a "sections" field) as
 * input.
 *
 * The first parameter is a raw source map (either as a JSON string, or already
 * parsed to an object). According to the spec for indexed source maps, they
 * have the following attributes:
 *
 *   - version: Which version of the source map spec this map is following.
 *   - file: Optional. The generated file this source map is associated with.
 *   - sections: A list of section definitions.
 *
 * Each value under the "sections" field has two fields:
 *   - offset: The offset into the original specified at which this section
 *       begins to apply, defined as an object with a "line" and "column"
 *       field.
 *   - map: A source map definition. This source map could also be indexed,
 *       but doesn't have to be.
 *
 * Instead of the "map" field, it's also possible to have a "url" field
 * specifying a URL to retrieve a source map from, but that's currently
 * unsupported.
 *
 * Here's an example source map, taken from the source map spec[0], but
 * modified to omit a section which uses the "url" field.
 *
 *  {
 *    version : 3,
 *    file: "app.js",
 *    sections: [{
 *      offset: {line:100, column:10},
 *      map: {
 *        version : 3,
 *        file: "section.js",
 *        sources: ["foo.js", "bar.js"],
 *        names: ["src", "maps", "are", "fun"],
 *        mappings: "AAAA,E;;ABCDE;"
 *      }
 *    }],
 *  }
 *
 * The second parameter, if given, is a string whose value is the URL
 * at which the source map was found.  This URL is used to compute the
 * sources array.
 *
 * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.535es3xeprgt
 */ function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
    var sourceMap = aSourceMap;
    if (typeof aSourceMap === 'string') {
        sourceMap = util.parseSourceMapInput(aSourceMap);
    }
    var version = util.getArg(sourceMap, 'version');
    var sections = util.getArg(sourceMap, 'sections');
    if (version != this._version) {
        throw new Error('Unsupported version: ' + version);
    }
    this._sources = new ArraySet();
    this._names = new ArraySet();
    var lastOffset = {
        line: -1,
        column: 0
    };
    this._sections = sections.map(function(s) {
        if (s.url) {
            // The url field will require support for asynchronicity.
            // See https://github.com/mozilla/source-map/issues/16
            throw new Error('Support for url field in sections not implemented.');
        }
        var offset = util.getArg(s, 'offset');
        var offsetLine = util.getArg(offset, 'line');
        var offsetColumn = util.getArg(offset, 'column');
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
            throw new Error('Section offsets must be ordered and non-overlapping.');
        }
        lastOffset = offset;
        return {
            generatedOffset: {
                // The offset fields are 0-based, but we use 1-based indices when
                // encoding/decoding from VLQ.
                generatedLine: offsetLine + 1,
                generatedColumn: offsetColumn + 1
            },
            consumer: new SourceMapConsumer(util.getArg(s, 'map'), aSourceMapURL)
        };
    });
}
IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
/**
 * The version of the source mapping spec that we are consuming.
 */ IndexedSourceMapConsumer.prototype._version = 3;
/**
 * The list of original sources.
 */ Object.defineProperty(IndexedSourceMapConsumer.prototype, 'sources', {
    get: function() {
        var sources = [];
        for(var i = 0; i < this._sections.length; i++){
            for(var j = 0; j < this._sections[i].consumer.sources.length; j++){
                sources.push(this._sections[i].consumer.sources[j]);
            }
        }
        return sources;
    }
});
/**
 * Returns the original source, line, and column information for the generated
 * source's line and column positions provided. The only argument is an object
 * with the following properties:
 *
 *   - line: The line number in the generated source.  The line number
 *     is 1-based.
 *   - column: The column number in the generated source.  The column
 *     number is 0-based.
 *
 * and an object is returned with the following properties:
 *
 *   - source: The original source file, or null.
 *   - line: The line number in the original source, or null.  The
 *     line number is 1-based.
 *   - column: The column number in the original source, or null.  The
 *     column number is 0-based.
 *   - name: The original identifier, or null.
 */ IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
    var needle = {
        generatedLine: util.getArg(aArgs, 'line'),
        generatedColumn: util.getArg(aArgs, 'column')
    };
    // Find the section containing the generated position we're trying to map
    // to an original position.
    var sectionIndex = binarySearch.search(needle, this._sections, function(needle, section) {
        var cmp = needle.generatedLine - section.generatedOffset.generatedLine;
        if (cmp) {
            return cmp;
        }
        return needle.generatedColumn - section.generatedOffset.generatedColumn;
    });
    var section = this._sections[sectionIndex];
    if (!section) {
        return {
            source: null,
            line: null,
            column: null,
            name: null
        };
    }
    return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
    });
};
/**
 * Return true if we have the source content for every source in the source
 * map, false otherwise.
 */ IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
    return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
    });
};
/**
 * Returns the original source content. The only argument is the url of the
 * original source file. Returns null if no original source content is
 * available.
 */ IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
    for(var i = 0; i < this._sections.length; i++){
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
            return content;
        }
    }
    if (nullOnMissing) {
        return null;
    } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
    }
};
/**
 * Returns the generated line and column information for the original source,
 * line, and column positions provided. The only argument is an object with
 * the following properties:
 *
 *   - source: The filename of the original source.
 *   - line: The line number in the original source.  The line number
 *     is 1-based.
 *   - column: The column number in the original source.  The column
 *     number is 0-based.
 *
 * and an object is returned with the following properties:
 *
 *   - line: The line number in the generated source, or null.  The
 *     line number is 1-based. 
 *   - column: The column number in the generated source, or null.
 *     The column number is 0-based.
 */ IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
    for(var i = 0; i < this._sections.length; i++){
        var section = this._sections[i];
        // Only consider this section if the requested source is in the list of
        // sources of the consumer.
        if (section.consumer._findSourceIndex(util.getArg(aArgs, 'source')) === -1) {
            continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
            var ret = {
                line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
                column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
            };
            return ret;
        }
    }
    return {
        line: null,
        column: null
    };
};
/**
 * Parse the mappings in a string in to a data structure which we can easily
 * query (the ordered arrays in the `this.__generatedMappings` and
 * `this.__originalMappings` properties).
 */ IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
    this.__generatedMappings = [];
    this.__originalMappings = [];
    for(var i = 0; i < this._sections.length; i++){
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for(var j = 0; j < sectionMappings.length; j++){
            var mapping = sectionMappings[j];
            var source = section.consumer._sources.at(mapping.source);
            source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
            this._sources.add(source);
            source = this._sources.indexOf(source);
            var name = null;
            if (mapping.name) {
                name = section.consumer._names.at(mapping.name);
                this._names.add(name);
                name = this._names.indexOf(name);
            }
            // The mappings coming from the consumer for the section have
            // generated positions relative to the start of the section, so we
            // need to offset them to be relative to the start of the concatenated
            // generated file.
            var adjustedMapping = {
                source: source,
                generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
                generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
                originalLine: mapping.originalLine,
                originalColumn: mapping.originalColumn,
                name: name
            };
            this.__generatedMappings.push(adjustedMapping);
            if (typeof adjustedMapping.originalLine === 'number') {
                this.__originalMappings.push(adjustedMapping);
            }
        }
    }
    quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
    quickSort(this.__originalMappings, util.compareByOriginalPositions);
};
exports.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
}}),
"[project]/node_modules/source-map/lib/source-node.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/* -*- Mode: js; js-indent-level: 2; -*- */ /*
 * Copyright 2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ var SourceMapGenerator = __turbopack_context__.r("[project]/node_modules/source-map/lib/source-map-generator.js [app-rsc] (ecmascript)").SourceMapGenerator;
var util = __turbopack_context__.r("[project]/node_modules/source-map/lib/util.js [app-rsc] (ecmascript)");
// Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
// operating systems these days (capturing the result).
var REGEX_NEWLINE = /(\r?\n)/;
// Newline character code for charCodeAt() comparisons
var NEWLINE_CODE = 10;
// Private symbol for identifying `SourceNode`s when multiple versions of
// the source-map library are loaded. This MUST NOT CHANGE across
// versions!
var isSourceNode = "$$$isSourceNode$$$";
/**
 * SourceNodes provide a way to abstract over interpolating/concatenating
 * snippets of generated JavaScript source code while maintaining the line and
 * column information associated with the original source code.
 *
 * @param aLine The original line number.
 * @param aColumn The original column number.
 * @param aSource The original source's filename.
 * @param aChunks Optional. An array of strings which are snippets of
 *        generated JS, or other SourceNodes.
 * @param aName The original identifier.
 */ function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
    this.children = [];
    this.sourceContents = {};
    this.line = aLine == null ? null : aLine;
    this.column = aColumn == null ? null : aColumn;
    this.source = aSource == null ? null : aSource;
    this.name = aName == null ? null : aName;
    this[isSourceNode] = true;
    if (aChunks != null) this.add(aChunks);
}
/**
 * Creates a SourceNode from generated code and a SourceMapConsumer.
 *
 * @param aGeneratedCode The generated code
 * @param aSourceMapConsumer The SourceMap for the generated code
 * @param aRelativePath Optional. The path that relative sources in the
 *        SourceMapConsumer should be relative to.
 */ SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
    // The SourceNode we want to fill with the generated code
    // and the SourceMap
    var node = new SourceNode();
    // All even indices of this array are one line of the generated code,
    // while all odd indices are the newlines between two adjacent lines
    // (since `REGEX_NEWLINE` captures its match).
    // Processed fragments are accessed by calling `shiftNextLine`.
    var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
    var remainingLinesIndex = 0;
    var shiftNextLine = function() {
        var lineContents = getNextLine();
        // The last line of a file might not have a newline.
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        "TURBOPACK unreachable";
        function getNextLine() {
            return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : undefined;
        }
    };
    // We need to remember the position of "remainingLines"
    var lastGeneratedLine = 1, lastGeneratedColumn = 0;
    // The generate SourceNodes we need a code range.
    // To extract it current and last mapping is used.
    // Here we store the last mapping.
    var lastMapping = null;
    aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
            // We add the code from "lastMapping" to "mapping":
            // First check if there is a new line in between.
            if (lastGeneratedLine < mapping.generatedLine) {
                // Associate first line with "lastMapping"
                addMappingWithCode(lastMapping, shiftNextLine());
                lastGeneratedLine++;
                lastGeneratedColumn = 0;
            // The remaining code is added without mapping
            } else {
                // There is no new line in between.
                // Associate the code between "lastGeneratedColumn" and
                // "mapping.generatedColumn" with "lastMapping"
                var nextLine = remainingLines[remainingLinesIndex] || '';
                var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
                remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
                lastGeneratedColumn = mapping.generatedColumn;
                addMappingWithCode(lastMapping, code);
                // No more remaining code, continue
                lastMapping = mapping;
                return;
            }
        }
        // We add the generated code until the first mapping
        // to the SourceNode without any mapping.
        // Each line is added as separate string.
        while(lastGeneratedLine < mapping.generatedLine){
            node.add(shiftNextLine());
            lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
            var nextLine = remainingLines[remainingLinesIndex] || '';
            node.add(nextLine.substr(0, mapping.generatedColumn));
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
    }, this);
    // We have processed all mappings.
    if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
            // Associate the remaining code in the current line with "lastMapping"
            addMappingWithCode(lastMapping, shiftNextLine());
        }
        // and add the remaining lines without any mapping
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
    }
    // Copy sourcesContent into SourceNode
    aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
            if (aRelativePath != null) {
                sourceFile = util.join(aRelativePath, sourceFile);
            }
            node.setSourceContent(sourceFile, content);
        }
    });
    return node;
    "TURBOPACK unreachable";
    function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === undefined) {
            node.add(code);
        } else {
            var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
            node.add(new SourceNode(mapping.originalLine, mapping.originalColumn, source, code, mapping.name));
        }
    }
};
/**
 * Add a chunk of generated JS to this source node.
 *
 * @param aChunk A string snippet of generated JS code, another instance of
 *        SourceNode, or an array where each member is one of those things.
 */ SourceNode.prototype.add = function SourceNode_add(aChunk) {
    if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
            this.add(chunk);
        }, this);
    } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
            this.children.push(aChunk);
        }
    } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
    }
    return this;
};
/**
 * Add a chunk of generated JS to the beginning of this source node.
 *
 * @param aChunk A string snippet of generated JS code, another instance of
 *        SourceNode, or an array where each member is one of those things.
 */ SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
    if (Array.isArray(aChunk)) {
        for(var i = aChunk.length - 1; i >= 0; i--){
            this.prepend(aChunk[i]);
        }
    } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
    } else {
        throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk);
    }
    return this;
};
/**
 * Walk over the tree of JS snippets in this node and its children. The
 * walking function is called once for each snippet of JS and is passed that
 * snippet and the its original associated source's line/column location.
 *
 * @param aFn The traversal function.
 */ SourceNode.prototype.walk = function SourceNode_walk(aFn) {
    var chunk;
    for(var i = 0, len = this.children.length; i < len; i++){
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
            chunk.walk(aFn);
        } else {
            if (chunk !== '') {
                aFn(chunk, {
                    source: this.source,
                    line: this.line,
                    column: this.column,
                    name: this.name
                });
            }
        }
    }
};
/**
 * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
 * each of `this.children`.
 *
 * @param aSep The separator.
 */ SourceNode.prototype.join = function SourceNode_join(aSep) {
    var newChildren;
    var i;
    var len = this.children.length;
    if (len > 0) {
        newChildren = [];
        for(i = 0; i < len - 1; i++){
            newChildren.push(this.children[i]);
            newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
    }
    return this;
};
/**
 * Call String.prototype.replace on the very right-most source snippet. Useful
 * for trimming whitespace from the end of a source node, etc.
 *
 * @param aPattern The pattern to replace.
 * @param aReplacement The thing to replace the pattern with.
 */ SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
    var lastChild = this.children[this.children.length - 1];
    if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
    } else if (typeof lastChild === 'string') {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
    } else {
        this.children.push(''.replace(aPattern, aReplacement));
    }
    return this;
};
/**
 * Set the source content for a source file. This will be added to the SourceMapGenerator
 * in the sourcesContent field.
 *
 * @param aSourceFile The filename of the source file
 * @param aSourceContent The content of the source file
 */ SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
    this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
};
/**
 * Walk over the tree of SourceNodes. The walking function is called for each
 * source file content and is passed the filename and source content.
 *
 * @param aFn The traversal function.
 */ SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
    for(var i = 0, len = this.children.length; i < len; i++){
        if (this.children[i][isSourceNode]) {
            this.children[i].walkSourceContents(aFn);
        }
    }
    var sources = Object.keys(this.sourceContents);
    for(var i = 0, len = sources.length; i < len; i++){
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
    }
};
/**
 * Return the string representation of this source node. Walks over the tree
 * and concatenates all the various snippets together to one string.
 */ SourceNode.prototype.toString = function SourceNode_toString() {
    var str = "";
    this.walk(function(chunk) {
        str += chunk;
    });
    return str;
};
/**
 * Returns the string representation of this source node along with a source
 * map.
 */ SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
    var generated = {
        code: "",
        line: 1,
        column: 0
    };
    var map = new SourceMapGenerator(aArgs);
    var sourceMappingActive = false;
    var lastOriginalSource = null;
    var lastOriginalLine = null;
    var lastOriginalColumn = null;
    var lastOriginalName = null;
    this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
            if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
                map.addMapping({
                    source: original.source,
                    original: {
                        line: original.line,
                        column: original.column
                    },
                    generated: {
                        line: generated.line,
                        column: generated.column
                    },
                    name: original.name
                });
            }
            lastOriginalSource = original.source;
            lastOriginalLine = original.line;
            lastOriginalColumn = original.column;
            lastOriginalName = original.name;
            sourceMappingActive = true;
        } else if (sourceMappingActive) {
            map.addMapping({
                generated: {
                    line: generated.line,
                    column: generated.column
                }
            });
            lastOriginalSource = null;
            sourceMappingActive = false;
        }
        for(var idx = 0, length = chunk.length; idx < length; idx++){
            if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
                generated.line++;
                generated.column = 0;
                // Mappings end at eol
                if (idx + 1 === length) {
                    lastOriginalSource = null;
                    sourceMappingActive = false;
                } else if (sourceMappingActive) {
                    map.addMapping({
                        source: original.source,
                        original: {
                            line: original.line,
                            column: original.column
                        },
                        generated: {
                            line: generated.line,
                            column: generated.column
                        },
                        name: original.name
                    });
                }
            } else {
                generated.column++;
            }
        }
    });
    this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
    });
    return {
        code: generated.code,
        map: map
    };
};
exports.SourceNode = SourceNode;
}}),
"[project]/node_modules/source-map/source-map.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/*
 * Copyright 2009-2011 Mozilla Foundation and contributors
 * Licensed under the New BSD license. See LICENSE.txt or:
 * http://opensource.org/licenses/BSD-3-Clause
 */ exports.SourceMapGenerator = __turbopack_context__.r("[project]/node_modules/source-map/lib/source-map-generator.js [app-rsc] (ecmascript)").SourceMapGenerator;
exports.SourceMapConsumer = __turbopack_context__.r("[project]/node_modules/source-map/lib/source-map-consumer.js [app-rsc] (ecmascript)").SourceMapConsumer;
exports.SourceNode = __turbopack_context__.r("[project]/node_modules/source-map/lib/source-node.js [app-rsc] (ecmascript)").SourceNode;
}}),
"[project]/node_modules/dotprompt/dist/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
// src/index.ts
var index_exports = {};
__export(index_exports, {
    Dotprompt: ()=>Dotprompt,
    PicoschemaParser: ()=>PicoschemaParser,
    picoschema: ()=>picoschema
});
module.exports = __toCommonJS(index_exports);
// src/dotprompt.ts
var Handlebars = __toESM(__turbopack_context__.r("[project]/node_modules/handlebars/lib/index.js [app-rsc] (ecmascript)"));
// src/helpers.ts
var helpers_exports = {};
__export(helpers_exports, {
    history: ()=>history,
    ifEquals: ()=>ifEquals,
    json: ()=>json,
    media: ()=>media,
    role: ()=>role,
    section: ()=>section,
    unlessEquals: ()=>unlessEquals
});
var import_handlebars = __turbopack_context__.r("[project]/node_modules/handlebars/lib/index.js [app-rsc] (ecmascript)");
function json(serializable, options) {
    return new import_handlebars.SafeString(JSON.stringify(serializable, null, options.hash.indent || 0));
}
function role(role2) {
    return new import_handlebars.SafeString(`<<<dotprompt:role:${role2}>>>`);
}
function history() {
    return new import_handlebars.SafeString("<<<dotprompt:history>>>");
}
function section(name) {
    return new import_handlebars.SafeString(`<<<dotprompt:section ${name}>>>`);
}
function media(options) {
    return new import_handlebars.SafeString(`<<<dotprompt:media:url ${options.hash.url}${options.hash.contentType ? ` ${options.hash.contentType}` : ""}>>>`);
}
function ifEquals(arg1, arg2, options) {
    return arg1 === arg2 ? options.fn(this) : options.inverse(this);
}
function unlessEquals(arg1, arg2, options) {
    return arg1 !== arg2 ? options.fn(this) : options.inverse(this);
}
// src/parse.ts
var import_yaml = __turbopack_context__.r("[project]/node_modules/yaml/dist/index.js [app-rsc] (ecmascript)");
var ROLE_MARKER_PREFIX = "<<<dotprompt:role:";
var HISTORY_MARKER_PREFIX = "<<<dotprompt:history";
var MEDIA_MARKER_PREFIX = "<<<dotprompt:media:";
var SECTION_MARKER_PREFIX = "<<<dotprompt:section";
var FRONTMATTER_AND_BODY_REGEX = /^---\s*\n([\s\S]*?)\n---\s*\n([\s\S]*)$/;
var ROLE_AND_HISTORY_MARKER_REGEX = /(<<<dotprompt:(?:role:[a-z]+|history))>>>/g;
var MEDIA_AND_SECTION_MARKER_REGEX = /(<<<dotprompt:(?:media:url|section).*?)>>>/g;
var RESERVED_METADATA_KEYWORDS = [
    // NOTE: KEEP SORTED
    "config",
    "description",
    "ext",
    "input",
    "model",
    "name",
    "output",
    "raw",
    "toolDefs",
    "tools",
    "variant",
    "version"
];
var BASE_METADATA = {
    ext: {},
    metadata: {},
    config: {}
};
function splitByRegex(source, regex) {
    return source.split(regex).filter((s)=>s.trim() !== "");
}
function splitByRoleAndHistoryMarkers(renderedString) {
    return splitByRegex(renderedString, ROLE_AND_HISTORY_MARKER_REGEX);
}
function splitByMediaAndSectionMarkers(source) {
    return splitByRegex(source, MEDIA_AND_SECTION_MARKER_REGEX);
}
function convertNamespacedEntryToNestedObject(key, value, obj = {}) {
    const result = obj || {};
    const lastDotIndex = key.lastIndexOf(".");
    const ns = key.substring(0, lastDotIndex);
    const field = key.substring(lastDotIndex + 1);
    result[ns] = result[ns] || {};
    result[ns][field] = value;
    return result;
}
function extractFrontmatterAndBody(source) {
    const match = source.match(FRONTMATTER_AND_BODY_REGEX);
    if (match) {
        const [, frontmatter, body] = match;
        return {
            frontmatter,
            body
        };
    }
    return {
        frontmatter: "",
        body: ""
    };
}
function parseDocument(source) {
    const { frontmatter, body } = extractFrontmatterAndBody(source);
    if (frontmatter) {
        try {
            const parsedMetadata = (0, import_yaml.parse)(frontmatter);
            const raw = {
                ...parsedMetadata
            };
            const pruned = {
                ...BASE_METADATA
            };
            const ext = {};
            for(const k in raw){
                const key = k;
                if (RESERVED_METADATA_KEYWORDS.includes(key)) {
                    pruned[key] = raw[key];
                } else if (key.includes(".")) {
                    convertNamespacedEntryToNestedObject(key, raw[key], ext);
                }
            }
            return {
                ...pruned,
                raw,
                ext,
                template: body.trim()
            };
        } catch (error) {
            console.error("Dotprompt: Error parsing YAML frontmatter:", error);
            return {
                ...BASE_METADATA,
                template: source.trim()
            };
        }
    }
    return {
        ...BASE_METADATA,
        template: source
    };
}
function messageSourcesToMessages(messageSources) {
    return messageSources.filter((ms)=>ms.content || ms.source).map((m)=>{
        const out = {
            role: m.role,
            content: m.content || toParts(m.source || "")
        };
        if (m.metadata) {
            out.metadata = m.metadata;
        }
        return out;
    });
}
function transformMessagesToHistory(messages) {
    return messages.map((m)=>({
            ...m,
            metadata: {
                ...m.metadata,
                purpose: "history"
            }
        }));
}
function toMessages(renderedString, data) {
    let currentMessage = {
        role: "user",
        source: ""
    };
    const messageSources = [
        currentMessage
    ];
    for (const piece of splitByRoleAndHistoryMarkers(renderedString)){
        if (piece.startsWith(ROLE_MARKER_PREFIX)) {
            const role2 = piece.substring(ROLE_MARKER_PREFIX.length);
            if (currentMessage.source?.trim()) {
                currentMessage = {
                    role: role2,
                    source: ""
                };
                messageSources.push(currentMessage);
            } else {
                currentMessage.role = role2;
            }
        } else if (piece.startsWith(HISTORY_MARKER_PREFIX)) {
            const historyMessages = transformMessagesToHistory(data?.messages ?? []);
            if (historyMessages) {
                messageSources.push(...historyMessages);
            }
            currentMessage = {
                role: "model",
                source: ""
            };
            messageSources.push(currentMessage);
        } else {
            currentMessage.source += piece;
        }
    }
    const messages = messageSourcesToMessages(messageSources);
    return insertHistory(messages, data?.messages);
}
function messagesHaveHistory(messages) {
    return messages.some((m)=>m.metadata?.purpose === "history");
}
function insertHistory(messages, history2 = []) {
    if (!history2 || messagesHaveHistory(messages)) {
        return messages;
    }
    if (messages.length === 0) {
        return history2;
    }
    const lastMessage = messages.at(-1);
    if (lastMessage?.role === "user") {
        const messagesWithoutLast = messages.slice(0, -1);
        return [
            ...messagesWithoutLast,
            ...history2,
            lastMessage
        ];
    }
    return [
        ...messages,
        ...history2
    ];
}
function toParts(source) {
    return splitByMediaAndSectionMarkers(source).map(parsePart);
}
function parsePart(piece) {
    if (piece.startsWith(MEDIA_MARKER_PREFIX)) {
        return parseMediaPart(piece);
    } else if (piece.startsWith(SECTION_MARKER_PREFIX)) {
        return parseSectionPart(piece);
    }
    return parseTextPart(piece);
}
function parseMediaPart(piece) {
    if (!piece.startsWith(MEDIA_MARKER_PREFIX)) {
        throw new Error("Invalid media piece");
    }
    const [_, url, contentType] = piece.split(" ");
    const part = {
        media: {
            url
        }
    };
    if (contentType) {
        part.media.contentType = contentType;
    }
    return part;
}
function parseSectionPart(piece) {
    if (!piece.startsWith(SECTION_MARKER_PREFIX)) {
        throw new Error("Invalid section piece");
    }
    const [_, sectionType] = piece.split(" ");
    return {
        metadata: {
            purpose: sectionType,
            pending: true
        }
    };
}
function parseTextPart(piece) {
    return {
        text: piece
    };
}
// src/picoschema.ts
var JSON_SCHEMA_SCALAR_TYPES = [
    "string",
    "boolean",
    "null",
    "number",
    "integer",
    "any"
];
var WILDCARD_PROPERTY_NAME = "(*)";
async function picoschema(schema, options) {
    return new PicoschemaParser(options).parse(schema);
}
var PicoschemaParser = class {
    schemaResolver;
    constructor(options){
        this.schemaResolver = options?.schemaResolver;
    }
    async mustResolveSchema(schemaName) {
        if (!this.schemaResolver) {
            throw new Error(`Picoschema: unsupported scalar type '${schemaName}'.`);
        }
        const val = await this.schemaResolver(schemaName);
        if (!val) {
            throw new Error(`Picoschema: could not find schema with name '${schemaName}'`);
        }
        return val;
    }
    async parse(schema) {
        if (!schema) return null;
        if (typeof schema === "string") {
            const [type, description] = extractDescription(schema);
            if (JSON_SCHEMA_SCALAR_TYPES.includes(type)) {
                let out = {
                    type
                };
                if (description) out = {
                    ...out,
                    description
                };
                return out;
            }
            const resolvedSchema = await this.mustResolveSchema(type);
            return description ? {
                ...resolvedSchema,
                description
            } : resolvedSchema;
        }
        if ([
            ...JSON_SCHEMA_SCALAR_TYPES,
            "object",
            "array"
        ].includes(schema?.type)) {
            return schema;
        }
        if (typeof schema?.properties === "object") {
            return {
                ...schema,
                type: "object"
            };
        }
        return this.parsePico(schema);
    }
    async parsePico(obj, path = []) {
        if (typeof obj === "string") {
            const [type, description] = extractDescription(obj);
            if (!JSON_SCHEMA_SCALAR_TYPES.includes(type)) {
                let resolvedSchema = await this.mustResolveSchema(type);
                if (description) resolvedSchema = {
                    ...resolvedSchema,
                    description
                };
                return resolvedSchema;
            }
            if (type === "any") {
                return description ? {
                    description
                } : {};
            }
            return description ? {
                type,
                description
            } : {
                type
            };
        } else if (typeof obj !== "object") {
            throw new Error("Picoschema: only consists of objects and strings. Got: " + JSON.stringify(obj));
        }
        const schema = {
            type: "object",
            properties: {},
            required: [],
            additionalProperties: false
        };
        for(const key in obj){
            if (key === WILDCARD_PROPERTY_NAME) {
                schema.additionalProperties = await this.parsePico(obj[key], [
                    ...path,
                    key
                ]);
                continue;
            }
            const [name, typeInfo] = key.split("(");
            const isOptional = name.endsWith("?");
            const propertyName = isOptional ? name.slice(0, -1) : name;
            if (!isOptional) {
                schema.required.push(propertyName);
            }
            if (!typeInfo) {
                const prop = {
                    ...await this.parsePico(obj[key], [
                        ...path,
                        key
                    ])
                };
                if (isOptional && typeof prop.type === "string") {
                    prop.type = [
                        prop.type,
                        "null"
                    ];
                }
                schema.properties[propertyName] = prop;
                continue;
            }
            const [type, description] = extractDescription(typeInfo.substring(0, typeInfo.length - 1));
            if (type === "array") {
                schema.properties[propertyName] = {
                    type: isOptional ? [
                        "array",
                        "null"
                    ] : "array",
                    items: await this.parsePico(obj[key], [
                        ...path,
                        key
                    ])
                };
            } else if (type === "object") {
                const prop = await this.parsePico(obj[key], [
                    ...path,
                    key
                ]);
                if (isOptional) prop.type = [
                    prop.type,
                    "null"
                ];
                schema.properties[propertyName] = prop;
            } else if (type === "enum") {
                const prop = {
                    enum: obj[key]
                };
                if (isOptional && !prop.enum.includes(null)) prop.enum.push(null);
                schema.properties[propertyName] = prop;
            } else {
                throw new Error("Picoschema: parenthetical types must be 'object' or 'array', got: " + type);
            }
            if (description) {
                schema.properties[propertyName].description = description;
            }
        }
        if (!schema.required.length) delete schema.required;
        return schema;
    }
};
function extractDescription(input) {
    if (!input.includes(",")) return [
        input,
        null
    ];
    const match = input.match(/(.*?), *(.*)$/);
    return [
        match[1],
        match[2]
    ];
}
// src/util.ts
function removeUndefinedFields(obj) {
    if (obj === null || typeof obj !== "object") {
        return obj;
    }
    if (Array.isArray(obj)) {
        return obj.map((item)=>removeUndefinedFields(item));
    }
    const result = {};
    for (const [key, value] of Object.entries(obj)){
        if (value !== void 0) {
            result[key] = removeUndefinedFields(value);
        }
    }
    return result;
}
// src/dotprompt.ts
var Dotprompt = class {
    handlebars;
    knownHelpers = {};
    defaultModel;
    modelConfigs = {};
    tools = {};
    toolResolver;
    schemas = {};
    schemaResolver;
    partialResolver;
    store;
    constructor(options){
        this.handlebars = Handlebars.noConflict();
        this.modelConfigs = options?.modelConfigs || this.modelConfigs;
        this.defaultModel = options?.defaultModel;
        this.tools = options?.tools || {};
        this.toolResolver = options?.toolResolver;
        this.schemas = options?.schemas || {};
        this.schemaResolver = options?.schemaResolver;
        this.partialResolver = options?.partialResolver;
        for(const key in helpers_exports){
            this.defineHelper(key, helpers_exports[key]);
            this.handlebars.registerHelper(key, helpers_exports[key]);
        }
        if (options?.helpers) {
            for(const key in options.helpers){
                this.defineHelper(key, options.helpers[key]);
            }
        }
        if (options?.partials) {
            for(const key in options.partials){
                this.definePartial(key, options.partials[key]);
            }
        }
    }
    /**
   * Registers a helper function for use in templates.
   *
   * @param name The name of the helper function to register
   * @param fn The helper function implementation
   * @return This instance for method chaining
   */ defineHelper(name, fn) {
        this.handlebars.registerHelper(name, fn);
        this.knownHelpers[name] = true;
        return this;
    }
    /**
   * Registers a partial template for use in other templates.
   *
   * @param name The name of the partial to register
   * @param source The template source for the partial
   * @return This instance for method chaining
   */ definePartial(name, source) {
        this.handlebars.registerPartial(name, source);
        return this;
    }
    /**
   * Registers a tool definition for use in prompts.
   *
   * @param def The tool definition to register
   * @return This instance for method chaining
   */ defineTool(def) {
        this.tools[def.name] = def;
        return this;
    }
    /**
   * Parses a prompt template string into a structured ParsedPrompt object.
   *
   * @param source The template source string to parse
   * @return A parsed prompt object with extracted metadata and template
   */ parse(source) {
        return parseDocument(source);
    }
    /**
   * Renders a prompt template with the provided data.
   *
   * @param source The template source string to render
   * @param data The data to use when rendering the template
   * @param options Additional metadata and options for rendering
   * @return A promise resolving to the rendered prompt
   */ async render(source, data = {}, options) {
        const renderer = await this.compile(source);
        return renderer(data, options);
    }
    /**
   * Processes schema definitions in picoschema format into standard JSON Schema.
   *
   * @param meta The prompt metadata containing schema definitions
   * @return A promise resolving to the processed metadata with expanded schemas
   */ async renderPicoschema(meta) {
        if (!meta.output?.schema && !meta.input?.schema) {
            return meta;
        }
        const newMeta = {
            ...meta
        };
        if (meta.input?.schema) {
            newMeta.input = {
                ...meta.input,
                schema: await picoschema(meta.input.schema, {
                    schemaResolver: this.wrappedSchemaResolver.bind(this)
                })
            };
        }
        if (meta.output?.schema) {
            newMeta.output = {
                ...meta.output,
                schema: await picoschema(meta.output.schema, {
                    schemaResolver: this.wrappedSchemaResolver.bind(this)
                })
            };
        }
        return newMeta;
    }
    /**
   * Resolves a schema name to its definition, using registered schemas or schema resolver.
   *
   * @param name The name of the schema to resolve
   * @return A promise resolving to the schema definition or null if not found
   */ async wrappedSchemaResolver(name) {
        if (this.schemas[name]) {
            return this.schemas[name];
        }
        if (this.schemaResolver) {
            return await this.schemaResolver(name);
        }
        return null;
    }
    /**
   * Merges multiple metadata objects together, resolving tools and schemas.
   *
   * @param base The base metadata object
   * @param merges Additional metadata objects to merge into the base
   * @return A promise resolving to the merged and processed metadata
   */ async resolveMetadata(base, ...merges) {
        let out = {
            ...base
        };
        for(let i = 0; i < merges.length; i++){
            if (!merges[i]) continue;
            const config = out.config || {};
            out = {
                ...out,
                ...merges[i]
            };
            out.config = {
                ...config,
                ...merges[i]?.config || {}
            };
        }
        const { template: _, ...outWithoutTemplate } = out;
        out = outWithoutTemplate;
        out = removeUndefinedFields(out);
        out = await this.resolveTools(out);
        out = await this.renderPicoschema(out);
        return out;
    }
    /**
   * Resolves tool names to their definitions using registered tools or tool resolver.
   *
   * @param base The metadata containing tool references to resolve
   * @return A promise resolving to metadata with resolved tool definitions
   */ async resolveTools(base) {
        const out = {
            ...base
        };
        if (out.tools) {
            const outTools = [];
            out.toolDefs = out.toolDefs || [];
            await Promise.all(out.tools.map(async (toolName)=>{
                if (this.tools[toolName]) {
                    if (out.toolDefs) {
                        out.toolDefs.push(this.tools[toolName]);
                    }
                } else if (this.toolResolver) {
                    const resolvedTool = await this.toolResolver(toolName);
                    if (!resolvedTool) {
                        throw new Error(`Dotprompt: Unable to resolve tool '${toolName}' to a recognized tool definition.`);
                    }
                    if (out.toolDefs) {
                        out.toolDefs.push(resolvedTool);
                    }
                } else {
                    outTools.push(toolName);
                }
            }));
            out.tools = outTools;
        }
        return out;
    }
    /**
   * Identifies all partial references in a template.
   *
   * @param template The template to scan for partial references
   * @return A set of partial names referenced in the template
   */ identifyPartials(template) {
        const ast = this.handlebars.parse(template);
        const partials = /* @__PURE__ */ new Set();
        const visitor = new class extends this.handlebars.Visitor {
            // Visit partial statements and add their names to our set.
            PartialStatement(partial) {
                if (partial && typeof partial === "object" && "name" in partial && partial.name && typeof partial.name === "object" && "original" in partial.name && typeof partial.name.original === "string") {
                    partials.add(partial.name.original);
                }
            }
        }();
        visitor.accept(ast);
        return partials;
    }
    /**
   * Resolves and registers all partials referenced in a template.
   *
   * @param template The template containing partial references
   * @return A promise that resolves when all partials are registered
   */ async resolvePartials(template) {
        if (!this.partialResolver && !this.store) {
            return;
        }
        const partials = this.identifyPartials(template);
        await Promise.all(Array.from(partials).map(async (name)=>{
            if (!this.handlebars.partials[name]) {
                let content = null;
                if (this.partialResolver) {
                    content = await this.partialResolver(name);
                }
                if (!content && this.store) {
                    const partial = await this.store.loadPartial(name);
                    content = partial?.source;
                }
                if (content) {
                    this.definePartial(name, content);
                    await this.resolvePartials(content);
                }
            }
        }));
    }
    /**
   * Compiles a template into a reusable function for rendering prompts.
   *
   * @param source The template source or parsed prompt to compile
   * @param additionalMetadata Additional metadata to include in the compiled template
   * @return A promise resolving to a function for rendering the template
   */ async compile(source, additionalMetadata) {
        let parsedSource;
        if (typeof source === "string") {
            parsedSource = this.parse(source);
        } else {
            parsedSource = source;
        }
        if (additionalMetadata) {
            parsedSource = {
                ...parsedSource,
                ...additionalMetadata
            };
        }
        await this.resolvePartials(parsedSource.template);
        const renderString = this.handlebars.compile(parsedSource.template, {
            knownHelpers: this.knownHelpers,
            knownHelpersOnly: true,
            noEscape: true
        });
        const renderFunc = async (data, options)=>{
            const { input, ...mergedMetadata } = await this.renderMetadata(parsedSource);
            const renderedString = renderString({
                ...options?.input?.default || {},
                ...data.input
            }, {
                data: {
                    metadata: {
                        prompt: mergedMetadata,
                        docs: data.docs,
                        messages: data.messages
                    },
                    ...data.context || {}
                }
            });
            return {
                ...mergedMetadata,
                messages: toMessages(renderedString, data)
            };
        };
        renderFunc.prompt = parsedSource;
        return renderFunc;
    }
    /**
   * Processes and resolves all metadata for a prompt template.
   *
   * @param source The template source or parsed prompt
   * @param additionalMetadata Additional metadata to include
   * @return A promise resolving to the fully processed metadata
   */ async renderMetadata(source, additionalMetadata) {
        let parsedSource;
        if (typeof source === "string") {
            parsedSource = this.parse(source);
        } else {
            parsedSource = source;
        }
        const selectedModel = additionalMetadata?.model || parsedSource.model || this.defaultModel;
        let modelConfig;
        if (selectedModel && this.modelConfigs[selectedModel]) {
            modelConfig = this.modelConfigs[selectedModel];
        }
        return this.resolveMetadata(modelConfig ? {
            config: modelConfig
        } : {}, parsedSource, additionalMetadata);
    }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    Dotprompt,
    PicoschemaParser,
    picoschema
});
}}),
"[project]/node_modules/json5/dist/index.mjs [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
// This is a generated file. Do not edit.
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var Space_Separator = /[\u1680\u2000-\u200A\u202F\u205F\u3000]/;
var ID_Start = /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u08A0-\u08B4\u08B6-\u08BD\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1877\u1880-\u1884\u1887-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1CE9-\u1CEC\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312E\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FEA\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDE80-\uDE9C\uDEA0-\uDED0\uDF00-\uDF1F\uDF2D-\uDF4A\uDF50-\uDF75\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00\uDE10-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE4\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC03-\uDC37\uDC83-\uDCAF\uDCD0-\uDCE8\uDD03-\uDD26\uDD50-\uDD72\uDD76\uDD83-\uDDB2\uDDC1-\uDDC4\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE2B\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEDE\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3D\uDF50\uDF5D-\uDF61]|\uD805[\uDC00-\uDC34\uDC47-\uDC4A\uDC80-\uDCAF\uDCC4\uDCC5\uDCC7\uDD80-\uDDAE\uDDD8-\uDDDB\uDE00-\uDE2F\uDE44\uDE80-\uDEAA\uDF00-\uDF19]|\uD806[\uDCA0-\uDCDF\uDCFF\uDE00\uDE0B-\uDE32\uDE3A\uDE50\uDE5C-\uDE83\uDE86-\uDE89\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC2E\uDC40\uDC72-\uDC8F\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD30\uDD46]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDED0-\uDEED\uDF00-\uDF2F\uDF40-\uDF43\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50\uDF93-\uDF9F\uDFE0\uDFE1]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00-\uDD1E\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB]|\uD83A[\uDC00-\uDCC4\uDD00-\uDD43]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]/;
var ID_Continue = /[\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0300-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u0483-\u0487\u048A-\u052F\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u05D0-\u05EA\u05F0-\u05F2\u0610-\u061A\u0620-\u0669\u066E-\u06D3\u06D5-\u06DC\u06DF-\u06E8\u06EA-\u06FC\u06FF\u0710-\u074A\u074D-\u07B1\u07C0-\u07F5\u07FA\u0800-\u082D\u0840-\u085B\u0860-\u086A\u08A0-\u08B4\u08B6-\u08BD\u08D4-\u08E1\u08E3-\u0963\u0966-\u096F\u0971-\u0983\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BC-\u09C4\u09C7\u09C8\u09CB-\u09CE\u09D7\u09DC\u09DD\u09DF-\u09E3\u09E6-\u09F1\u09FC\u0A01-\u0A03\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A59-\u0A5C\u0A5E\u0A66-\u0A75\u0A81-\u0A83\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABC-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AD0\u0AE0-\u0AE3\u0AE6-\u0AEF\u0AF9-\u0AFF\u0B01-\u0B03\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3C-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B56\u0B57\u0B5C\u0B5D\u0B5F-\u0B63\u0B66-\u0B6F\u0B71\u0B82\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD0\u0BD7\u0BE6-\u0BEF\u0C00-\u0C03\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C58-\u0C5A\u0C60-\u0C63\u0C66-\u0C6F\u0C80-\u0C83\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBC-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CDE\u0CE0-\u0CE3\u0CE6-\u0CEF\u0CF1\u0CF2\u0D00-\u0D03\u0D05-\u0D0C\u0D0E-\u0D10\u0D12-\u0D44\u0D46-\u0D48\u0D4A-\u0D4E\u0D54-\u0D57\u0D5F-\u0D63\u0D66-\u0D6F\u0D7A-\u0D7F\u0D82\u0D83\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E01-\u0E3A\u0E40-\u0E4E\u0E50-\u0E59\u0E81\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB9\u0EBB-\u0EBD\u0EC0-\u0EC4\u0EC6\u0EC8-\u0ECD\u0ED0-\u0ED9\u0EDC-\u0EDF\u0F00\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E-\u0F47\u0F49-\u0F6C\u0F71-\u0F84\u0F86-\u0F97\u0F99-\u0FBC\u0FC6\u1000-\u1049\u1050-\u109D\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u135D-\u135F\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u170C\u170E-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176C\u176E-\u1770\u1772\u1773\u1780-\u17D3\u17D7\u17DC\u17DD\u17E0-\u17E9\u180B-\u180D\u1810-\u1819\u1820-\u1877\u1880-\u18AA\u18B0-\u18F5\u1900-\u191E\u1920-\u192B\u1930-\u193B\u1946-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u19D0-\u19D9\u1A00-\u1A1B\u1A20-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AA7\u1AB0-\u1ABD\u1B00-\u1B4B\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1BF3\u1C00-\u1C37\u1C40-\u1C49\u1C4D-\u1C7D\u1C80-\u1C88\u1CD0-\u1CD2\u1CD4-\u1CF9\u1D00-\u1DF9\u1DFB-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u203F\u2040\u2054\u2071\u207F\u2090-\u209C\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D7F-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u2DE0-\u2DFF\u2E2F\u3005-\u3007\u3021-\u302F\u3031-\u3035\u3038-\u303C\u3041-\u3096\u3099\u309A\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312E\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FEA\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA62B\uA640-\uA66F\uA674-\uA67D\uA67F-\uA6F1\uA717-\uA71F\uA722-\uA788\uA78B-\uA7AE\uA7B0-\uA7B7\uA7F7-\uA827\uA840-\uA873\uA880-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F7\uA8FB\uA8FD\uA900-\uA92D\uA930-\uA953\uA960-\uA97C\uA980-\uA9C0\uA9CF-\uA9D9\uA9E0-\uA9FE\uAA00-\uAA36\uAA40-\uAA4D\uAA50-\uAA59\uAA60-\uAA76\uAA7A-\uAAC2\uAADB-\uAADD\uAAE0-\uAAEF\uAAF2-\uAAF6\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB65\uAB70-\uABEA\uABEC\uABED\uABF0-\uABF9\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFE70-\uFE74\uFE76-\uFEFC\uFF10-\uFF19\uFF21-\uFF3A\uFF3F\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC]|\uD800[\uDC00-\uDC0B\uDC0D-\uDC26\uDC28-\uDC3A\uDC3C\uDC3D\uDC3F-\uDC4D\uDC50-\uDC5D\uDC80-\uDCFA\uDD40-\uDD74\uDDFD\uDE80-\uDE9C\uDEA0-\uDED0\uDEE0\uDF00-\uDF1F\uDF2D-\uDF4A\uDF50-\uDF7A\uDF80-\uDF9D\uDFA0-\uDFC3\uDFC8-\uDFCF\uDFD1-\uDFD5]|\uD801[\uDC00-\uDC9D\uDCA0-\uDCA9\uDCB0-\uDCD3\uDCD8-\uDCFB\uDD00-\uDD27\uDD30-\uDD63\uDE00-\uDF36\uDF40-\uDF55\uDF60-\uDF67]|\uD802[\uDC00-\uDC05\uDC08\uDC0A-\uDC35\uDC37\uDC38\uDC3C\uDC3F-\uDC55\uDC60-\uDC76\uDC80-\uDC9E\uDCE0-\uDCF2\uDCF4\uDCF5\uDD00-\uDD15\uDD20-\uDD39\uDD80-\uDDB7\uDDBE\uDDBF\uDE00-\uDE03\uDE05\uDE06\uDE0C-\uDE13\uDE15-\uDE17\uDE19-\uDE33\uDE38-\uDE3A\uDE3F\uDE60-\uDE7C\uDE80-\uDE9C\uDEC0-\uDEC7\uDEC9-\uDEE6\uDF00-\uDF35\uDF40-\uDF55\uDF60-\uDF72\uDF80-\uDF91]|\uD803[\uDC00-\uDC48\uDC80-\uDCB2\uDCC0-\uDCF2]|\uD804[\uDC00-\uDC46\uDC66-\uDC6F\uDC7F-\uDCBA\uDCD0-\uDCE8\uDCF0-\uDCF9\uDD00-\uDD34\uDD36-\uDD3F\uDD50-\uDD73\uDD76\uDD80-\uDDC4\uDDCA-\uDDCC\uDDD0-\uDDDA\uDDDC\uDE00-\uDE11\uDE13-\uDE37\uDE3E\uDE80-\uDE86\uDE88\uDE8A-\uDE8D\uDE8F-\uDE9D\uDE9F-\uDEA8\uDEB0-\uDEEA\uDEF0-\uDEF9\uDF00-\uDF03\uDF05-\uDF0C\uDF0F\uDF10\uDF13-\uDF28\uDF2A-\uDF30\uDF32\uDF33\uDF35-\uDF39\uDF3C-\uDF44\uDF47\uDF48\uDF4B-\uDF4D\uDF50\uDF57\uDF5D-\uDF63\uDF66-\uDF6C\uDF70-\uDF74]|\uD805[\uDC00-\uDC4A\uDC50-\uDC59\uDC80-\uDCC5\uDCC7\uDCD0-\uDCD9\uDD80-\uDDB5\uDDB8-\uDDC0\uDDD8-\uDDDD\uDE00-\uDE40\uDE44\uDE50-\uDE59\uDE80-\uDEB7\uDEC0-\uDEC9\uDF00-\uDF19\uDF1D-\uDF2B\uDF30-\uDF39]|\uD806[\uDCA0-\uDCE9\uDCFF\uDE00-\uDE3E\uDE47\uDE50-\uDE83\uDE86-\uDE99\uDEC0-\uDEF8]|\uD807[\uDC00-\uDC08\uDC0A-\uDC36\uDC38-\uDC40\uDC50-\uDC59\uDC72-\uDC8F\uDC92-\uDCA7\uDCA9-\uDCB6\uDD00-\uDD06\uDD08\uDD09\uDD0B-\uDD36\uDD3A\uDD3C\uDD3D\uDD3F-\uDD47\uDD50-\uDD59]|\uD808[\uDC00-\uDF99]|\uD809[\uDC00-\uDC6E\uDC80-\uDD43]|[\uD80C\uD81C-\uD820\uD840-\uD868\uD86A-\uD86C\uD86F-\uD872\uD874-\uD879][\uDC00-\uDFFF]|\uD80D[\uDC00-\uDC2E]|\uD811[\uDC00-\uDE46]|\uD81A[\uDC00-\uDE38\uDE40-\uDE5E\uDE60-\uDE69\uDED0-\uDEED\uDEF0-\uDEF4\uDF00-\uDF36\uDF40-\uDF43\uDF50-\uDF59\uDF63-\uDF77\uDF7D-\uDF8F]|\uD81B[\uDF00-\uDF44\uDF50-\uDF7E\uDF8F-\uDF9F\uDFE0\uDFE1]|\uD821[\uDC00-\uDFEC]|\uD822[\uDC00-\uDEF2]|\uD82C[\uDC00-\uDD1E\uDD70-\uDEFB]|\uD82F[\uDC00-\uDC6A\uDC70-\uDC7C\uDC80-\uDC88\uDC90-\uDC99\uDC9D\uDC9E]|\uD834[\uDD65-\uDD69\uDD6D-\uDD72\uDD7B-\uDD82\uDD85-\uDD8B\uDDAA-\uDDAD\uDE42-\uDE44]|\uD835[\uDC00-\uDC54\uDC56-\uDC9C\uDC9E\uDC9F\uDCA2\uDCA5\uDCA6\uDCA9-\uDCAC\uDCAE-\uDCB9\uDCBB\uDCBD-\uDCC3\uDCC5-\uDD05\uDD07-\uDD0A\uDD0D-\uDD14\uDD16-\uDD1C\uDD1E-\uDD39\uDD3B-\uDD3E\uDD40-\uDD44\uDD46\uDD4A-\uDD50\uDD52-\uDEA5\uDEA8-\uDEC0\uDEC2-\uDEDA\uDEDC-\uDEFA\uDEFC-\uDF14\uDF16-\uDF34\uDF36-\uDF4E\uDF50-\uDF6E\uDF70-\uDF88\uDF8A-\uDFA8\uDFAA-\uDFC2\uDFC4-\uDFCB\uDFCE-\uDFFF]|\uD836[\uDE00-\uDE36\uDE3B-\uDE6C\uDE75\uDE84\uDE9B-\uDE9F\uDEA1-\uDEAF]|\uD838[\uDC00-\uDC06\uDC08-\uDC18\uDC1B-\uDC21\uDC23\uDC24\uDC26-\uDC2A]|\uD83A[\uDC00-\uDCC4\uDCD0-\uDCD6\uDD00-\uDD4A\uDD50-\uDD59]|\uD83B[\uDE00-\uDE03\uDE05-\uDE1F\uDE21\uDE22\uDE24\uDE27\uDE29-\uDE32\uDE34-\uDE37\uDE39\uDE3B\uDE42\uDE47\uDE49\uDE4B\uDE4D-\uDE4F\uDE51\uDE52\uDE54\uDE57\uDE59\uDE5B\uDE5D\uDE5F\uDE61\uDE62\uDE64\uDE67-\uDE6A\uDE6C-\uDE72\uDE74-\uDE77\uDE79-\uDE7C\uDE7E\uDE80-\uDE89\uDE8B-\uDE9B\uDEA1-\uDEA3\uDEA5-\uDEA9\uDEAB-\uDEBB]|\uD869[\uDC00-\uDED6\uDF00-\uDFFF]|\uD86D[\uDC00-\uDF34\uDF40-\uDFFF]|\uD86E[\uDC00-\uDC1D\uDC20-\uDFFF]|\uD873[\uDC00-\uDEA1\uDEB0-\uDFFF]|\uD87A[\uDC00-\uDFE0]|\uD87E[\uDC00-\uDE1D]|\uDB40[\uDD00-\uDDEF]/;
var unicode = {
    Space_Separator: Space_Separator,
    ID_Start: ID_Start,
    ID_Continue: ID_Continue
};
var util = {
    isSpaceSeparator (c) {
        return typeof c === 'string' && unicode.Space_Separator.test(c);
    },
    isIdStartChar (c) {
        return typeof c === 'string' && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c === '$' || c === '_' || unicode.ID_Start.test(c));
    },
    isIdContinueChar (c) {
        return typeof c === 'string' && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c === '$' || c === '_' || c === '\u200C' || c === '\u200D' || unicode.ID_Continue.test(c));
    },
    isDigit (c) {
        return typeof c === 'string' && /[0-9]/.test(c);
    },
    isHexDigit (c) {
        return typeof c === 'string' && /[0-9A-Fa-f]/.test(c);
    }
};
let source;
let parseState;
let stack;
let pos;
let line;
let column;
let token;
let key;
let root;
var parse = function parse(text, reviver) {
    source = String(text);
    parseState = 'start';
    stack = [];
    pos = 0;
    line = 1;
    column = 0;
    token = undefined;
    key = undefined;
    root = undefined;
    do {
        token = lex();
        // This code is unreachable.
        // if (!parseStates[parseState]) {
        //     throw invalidParseState()
        // }
        parseStates[parseState]();
    }while (token.type !== 'eof')
    if (typeof reviver === 'function') {
        return internalize({
            '': root
        }, '', reviver);
    }
    return root;
};
function internalize(holder, name, reviver) {
    const value = holder[name];
    if (value != null && typeof value === 'object') {
        if (Array.isArray(value)) {
            for(let i = 0; i < value.length; i++){
                const key = String(i);
                const replacement = internalize(value, key, reviver);
                if (replacement === undefined) {
                    delete value[key];
                } else {
                    Object.defineProperty(value, key, {
                        value: replacement,
                        writable: true,
                        enumerable: true,
                        configurable: true
                    });
                }
            }
        } else {
            for(const key in value){
                const replacement = internalize(value, key, reviver);
                if (replacement === undefined) {
                    delete value[key];
                } else {
                    Object.defineProperty(value, key, {
                        value: replacement,
                        writable: true,
                        enumerable: true,
                        configurable: true
                    });
                }
            }
        }
    }
    return reviver.call(holder, name, value);
}
let lexState;
let buffer;
let doubleQuote;
let sign;
let c;
function lex() {
    lexState = 'default';
    buffer = '';
    doubleQuote = false;
    sign = 1;
    for(;;){
        c = peek();
        // This code is unreachable.
        // if (!lexStates[lexState]) {
        //     throw invalidLexState(lexState)
        // }
        const token = lexStates[lexState]();
        if (token) {
            return token;
        }
    }
}
function peek() {
    if (source[pos]) {
        return String.fromCodePoint(source.codePointAt(pos));
    }
}
function read() {
    const c = peek();
    if (c === '\n') {
        line++;
        column = 0;
    } else if (c) {
        column += c.length;
    } else {
        column++;
    }
    if (c) {
        pos += c.length;
    }
    return c;
}
const lexStates = {
    default () {
        switch(c){
            case '\t':
            case '\v':
            case '\f':
            case ' ':
            case '\u00A0':
            case '\uFEFF':
            case '\n':
            case '\r':
            case '\u2028':
            case '\u2029':
                read();
                return;
            case '/':
                read();
                lexState = 'comment';
                return;
            case undefined:
                read();
                return newToken('eof');
        }
        if (util.isSpaceSeparator(c)) {
            read();
            return;
        }
        // This code is unreachable.
        // if (!lexStates[parseState]) {
        //     throw invalidLexState(parseState)
        // }
        return lexStates[parseState]();
    },
    comment () {
        switch(c){
            case '*':
                read();
                lexState = 'multiLineComment';
                return;
            case '/':
                read();
                lexState = 'singleLineComment';
                return;
        }
        throw invalidChar(read());
    },
    multiLineComment () {
        switch(c){
            case '*':
                read();
                lexState = 'multiLineCommentAsterisk';
                return;
            case undefined:
                throw invalidChar(read());
        }
        read();
    },
    multiLineCommentAsterisk () {
        switch(c){
            case '*':
                read();
                return;
            case '/':
                read();
                lexState = 'default';
                return;
            case undefined:
                throw invalidChar(read());
        }
        read();
        lexState = 'multiLineComment';
    },
    singleLineComment () {
        switch(c){
            case '\n':
            case '\r':
            case '\u2028':
            case '\u2029':
                read();
                lexState = 'default';
                return;
            case undefined:
                read();
                return newToken('eof');
        }
        read();
    },
    value () {
        switch(c){
            case '{':
            case '[':
                return newToken('punctuator', read());
            case 'n':
                read();
                literal('ull');
                return newToken('null', null);
            case 't':
                read();
                literal('rue');
                return newToken('boolean', true);
            case 'f':
                read();
                literal('alse');
                return newToken('boolean', false);
            case '-':
            case '+':
                if (read() === '-') {
                    sign = -1;
                }
                lexState = 'sign';
                return;
            case '.':
                buffer = read();
                lexState = 'decimalPointLeading';
                return;
            case '0':
                buffer = read();
                lexState = 'zero';
                return;
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                buffer = read();
                lexState = 'decimalInteger';
                return;
            case 'I':
                read();
                literal('nfinity');
                return newToken('numeric', Infinity);
            case 'N':
                read();
                literal('aN');
                return newToken('numeric', NaN);
            case '"':
            case "'":
                doubleQuote = read() === '"';
                buffer = '';
                lexState = 'string';
                return;
        }
        throw invalidChar(read());
    },
    identifierNameStartEscape () {
        if (c !== 'u') {
            throw invalidChar(read());
        }
        read();
        const u = unicodeEscape();
        switch(u){
            case '$':
            case '_':
                break;
            default:
                if (!util.isIdStartChar(u)) {
                    throw invalidIdentifier();
                }
                break;
        }
        buffer += u;
        lexState = 'identifierName';
    },
    identifierName () {
        switch(c){
            case '$':
            case '_':
            case '\u200C':
            case '\u200D':
                buffer += read();
                return;
            case '\\':
                read();
                lexState = 'identifierNameEscape';
                return;
        }
        if (util.isIdContinueChar(c)) {
            buffer += read();
            return;
        }
        return newToken('identifier', buffer);
    },
    identifierNameEscape () {
        if (c !== 'u') {
            throw invalidChar(read());
        }
        read();
        const u = unicodeEscape();
        switch(u){
            case '$':
            case '_':
            case '\u200C':
            case '\u200D':
                break;
            default:
                if (!util.isIdContinueChar(u)) {
                    throw invalidIdentifier();
                }
                break;
        }
        buffer += u;
        lexState = 'identifierName';
    },
    sign () {
        switch(c){
            case '.':
                buffer = read();
                lexState = 'decimalPointLeading';
                return;
            case '0':
                buffer = read();
                lexState = 'zero';
                return;
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                buffer = read();
                lexState = 'decimalInteger';
                return;
            case 'I':
                read();
                literal('nfinity');
                return newToken('numeric', sign * Infinity);
            case 'N':
                read();
                literal('aN');
                return newToken('numeric', NaN);
        }
        throw invalidChar(read());
    },
    zero () {
        switch(c){
            case '.':
                buffer += read();
                lexState = 'decimalPoint';
                return;
            case 'e':
            case 'E':
                buffer += read();
                lexState = 'decimalExponent';
                return;
            case 'x':
            case 'X':
                buffer += read();
                lexState = 'hexadecimal';
                return;
        }
        return newToken('numeric', sign * 0);
    },
    decimalInteger () {
        switch(c){
            case '.':
                buffer += read();
                lexState = 'decimalPoint';
                return;
            case 'e':
            case 'E':
                buffer += read();
                lexState = 'decimalExponent';
                return;
        }
        if (util.isDigit(c)) {
            buffer += read();
            return;
        }
        return newToken('numeric', sign * Number(buffer));
    },
    decimalPointLeading () {
        if (util.isDigit(c)) {
            buffer += read();
            lexState = 'decimalFraction';
            return;
        }
        throw invalidChar(read());
    },
    decimalPoint () {
        switch(c){
            case 'e':
            case 'E':
                buffer += read();
                lexState = 'decimalExponent';
                return;
        }
        if (util.isDigit(c)) {
            buffer += read();
            lexState = 'decimalFraction';
            return;
        }
        return newToken('numeric', sign * Number(buffer));
    },
    decimalFraction () {
        switch(c){
            case 'e':
            case 'E':
                buffer += read();
                lexState = 'decimalExponent';
                return;
        }
        if (util.isDigit(c)) {
            buffer += read();
            return;
        }
        return newToken('numeric', sign * Number(buffer));
    },
    decimalExponent () {
        switch(c){
            case '+':
            case '-':
                buffer += read();
                lexState = 'decimalExponentSign';
                return;
        }
        if (util.isDigit(c)) {
            buffer += read();
            lexState = 'decimalExponentInteger';
            return;
        }
        throw invalidChar(read());
    },
    decimalExponentSign () {
        if (util.isDigit(c)) {
            buffer += read();
            lexState = 'decimalExponentInteger';
            return;
        }
        throw invalidChar(read());
    },
    decimalExponentInteger () {
        if (util.isDigit(c)) {
            buffer += read();
            return;
        }
        return newToken('numeric', sign * Number(buffer));
    },
    hexadecimal () {
        if (util.isHexDigit(c)) {
            buffer += read();
            lexState = 'hexadecimalInteger';
            return;
        }
        throw invalidChar(read());
    },
    hexadecimalInteger () {
        if (util.isHexDigit(c)) {
            buffer += read();
            return;
        }
        return newToken('numeric', sign * Number(buffer));
    },
    string () {
        switch(c){
            case '\\':
                read();
                buffer += escape();
                return;
            case '"':
                if (doubleQuote) {
                    read();
                    return newToken('string', buffer);
                }
                buffer += read();
                return;
            case "'":
                if (!doubleQuote) {
                    read();
                    return newToken('string', buffer);
                }
                buffer += read();
                return;
            case '\n':
            case '\r':
                throw invalidChar(read());
            case '\u2028':
            case '\u2029':
                separatorChar(c);
                break;
            case undefined:
                throw invalidChar(read());
        }
        buffer += read();
    },
    start () {
        switch(c){
            case '{':
            case '[':
                return newToken('punctuator', read());
        }
        lexState = 'value';
    },
    beforePropertyName () {
        switch(c){
            case '$':
            case '_':
                buffer = read();
                lexState = 'identifierName';
                return;
            case '\\':
                read();
                lexState = 'identifierNameStartEscape';
                return;
            case '}':
                return newToken('punctuator', read());
            case '"':
            case "'":
                doubleQuote = read() === '"';
                lexState = 'string';
                return;
        }
        if (util.isIdStartChar(c)) {
            buffer += read();
            lexState = 'identifierName';
            return;
        }
        throw invalidChar(read());
    },
    afterPropertyName () {
        if (c === ':') {
            return newToken('punctuator', read());
        }
        throw invalidChar(read());
    },
    beforePropertyValue () {
        lexState = 'value';
    },
    afterPropertyValue () {
        switch(c){
            case ',':
            case '}':
                return newToken('punctuator', read());
        }
        throw invalidChar(read());
    },
    beforeArrayValue () {
        if (c === ']') {
            return newToken('punctuator', read());
        }
        lexState = 'value';
    },
    afterArrayValue () {
        switch(c){
            case ',':
            case ']':
                return newToken('punctuator', read());
        }
        throw invalidChar(read());
    },
    end () {
        // This code is unreachable since it's handled by the default lexState.
        // if (c === undefined) {
        //     read()
        //     return newToken('eof')
        // }
        throw invalidChar(read());
    }
};
function newToken(type, value) {
    return {
        type,
        value,
        line,
        column
    };
}
function literal(s) {
    for (const c of s){
        const p = peek();
        if (p !== c) {
            throw invalidChar(read());
        }
        read();
    }
}
function escape() {
    const c = peek();
    switch(c){
        case 'b':
            read();
            return '\b';
        case 'f':
            read();
            return '\f';
        case 'n':
            read();
            return '\n';
        case 'r':
            read();
            return '\r';
        case 't':
            read();
            return '\t';
        case 'v':
            read();
            return '\v';
        case '0':
            read();
            if (util.isDigit(peek())) {
                throw invalidChar(read());
            }
            return '\0';
        case 'x':
            read();
            return hexEscape();
        case 'u':
            read();
            return unicodeEscape();
        case '\n':
        case '\u2028':
        case '\u2029':
            read();
            return '';
        case '\r':
            read();
            if (peek() === '\n') {
                read();
            }
            return '';
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            throw invalidChar(read());
        case undefined:
            throw invalidChar(read());
    }
    return read();
}
function hexEscape() {
    let buffer = '';
    let c = peek();
    if (!util.isHexDigit(c)) {
        throw invalidChar(read());
    }
    buffer += read();
    c = peek();
    if (!util.isHexDigit(c)) {
        throw invalidChar(read());
    }
    buffer += read();
    return String.fromCodePoint(parseInt(buffer, 16));
}
function unicodeEscape() {
    let buffer = '';
    let count = 4;
    while(count-- > 0){
        const c = peek();
        if (!util.isHexDigit(c)) {
            throw invalidChar(read());
        }
        buffer += read();
    }
    return String.fromCodePoint(parseInt(buffer, 16));
}
const parseStates = {
    start () {
        if (token.type === 'eof') {
            throw invalidEOF();
        }
        push();
    },
    beforePropertyName () {
        switch(token.type){
            case 'identifier':
            case 'string':
                key = token.value;
                parseState = 'afterPropertyName';
                return;
            case 'punctuator':
                // This code is unreachable since it's handled by the lexState.
                // if (token.value !== '}') {
                //     throw invalidToken()
                // }
                pop();
                return;
            case 'eof':
                throw invalidEOF();
        }
    // This code is unreachable since it's handled by the lexState.
    // throw invalidToken()
    },
    afterPropertyName () {
        // This code is unreachable since it's handled by the lexState.
        // if (token.type !== 'punctuator' || token.value !== ':') {
        //     throw invalidToken()
        // }
        if (token.type === 'eof') {
            throw invalidEOF();
        }
        parseState = 'beforePropertyValue';
    },
    beforePropertyValue () {
        if (token.type === 'eof') {
            throw invalidEOF();
        }
        push();
    },
    beforeArrayValue () {
        if (token.type === 'eof') {
            throw invalidEOF();
        }
        if (token.type === 'punctuator' && token.value === ']') {
            pop();
            return;
        }
        push();
    },
    afterPropertyValue () {
        // This code is unreachable since it's handled by the lexState.
        // if (token.type !== 'punctuator') {
        //     throw invalidToken()
        // }
        if (token.type === 'eof') {
            throw invalidEOF();
        }
        switch(token.value){
            case ',':
                parseState = 'beforePropertyName';
                return;
            case '}':
                pop();
        }
    // This code is unreachable since it's handled by the lexState.
    // throw invalidToken()
    },
    afterArrayValue () {
        // This code is unreachable since it's handled by the lexState.
        // if (token.type !== 'punctuator') {
        //     throw invalidToken()
        // }
        if (token.type === 'eof') {
            throw invalidEOF();
        }
        switch(token.value){
            case ',':
                parseState = 'beforeArrayValue';
                return;
            case ']':
                pop();
        }
    // This code is unreachable since it's handled by the lexState.
    // throw invalidToken()
    },
    end () {
    // This code is unreachable since it's handled by the lexState.
    // if (token.type !== 'eof') {
    //     throw invalidToken()
    // }
    }
};
function push() {
    let value;
    switch(token.type){
        case 'punctuator':
            switch(token.value){
                case '{':
                    value = {};
                    break;
                case '[':
                    value = [];
                    break;
            }
            break;
        case 'null':
        case 'boolean':
        case 'numeric':
        case 'string':
            value = token.value;
            break;
    }
    if (root === undefined) {
        root = value;
    } else {
        const parent = stack[stack.length - 1];
        if (Array.isArray(parent)) {
            parent.push(value);
        } else {
            Object.defineProperty(parent, key, {
                value,
                writable: true,
                enumerable: true,
                configurable: true
            });
        }
    }
    if (value !== null && typeof value === 'object') {
        stack.push(value);
        if (Array.isArray(value)) {
            parseState = 'beforeArrayValue';
        } else {
            parseState = 'beforePropertyName';
        }
    } else {
        const current = stack[stack.length - 1];
        if (current == null) {
            parseState = 'end';
        } else if (Array.isArray(current)) {
            parseState = 'afterArrayValue';
        } else {
            parseState = 'afterPropertyValue';
        }
    }
}
function pop() {
    stack.pop();
    const current = stack[stack.length - 1];
    if (current == null) {
        parseState = 'end';
    } else if (Array.isArray(current)) {
        parseState = 'afterArrayValue';
    } else {
        parseState = 'afterPropertyValue';
    }
}
// This code is unreachable.
// function invalidParseState () {
//     return new Error(`JSON5: invalid parse state '${parseState}'`)
// }
// This code is unreachable.
// function invalidLexState (state) {
//     return new Error(`JSON5: invalid lex state '${state}'`)
// }
function invalidChar(c) {
    if (c === undefined) {
        return syntaxError(`JSON5: invalid end of input at ${line}:${column}`);
    }
    return syntaxError(`JSON5: invalid character '${formatChar(c)}' at ${line}:${column}`);
}
function invalidEOF() {
    return syntaxError(`JSON5: invalid end of input at ${line}:${column}`);
}
// This code is unreachable.
// function invalidToken () {
//     if (token.type === 'eof') {
//         return syntaxError(`JSON5: invalid end of input at ${line}:${column}`)
//     }
//     const c = String.fromCodePoint(token.value.codePointAt(0))
//     return syntaxError(`JSON5: invalid character '${formatChar(c)}' at ${line}:${column}`)
// }
function invalidIdentifier() {
    column -= 5;
    return syntaxError(`JSON5: invalid identifier character at ${line}:${column}`);
}
function separatorChar(c) {
    console.warn(`JSON5: '${formatChar(c)}' in strings is not valid ECMAScript; consider escaping`);
}
function formatChar(c) {
    const replacements = {
        "'": "\\'",
        '"': '\\"',
        '\\': '\\\\',
        '\b': '\\b',
        '\f': '\\f',
        '\n': '\\n',
        '\r': '\\r',
        '\t': '\\t',
        '\v': '\\v',
        '\0': '\\0',
        '\u2028': '\\u2028',
        '\u2029': '\\u2029'
    };
    if (replacements[c]) {
        return replacements[c];
    }
    if (c < ' ') {
        const hexString = c.charCodeAt(0).toString(16);
        return '\\x' + ('00' + hexString).substring(hexString.length);
    }
    return c;
}
function syntaxError(message) {
    const err = new SyntaxError(message);
    err.lineNumber = line;
    err.columnNumber = column;
    return err;
}
var stringify = function stringify(value, replacer, space) {
    const stack = [];
    let indent = '';
    let propertyList;
    let replacerFunc;
    let gap = '';
    let quote;
    if (replacer != null && typeof replacer === 'object' && !Array.isArray(replacer)) {
        space = replacer.space;
        quote = replacer.quote;
        replacer = replacer.replacer;
    }
    if (typeof replacer === 'function') {
        replacerFunc = replacer;
    } else if (Array.isArray(replacer)) {
        propertyList = [];
        for (const v of replacer){
            let item;
            if (typeof v === 'string') {
                item = v;
            } else if (typeof v === 'number' || v instanceof String || v instanceof Number) {
                item = String(v);
            }
            if (item !== undefined && propertyList.indexOf(item) < 0) {
                propertyList.push(item);
            }
        }
    }
    if (space instanceof Number) {
        space = Number(space);
    } else if (space instanceof String) {
        space = String(space);
    }
    if (typeof space === 'number') {
        if (space > 0) {
            space = Math.min(10, Math.floor(space));
            gap = '          '.substr(0, space);
        }
    } else if (typeof space === 'string') {
        gap = space.substr(0, 10);
    }
    return serializeProperty('', {
        '': value
    });
    "TURBOPACK unreachable";
    function serializeProperty(key, holder) {
        let value = holder[key];
        if (value != null) {
            if (typeof value.toJSON5 === 'function') {
                value = value.toJSON5(key);
            } else if (typeof value.toJSON === 'function') {
                value = value.toJSON(key);
            }
        }
        if (replacerFunc) {
            value = replacerFunc.call(holder, key, value);
        }
        if (value instanceof Number) {
            value = Number(value);
        } else if (value instanceof String) {
            value = String(value);
        } else if (value instanceof Boolean) {
            value = value.valueOf();
        }
        switch(value){
            case null:
                return 'null';
            case true:
                return 'true';
            case false:
                return 'false';
        }
        if (typeof value === 'string') {
            return quoteString(value, false);
        }
        if (typeof value === 'number') {
            return String(value);
        }
        if (typeof value === 'object') {
            return Array.isArray(value) ? serializeArray(value) : serializeObject(value);
        }
        return undefined;
    }
    function quoteString(value) {
        const quotes = {
            "'": 0.1,
            '"': 0.2
        };
        const replacements = {
            "'": "\\'",
            '"': '\\"',
            '\\': '\\\\',
            '\b': '\\b',
            '\f': '\\f',
            '\n': '\\n',
            '\r': '\\r',
            '\t': '\\t',
            '\v': '\\v',
            '\0': '\\0',
            '\u2028': '\\u2028',
            '\u2029': '\\u2029'
        };
        let product = '';
        for(let i = 0; i < value.length; i++){
            const c = value[i];
            switch(c){
                case "'":
                case '"':
                    quotes[c]++;
                    product += c;
                    continue;
                case '\0':
                    if (util.isDigit(value[i + 1])) {
                        product += '\\x00';
                        continue;
                    }
            }
            if (replacements[c]) {
                product += replacements[c];
                continue;
            }
            if (c < ' ') {
                let hexString = c.charCodeAt(0).toString(16);
                product += '\\x' + ('00' + hexString).substring(hexString.length);
                continue;
            }
            product += c;
        }
        const quoteChar = quote || Object.keys(quotes).reduce((a, b)=>quotes[a] < quotes[b] ? a : b);
        product = product.replace(new RegExp(quoteChar, 'g'), replacements[quoteChar]);
        return quoteChar + product + quoteChar;
    }
    function serializeObject(value) {
        if (stack.indexOf(value) >= 0) {
            throw TypeError('Converting circular structure to JSON5');
        }
        stack.push(value);
        let stepback = indent;
        indent = indent + gap;
        let keys = propertyList || Object.keys(value);
        let partial = [];
        for (const key of keys){
            const propertyString = serializeProperty(key, value);
            if (propertyString !== undefined) {
                let member = serializeKey(key) + ':';
                if (gap !== '') {
                    member += ' ';
                }
                member += propertyString;
                partial.push(member);
            }
        }
        let final;
        if (partial.length === 0) {
            final = '{}';
        } else {
            let properties;
            if (gap === '') {
                properties = partial.join(',');
                final = '{' + properties + '}';
            } else {
                let separator = ',\n' + indent;
                properties = partial.join(separator);
                final = '{\n' + indent + properties + ',\n' + stepback + '}';
            }
        }
        stack.pop();
        indent = stepback;
        return final;
    }
    function serializeKey(key) {
        if (key.length === 0) {
            return quoteString(key, true);
        }
        const firstChar = String.fromCodePoint(key.codePointAt(0));
        if (!util.isIdStartChar(firstChar)) {
            return quoteString(key, true);
        }
        for(let i = firstChar.length; i < key.length; i++){
            if (!util.isIdContinueChar(String.fromCodePoint(key.codePointAt(i)))) {
                return quoteString(key, true);
            }
        }
        return key;
    }
    function serializeArray(value) {
        if (stack.indexOf(value) >= 0) {
            throw TypeError('Converting circular structure to JSON5');
        }
        stack.push(value);
        let stepback = indent;
        indent = indent + gap;
        let partial = [];
        for(let i = 0; i < value.length; i++){
            const propertyString = serializeProperty(String(i), value);
            partial.push(propertyString !== undefined ? propertyString : 'null');
        }
        let final;
        if (partial.length === 0) {
            final = '[]';
        } else {
            if (gap === '') {
                let properties = partial.join(',');
                final = '[' + properties + ']';
            } else {
                let separator = ',\n' + indent;
                let properties = partial.join(separator);
                final = '[\n' + indent + properties + ',\n' + stepback + ']';
            }
        }
        stack.pop();
        indent = stepback;
        return final;
    }
};
const JSON5 = {
    parse,
    stringify
};
var lib = JSON5;
const __TURBOPACK__default__export__ = lib;
}}),
"[project]/node_modules/partial-json/dist/options.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/**
 * Sometimes you don't allow every type to be partially parsed.
 * For example, you may not want a partial number because it may increase its size gradually before it's complete.
 * In this case, you can use the `Allow` object to control what types you allow to be partially parsed.
 * @module
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Allow = exports.ALL = exports.COLLECTION = exports.ATOM = exports.SPECIAL = exports.INF = exports._INFINITY = exports.INFINITY = exports.NAN = exports.BOOL = exports.NULL = exports.OBJ = exports.ARR = exports.NUM = exports.STR = void 0;
/**
 * allow partial strings like `"hello \u12` to be parsed as `"hello "`
 */ exports.STR = 0b000000001;
/**
 * allow partial numbers like `123.` to be parsed as `123`
 */ exports.NUM = 0b000000010;
/**
 * allow partial arrays like `[1, 2,` to be parsed as `[1, 2]`
 */ exports.ARR = 0b000000100;
/**
 * allow partial objects like `{"a": 1, "b":` to be parsed as `{"a": 1}`
 */ exports.OBJ = 0b000001000;
/**
 * allow `nu` to be parsed as `null`
 */ exports.NULL = 0b000010000;
/**
 * allow `tr` to be parsed as `true`, and `fa` to be parsed as `false`
 */ exports.BOOL = 0b000100000;
/**
 * allow `Na` to be parsed as `NaN`
 */ exports.NAN = 0b001000000;
/**
 * allow `Inf` to be parsed as `Infinity`
 */ exports.INFINITY = 0b010000000;
/**
 * allow `-Inf` to be parsed as `-Infinity`
 */ exports._INFINITY = 0b100000000;
exports.INF = exports.INFINITY | exports._INFINITY;
exports.SPECIAL = exports.NULL | exports.BOOL | exports.INF | exports.NAN;
exports.ATOM = exports.STR | exports.NUM | exports.SPECIAL;
exports.COLLECTION = exports.ARR | exports.OBJ;
exports.ALL = exports.ATOM | exports.COLLECTION;
/**
 * Control what types you allow to be partially parsed.
 * The default is to allow all types to be partially parsed, which in most casees is the best option.
 * @example
 * If you don't want to allow partial objects, you can use the following code:
 * ```ts
 * import { Allow, parse } from "partial-json";
 * parse(`[{"a": 1, "b": 2}, {"a": 3,`, Allow.ARR); // [ { a: 1, b: 2 } ]
 * ```
 * Or you can use `~` to disallow a type:
 * ```ts
 * parse(`[{"a": 1, "b": 2}, {"a": 3,`, ~Allow.OBJ); // [ { a: 1, b: 2 } ]
 * ```
 * @example
 * If you don't want to allow partial strings, you can use the following code:
 * ```ts
 * import { Allow, parse } from "partial-json";
 * parse(`["complete string", "incompl`, ~Allow.STR); // [ 'complete string' ]
 * ```
 */ exports.Allow = {
    STR: exports.STR,
    NUM: exports.NUM,
    ARR: exports.ARR,
    OBJ: exports.OBJ,
    NULL: exports.NULL,
    BOOL: exports.BOOL,
    NAN: exports.NAN,
    INFINITY: exports.INFINITY,
    _INFINITY: exports._INFINITY,
    INF: exports.INF,
    SPECIAL: exports.SPECIAL,
    ATOM: exports.ATOM,
    COLLECTION: exports.COLLECTION,
    ALL: exports.ALL
};
exports.default = exports.Allow;
}}),
"[project]/node_modules/partial-json/dist/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = {
            enumerable: true,
            get: function() {
                return m[k];
            }
        };
    }
    Object.defineProperty(o, k2, desc);
} : function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});
var __exportStar = this && this.__exportStar || function(m, exports1) {
    for(var p in m)if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports1, p)) __createBinding(exports1, m, p);
};
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Allow = exports.MalformedJSON = exports.PartialJSON = exports.parseJSON = exports.parse = void 0;
const options_1 = __turbopack_context__.r("[project]/node_modules/partial-json/dist/options.js [app-rsc] (ecmascript)");
Object.defineProperty(exports, "Allow", {
    enumerable: true,
    get: function() {
        return options_1.Allow;
    }
});
__exportStar(__turbopack_context__.r("[project]/node_modules/partial-json/dist/options.js [app-rsc] (ecmascript)"), exports);
class PartialJSON extends Error {
}
exports.PartialJSON = PartialJSON;
class MalformedJSON extends Error {
}
exports.MalformedJSON = MalformedJSON;
/**
 * Parse incomplete JSON
 * @param {string} jsonString Partial JSON to be parsed
 * @param {number} allowPartial Specify what types are allowed to be partial, see {@link Allow} for details
 * @returns The parsed JSON
 * @throws {PartialJSON} If the JSON is incomplete (related to the `allow` parameter)
 * @throws {MalformedJSON} If the JSON is malformed
 */ function parseJSON(jsonString, allowPartial = options_1.Allow.ALL) {
    if (typeof jsonString !== "string") {
        throw new TypeError(`expecting str, got ${typeof jsonString}`);
    }
    if (!jsonString.trim()) {
        throw new Error(`${jsonString} is empty`);
    }
    return _parseJSON(jsonString.trim(), allowPartial);
}
exports.parseJSON = parseJSON;
;
const _parseJSON = (jsonString, allow)=>{
    const length = jsonString.length;
    let index = 0;
    const markPartialJSON = (msg)=>{
        throw new PartialJSON(`${msg} at position ${index}`);
    };
    const throwMalformedError = (msg)=>{
        throw new MalformedJSON(`${msg} at position ${index}`);
    };
    const parseAny = ()=>{
        skipBlank();
        if (index >= length) markPartialJSON("Unexpected end of input");
        if (jsonString[index] === '"') return parseStr();
        if (jsonString[index] === "{") return parseObj();
        if (jsonString[index] === "[") return parseArr();
        if (jsonString.substring(index, index + 4) === "null" || options_1.Allow.NULL & allow && length - index < 4 && "null".startsWith(jsonString.substring(index))) {
            index += 4;
            return null;
        }
        if (jsonString.substring(index, index + 4) === "true" || options_1.Allow.BOOL & allow && length - index < 4 && "true".startsWith(jsonString.substring(index))) {
            index += 4;
            return true;
        }
        if (jsonString.substring(index, index + 5) === "false" || options_1.Allow.BOOL & allow && length - index < 5 && "false".startsWith(jsonString.substring(index))) {
            index += 5;
            return false;
        }
        if (jsonString.substring(index, index + 8) === "Infinity" || options_1.Allow.INFINITY & allow && length - index < 8 && "Infinity".startsWith(jsonString.substring(index))) {
            index += 8;
            return Infinity;
        }
        if (jsonString.substring(index, index + 9) === "-Infinity" || options_1.Allow._INFINITY & allow && 1 < length - index && length - index < 9 && "-Infinity".startsWith(jsonString.substring(index))) {
            index += 9;
            return -Infinity;
        }
        if (jsonString.substring(index, index + 3) === "NaN" || options_1.Allow.NAN & allow && length - index < 3 && "NaN".startsWith(jsonString.substring(index))) {
            index += 3;
            return NaN;
        }
        return parseNum();
    };
    const parseStr = ()=>{
        const start = index;
        let escape = false;
        index++; // skip initial quote
        while(index < length && (jsonString[index] !== '"' || escape && jsonString[index - 1] === "\\")){
            escape = jsonString[index] === "\\" ? !escape : false;
            index++;
        }
        if (jsonString.charAt(index) == '"') {
            try {
                return JSON.parse(jsonString.substring(start, ++index - Number(escape)));
            } catch (e) {
                throwMalformedError(String(e));
            }
        } else if (options_1.Allow.STR & allow) {
            try {
                return JSON.parse(jsonString.substring(start, index - Number(escape)) + '"');
            } catch (e) {
                // SyntaxError: Invalid escape sequence
                return JSON.parse(jsonString.substring(start, jsonString.lastIndexOf("\\")) + '"');
            }
        }
        markPartialJSON("Unterminated string literal");
    };
    const parseObj = ()=>{
        index++; // skip initial brace
        skipBlank();
        const obj = {};
        try {
            while(jsonString[index] !== "}"){
                skipBlank();
                if (index >= length && options_1.Allow.OBJ & allow) return obj;
                const key = parseStr();
                skipBlank();
                index++; // skip colon
                try {
                    const value = parseAny();
                    obj[key] = value;
                } catch (e) {
                    if (options_1.Allow.OBJ & allow) return obj;
                    else throw e;
                }
                skipBlank();
                if (jsonString[index] === ",") index++; // skip comma
            }
        } catch (e) {
            if (options_1.Allow.OBJ & allow) return obj;
            else markPartialJSON("Expected '}' at end of object");
        }
        index++; // skip final brace
        return obj;
    };
    const parseArr = ()=>{
        index++; // skip initial bracket
        const arr = [];
        try {
            while(jsonString[index] !== "]"){
                arr.push(parseAny());
                skipBlank();
                if (jsonString[index] === ",") {
                    index++; // skip comma
                }
            }
        } catch (e) {
            if (options_1.Allow.ARR & allow) {
                return arr;
            }
            markPartialJSON("Expected ']' at end of array");
        }
        index++; // skip final bracket
        return arr;
    };
    const parseNum = ()=>{
        if (index === 0) {
            if (jsonString === "-") throwMalformedError("Not sure what '-' is");
            try {
                return JSON.parse(jsonString);
            } catch (e) {
                if (options_1.Allow.NUM & allow) try {
                    return JSON.parse(jsonString.substring(0, jsonString.lastIndexOf("e")));
                } catch (e) {}
                throwMalformedError(String(e));
            }
        }
        const start = index;
        if (jsonString[index] === "-") index++;
        while(jsonString[index] && ",]}".indexOf(jsonString[index]) === -1)index++;
        if (index == length && !(options_1.Allow.NUM & allow)) markPartialJSON("Unterminated number literal");
        try {
            return JSON.parse(jsonString.substring(start, index));
        } catch (e) {
            if (jsonString.substring(start, index) === "-") markPartialJSON("Not sure what '-' is");
            try {
                return JSON.parse(jsonString.substring(start, jsonString.lastIndexOf("e")));
            } catch (e) {
                throwMalformedError(String(e));
            }
        }
    };
    const skipBlank = ()=>{
        while(index < length && " \n\r\t".includes(jsonString[index])){
            index++;
        }
    };
    return parseAny();
};
const parse = parseJSON;
exports.parse = parse;
}}),
"[project]/node_modules/uri-templates/uri-templates.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
(function(global, factory) {
    if (typeof define === 'function' && define.amd) {
        ((r)=>r !== undefined && __turbopack_context__.v(r))(factory());
    } else if (("TURBOPACK compile-time value", "object") !== 'undefined' && module.exports) {
        module.exports = factory();
    } else {
        global.UriTemplate = factory();
    }
})(this, function() {
    var uriTemplateGlobalModifiers = {
        "+": true,
        "#": true,
        ".": true,
        "/": true,
        ";": true,
        "?": true,
        "&": true
    };
    var uriTemplateSuffices = {
        "*": true
    };
    var urlEscapedChars = /[:/&?#]/;
    function notReallyPercentEncode(string) {
        return encodeURI(string).replace(/%25[0-9][0-9]/g, function(doubleEncoded) {
            return "%" + doubleEncoded.substring(3);
        });
    }
    function isPercentEncoded(string) {
        string = string.replace(/%../g, '');
        return encodeURIComponent(string) === string;
    }
    function uriTemplateSubstitution(spec) {
        var modifier = "";
        if (uriTemplateGlobalModifiers[spec.charAt(0)]) {
            modifier = spec.charAt(0);
            spec = spec.substring(1);
        }
        var separator = "";
        var prefix = "";
        var shouldEscape = true;
        var showVariables = false;
        var trimEmptyString = false;
        if (modifier == '+') {
            shouldEscape = false;
        } else if (modifier == ".") {
            prefix = ".";
            separator = ".";
        } else if (modifier == "/") {
            prefix = "/";
            separator = "/";
        } else if (modifier == '#') {
            prefix = "#";
            shouldEscape = false;
        } else if (modifier == ';') {
            prefix = ";";
            separator = ";", showVariables = true;
            trimEmptyString = true;
        } else if (modifier == '?') {
            prefix = "?";
            separator = "&", showVariables = true;
        } else if (modifier == '&') {
            prefix = "&";
            separator = "&", showVariables = true;
        }
        var varNames = [];
        var varList = spec.split(",");
        var varSpecs = [];
        var varSpecMap = {};
        for(var i = 0; i < varList.length; i++){
            var varName = varList[i];
            var truncate = null;
            if (varName.indexOf(":") != -1) {
                var parts = varName.split(":");
                varName = parts[0];
                truncate = parseInt(parts[1]);
            }
            var suffices = {};
            while(uriTemplateSuffices[varName.charAt(varName.length - 1)]){
                suffices[varName.charAt(varName.length - 1)] = true;
                varName = varName.substring(0, varName.length - 1);
            }
            var varSpec = {
                truncate: truncate,
                name: varName,
                suffices: suffices
            };
            varSpecs.push(varSpec);
            varSpecMap[varName] = varSpec;
            varNames.push(varName);
        }
        var subFunction = function(valueFunction) {
            var result = "";
            var startIndex = 0;
            for(var i = 0; i < varSpecs.length; i++){
                var varSpec = varSpecs[i];
                var value = valueFunction(varSpec.name);
                if (value == null || Array.isArray(value) && value.length == 0 || typeof value == 'object' && Object.keys(value).length == 0) {
                    startIndex++;
                    continue;
                }
                if (i == startIndex) {
                    result += prefix;
                } else {
                    result += separator || ",";
                }
                if (Array.isArray(value)) {
                    if (showVariables) {
                        result += varSpec.name + "=";
                    }
                    for(var j = 0; j < value.length; j++){
                        if (j > 0) {
                            result += varSpec.suffices['*'] ? separator || "," : ",";
                            if (varSpec.suffices['*'] && showVariables) {
                                result += varSpec.name + "=";
                            }
                        }
                        result += shouldEscape ? encodeURIComponent(value[j]).replace(/!/g, "%21") : notReallyPercentEncode(value[j]);
                    }
                } else if (typeof value == "object") {
                    if (showVariables && !varSpec.suffices['*']) {
                        result += varSpec.name + "=";
                    }
                    var first = true;
                    for(var key in value){
                        if (!first) {
                            result += varSpec.suffices['*'] ? separator || "," : ",";
                        }
                        first = false;
                        result += shouldEscape ? encodeURIComponent(key).replace(/!/g, "%21") : notReallyPercentEncode(key);
                        result += varSpec.suffices['*'] ? '=' : ",";
                        result += shouldEscape ? encodeURIComponent(value[key]).replace(/!/g, "%21") : notReallyPercentEncode(value[key]);
                    }
                } else {
                    if (showVariables) {
                        result += varSpec.name;
                        if (!trimEmptyString || value != "") {
                            result += "=";
                        }
                    }
                    if (varSpec.truncate != null) {
                        value = value.substring(0, varSpec.truncate);
                    }
                    result += shouldEscape ? encodeURIComponent(value).replace(/!/g, "%21") : notReallyPercentEncode(value);
                }
            }
            return result;
        };
        var guessFunction = function(stringValue, resultObj, strict) {
            if (prefix) {
                stringValue = stringValue.substring(prefix.length);
            }
            if (varSpecs.length == 1 && varSpecs[0].suffices['*']) {
                var varSpec = varSpecs[0];
                var varName = varSpec.name;
                var arrayValue = varSpec.suffices['*'] ? stringValue.split(separator || ",") : [
                    stringValue
                ];
                var hasEquals = shouldEscape && stringValue.indexOf('=') != -1; // There's otherwise no way to distinguish between "{value*}" for arrays and objects
                for(var i = 1; i < arrayValue.length; i++){
                    var stringValue = arrayValue[i];
                    if (hasEquals && stringValue.indexOf('=') == -1) {
                        // Bit of a hack - if we're expecting "=" for key/value pairs, and values can't contain "=", then assume a value has been accidentally split
                        arrayValue[i - 1] += (separator || ",") + stringValue;
                        arrayValue.splice(i, 1);
                        i--;
                    }
                }
                for(var i = 0; i < arrayValue.length; i++){
                    var stringValue = arrayValue[i];
                    if (shouldEscape && stringValue.indexOf('=') != -1) {
                        hasEquals = true;
                    }
                    var innerArrayValue = stringValue.split(",");
                    if (innerArrayValue.length == 1) {
                        arrayValue[i] = innerArrayValue[0];
                    } else {
                        arrayValue[i] = innerArrayValue;
                    }
                }
                if (showVariables || hasEquals) {
                    var objectValue = resultObj[varName] || {};
                    for(var j = 0; j < arrayValue.length; j++){
                        var innerValue = stringValue;
                        if (showVariables && !innerValue) {
                            continue;
                        }
                        if (typeof arrayValue[j] == "string") {
                            var stringValue = arrayValue[j];
                            var innerVarName = stringValue.split("=", 1)[0];
                            var stringValue = stringValue.substring(innerVarName.length + 1);
                            if (shouldEscape) {
                                if (strict && !isPercentEncoded(stringValue)) {
                                    return;
                                }
                                stringValue = decodeURIComponent(stringValue);
                            }
                            innerValue = stringValue;
                        } else {
                            var stringValue = arrayValue[j][0];
                            var innerVarName = stringValue.split("=", 1)[0];
                            var stringValue = stringValue.substring(innerVarName.length + 1);
                            if (shouldEscape) {
                                if (strict && !isPercentEncoded(stringValue)) {
                                    return;
                                }
                                stringValue = decodeURIComponent(stringValue);
                            }
                            arrayValue[j][0] = stringValue;
                            innerValue = arrayValue[j];
                        }
                        if (shouldEscape) {
                            if (strict && !isPercentEncoded(innerVarName)) {
                                return;
                            }
                            innerVarName = decodeURIComponent(innerVarName);
                        }
                        if (objectValue[innerVarName] !== undefined) {
                            if (Array.isArray(objectValue[innerVarName])) {
                                objectValue[innerVarName].push(innerValue);
                            } else {
                                objectValue[innerVarName] = [
                                    objectValue[innerVarName],
                                    innerValue
                                ];
                            }
                        } else {
                            objectValue[innerVarName] = innerValue;
                        }
                    }
                    if (Object.keys(objectValue).length == 1 && objectValue[varName] !== undefined) {
                        resultObj[varName] = objectValue[varName];
                    } else {
                        resultObj[varName] = objectValue;
                    }
                } else {
                    if (shouldEscape) {
                        for(var j = 0; j < arrayValue.length; j++){
                            var innerArrayValue = arrayValue[j];
                            if (Array.isArray(innerArrayValue)) {
                                for(var k = 0; k < innerArrayValue.length; k++){
                                    if (strict && !isPercentEncoded(innerArrayValue[k])) {
                                        return;
                                    }
                                    innerArrayValue[k] = decodeURIComponent(innerArrayValue[k]);
                                }
                            } else {
                                if (strict && !isPercentEncoded(innerArrayValue)) {
                                    return;
                                }
                                arrayValue[j] = decodeURIComponent(innerArrayValue);
                            }
                        }
                    }
                    if (resultObj[varName] !== undefined) {
                        if (Array.isArray(resultObj[varName])) {
                            resultObj[varName] = resultObj[varName].concat(arrayValue);
                        } else {
                            resultObj[varName] = [
                                resultObj[varName]
                            ].concat(arrayValue);
                        }
                    } else {
                        if (arrayValue.length == 1 && !varSpec.suffices['*']) {
                            resultObj[varName] = arrayValue[0];
                        } else {
                            resultObj[varName] = arrayValue;
                        }
                    }
                }
            } else {
                var arrayValue = varSpecs.length == 1 ? [
                    stringValue
                ] : stringValue.split(separator || ",");
                var specIndexMap = {};
                for(var i = 0; i < arrayValue.length; i++){
                    // Try from beginning
                    var firstStarred = 0;
                    for(; firstStarred < varSpecs.length - 1 && firstStarred < i; firstStarred++){
                        if (varSpecs[firstStarred].suffices['*']) {
                            break;
                        }
                    }
                    if (firstStarred == i) {
                        // The first [i] of them have no "*" suffix
                        specIndexMap[i] = i;
                        continue;
                    } else {
                        // Try from the end
                        for(var lastStarred = varSpecs.length - 1; lastStarred > 0 && varSpecs.length - lastStarred < arrayValue.length - i; lastStarred--){
                            if (varSpecs[lastStarred].suffices['*']) {
                                break;
                            }
                        }
                        if (varSpecs.length - lastStarred == arrayValue.length - i) {
                            // The last [length - i] of them have no "*" suffix
                            specIndexMap[i] = lastStarred;
                            continue;
                        }
                    }
                    // Just give up and use the first one
                    specIndexMap[i] = firstStarred;
                }
                for(var i = 0; i < arrayValue.length; i++){
                    var stringValue = arrayValue[i];
                    if (!stringValue && showVariables) {
                        continue;
                    }
                    var innerArrayValue = stringValue.split(",");
                    var hasEquals = false;
                    if (showVariables) {
                        var stringValue = innerArrayValue[0]; // using innerArrayValue
                        var varName = stringValue.split("=", 1)[0];
                        var stringValue = stringValue.substring(varName.length + 1);
                        innerArrayValue[0] = stringValue;
                        var varSpec = varSpecMap[varName] || varSpecs[0];
                    } else {
                        var varSpec = varSpecs[specIndexMap[i]];
                        var varName = varSpec.name;
                    }
                    for(var j = 0; j < innerArrayValue.length; j++){
                        if (shouldEscape) {
                            if (strict && !isPercentEncoded(innerArrayValue[j])) {
                                return;
                            }
                            innerArrayValue[j] = decodeURIComponent(innerArrayValue[j]);
                        }
                    }
                    if ((showVariables || varSpec.suffices['*']) && resultObj[varName] !== undefined) {
                        if (Array.isArray(resultObj[varName])) {
                            resultObj[varName] = resultObj[varName].concat(innerArrayValue);
                        } else {
                            resultObj[varName] = [
                                resultObj[varName]
                            ].concat(innerArrayValue);
                        }
                    } else {
                        if (innerArrayValue.length == 1 && !varSpec.suffices['*']) {
                            resultObj[varName] = innerArrayValue[0];
                        } else {
                            resultObj[varName] = innerArrayValue;
                        }
                    }
                }
            }
            return 1;
        };
        return {
            varNames: varNames,
            prefix: prefix,
            substitution: subFunction,
            unSubstitution: guessFunction
        };
    }
    function UriTemplate(template) {
        if (!(this instanceof UriTemplate)) {
            return new UriTemplate(template);
        }
        var parts = template.split("{");
        var textParts = [
            parts.shift()
        ];
        var prefixes = [];
        var substitutions = [];
        var unSubstitutions = [];
        var varNames = [];
        while(parts.length > 0){
            var part = parts.shift();
            var spec = part.split("}")[0];
            var remainder = part.substring(spec.length + 1);
            var funcs = uriTemplateSubstitution(spec);
            substitutions.push(funcs.substitution);
            unSubstitutions.push(funcs.unSubstitution);
            prefixes.push(funcs.prefix);
            textParts.push(remainder);
            varNames = varNames.concat(funcs.varNames);
        }
        this.fill = function(valueFunction) {
            if (valueFunction && typeof valueFunction !== 'function') {
                var value = valueFunction;
                valueFunction = function(varName) {
                    return value[varName];
                };
            }
            var result = textParts[0];
            for(var i = 0; i < substitutions.length; i++){
                var substitution = substitutions[i];
                result += substitution(valueFunction);
                result += textParts[i + 1];
            }
            return result;
        };
        this.fromUri = function(substituted, options) {
            options = options || {};
            var result = {};
            for(var i = 0; i < textParts.length; i++){
                var part = textParts[i];
                if (substituted.substring(0, part.length) !== part) {
                    return;
                }
                substituted = substituted.substring(part.length);
                if (i >= textParts.length - 1) {
                    // We've run out of input - is there any template left?
                    if (substituted == "") {
                        break;
                    } else {
                        return;
                    }
                }
                var prefix = prefixes[i];
                if (prefix && substituted.substring(0, prefix.length) !== prefix) {
                    continue;
                }
                // Find the next part to un-substitute
                var nextPart = textParts[i + 1];
                var offset = i;
                while(true){
                    if (offset == textParts.length - 2) {
                        var endPart = substituted.substring(substituted.length - nextPart.length);
                        if (endPart !== nextPart) {
                            return;
                        }
                        var stringValue = substituted.substring(0, substituted.length - nextPart.length);
                        substituted = endPart;
                    } else if (nextPart) {
                        var nextPartPos = substituted.indexOf(nextPart);
                        var stringValue = substituted.substring(0, nextPartPos);
                        substituted = substituted.substring(nextPartPos);
                    } else if (prefixes[offset + 1]) {
                        var nextPartPos = substituted.indexOf(prefixes[offset + 1]);
                        if (nextPartPos === -1) nextPartPos = substituted.length;
                        var stringValue = substituted.substring(0, nextPartPos);
                        substituted = substituted.substring(nextPartPos);
                    } else if (textParts.length > offset + 2) {
                        // If the separator between this variable and the next is blank (with no prefix), continue onwards
                        offset++;
                        nextPart = textParts[offset + 1];
                        continue;
                    } else {
                        var stringValue = substituted;
                        substituted = "";
                    }
                    break;
                }
                if (!unSubstitutions[i](stringValue, result, options.strict)) {
                    return;
                }
            }
            return result;
        };
        this.varNames = varNames;
        this.template = template;
    }
    UriTemplate.prototype = {
        toString: function() {
            return this.template;
        },
        fillFromObject: function(obj) {
            return this.fill(obj);
        },
        test: function(uri, options) {
            return !!this.fromUri(uri, options);
        }
    };
    return UriTemplate;
});
}}),
"[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
;
;
;
;
;
;
;
;
;
;
;
;
;
;
}}),
"[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/uuid/dist/esm-node/max.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
const __TURBOPACK__default__export__ = 'ffffffff-ffff-ffff-ffff-ffffffffffff';
}}),
"[project]/node_modules/uuid/dist/esm-node/nil.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
const __TURBOPACK__default__export__ = '00000000-0000-0000-0000-000000000000';
}}),
"[project]/node_modules/uuid/dist/esm-node/regex.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
const __TURBOPACK__default__export__ = /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-8][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000|ffffffff-ffff-ffff-ffff-ffffffffffff)$/i;
}}),
"[project]/node_modules/uuid/dist/esm-node/validate.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$regex$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/regex.js [app-rsc] (ecmascript)");
;
function validate(uuid) {
    return typeof uuid === 'string' && __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$regex$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"].test(uuid);
}
const __TURBOPACK__default__export__ = validate;
}}),
"[project]/node_modules/uuid/dist/esm-node/parse.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/validate.js [app-rsc] (ecmascript)");
;
function parse(uuid) {
    if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(uuid)) {
        throw TypeError('Invalid UUID');
    }
    let v;
    const arr = new Uint8Array(16);
    // Parse ########-....-....-....-............
    arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;
    arr[1] = v >>> 16 & 0xff;
    arr[2] = v >>> 8 & 0xff;
    arr[3] = v & 0xff;
    // Parse ........-####-....-....-............
    arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;
    arr[5] = v & 0xff;
    // Parse ........-....-####-....-............
    arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;
    arr[7] = v & 0xff;
    // Parse ........-....-....-####-............
    arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;
    arr[9] = v & 0xff;
    // Parse ........-....-....-....-############
    // (Use "/" to avoid 32-bit truncation when bit-shifting high-order bytes)
    arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;
    arr[11] = v / 0x100000000 & 0xff;
    arr[12] = v >>> 24 & 0xff;
    arr[13] = v >>> 16 & 0xff;
    arr[14] = v >>> 8 & 0xff;
    arr[15] = v & 0xff;
    return arr;
}
const __TURBOPACK__default__export__ = parse;
}}),
"[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__),
    "unsafeStringify": (()=>unsafeStringify)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/validate.js [app-rsc] (ecmascript)");
;
/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */ const byteToHex = [];
for(let i = 0; i < 256; ++i){
    byteToHex.push((i + 0x100).toString(16).slice(1));
}
function unsafeStringify(arr, offset = 0) {
    // Note: Be careful editing this code!  It's been tuned for performance
    // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
    //
    // Note to future-self: No, you can't remove the `toLowerCase()` call.
    // REF: https://github.com/uuidjs/uuid/pull/677#issuecomment-1757351351
    return (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase();
}
function stringify(arr, offset = 0) {
    const uuid = unsafeStringify(arr, offset);
    // Consistency check for valid UUID.  If this throws, it's likely due to one
    // of the following:
    // - One or more input array values don't map to a hex octet (leading to
    // "undefined" in the uuid)
    // - Invalid input values for the RFC `version` or `variant` fields
    if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(uuid)) {
        throw TypeError('Stringified UUID is invalid');
    }
    return uuid;
}
const __TURBOPACK__default__export__ = stringify;
}}),
"[project]/node_modules/uuid/dist/esm-node/rng.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>rng)
});
var __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/node:crypto [external] (node:crypto, cjs)");
;
const rnds8Pool = new Uint8Array(256); // # of random values to pre-allocate
let poolPtr = rnds8Pool.length;
function rng() {
    if (poolPtr > rnds8Pool.length - 16) {
        __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__["default"].randomFillSync(rnds8Pool);
        poolPtr = 0;
    }
    return rnds8Pool.slice(poolPtr, poolPtr += 16);
}
}}),
"[project]/node_modules/uuid/dist/esm-node/v1.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$rng$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/rng.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
;
;
// **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html
let _nodeId;
let _clockseq;
// Previous uuid creation time
let _lastMSecs = 0;
let _lastNSecs = 0;
// See https://github.com/uuidjs/uuid for API details
function v1(options, buf, offset) {
    let i = buf && offset || 0;
    const b = buf || new Array(16);
    options = options || {};
    let node = options.node;
    let clockseq = options.clockseq;
    // v1 only: Use cached `node` and `clockseq` values
    if (!options._v6) {
        if (!node) {
            node = _nodeId;
        }
        if (clockseq == null) {
            clockseq = _clockseq;
        }
    }
    // Handle cases where we need entropy.  We do this lazily to minimize issues
    // related to insufficient system entropy.  See #189
    if (node == null || clockseq == null) {
        const seedBytes = options.random || (options.rng || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$rng$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])();
        // Randomize node
        if (node == null) {
            node = [
                seedBytes[0],
                seedBytes[1],
                seedBytes[2],
                seedBytes[3],
                seedBytes[4],
                seedBytes[5]
            ];
            // v1 only: cache node value for reuse
            if (!_nodeId && !options._v6) {
                // per RFC4122 4.5: Set MAC multicast bit (v1 only)
                node[0] |= 0x01; // Set multicast bit
                _nodeId = node;
            }
        }
        // Randomize clockseq
        if (clockseq == null) {
            // Per 4.2.2, randomize (14 bit) clockseq
            clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
            if (_clockseq === undefined && !options._v6) {
                _clockseq = clockseq;
            }
        }
    }
    // v1 & v6 timestamps are 100 nano-second units since the Gregorian epoch,
    // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so time is
    // handled internally as 'msecs' (integer milliseconds) and 'nsecs'
    // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.
    let msecs = options.msecs !== undefined ? options.msecs : Date.now();
    // Per 4.2.1.2, use count of uuid's generated during the current clock
    // cycle to simulate higher resolution clock
    let nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1;
    // Time since last uuid creation (in msecs)
    const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000;
    // Per 4.2.1.2, Bump clockseq on clock regression
    if (dt < 0 && options.clockseq === undefined) {
        clockseq = clockseq + 1 & 0x3fff;
    }
    // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
    // time interval
    if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
        nsecs = 0;
    }
    // Per 4.2.1.2 Throw error if too many uuids are requested
    if (nsecs >= 10000) {
        throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
    }
    _lastMSecs = msecs;
    _lastNSecs = nsecs;
    _clockseq = clockseq;
    // Per 4.1.4 - Convert from unix epoch to Gregorian epoch
    msecs += 12219292800000;
    // `time_low`
    const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
    b[i++] = tl >>> 24 & 0xff;
    b[i++] = tl >>> 16 & 0xff;
    b[i++] = tl >>> 8 & 0xff;
    b[i++] = tl & 0xff;
    // `time_mid`
    const tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
    b[i++] = tmh >>> 8 & 0xff;
    b[i++] = tmh & 0xff;
    // `time_high_and_version`
    b[i++] = tmh >>> 24 & 0xf | 0x10; // include version
    b[i++] = tmh >>> 16 & 0xff;
    // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)
    b[i++] = clockseq >>> 8 | 0x80;
    // `clock_seq_low`
    b[i++] = clockseq & 0xff;
    // `node`
    for(let n = 0; n < 6; ++n){
        b[i + n] = node[n];
    }
    return buf || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(b);
}
const __TURBOPACK__default__export__ = v1;
}}),
"[project]/node_modules/uuid/dist/esm-node/v1ToV6.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>v1ToV6)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/parse.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
;
;
function v1ToV6(uuid) {
    const v1Bytes = typeof uuid === 'string' ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(uuid) : uuid;
    const v6Bytes = _v1ToV6(v1Bytes);
    return typeof uuid === 'string' ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(v6Bytes) : v6Bytes;
}
// Do the field transformation needed for v1 -> v6
function _v1ToV6(v1Bytes, randomize = false) {
    return Uint8Array.of((v1Bytes[6] & 0x0f) << 4 | v1Bytes[7] >> 4 & 0x0f, (v1Bytes[7] & 0x0f) << 4 | (v1Bytes[4] & 0xf0) >> 4, (v1Bytes[4] & 0x0f) << 4 | (v1Bytes[5] & 0xf0) >> 4, (v1Bytes[5] & 0x0f) << 4 | (v1Bytes[0] & 0xf0) >> 4, (v1Bytes[0] & 0x0f) << 4 | (v1Bytes[1] & 0xf0) >> 4, (v1Bytes[1] & 0x0f) << 4 | (v1Bytes[2] & 0xf0) >> 4, 0x60 | v1Bytes[2] & 0x0f, v1Bytes[3], v1Bytes[8], v1Bytes[9], v1Bytes[10], v1Bytes[11], v1Bytes[12], v1Bytes[13], v1Bytes[14], v1Bytes[15]);
}
}}),
"[project]/node_modules/uuid/dist/esm-node/v35.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "DNS": (()=>DNS),
    "URL": (()=>URL),
    "default": (()=>v35)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/parse.js [app-rsc] (ecmascript)");
;
;
function stringToBytes(str) {
    str = unescape(encodeURIComponent(str)); // UTF8 escape
    const bytes = [];
    for(let i = 0; i < str.length; ++i){
        bytes.push(str.charCodeAt(i));
    }
    return bytes;
}
const DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
const URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
function v35(name, version, hashfunc) {
    function generateUUID(value, namespace, buf, offset) {
        var _namespace;
        if (typeof value === 'string') {
            value = stringToBytes(value);
        }
        if (typeof namespace === 'string') {
            namespace = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(namespace);
        }
        if (((_namespace = namespace) === null || _namespace === void 0 ? void 0 : _namespace.length) !== 16) {
            throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');
        }
        // Compute hash of namespace and value, Per 4.3
        // Future: Use spread syntax when supported on all platforms, e.g. `bytes =
        // hashfunc([...namespace, ... value])`
        let bytes = new Uint8Array(16 + value.length);
        bytes.set(namespace);
        bytes.set(value, namespace.length);
        bytes = hashfunc(bytes);
        bytes[6] = bytes[6] & 0x0f | version;
        bytes[8] = bytes[8] & 0x3f | 0x80;
        if (buf) {
            offset = offset || 0;
            for(let i = 0; i < 16; ++i){
                buf[offset + i] = bytes[i];
            }
            return buf;
        }
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(bytes);
    }
    // Function#name is not settable on some platforms (#270)
    try {
        generateUUID.name = name;
    } catch (err) {}
    // For CommonJS default export support
    generateUUID.DNS = DNS;
    generateUUID.URL = URL;
    return generateUUID;
}
}}),
"[project]/node_modules/uuid/dist/esm-node/md5.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/node:crypto [external] (node:crypto, cjs)");
;
function md5(bytes) {
    if (Array.isArray(bytes)) {
        bytes = Buffer.from(bytes);
    } else if (typeof bytes === 'string') {
        bytes = Buffer.from(bytes, 'utf8');
    }
    return __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__["default"].createHash('md5').update(bytes).digest();
}
const __TURBOPACK__default__export__ = md5;
}}),
"[project]/node_modules/uuid/dist/esm-node/v3.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v35$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v35.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$md5$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/md5.js [app-rsc] (ecmascript)");
;
;
const v3 = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v35$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])('v3', 0x30, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$md5$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]);
const __TURBOPACK__default__export__ = v3;
}}),
"[project]/node_modules/uuid/dist/esm-node/native.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/node:crypto [external] (node:crypto, cjs)");
;
const __TURBOPACK__default__export__ = {
    randomUUID: __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__["default"].randomUUID
};
}}),
"[project]/node_modules/uuid/dist/esm-node/v4.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$native$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/native.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$rng$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/rng.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
;
;
;
function v4(options, buf, offset) {
    if (__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$native$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"].randomUUID && !buf && !options) {
        return __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$native$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"].randomUUID();
    }
    options = options || {};
    const rnds = options.random || (options.rng || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$rng$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])();
    // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`
    rnds[6] = rnds[6] & 0x0f | 0x40;
    rnds[8] = rnds[8] & 0x3f | 0x80;
    // Copy bytes to buffer, if provided
    if (buf) {
        offset = offset || 0;
        for(let i = 0; i < 16; ++i){
            buf[offset + i] = rnds[i];
        }
        return buf;
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(rnds);
}
const __TURBOPACK__default__export__ = v4;
}}),
"[project]/node_modules/uuid/dist/esm-node/sha1.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__ = __turbopack_context__.i("[externals]/node:crypto [external] (node:crypto, cjs)");
;
function sha1(bytes) {
    if (Array.isArray(bytes)) {
        bytes = Buffer.from(bytes);
    } else if (typeof bytes === 'string') {
        bytes = Buffer.from(bytes, 'utf8');
    }
    return __TURBOPACK__imported__module__$5b$externals$5d2f$node$3a$crypto__$5b$external$5d$__$28$node$3a$crypto$2c$__cjs$29$__["default"].createHash('sha1').update(bytes).digest();
}
const __TURBOPACK__default__export__ = sha1;
}}),
"[project]/node_modules/uuid/dist/esm-node/v5.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v35$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v35.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$sha1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/sha1.js [app-rsc] (ecmascript)");
;
;
const v5 = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v35$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])('v5', 0x50, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$sha1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]);
const __TURBOPACK__default__export__ = v5;
}}),
"[project]/node_modules/uuid/dist/esm-node/v6.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>v6)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v1.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1ToV6$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v1ToV6.js [app-rsc] (ecmascript)");
;
;
;
function v6(options = {}, buf, offset = 0) {
    // v6 is v1 with different field layout, so we start with a v1 UUID, albeit
    // with slightly different behavior around how the clock_seq and node fields
    // are randomized, which is why we call v1 with _v6: true.
    let bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])({
        ...options,
        _v6: true
    }, new Uint8Array(16));
    // Reorder the fields to v6 layout.
    bytes = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1ToV6$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(bytes);
    // Return as a byte array if requested
    if (buf) {
        for(let i = 0; i < 16; i++){
            buf[offset + i] = bytes[i];
        }
        return buf;
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(bytes);
}
}}),
"[project]/node_modules/uuid/dist/esm-node/v6ToV1.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>v6ToV1)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/parse.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
;
;
function v6ToV1(uuid) {
    const v6Bytes = typeof uuid === 'string' ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(uuid) : uuid;
    const v1Bytes = _v6ToV1(v6Bytes);
    return typeof uuid === 'string' ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(v1Bytes) : v1Bytes;
}
// Do the field transformation needed for v6 -> v1
function _v6ToV1(v6Bytes) {
    return Uint8Array.of((v6Bytes[3] & 0x0f) << 4 | v6Bytes[4] >> 4 & 0x0f, (v6Bytes[4] & 0x0f) << 4 | (v6Bytes[5] & 0xf0) >> 4, (v6Bytes[5] & 0x0f) << 4 | v6Bytes[6] & 0x0f, v6Bytes[7], (v6Bytes[1] & 0x0f) << 4 | (v6Bytes[2] & 0xf0) >> 4, (v6Bytes[2] & 0x0f) << 4 | (v6Bytes[3] & 0xf0) >> 4, 0x10 | (v6Bytes[0] & 0xf0) >> 4, (v6Bytes[0] & 0x0f) << 4 | (v6Bytes[1] & 0xf0) >> 4, v6Bytes[8], v6Bytes[9], v6Bytes[10], v6Bytes[11], v6Bytes[12], v6Bytes[13], v6Bytes[14], v6Bytes[15]);
}
}}),
"[project]/node_modules/uuid/dist/esm-node/v7.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$rng$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/rng.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
;
;
/**
 * UUID V7 - Unix Epoch time-based UUID
 *
 * The IETF has published RFC9562, introducing 3 new UUID versions (6,7,8). This
 * implementation of V7 is based on the accepted, though not yet approved,
 * revisions.
 *
 * RFC 9562:https://www.rfc-editor.org/rfc/rfc9562.html Universally Unique
 * IDentifiers (UUIDs)

 *
 * Sample V7 value:
 * https://www.rfc-editor.org/rfc/rfc9562.html#name-example-of-a-uuidv7-value
 *
 * Monotonic Bit Layout: RFC rfc9562.6.2 Method 1, Dedicated Counter Bits ref:
 *     https://www.rfc-editor.org/rfc/rfc9562.html#section-6.2-5.1
 *
 *   0                   1                   2                   3 0 1 2 3 4 5 6
 *   7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |                          unix_ts_ms                           |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |          unix_ts_ms           |  ver  |        seq_hi         |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |var|               seq_low               |        rand         |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *  |                             rand                              |
 *  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 *
 * seq is a 31 bit serialized counter; comprised of 12 bit seq_hi and 19 bit
 * seq_low, and randomly initialized upon timestamp change. 31 bit counter size
 * was selected as any bitwise operations in node are done as _signed_ 32 bit
 * ints. we exclude the sign bit.
 */ let _seqLow = null;
let _seqHigh = null;
let _msecs = 0;
function v7(options, buf, offset) {
    options = options || {};
    // initialize buffer and pointer
    let i = buf && offset || 0;
    const b = buf || new Uint8Array(16);
    // rnds is Uint8Array(16) filled with random bytes
    const rnds = options.random || (options.rng || __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$rng$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])();
    // milliseconds since unix epoch, 1970-01-01 00:00
    const msecs = options.msecs !== undefined ? options.msecs : Date.now();
    // seq is user provided 31 bit counter
    let seq = options.seq !== undefined ? options.seq : null;
    // initialize local seq high/low parts
    let seqHigh = _seqHigh;
    let seqLow = _seqLow;
    // check if clock has advanced and user has not provided msecs
    if (msecs > _msecs && options.msecs === undefined) {
        _msecs = msecs;
        // unless user provided seq, reset seq parts
        if (seq !== null) {
            seqHigh = null;
            seqLow = null;
        }
    }
    // if we have a user provided seq
    if (seq !== null) {
        // trim provided seq to 31 bits of value, avoiding overflow
        if (seq > 0x7fffffff) {
            seq = 0x7fffffff;
        }
        // split provided seq into high/low parts
        seqHigh = seq >>> 19 & 0xfff;
        seqLow = seq & 0x7ffff;
    }
    // randomly initialize seq
    if (seqHigh === null || seqLow === null) {
        seqHigh = rnds[6] & 0x7f;
        seqHigh = seqHigh << 8 | rnds[7];
        seqLow = rnds[8] & 0x3f; // pad for var
        seqLow = seqLow << 8 | rnds[9];
        seqLow = seqLow << 5 | rnds[10] >>> 3;
    }
    // increment seq if within msecs window
    if (msecs + 10000 > _msecs && seq === null) {
        if (++seqLow > 0x7ffff) {
            seqLow = 0;
            if (++seqHigh > 0xfff) {
                seqHigh = 0;
                // increment internal _msecs. this allows us to continue incrementing
                // while staying monotonic. Note, once we hit 10k milliseconds beyond system
                // clock, we will reset breaking monotonicity (after (2^31)*10000 generations)
                _msecs++;
            }
        }
    } else {
        // resetting; we have advanced more than
        // 10k milliseconds beyond system clock
        _msecs = msecs;
    }
    _seqHigh = seqHigh;
    _seqLow = seqLow;
    // [bytes 0-5] 48 bits of local timestamp
    b[i++] = _msecs / 0x10000000000 & 0xff;
    b[i++] = _msecs / 0x100000000 & 0xff;
    b[i++] = _msecs / 0x1000000 & 0xff;
    b[i++] = _msecs / 0x10000 & 0xff;
    b[i++] = _msecs / 0x100 & 0xff;
    b[i++] = _msecs & 0xff;
    // [byte 6] - set 4 bits of version (7) with first 4 bits seq_hi
    b[i++] = seqHigh >>> 4 & 0x0f | 0x70;
    // [byte 7] remaining 8 bits of seq_hi
    b[i++] = seqHigh & 0xff;
    // [byte 8] - variant (2 bits), first 6 bits seq_low
    b[i++] = seqLow >>> 13 & 0x3f | 0x80;
    // [byte 9] 8 bits seq_low
    b[i++] = seqLow >>> 5 & 0xff;
    // [byte 10] remaining 5 bits seq_low, 3 bits random
    b[i++] = seqLow << 3 & 0xff | rnds[10] & 0x07;
    // [bytes 11-15] always random
    b[i++] = rnds[11];
    b[i++] = rnds[12];
    b[i++] = rnds[13];
    b[i++] = rnds[14];
    b[i++] = rnds[15];
    return buf || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["unsafeStringify"])(b);
}
const __TURBOPACK__default__export__ = v7;
}}),
"[project]/node_modules/uuid/dist/esm-node/version.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>__TURBOPACK__default__export__)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/validate.js [app-rsc] (ecmascript)");
;
function version(uuid) {
    if (!(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])(uuid)) {
        throw TypeError('Invalid UUID');
    }
    return parseInt(uuid.slice(14, 15), 16);
}
const __TURBOPACK__default__export__ = version;
}}),
"[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <exports>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "MAX": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$max$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "NIL": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$nil$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "parse": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "stringify": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v1": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v1ToV6": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1ToV6$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v3": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v3$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v4": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v4$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v5": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v5$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v6": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v6$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v6ToV1": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v6ToV1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "v7": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v7$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "validate": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"]),
    "version": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$version$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["default"])
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$max$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/max.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$nil$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/nil.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$parse$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/parse.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$stringify$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/stringify.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v1.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v1ToV6$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v1ToV6.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v3$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v3.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v4$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v4.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v5$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v5.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v6$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v6.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v6ToV1$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v6ToV1.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$v7$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/v7.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$validate$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/validate.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$version$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/version.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "MAX": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["MAX"]),
    "NIL": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["NIL"]),
    "parse": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["parse"]),
    "stringify": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["stringify"]),
    "v1": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v1"]),
    "v1ToV6": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v1ToV6"]),
    "v3": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v3"]),
    "v4": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v4"]),
    "v5": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v5"]),
    "v6": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v6"]),
    "v6ToV1": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v6ToV1"]),
    "v7": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["v7"]),
    "validate": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["validate"]),
    "version": (()=>__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__["version"])
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$uuid$2f$dist$2f$esm$2d$node$2f$index$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$exports$3e$__ = __turbopack_context__.i("[project]/node_modules/uuid/dist/esm-node/index.js [app-rsc] (ecmascript) <exports>");
}}),
"[project]/node_modules/semver/internal/constants.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
// Note: this is the semver.org version of the spec that it implements
// Not necessarily the package version of this code.
const SEMVER_SPEC_VERSION = '2.0.0';
const MAX_LENGTH = 256;
const MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */ 9007199254740991;
// Max safe segment length for coercion.
const MAX_SAFE_COMPONENT_LENGTH = 16;
// Max safe length for a build identifier. The max length minus 6 characters for
// the shortest version with a build 0.0.0+BUILD.
const MAX_SAFE_BUILD_LENGTH = MAX_LENGTH - 6;
const RELEASE_TYPES = [
    'major',
    'premajor',
    'minor',
    'preminor',
    'patch',
    'prepatch',
    'prerelease'
];
module.exports = {
    MAX_LENGTH,
    MAX_SAFE_COMPONENT_LENGTH,
    MAX_SAFE_BUILD_LENGTH,
    MAX_SAFE_INTEGER,
    RELEASE_TYPES,
    SEMVER_SPEC_VERSION,
    FLAG_INCLUDE_PRERELEASE: 0b001,
    FLAG_LOOSE: 0b010
};
}}),
"[project]/node_modules/semver/internal/debug.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const debug = typeof process === 'object' && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args)=>console.error('SEMVER', ...args) : ()=>{};
module.exports = debug;
}}),
"[project]/node_modules/semver/internal/re.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const { MAX_SAFE_COMPONENT_LENGTH, MAX_SAFE_BUILD_LENGTH, MAX_LENGTH } = __turbopack_context__.r("[project]/node_modules/semver/internal/constants.js [app-rsc] (ecmascript)");
const debug = __turbopack_context__.r("[project]/node_modules/semver/internal/debug.js [app-rsc] (ecmascript)");
exports = module.exports = {};
// The actual regexps go on exports.re
const re = exports.re = [];
const safeRe = exports.safeRe = [];
const src = exports.src = [];
const safeSrc = exports.safeSrc = [];
const t = exports.t = {};
let R = 0;
const LETTERDASHNUMBER = '[a-zA-Z0-9-]';
// Replace some greedy regex tokens to prevent regex dos issues. These regex are
// used internally via the safeRe object since all inputs in this library get
// normalized first to trim and collapse all extra whitespace. The original
// regexes are exported for userland consumption and lower level usage. A
// future breaking change could export the safer regex only with a note that
// all input should have extra whitespace removed.
const safeRegexReplacements = [
    [
        '\\s',
        1
    ],
    [
        '\\d',
        MAX_LENGTH
    ],
    [
        LETTERDASHNUMBER,
        MAX_SAFE_BUILD_LENGTH
    ]
];
const makeSafeRegex = (value)=>{
    for (const [token, max] of safeRegexReplacements){
        value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
    }
    return value;
};
const createToken = (name, value, isGlobal)=>{
    const safe = makeSafeRegex(value);
    const index = R++;
    debug(name, index, value);
    t[name] = index;
    src[index] = value;
    safeSrc[index] = safe;
    re[index] = new RegExp(value, isGlobal ? 'g' : undefined);
    safeRe[index] = new RegExp(safe, isGlobal ? 'g' : undefined);
};
// The following Regular Expressions can be used for tokenizing,
// validating, and parsing SemVer version strings.
// ## Numeric Identifier
// A single `0`, or a non-zero digit followed by zero or more digits.
createToken('NUMERICIDENTIFIER', '0|[1-9]\\d*');
createToken('NUMERICIDENTIFIERLOOSE', '\\d+');
// ## Non-numeric Identifier
// Zero or more digits, followed by a letter or hyphen, and then zero or
// more letters, digits, or hyphens.
createToken('NONNUMERICIDENTIFIER', `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
// ## Main Version
// Three dot-separated numeric identifiers.
createToken('MAINVERSION', `(${src[t.NUMERICIDENTIFIER]})\\.` + `(${src[t.NUMERICIDENTIFIER]})\\.` + `(${src[t.NUMERICIDENTIFIER]})`);
createToken('MAINVERSIONLOOSE', `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.` + `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.` + `(${src[t.NUMERICIDENTIFIERLOOSE]})`);
// ## Pre-release Version Identifier
// A numeric identifier, or a non-numeric identifier.
// Non-numberic identifiers include numberic identifiers but can be longer.
// Therefore non-numberic identifiers must go first.
createToken('PRERELEASEIDENTIFIER', `(?:${src[t.NONNUMERICIDENTIFIER]}|${src[t.NUMERICIDENTIFIER]})`);
createToken('PRERELEASEIDENTIFIERLOOSE', `(?:${src[t.NONNUMERICIDENTIFIER]}|${src[t.NUMERICIDENTIFIERLOOSE]})`);
// ## Pre-release Version
// Hyphen, followed by one or more dot-separated pre-release version
// identifiers.
createToken('PRERELEASE', `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
createToken('PRERELEASELOOSE', `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
// ## Build Metadata Identifier
// Any combination of digits, letters, or hyphens.
createToken('BUILDIDENTIFIER', `${LETTERDASHNUMBER}+`);
// ## Build Metadata
// Plus sign, followed by one or more period-separated build metadata
// identifiers.
createToken('BUILD', `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
// ## Full Version String
// A main version, followed optionally by a pre-release version and
// build metadata.
// Note that the only major, minor, patch, and pre-release sections of
// the version string are capturing groups.  The build metadata is not a
// capturing group, because it should not ever be used in version
// comparison.
createToken('FULLPLAIN', `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
createToken('FULL', `^${src[t.FULLPLAIN]}$`);
// like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
// also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
// common in the npm registry.
createToken('LOOSEPLAIN', `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
createToken('LOOSE', `^${src[t.LOOSEPLAIN]}$`);
createToken('GTLT', '((?:<|>)?=?)');
// Something like "2.*" or "1.2.x".
// Note that "x.x" is a valid xRange identifer, meaning "any version"
// Only the first item is strictly required.
createToken('XRANGEIDENTIFIERLOOSE', `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
createToken('XRANGEIDENTIFIER', `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
createToken('XRANGEPLAIN', `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})` + `(?:\\.(${src[t.XRANGEIDENTIFIER]})` + `(?:\\.(${src[t.XRANGEIDENTIFIER]})` + `(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?` + `)?)?`);
createToken('XRANGEPLAINLOOSE', `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})` + `(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?` + `)?)?`);
createToken('XRANGE', `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
createToken('XRANGELOOSE', `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
// Coercion.
// Extract anything that could conceivably be a part of a valid semver
createToken('COERCEPLAIN', `${'(^|[^\\d])' + '(\\d{1,'}${MAX_SAFE_COMPONENT_LENGTH}})` + `(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?` + `(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);
createToken('COERCE', `${src[t.COERCEPLAIN]}(?:$|[^\\d])`);
createToken('COERCEFULL', src[t.COERCEPLAIN] + `(?:${src[t.PRERELEASE]})?` + `(?:${src[t.BUILD]})?` + `(?:$|[^\\d])`);
createToken('COERCERTL', src[t.COERCE], true);
createToken('COERCERTLFULL', src[t.COERCEFULL], true);
// Tilde ranges.
// Meaning is "reasonably at or greater than"
createToken('LONETILDE', '(?:~>?)');
createToken('TILDETRIM', `(\\s*)${src[t.LONETILDE]}\\s+`, true);
exports.tildeTrimReplace = '$1~';
createToken('TILDE', `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
createToken('TILDELOOSE', `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
// Caret ranges.
// Meaning is "at least and backwards compatible with"
createToken('LONECARET', '(?:\\^)');
createToken('CARETTRIM', `(\\s*)${src[t.LONECARET]}\\s+`, true);
exports.caretTrimReplace = '$1^';
createToken('CARET', `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
createToken('CARETLOOSE', `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
// A simple gt/lt/eq thing, or just "" to indicate "any version"
createToken('COMPARATORLOOSE', `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
createToken('COMPARATOR', `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
// An expression to strip any whitespace between the gtlt and the thing
// it modifies, so that `> 1.2.3` ==> `>1.2.3`
createToken('COMPARATORTRIM', `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
exports.comparatorTrimReplace = '$1$2$3';
// Something like `1.2.3 - 1.2.4`
// Note that these all use the loose form, because they'll be
// checked against either the strict or loose comparator form
// later.
createToken('HYPHENRANGE', `^\\s*(${src[t.XRANGEPLAIN]})` + `\\s+-\\s+` + `(${src[t.XRANGEPLAIN]})` + `\\s*$`);
createToken('HYPHENRANGELOOSE', `^\\s*(${src[t.XRANGEPLAINLOOSE]})` + `\\s+-\\s+` + `(${src[t.XRANGEPLAINLOOSE]})` + `\\s*$`);
// Star ranges basically just allow anything at all.
createToken('STAR', '(<|>)?=?\\s*\\*');
// >=0.0.0 is like a star
createToken('GTE0', '^\\s*>=\\s*0\\.0\\.0\\s*$');
createToken('GTE0PRE', '^\\s*>=\\s*0\\.0\\.0-0\\s*$');
}}),
"[project]/node_modules/semver/internal/parse-options.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
// parse out just the options we care about
const looseOption = Object.freeze({
    loose: true
});
const emptyOpts = Object.freeze({});
const parseOptions = (options)=>{
    if (!options) {
        return emptyOpts;
    }
    if (typeof options !== 'object') {
        return looseOption;
    }
    return options;
};
module.exports = parseOptions;
}}),
"[project]/node_modules/semver/internal/identifiers.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const numeric = /^[0-9]+$/;
const compareIdentifiers = (a, b)=>{
    const anum = numeric.test(a);
    const bnum = numeric.test(b);
    if (anum && bnum) {
        a = +a;
        b = +b;
    }
    return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
};
const rcompareIdentifiers = (a, b)=>compareIdentifiers(b, a);
module.exports = {
    compareIdentifiers,
    rcompareIdentifiers
};
}}),
"[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const debug = __turbopack_context__.r("[project]/node_modules/semver/internal/debug.js [app-rsc] (ecmascript)");
const { MAX_LENGTH, MAX_SAFE_INTEGER } = __turbopack_context__.r("[project]/node_modules/semver/internal/constants.js [app-rsc] (ecmascript)");
const { safeRe: re, t } = __turbopack_context__.r("[project]/node_modules/semver/internal/re.js [app-rsc] (ecmascript)");
const parseOptions = __turbopack_context__.r("[project]/node_modules/semver/internal/parse-options.js [app-rsc] (ecmascript)");
const { compareIdentifiers } = __turbopack_context__.r("[project]/node_modules/semver/internal/identifiers.js [app-rsc] (ecmascript)");
class SemVer {
    constructor(version, options){
        options = parseOptions(options);
        if (version instanceof SemVer) {
            if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
                return version;
            } else {
                version = version.version;
            }
        } else if (typeof version !== 'string') {
            throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
        }
        if (version.length > MAX_LENGTH) {
            throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
        }
        debug('SemVer', version, options);
        this.options = options;
        this.loose = !!options.loose;
        // this isn't actually relevant for versions, but keep it so that we
        // don't run into trouble passing this.options around.
        this.includePrerelease = !!options.includePrerelease;
        const m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
            throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        // these are actually numbers
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
            throw new TypeError('Invalid major version');
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
            throw new TypeError('Invalid minor version');
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
            throw new TypeError('Invalid patch version');
        }
        // numberify any prerelease numeric ids
        if (!m[4]) {
            this.prerelease = [];
        } else {
            this.prerelease = m[4].split('.').map((id)=>{
                if (/^[0-9]+$/.test(id)) {
                    const num = +id;
                    if (num >= 0 && num < MAX_SAFE_INTEGER) {
                        return num;
                    }
                }
                return id;
            });
        }
        this.build = m[5] ? m[5].split('.') : [];
        this.format();
    }
    format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
            this.version += `-${this.prerelease.join('.')}`;
        }
        return this.version;
    }
    toString() {
        return this.version;
    }
    compare(other) {
        debug('SemVer.compare', this.version, this.options, other);
        if (!(other instanceof SemVer)) {
            if (typeof other === 'string' && other === this.version) {
                return 0;
            }
            other = new SemVer(other, this.options);
        }
        if (other.version === this.version) {
            return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
    }
    compareMain(other) {
        if (!(other instanceof SemVer)) {
            other = new SemVer(other, this.options);
        }
        return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
    }
    comparePre(other) {
        if (!(other instanceof SemVer)) {
            other = new SemVer(other, this.options);
        }
        // NOT having a prerelease is > having one
        if (this.prerelease.length && !other.prerelease.length) {
            return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
            return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
            return 0;
        }
        let i = 0;
        do {
            const a = this.prerelease[i];
            const b = other.prerelease[i];
            debug('prerelease compare', i, a, b);
            if (a === undefined && b === undefined) {
                return 0;
            } else if (b === undefined) {
                return 1;
            } else if (a === undefined) {
                return -1;
            } else if (a === b) {
                continue;
            } else {
                return compareIdentifiers(a, b);
            }
        }while (++i)
    }
    compareBuild(other) {
        if (!(other instanceof SemVer)) {
            other = new SemVer(other, this.options);
        }
        let i = 0;
        do {
            const a = this.build[i];
            const b = other.build[i];
            debug('build compare', i, a, b);
            if (a === undefined && b === undefined) {
                return 0;
            } else if (b === undefined) {
                return 1;
            } else if (a === undefined) {
                return -1;
            } else if (a === b) {
                continue;
            } else {
                return compareIdentifiers(a, b);
            }
        }while (++i)
    }
    // preminor will bump the version up to the next minor release, and immediately
    // down to pre-release. premajor and prepatch work the same way.
    inc(release, identifier, identifierBase) {
        if (release.startsWith('pre')) {
            if (!identifier && identifierBase === false) {
                throw new Error('invalid increment argument: identifier is empty');
            }
            // Avoid an invalid semver results
            if (identifier) {
                const match = `-${identifier}`.match(this.options.loose ? re[t.PRERELEASELOOSE] : re[t.PRERELEASE]);
                if (!match || match[1] !== identifier) {
                    throw new Error(`invalid identifier: ${identifier}`);
                }
            }
        }
        switch(release){
            case 'premajor':
                this.prerelease.length = 0;
                this.patch = 0;
                this.minor = 0;
                this.major++;
                this.inc('pre', identifier, identifierBase);
                break;
            case 'preminor':
                this.prerelease.length = 0;
                this.patch = 0;
                this.minor++;
                this.inc('pre', identifier, identifierBase);
                break;
            case 'prepatch':
                // If this is already a prerelease, it will bump to the next version
                // drop any prereleases that might already exist, since they are not
                // relevant at this point.
                this.prerelease.length = 0;
                this.inc('patch', identifier, identifierBase);
                this.inc('pre', identifier, identifierBase);
                break;
            // If the input is a non-prerelease version, this acts the same as
            // prepatch.
            case 'prerelease':
                if (this.prerelease.length === 0) {
                    this.inc('patch', identifier, identifierBase);
                }
                this.inc('pre', identifier, identifierBase);
                break;
            case 'release':
                if (this.prerelease.length === 0) {
                    throw new Error(`version ${this.raw} is not a prerelease`);
                }
                this.prerelease.length = 0;
                break;
            case 'major':
                // If this is a pre-major version, bump up to the same major version.
                // Otherwise increment major.
                // 1.0.0-5 bumps to 1.0.0
                // 1.1.0 bumps to 2.0.0
                if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
                    this.major++;
                }
                this.minor = 0;
                this.patch = 0;
                this.prerelease = [];
                break;
            case 'minor':
                // If this is a pre-minor version, bump up to the same minor version.
                // Otherwise increment minor.
                // 1.2.0-5 bumps to 1.2.0
                // 1.2.1 bumps to 1.3.0
                if (this.patch !== 0 || this.prerelease.length === 0) {
                    this.minor++;
                }
                this.patch = 0;
                this.prerelease = [];
                break;
            case 'patch':
                // If this is not a pre-release version, it will increment the patch.
                // If it is a pre-release it will bump up to the same patch version.
                // 1.2.0-5 patches to 1.2.0
                // 1.2.0 patches to 1.2.1
                if (this.prerelease.length === 0) {
                    this.patch++;
                }
                this.prerelease = [];
                break;
            // This probably shouldn't be used publicly.
            // 1.0.0 'pre' would become 1.0.0-0 which is the wrong direction.
            case 'pre':
                {
                    const base = Number(identifierBase) ? 1 : 0;
                    if (this.prerelease.length === 0) {
                        this.prerelease = [
                            base
                        ];
                    } else {
                        let i = this.prerelease.length;
                        while(--i >= 0){
                            if (typeof this.prerelease[i] === 'number') {
                                this.prerelease[i]++;
                                i = -2;
                            }
                        }
                        if (i === -1) {
                            // didn't increment anything
                            if (identifier === this.prerelease.join('.') && identifierBase === false) {
                                throw new Error('invalid increment argument: identifier already exists');
                            }
                            this.prerelease.push(base);
                        }
                    }
                    if (identifier) {
                        // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
                        // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
                        let prerelease = [
                            identifier,
                            base
                        ];
                        if (identifierBase === false) {
                            prerelease = [
                                identifier
                            ];
                        }
                        if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                            if (isNaN(this.prerelease[1])) {
                                this.prerelease = prerelease;
                            }
                        } else {
                            this.prerelease = prerelease;
                        }
                    }
                    break;
                }
            default:
                throw new Error(`invalid increment argument: ${release}`);
        }
        this.raw = this.format();
        if (this.build.length) {
            this.raw += `+${this.build.join('.')}`;
        }
        return this;
    }
}
module.exports = SemVer;
}}),
"[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const parse = (version, options, throwErrors = false)=>{
    if (version instanceof SemVer) {
        return version;
    }
    try {
        return new SemVer(version, options);
    } catch (er) {
        if (!throwErrors) {
            return null;
        }
        throw er;
    }
};
module.exports = parse;
}}),
"[project]/node_modules/semver/functions/valid.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const parse = __turbopack_context__.r("[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)");
const valid = (version, options)=>{
    const v = parse(version, options);
    return v ? v.version : null;
};
module.exports = valid;
}}),
"[project]/node_modules/semver/functions/clean.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const parse = __turbopack_context__.r("[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)");
const clean = (version, options)=>{
    const s = parse(version.trim().replace(/^[=v]+/, ''), options);
    return s ? s.version : null;
};
module.exports = clean;
}}),
"[project]/node_modules/semver/functions/inc.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const inc = (version, release, options, identifier, identifierBase)=>{
    if (typeof options === 'string') {
        identifierBase = identifier;
        identifier = options;
        options = undefined;
    }
    try {
        return new SemVer(version instanceof SemVer ? version.version : version, options).inc(release, identifier, identifierBase).version;
    } catch (er) {
        return null;
    }
};
module.exports = inc;
}}),
"[project]/node_modules/semver/functions/diff.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const parse = __turbopack_context__.r("[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)");
const diff = (version1, version2)=>{
    const v1 = parse(version1, null, true);
    const v2 = parse(version2, null, true);
    const comparison = v1.compare(v2);
    if (comparison === 0) {
        return null;
    }
    const v1Higher = comparison > 0;
    const highVersion = v1Higher ? v1 : v2;
    const lowVersion = v1Higher ? v2 : v1;
    const highHasPre = !!highVersion.prerelease.length;
    const lowHasPre = !!lowVersion.prerelease.length;
    if (lowHasPre && !highHasPre) {
        // Going from prerelease -> no prerelease requires some special casing
        // If the low version has only a major, then it will always be a major
        // Some examples:
        // 1.0.0-1 -> 1.0.0
        // 1.0.0-1 -> 1.1.1
        // 1.0.0-1 -> 2.0.0
        if (!lowVersion.patch && !lowVersion.minor) {
            return 'major';
        }
        // If the main part has no difference
        if (lowVersion.compareMain(highVersion) === 0) {
            if (lowVersion.minor && !lowVersion.patch) {
                return 'minor';
            }
            return 'patch';
        }
    }
    // add the `pre` prefix if we are going to a prerelease version
    const prefix = highHasPre ? 'pre' : '';
    if (v1.major !== v2.major) {
        return prefix + 'major';
    }
    if (v1.minor !== v2.minor) {
        return prefix + 'minor';
    }
    if (v1.patch !== v2.patch) {
        return prefix + 'patch';
    }
    // high and low are preleases
    return 'prerelease';
};
module.exports = diff;
}}),
"[project]/node_modules/semver/functions/major.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const major = (a, loose)=>new SemVer(a, loose).major;
module.exports = major;
}}),
"[project]/node_modules/semver/functions/minor.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const minor = (a, loose)=>new SemVer(a, loose).minor;
module.exports = minor;
}}),
"[project]/node_modules/semver/functions/patch.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const patch = (a, loose)=>new SemVer(a, loose).patch;
module.exports = patch;
}}),
"[project]/node_modules/semver/functions/prerelease.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const parse = __turbopack_context__.r("[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)");
const prerelease = (version, options)=>{
    const parsed = parse(version, options);
    return parsed && parsed.prerelease.length ? parsed.prerelease : null;
};
module.exports = prerelease;
}}),
"[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const compare = (a, b, loose)=>new SemVer(a, loose).compare(new SemVer(b, loose));
module.exports = compare;
}}),
"[project]/node_modules/semver/functions/rcompare.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const rcompare = (a, b, loose)=>compare(b, a, loose);
module.exports = rcompare;
}}),
"[project]/node_modules/semver/functions/compare-loose.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const compareLoose = (a, b)=>compare(a, b, true);
module.exports = compareLoose;
}}),
"[project]/node_modules/semver/functions/compare-build.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const compareBuild = (a, b, loose)=>{
    const versionA = new SemVer(a, loose);
    const versionB = new SemVer(b, loose);
    return versionA.compare(versionB) || versionA.compareBuild(versionB);
};
module.exports = compareBuild;
}}),
"[project]/node_modules/semver/functions/sort.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compareBuild = __turbopack_context__.r("[project]/node_modules/semver/functions/compare-build.js [app-rsc] (ecmascript)");
const sort = (list, loose)=>list.sort((a, b)=>compareBuild(a, b, loose));
module.exports = sort;
}}),
"[project]/node_modules/semver/functions/rsort.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compareBuild = __turbopack_context__.r("[project]/node_modules/semver/functions/compare-build.js [app-rsc] (ecmascript)");
const rsort = (list, loose)=>list.sort((a, b)=>compareBuild(b, a, loose));
module.exports = rsort;
}}),
"[project]/node_modules/semver/functions/gt.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const gt = (a, b, loose)=>compare(a, b, loose) > 0;
module.exports = gt;
}}),
"[project]/node_modules/semver/functions/lt.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const lt = (a, b, loose)=>compare(a, b, loose) < 0;
module.exports = lt;
}}),
"[project]/node_modules/semver/functions/eq.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const eq = (a, b, loose)=>compare(a, b, loose) === 0;
module.exports = eq;
}}),
"[project]/node_modules/semver/functions/neq.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const neq = (a, b, loose)=>compare(a, b, loose) !== 0;
module.exports = neq;
}}),
"[project]/node_modules/semver/functions/gte.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const gte = (a, b, loose)=>compare(a, b, loose) >= 0;
module.exports = gte;
}}),
"[project]/node_modules/semver/functions/lte.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const lte = (a, b, loose)=>compare(a, b, loose) <= 0;
module.exports = lte;
}}),
"[project]/node_modules/semver/functions/cmp.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const eq = __turbopack_context__.r("[project]/node_modules/semver/functions/eq.js [app-rsc] (ecmascript)");
const neq = __turbopack_context__.r("[project]/node_modules/semver/functions/neq.js [app-rsc] (ecmascript)");
const gt = __turbopack_context__.r("[project]/node_modules/semver/functions/gt.js [app-rsc] (ecmascript)");
const gte = __turbopack_context__.r("[project]/node_modules/semver/functions/gte.js [app-rsc] (ecmascript)");
const lt = __turbopack_context__.r("[project]/node_modules/semver/functions/lt.js [app-rsc] (ecmascript)");
const lte = __turbopack_context__.r("[project]/node_modules/semver/functions/lte.js [app-rsc] (ecmascript)");
const cmp = (a, op, b, loose)=>{
    switch(op){
        case '===':
            if (typeof a === 'object') {
                a = a.version;
            }
            if (typeof b === 'object') {
                b = b.version;
            }
            return a === b;
        case '!==':
            if (typeof a === 'object') {
                a = a.version;
            }
            if (typeof b === 'object') {
                b = b.version;
            }
            return a !== b;
        case '':
        case '=':
        case '==':
            return eq(a, b, loose);
        case '!=':
            return neq(a, b, loose);
        case '>':
            return gt(a, b, loose);
        case '>=':
            return gte(a, b, loose);
        case '<':
            return lt(a, b, loose);
        case '<=':
            return lte(a, b, loose);
        default:
            throw new TypeError(`Invalid operator: ${op}`);
    }
};
module.exports = cmp;
}}),
"[project]/node_modules/semver/functions/coerce.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const parse = __turbopack_context__.r("[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)");
const { safeRe: re, t } = __turbopack_context__.r("[project]/node_modules/semver/internal/re.js [app-rsc] (ecmascript)");
const coerce = (version, options)=>{
    if (version instanceof SemVer) {
        return version;
    }
    if (typeof version === 'number') {
        version = String(version);
    }
    if (typeof version !== 'string') {
        return null;
    }
    options = options || {};
    let match = null;
    if (!options.rtl) {
        match = version.match(options.includePrerelease ? re[t.COERCEFULL] : re[t.COERCE]);
    } else {
        // Find the right-most coercible string that does not share
        // a terminus with a more left-ward coercible string.
        // Eg, '1.2.3.4' wants to coerce '2.3.4', not '3.4' or '4'
        // With includePrerelease option set, '1.2.3.4-rc' wants to coerce '2.3.4-rc', not '2.3.4'
        //
        // Walk through the string checking with a /g regexp
        // Manually set the index so as to pick up overlapping matches.
        // Stop when we get a match that ends at the string end, since no
        // coercible string can be more right-ward without the same terminus.
        const coerceRtlRegex = options.includePrerelease ? re[t.COERCERTLFULL] : re[t.COERCERTL];
        let next;
        while((next = coerceRtlRegex.exec(version)) && (!match || match.index + match[0].length !== version.length)){
            if (!match || next.index + next[0].length !== match.index + match[0].length) {
                match = next;
            }
            coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
        }
        // leave it in a clean state
        coerceRtlRegex.lastIndex = -1;
    }
    if (match === null) {
        return null;
    }
    const major = match[2];
    const minor = match[3] || '0';
    const patch = match[4] || '0';
    const prerelease = options.includePrerelease && match[5] ? `-${match[5]}` : '';
    const build = options.includePrerelease && match[6] ? `+${match[6]}` : '';
    return parse(`${major}.${minor}.${patch}${prerelease}${build}`, options);
};
module.exports = coerce;
}}),
"[project]/node_modules/semver/internal/lrucache.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
class LRUCache {
    constructor(){
        this.max = 1000;
        this.map = new Map();
    }
    get(key) {
        const value = this.map.get(key);
        if (value === undefined) {
            return undefined;
        } else {
            // Remove the key from the map and add it to the end
            this.map.delete(key);
            this.map.set(key, value);
            return value;
        }
    }
    delete(key) {
        return this.map.delete(key);
    }
    set(key, value) {
        const deleted = this.delete(key);
        if (!deleted && value !== undefined) {
            // If cache is full, delete the least recently used item
            if (this.map.size >= this.max) {
                const firstKey = this.map.keys().next().value;
                this.delete(firstKey);
            }
            this.map.set(key, value);
        }
        return this;
    }
}
module.exports = LRUCache;
}}),
"[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SPACE_CHARACTERS = /\s+/g;
// hoisted class for cyclic dependency
class Range {
    constructor(range, options){
        options = parseOptions(options);
        if (range instanceof Range) {
            if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
                return range;
            } else {
                return new Range(range.raw, options);
            }
        }
        if (range instanceof Comparator) {
            // just put it in the set and return
            this.raw = range.value;
            this.set = [
                [
                    range
                ]
            ];
            this.formatted = undefined;
            return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        // First reduce all whitespace as much as possible so we do not have to rely
        // on potentially slow regexes like \s*. This is then stored and used for
        // future error messages as well.
        this.raw = range.trim().replace(SPACE_CHARACTERS, ' ');
        // First, split on ||
        this.set = this.raw.split('||')// map the range to a 2d array of comparators
        .map((r)=>this.parseRange(r.trim()))// throw out any comparator lists that are empty
        // this generally means that it was not a valid range, which is allowed
        // in loose mode, but will still throw if the WHOLE range is invalid.
        .filter((c)=>c.length);
        if (!this.set.length) {
            throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        // if we have any that are not the null set, throw out null sets.
        if (this.set.length > 1) {
            // keep the first one, in case they're all null sets
            const first = this.set[0];
            this.set = this.set.filter((c)=>!isNullSet(c[0]));
            if (this.set.length === 0) {
                this.set = [
                    first
                ];
            } else if (this.set.length > 1) {
                // if we have any that are *, then the range is just *
                for (const c of this.set){
                    if (c.length === 1 && isAny(c[0])) {
                        this.set = [
                            c
                        ];
                        break;
                    }
                }
            }
        }
        this.formatted = undefined;
    }
    get range() {
        if (this.formatted === undefined) {
            this.formatted = '';
            for(let i = 0; i < this.set.length; i++){
                if (i > 0) {
                    this.formatted += '||';
                }
                const comps = this.set[i];
                for(let k = 0; k < comps.length; k++){
                    if (k > 0) {
                        this.formatted += ' ';
                    }
                    this.formatted += comps[k].toString().trim();
                }
            }
        }
        return this.formatted;
    }
    format() {
        return this.range;
    }
    toString() {
        return this.range;
    }
    parseRange(range) {
        // memoize range parsing for performance.
        // this is a very hot path, and fully deterministic.
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ':' + range;
        const cached = cache.get(memoKey);
        if (cached) {
            return cached;
        }
        const loose = this.options.loose;
        // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug('hyphen replace', range);
        // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug('comparator trim', range);
        // `~ 1.2.3` => `~1.2.3`
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        debug('tilde trim', range);
        // `^ 1.2.3` => `^1.2.3`
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        debug('caret trim', range);
        // At this point, the range is completely trimmed and
        // ready to be split into comparators.
        let rangeList = range.split(' ').map((comp)=>parseComparator(comp, this.options)).join(' ').split(/\s+/)// >=0.0.0 is equivalent to *
        .map((comp)=>replaceGTE0(comp, this.options));
        if (loose) {
            // in loose mode, throw out any that are not valid comparators
            rangeList = rangeList.filter((comp)=>{
                debug('loose invalid filter', comp, this.options);
                return !!comp.match(re[t.COMPARATORLOOSE]);
            });
        }
        debug('range list', rangeList);
        // if any comparators are the null set, then replace with JUST null set
        // if more than one comparator, remove any * comparators
        // also, don't include the same comparator more than once
        const rangeMap = new Map();
        const comparators = rangeList.map((comp)=>new Comparator(comp, this.options));
        for (const comp of comparators){
            if (isNullSet(comp)) {
                return [
                    comp
                ];
            }
            rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has('')) {
            rangeMap.delete('');
        }
        const result = [
            ...rangeMap.values()
        ];
        cache.set(memoKey, result);
        return result;
    }
    intersects(range, options) {
        if (!(range instanceof Range)) {
            throw new TypeError('a Range is required');
        }
        return this.set.some((thisComparators)=>{
            return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators)=>{
                return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator)=>{
                    return rangeComparators.every((rangeComparator)=>{
                        return thisComparator.intersects(rangeComparator, options);
                    });
                });
            });
        });
    }
    // if ANY of the sets match ALL of its comparators, then pass
    test(version) {
        if (!version) {
            return false;
        }
        if (typeof version === 'string') {
            try {
                version = new SemVer(version, this.options);
            } catch (er) {
                return false;
            }
        }
        for(let i = 0; i < this.set.length; i++){
            if (testSet(this.set[i], version, this.options)) {
                return true;
            }
        }
        return false;
    }
}
module.exports = Range;
const LRU = __turbopack_context__.r("[project]/node_modules/semver/internal/lrucache.js [app-rsc] (ecmascript)");
const cache = new LRU();
const parseOptions = __turbopack_context__.r("[project]/node_modules/semver/internal/parse-options.js [app-rsc] (ecmascript)");
const Comparator = __turbopack_context__.r("[project]/node_modules/semver/classes/comparator.js [app-rsc] (ecmascript)");
const debug = __turbopack_context__.r("[project]/node_modules/semver/internal/debug.js [app-rsc] (ecmascript)");
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const { safeRe: re, t, comparatorTrimReplace, tildeTrimReplace, caretTrimReplace } = __turbopack_context__.r("[project]/node_modules/semver/internal/re.js [app-rsc] (ecmascript)");
const { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = __turbopack_context__.r("[project]/node_modules/semver/internal/constants.js [app-rsc] (ecmascript)");
const isNullSet = (c)=>c.value === '<0.0.0-0';
const isAny = (c)=>c.value === '';
// take a set of comparators and determine whether there
// exists a version which can satisfy it
const isSatisfiable = (comparators, options)=>{
    let result = true;
    const remainingComparators = comparators.slice();
    let testComparator = remainingComparators.pop();
    while(result && remainingComparators.length){
        result = remainingComparators.every((otherComparator)=>{
            return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
    }
    return result;
};
// comprised of xranges, tildes, stars, and gtlt's at this point.
// already replaced the hyphen ranges
// turn into a set of JUST comparators.
const parseComparator = (comp, options)=>{
    debug('comp', comp, options);
    comp = replaceCarets(comp, options);
    debug('caret', comp);
    comp = replaceTildes(comp, options);
    debug('tildes', comp);
    comp = replaceXRanges(comp, options);
    debug('xrange', comp);
    comp = replaceStars(comp, options);
    debug('stars', comp);
    return comp;
};
const isX = (id)=>!id || id.toLowerCase() === 'x' || id === '*';
// ~, ~> --> * (any, kinda silly)
// ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0-0
// ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0-0
// ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0-0
// ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0-0
// ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0-0
// ~0.0.1 --> >=0.0.1 <0.1.0-0
const replaceTildes = (comp, options)=>{
    return comp.trim().split(/\s+/).map((c)=>replaceTilde(c, options)).join(' ');
};
const replaceTilde = (comp, options)=>{
    const r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
    return comp.replace(r, (_, M, m, p, pr)=>{
        debug('tilde', comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
            ret = '';
        } else if (isX(m)) {
            ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
            // ~1.2 == >=1.2.0 <1.3.0-0
            ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
            debug('replaceTilde pr', pr);
            ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
            // ~1.2.3 == >=1.2.3 <1.3.0-0
            ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug('tilde return', ret);
        return ret;
    });
};
// ^ --> * (any, kinda silly)
// ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0-0
// ^2.0, ^2.0.x --> >=2.0.0 <3.0.0-0
// ^1.2, ^1.2.x --> >=1.2.0 <2.0.0-0
// ^1.2.3 --> >=1.2.3 <2.0.0-0
// ^1.2.0 --> >=1.2.0 <2.0.0-0
// ^0.0.1 --> >=0.0.1 <0.0.2-0
// ^0.1.0 --> >=0.1.0 <0.2.0-0
const replaceCarets = (comp, options)=>{
    return comp.trim().split(/\s+/).map((c)=>replaceCaret(c, options)).join(' ');
};
const replaceCaret = (comp, options)=>{
    debug('caret', comp, options);
    const r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
    const z = options.includePrerelease ? '-0' : '';
    return comp.replace(r, (_, M, m, p, pr)=>{
        debug('caret', comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
            ret = '';
        } else if (isX(m)) {
            ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
            if (M === '0') {
                ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
            } else {
                ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
            }
        } else if (pr) {
            debug('replaceCaret pr', pr);
            if (M === '0') {
                if (m === '0') {
                    ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
                } else {
                    ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
                }
            } else {
                ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
            }
        } else {
            debug('no pr');
            if (M === '0') {
                if (m === '0') {
                    ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
                } else {
                    ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
                }
            } else {
                ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
            }
        }
        debug('caret return', ret);
        return ret;
    });
};
const replaceXRanges = (comp, options)=>{
    debug('replaceXRanges', comp, options);
    return comp.split(/\s+/).map((c)=>replaceXRange(c, options)).join(' ');
};
const replaceXRange = (comp, options)=>{
    comp = comp.trim();
    const r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
    return comp.replace(r, (ret, gtlt, M, m, p, pr)=>{
        debug('xRange', comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === '=' && anyX) {
            gtlt = '';
        }
        // if we're including prereleases in the match, then we need
        // to fix this to -0, the lowest possible prerelease value
        pr = options.includePrerelease ? '-0' : '';
        if (xM) {
            if (gtlt === '>' || gtlt === '<') {
                // nothing is allowed
                ret = '<0.0.0-0';
            } else {
                // nothing is forbidden
                ret = '*';
            }
        } else if (gtlt && anyX) {
            // we know patch is an x, because we have any x at all.
            // replace X with 0
            if (xm) {
                m = 0;
            }
            p = 0;
            if (gtlt === '>') {
                // >1 => >=2.0.0
                // >1.2 => >=1.3.0
                gtlt = '>=';
                if (xm) {
                    M = +M + 1;
                    m = 0;
                    p = 0;
                } else {
                    m = +m + 1;
                    p = 0;
                }
            } else if (gtlt === '<=') {
                // <=0.7.x is actually <0.8.0, since any 0.7.x should
                // pass.  Similarly, <=7.x is actually <8.0.0, etc.
                gtlt = '<';
                if (xm) {
                    M = +M + 1;
                } else {
                    m = +m + 1;
                }
            }
            if (gtlt === '<') {
                pr = '-0';
            }
            ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
            ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
            ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug('xRange return', ret);
        return ret;
    });
};
// Because * is AND-ed with everything else in the comparator,
// and '' means "any version", just remove the *s entirely.
const replaceStars = (comp, options)=>{
    debug('replaceStars', comp, options);
    // Looseness is ignored here.  star is always as loose as it gets!
    return comp.trim().replace(re[t.STAR], '');
};
const replaceGTE0 = (comp, options)=>{
    debug('replaceGTE0', comp, options);
    return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], '');
};
// This function is passed to string.replace(re[t.HYPHENRANGE])
// M, m, patch, prerelease, build
// 1.2 - 3.4.5 => >=1.2.0 <=3.4.5
// 1.2.3 - 3.4 => >=1.2.0 <3.5.0-0 Any 3.4.x will do
// 1.2 - 3.4 => >=1.2.0 <3.5.0-0
// TODO build?
const hyphenReplace = (incPr)=>($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr)=>{
        if (isX(fM)) {
            from = '';
        } else if (isX(fm)) {
            from = `>=${fM}.0.0${incPr ? '-0' : ''}`;
        } else if (isX(fp)) {
            from = `>=${fM}.${fm}.0${incPr ? '-0' : ''}`;
        } else if (fpr) {
            from = `>=${from}`;
        } else {
            from = `>=${from}${incPr ? '-0' : ''}`;
        }
        if (isX(tM)) {
            to = '';
        } else if (isX(tm)) {
            to = `<${+tM + 1}.0.0-0`;
        } else if (isX(tp)) {
            to = `<${tM}.${+tm + 1}.0-0`;
        } else if (tpr) {
            to = `<=${tM}.${tm}.${tp}-${tpr}`;
        } else if (incPr) {
            to = `<${tM}.${tm}.${+tp + 1}-0`;
        } else {
            to = `<=${to}`;
        }
        return `${from} ${to}`.trim();
    };
const testSet = (set, version, options)=>{
    for(let i = 0; i < set.length; i++){
        if (!set[i].test(version)) {
            return false;
        }
    }
    if (version.prerelease.length && !options.includePrerelease) {
        // Find the set of versions that are allowed to have prereleases
        // For example, ^1.2.3-pr.1 desugars to >=1.2.3-pr.1 <2.0.0
        // That should allow `1.2.3-pr.2` to pass.
        // However, `1.2.4-alpha.notready` should NOT be allowed,
        // even though it's within the range set by the comparators.
        for(let i = 0; i < set.length; i++){
            debug(set[i].semver);
            if (set[i].semver === Comparator.ANY) {
                continue;
            }
            if (set[i].semver.prerelease.length > 0) {
                const allowed = set[i].semver;
                if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
                    return true;
                }
            }
        }
        // Version has a -pre, but it's not one of the ones we like.
        return false;
    }
    return true;
};
}}),
"[project]/node_modules/semver/classes/comparator.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const ANY = Symbol('SemVer ANY');
// hoisted class for cyclic dependency
class Comparator {
    static get ANY() {
        return ANY;
    }
    constructor(comp, options){
        options = parseOptions(options);
        if (comp instanceof Comparator) {
            if (comp.loose === !!options.loose) {
                return comp;
            } else {
                comp = comp.value;
            }
        }
        comp = comp.trim().split(/\s+/).join(' ');
        debug('comparator', comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
            this.value = '';
        } else {
            this.value = this.operator + this.semver.version;
        }
        debug('comp', this);
    }
    parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
            throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== undefined ? m[1] : '';
        if (this.operator === '=') {
            this.operator = '';
        }
        // if it literally is just '>' or '' then allow anything.
        if (!m[2]) {
            this.semver = ANY;
        } else {
            this.semver = new SemVer(m[2], this.options.loose);
        }
    }
    toString() {
        return this.value;
    }
    test(version) {
        debug('Comparator.test', version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
            return true;
        }
        if (typeof version === 'string') {
            try {
                version = new SemVer(version, this.options);
            } catch (er) {
                return false;
            }
        }
        return cmp(version, this.operator, this.semver, this.options);
    }
    intersects(comp, options) {
        if (!(comp instanceof Comparator)) {
            throw new TypeError('a Comparator is required');
        }
        if (this.operator === '') {
            if (this.value === '') {
                return true;
            }
            return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === '') {
            if (comp.value === '') {
                return true;
            }
            return new Range(this.value, options).test(comp.semver);
        }
        options = parseOptions(options);
        // Special cases where nothing can possibly be lower
        if (options.includePrerelease && (this.value === '<0.0.0-0' || comp.value === '<0.0.0-0')) {
            return false;
        }
        if (!options.includePrerelease && (this.value.startsWith('<0.0.0') || comp.value.startsWith('<0.0.0'))) {
            return false;
        }
        // Same direction increasing (> or >=)
        if (this.operator.startsWith('>') && comp.operator.startsWith('>')) {
            return true;
        }
        // Same direction decreasing (< or <=)
        if (this.operator.startsWith('<') && comp.operator.startsWith('<')) {
            return true;
        }
        // same SemVer and both sides are inclusive (<= or >=)
        if (this.semver.version === comp.semver.version && this.operator.includes('=') && comp.operator.includes('=')) {
            return true;
        }
        // opposite directions less than
        if (cmp(this.semver, '<', comp.semver, options) && this.operator.startsWith('>') && comp.operator.startsWith('<')) {
            return true;
        }
        // opposite directions greater than
        if (cmp(this.semver, '>', comp.semver, options) && this.operator.startsWith('<') && comp.operator.startsWith('>')) {
            return true;
        }
        return false;
    }
}
module.exports = Comparator;
const parseOptions = __turbopack_context__.r("[project]/node_modules/semver/internal/parse-options.js [app-rsc] (ecmascript)");
const { safeRe: re, t } = __turbopack_context__.r("[project]/node_modules/semver/internal/re.js [app-rsc] (ecmascript)");
const cmp = __turbopack_context__.r("[project]/node_modules/semver/functions/cmp.js [app-rsc] (ecmascript)");
const debug = __turbopack_context__.r("[project]/node_modules/semver/internal/debug.js [app-rsc] (ecmascript)");
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
}}),
"[project]/node_modules/semver/functions/satisfies.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const satisfies = (version, range, options)=>{
    try {
        range = new Range(range, options);
    } catch (er) {
        return false;
    }
    return range.test(version);
};
module.exports = satisfies;
}}),
"[project]/node_modules/semver/ranges/to-comparators.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
// Mostly just for testing and legacy API reasons
const toComparators = (range, options)=>new Range(range, options).set.map((comp)=>comp.map((c)=>c.value).join(' ').trim().split(' '));
module.exports = toComparators;
}}),
"[project]/node_modules/semver/ranges/max-satisfying.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const maxSatisfying = (versions, range, options)=>{
    let max = null;
    let maxSV = null;
    let rangeObj = null;
    try {
        rangeObj = new Range(range, options);
    } catch (er) {
        return null;
    }
    versions.forEach((v)=>{
        if (rangeObj.test(v)) {
            // satisfies(v, range, options)
            if (!max || maxSV.compare(v) === -1) {
                // compare(max, v, true)
                max = v;
                maxSV = new SemVer(max, options);
            }
        }
    });
    return max;
};
module.exports = maxSatisfying;
}}),
"[project]/node_modules/semver/ranges/min-satisfying.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const minSatisfying = (versions, range, options)=>{
    let min = null;
    let minSV = null;
    let rangeObj = null;
    try {
        rangeObj = new Range(range, options);
    } catch (er) {
        return null;
    }
    versions.forEach((v)=>{
        if (rangeObj.test(v)) {
            // satisfies(v, range, options)
            if (!min || minSV.compare(v) === 1) {
                // compare(min, v, true)
                min = v;
                minSV = new SemVer(min, options);
            }
        }
    });
    return min;
};
module.exports = minSatisfying;
}}),
"[project]/node_modules/semver/ranges/min-version.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const gt = __turbopack_context__.r("[project]/node_modules/semver/functions/gt.js [app-rsc] (ecmascript)");
const minVersion = (range, loose)=>{
    range = new Range(range, loose);
    let minver = new SemVer('0.0.0');
    if (range.test(minver)) {
        return minver;
    }
    minver = new SemVer('0.0.0-0');
    if (range.test(minver)) {
        return minver;
    }
    minver = null;
    for(let i = 0; i < range.set.length; ++i){
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator)=>{
            // Clone to avoid manipulating the comparator's semver object.
            const compver = new SemVer(comparator.semver.version);
            switch(comparator.operator){
                case '>':
                    if (compver.prerelease.length === 0) {
                        compver.patch++;
                    } else {
                        compver.prerelease.push(0);
                    }
                    compver.raw = compver.format();
                /* fallthrough */ case '':
                case '>=':
                    if (!setMin || gt(compver, setMin)) {
                        setMin = compver;
                    }
                    break;
                case '<':
                case '<=':
                    break;
                /* istanbul ignore next */ default:
                    throw new Error(`Unexpected operation: ${comparator.operator}`);
            }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
            minver = setMin;
        }
    }
    if (minver && range.test(minver)) {
        return minver;
    }
    return null;
};
module.exports = minVersion;
}}),
"[project]/node_modules/semver/ranges/valid.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const validRange = (range, options)=>{
    try {
        // Return '*' instead of '' so that truthiness works.
        // This will throw if it's invalid anyway
        return new Range(range, options).range || '*';
    } catch (er) {
        return null;
    }
};
module.exports = validRange;
}}),
"[project]/node_modules/semver/ranges/outside.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const Comparator = __turbopack_context__.r("[project]/node_modules/semver/classes/comparator.js [app-rsc] (ecmascript)");
const { ANY } = Comparator;
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const satisfies = __turbopack_context__.r("[project]/node_modules/semver/functions/satisfies.js [app-rsc] (ecmascript)");
const gt = __turbopack_context__.r("[project]/node_modules/semver/functions/gt.js [app-rsc] (ecmascript)");
const lt = __turbopack_context__.r("[project]/node_modules/semver/functions/lt.js [app-rsc] (ecmascript)");
const lte = __turbopack_context__.r("[project]/node_modules/semver/functions/lte.js [app-rsc] (ecmascript)");
const gte = __turbopack_context__.r("[project]/node_modules/semver/functions/gte.js [app-rsc] (ecmascript)");
const outside = (version, range, hilo, options)=>{
    version = new SemVer(version, options);
    range = new Range(range, options);
    let gtfn, ltefn, ltfn, comp, ecomp;
    switch(hilo){
        case '>':
            gtfn = gt;
            ltefn = lte;
            ltfn = lt;
            comp = '>';
            ecomp = '>=';
            break;
        case '<':
            gtfn = lt;
            ltefn = gte;
            ltfn = gt;
            comp = '<';
            ecomp = '<=';
            break;
        default:
            throw new TypeError('Must provide a hilo val of "<" or ">"');
    }
    // If it satisfies the range it is not outside
    if (satisfies(version, range, options)) {
        return false;
    }
    // From now on, variable terms are as if we're in "gtr" mode.
    // but note that everything is flipped for the "ltr" function.
    for(let i = 0; i < range.set.length; ++i){
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator)=>{
            if (comparator.semver === ANY) {
                comparator = new Comparator('>=0.0.0');
            }
            high = high || comparator;
            low = low || comparator;
            if (gtfn(comparator.semver, high.semver, options)) {
                high = comparator;
            } else if (ltfn(comparator.semver, low.semver, options)) {
                low = comparator;
            }
        });
        // If the edge version comparator has a operator then our version
        // isn't outside it
        if (high.operator === comp || high.operator === ecomp) {
            return false;
        }
        // If the lowest version comparator has an operator and our version
        // is less than it then it isn't higher than the range
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
            return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
            return false;
        }
    }
    return true;
};
module.exports = outside;
}}),
"[project]/node_modules/semver/ranges/gtr.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
// Determine if version is greater than all the versions possible in the range.
const outside = __turbopack_context__.r("[project]/node_modules/semver/ranges/outside.js [app-rsc] (ecmascript)");
const gtr = (version, range, options)=>outside(version, range, '>', options);
module.exports = gtr;
}}),
"[project]/node_modules/semver/ranges/ltr.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const outside = __turbopack_context__.r("[project]/node_modules/semver/ranges/outside.js [app-rsc] (ecmascript)");
// Determine if version is less than all the versions possible in the range
const ltr = (version, range, options)=>outside(version, range, '<', options);
module.exports = ltr;
}}),
"[project]/node_modules/semver/ranges/intersects.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const intersects = (r1, r2, options)=>{
    r1 = new Range(r1, options);
    r2 = new Range(r2, options);
    return r1.intersects(r2, options);
};
module.exports = intersects;
}}),
"[project]/node_modules/semver/ranges/simplify.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
// given a set of versions and a range, create a "simplified" range
// that includes the same versions that the original range does
// If the original range is shorter than the simplified one, return that.
const satisfies = __turbopack_context__.r("[project]/node_modules/semver/functions/satisfies.js [app-rsc] (ecmascript)");
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
module.exports = (versions, range, options)=>{
    const set = [];
    let first = null;
    let prev = null;
    const v = versions.sort((a, b)=>compare(a, b, options));
    for (const version of v){
        const included = satisfies(version, range, options);
        if (included) {
            prev = version;
            if (!first) {
                first = version;
            }
        } else {
            if (prev) {
                set.push([
                    first,
                    prev
                ]);
            }
            prev = null;
            first = null;
        }
    }
    if (first) {
        set.push([
            first,
            null
        ]);
    }
    const ranges = [];
    for (const [min, max] of set){
        if (min === max) {
            ranges.push(min);
        } else if (!max && min === v[0]) {
            ranges.push('*');
        } else if (!max) {
            ranges.push(`>=${min}`);
        } else if (min === v[0]) {
            ranges.push(`<=${max}`);
        } else {
            ranges.push(`${min} - ${max}`);
        }
    }
    const simplified = ranges.join(' || ');
    const original = typeof range.raw === 'string' ? range.raw : String(range);
    return simplified.length < original.length ? simplified : range;
};
}}),
"[project]/node_modules/semver/ranges/subset.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const Comparator = __turbopack_context__.r("[project]/node_modules/semver/classes/comparator.js [app-rsc] (ecmascript)");
const { ANY } = Comparator;
const satisfies = __turbopack_context__.r("[project]/node_modules/semver/functions/satisfies.js [app-rsc] (ecmascript)");
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
// Complex range `r1 || r2 || ...` is a subset of `R1 || R2 || ...` iff:
// - Every simple range `r1, r2, ...` is a null set, OR
// - Every simple range `r1, r2, ...` which is not a null set is a subset of
//   some `R1, R2, ...`
//
// Simple range `c1 c2 ...` is a subset of simple range `C1 C2 ...` iff:
// - If c is only the ANY comparator
//   - If C is only the ANY comparator, return true
//   - Else if in prerelease mode, return false
//   - else replace c with `[>=0.0.0]`
// - If C is only the ANY comparator
//   - if in prerelease mode, return true
//   - else replace C with `[>=0.0.0]`
// - Let EQ be the set of = comparators in c
// - If EQ is more than one, return true (null set)
// - Let GT be the highest > or >= comparator in c
// - Let LT be the lowest < or <= comparator in c
// - If GT and LT, and GT.semver > LT.semver, return true (null set)
// - If any C is a = range, and GT or LT are set, return false
// - If EQ
//   - If GT, and EQ does not satisfy GT, return true (null set)
//   - If LT, and EQ does not satisfy LT, return true (null set)
//   - If EQ satisfies every C, return true
//   - Else return false
// - If GT
//   - If GT.semver is lower than any > or >= comp in C, return false
//   - If GT is >=, and GT.semver does not satisfy every C, return false
//   - If GT.semver has a prerelease, and not in prerelease mode
//     - If no C has a prerelease and the GT.semver tuple, return false
// - If LT
//   - If LT.semver is greater than any < or <= comp in C, return false
//   - If LT is <=, and LT.semver does not satisfy every C, return false
//   - If GT.semver has a prerelease, and not in prerelease mode
//     - If no C has a prerelease and the LT.semver tuple, return false
// - Else return true
const subset = (sub, dom, options = {})=>{
    if (sub === dom) {
        return true;
    }
    sub = new Range(sub, options);
    dom = new Range(dom, options);
    let sawNonNull = false;
    OUTER: for (const simpleSub of sub.set){
        for (const simpleDom of dom.set){
            const isSub = simpleSubset(simpleSub, simpleDom, options);
            sawNonNull = sawNonNull || isSub !== null;
            if (isSub) {
                continue OUTER;
            }
        }
        // the null set is a subset of everything, but null simple ranges in
        // a complex range should be ignored.  so if we saw a non-null range,
        // then we know this isn't a subset, but if EVERY simple range was null,
        // then it is a subset.
        if (sawNonNull) {
            return false;
        }
    }
    return true;
};
const minimumVersionWithPreRelease = [
    new Comparator('>=0.0.0-0')
];
const minimumVersion = [
    new Comparator('>=0.0.0')
];
const simpleSubset = (sub, dom, options)=>{
    if (sub === dom) {
        return true;
    }
    if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
            return true;
        } else if (options.includePrerelease) {
            sub = minimumVersionWithPreRelease;
        } else {
            sub = minimumVersion;
        }
    }
    if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease) {
            return true;
        } else {
            dom = minimumVersion;
        }
    }
    const eqSet = new Set();
    let gt, lt;
    for (const c of sub){
        if (c.operator === '>' || c.operator === '>=') {
            gt = higherGT(gt, c, options);
        } else if (c.operator === '<' || c.operator === '<=') {
            lt = lowerLT(lt, c, options);
        } else {
            eqSet.add(c.semver);
        }
    }
    if (eqSet.size > 1) {
        return null;
    }
    let gtltComp;
    if (gt && lt) {
        gtltComp = compare(gt.semver, lt.semver, options);
        if (gtltComp > 0) {
            return null;
        } else if (gtltComp === 0 && (gt.operator !== '>=' || lt.operator !== '<=')) {
            return null;
        }
    }
    // will iterate one or zero times
    for (const eq of eqSet){
        if (gt && !satisfies(eq, String(gt), options)) {
            return null;
        }
        if (lt && !satisfies(eq, String(lt), options)) {
            return null;
        }
        for (const c of dom){
            if (!satisfies(eq, String(c), options)) {
                return false;
            }
        }
        return true;
    }
    let higher, lower;
    let hasDomLT, hasDomGT;
    // if the subset has a prerelease, we need a comparator in the superset
    // with the same tuple and a prerelease, or it's not a subset
    let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
    let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
    // exception: <1.2.3-0 is the same as <1.2.3
    if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === '<' && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
    }
    for (const c of dom){
        hasDomGT = hasDomGT || c.operator === '>' || c.operator === '>=';
        hasDomLT = hasDomLT || c.operator === '<' || c.operator === '<=';
        if (gt) {
            if (needDomGTPre) {
                if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
                    needDomGTPre = false;
                }
            }
            if (c.operator === '>' || c.operator === '>=') {
                higher = higherGT(gt, c, options);
                if (higher === c && higher !== gt) {
                    return false;
                }
            } else if (gt.operator === '>=' && !satisfies(gt.semver, String(c), options)) {
                return false;
            }
        }
        if (lt) {
            if (needDomLTPre) {
                if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
                    needDomLTPre = false;
                }
            }
            if (c.operator === '<' || c.operator === '<=') {
                lower = lowerLT(lt, c, options);
                if (lower === c && lower !== lt) {
                    return false;
                }
            } else if (lt.operator === '<=' && !satisfies(lt.semver, String(c), options)) {
                return false;
            }
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0) {
            return false;
        }
    }
    // if there was a < or >, and nothing in the dom, then must be false
    // UNLESS it was limited by another range in the other direction.
    // Eg, >1.0.0 <1.0.1 is still a subset of <2.0.0
    if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
    }
    if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
    }
    // we needed a prerelease range in a specific tuple, but didn't get one
    // then this isn't a subset.  eg >=1.2.3-pre is not a subset of >=1.0.0,
    // because it includes prereleases in the 1.2.3 tuple
    if (needDomGTPre || needDomLTPre) {
        return false;
    }
    return true;
};
// >=1.2.3 is lower than >1.2.3
const higherGT = (a, b, options)=>{
    if (!a) {
        return b;
    }
    const comp = compare(a.semver, b.semver, options);
    return comp > 0 ? a : comp < 0 ? b : b.operator === '>' && a.operator === '>=' ? b : a;
};
// <=1.2.3 is higher than <1.2.3
const lowerLT = (a, b, options)=>{
    if (!a) {
        return b;
    }
    const comp = compare(a.semver, b.semver, options);
    return comp < 0 ? a : comp > 0 ? b : b.operator === '<' && a.operator === '<=' ? b : a;
};
module.exports = subset;
}}),
"[project]/node_modules/semver/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
// just pre-load all the stuff that index.js lazily exports
const internalRe = __turbopack_context__.r("[project]/node_modules/semver/internal/re.js [app-rsc] (ecmascript)");
const constants = __turbopack_context__.r("[project]/node_modules/semver/internal/constants.js [app-rsc] (ecmascript)");
const SemVer = __turbopack_context__.r("[project]/node_modules/semver/classes/semver.js [app-rsc] (ecmascript)");
const identifiers = __turbopack_context__.r("[project]/node_modules/semver/internal/identifiers.js [app-rsc] (ecmascript)");
const parse = __turbopack_context__.r("[project]/node_modules/semver/functions/parse.js [app-rsc] (ecmascript)");
const valid = __turbopack_context__.r("[project]/node_modules/semver/functions/valid.js [app-rsc] (ecmascript)");
const clean = __turbopack_context__.r("[project]/node_modules/semver/functions/clean.js [app-rsc] (ecmascript)");
const inc = __turbopack_context__.r("[project]/node_modules/semver/functions/inc.js [app-rsc] (ecmascript)");
const diff = __turbopack_context__.r("[project]/node_modules/semver/functions/diff.js [app-rsc] (ecmascript)");
const major = __turbopack_context__.r("[project]/node_modules/semver/functions/major.js [app-rsc] (ecmascript)");
const minor = __turbopack_context__.r("[project]/node_modules/semver/functions/minor.js [app-rsc] (ecmascript)");
const patch = __turbopack_context__.r("[project]/node_modules/semver/functions/patch.js [app-rsc] (ecmascript)");
const prerelease = __turbopack_context__.r("[project]/node_modules/semver/functions/prerelease.js [app-rsc] (ecmascript)");
const compare = __turbopack_context__.r("[project]/node_modules/semver/functions/compare.js [app-rsc] (ecmascript)");
const rcompare = __turbopack_context__.r("[project]/node_modules/semver/functions/rcompare.js [app-rsc] (ecmascript)");
const compareLoose = __turbopack_context__.r("[project]/node_modules/semver/functions/compare-loose.js [app-rsc] (ecmascript)");
const compareBuild = __turbopack_context__.r("[project]/node_modules/semver/functions/compare-build.js [app-rsc] (ecmascript)");
const sort = __turbopack_context__.r("[project]/node_modules/semver/functions/sort.js [app-rsc] (ecmascript)");
const rsort = __turbopack_context__.r("[project]/node_modules/semver/functions/rsort.js [app-rsc] (ecmascript)");
const gt = __turbopack_context__.r("[project]/node_modules/semver/functions/gt.js [app-rsc] (ecmascript)");
const lt = __turbopack_context__.r("[project]/node_modules/semver/functions/lt.js [app-rsc] (ecmascript)");
const eq = __turbopack_context__.r("[project]/node_modules/semver/functions/eq.js [app-rsc] (ecmascript)");
const neq = __turbopack_context__.r("[project]/node_modules/semver/functions/neq.js [app-rsc] (ecmascript)");
const gte = __turbopack_context__.r("[project]/node_modules/semver/functions/gte.js [app-rsc] (ecmascript)");
const lte = __turbopack_context__.r("[project]/node_modules/semver/functions/lte.js [app-rsc] (ecmascript)");
const cmp = __turbopack_context__.r("[project]/node_modules/semver/functions/cmp.js [app-rsc] (ecmascript)");
const coerce = __turbopack_context__.r("[project]/node_modules/semver/functions/coerce.js [app-rsc] (ecmascript)");
const Comparator = __turbopack_context__.r("[project]/node_modules/semver/classes/comparator.js [app-rsc] (ecmascript)");
const Range = __turbopack_context__.r("[project]/node_modules/semver/classes/range.js [app-rsc] (ecmascript)");
const satisfies = __turbopack_context__.r("[project]/node_modules/semver/functions/satisfies.js [app-rsc] (ecmascript)");
const toComparators = __turbopack_context__.r("[project]/node_modules/semver/ranges/to-comparators.js [app-rsc] (ecmascript)");
const maxSatisfying = __turbopack_context__.r("[project]/node_modules/semver/ranges/max-satisfying.js [app-rsc] (ecmascript)");
const minSatisfying = __turbopack_context__.r("[project]/node_modules/semver/ranges/min-satisfying.js [app-rsc] (ecmascript)");
const minVersion = __turbopack_context__.r("[project]/node_modules/semver/ranges/min-version.js [app-rsc] (ecmascript)");
const validRange = __turbopack_context__.r("[project]/node_modules/semver/ranges/valid.js [app-rsc] (ecmascript)");
const outside = __turbopack_context__.r("[project]/node_modules/semver/ranges/outside.js [app-rsc] (ecmascript)");
const gtr = __turbopack_context__.r("[project]/node_modules/semver/ranges/gtr.js [app-rsc] (ecmascript)");
const ltr = __turbopack_context__.r("[project]/node_modules/semver/ranges/ltr.js [app-rsc] (ecmascript)");
const intersects = __turbopack_context__.r("[project]/node_modules/semver/ranges/intersects.js [app-rsc] (ecmascript)");
const simplifyRange = __turbopack_context__.r("[project]/node_modules/semver/ranges/simplify.js [app-rsc] (ecmascript)");
const subset = __turbopack_context__.r("[project]/node_modules/semver/ranges/subset.js [app-rsc] (ecmascript)");
module.exports = {
    parse,
    valid,
    clean,
    inc,
    diff,
    major,
    minor,
    patch,
    prerelease,
    compare,
    rcompare,
    compareLoose,
    compareBuild,
    sort,
    rsort,
    gt,
    lt,
    eq,
    neq,
    gte,
    lte,
    cmp,
    coerce,
    Comparator,
    Range,
    satisfies,
    toComparators,
    maxSatisfying,
    minSatisfying,
    minVersion,
    validRange,
    outside,
    gtr,
    ltr,
    intersects,
    simplifyRange,
    subset,
    SemVer,
    re: internalRe.re,
    src: internalRe.src,
    tokens: internalRe.t,
    SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION,
    RELEASE_TYPES: constants.RELEASE_TYPES,
    compareIdentifiers: identifiers.compareIdentifiers,
    rcompareIdentifiers: identifiers.rcompareIdentifiers
};
}}),
"[project]/node_modules/shimmer/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
function isFunction(funktion) {
    return typeof funktion === 'function';
}
// Default to complaining loudly when things don't go according to plan.
var logger = console.error.bind(console);
// Sets a property on an object, preserving its enumerability.
// This function assumes that the property is already writable.
function defineProperty(obj, name, value) {
    var enumerable = !!obj[name] && obj.propertyIsEnumerable(name);
    Object.defineProperty(obj, name, {
        configurable: true,
        enumerable: enumerable,
        writable: true,
        value: value
    });
}
// Keep initialization idempotent.
function shimmer(options) {
    if (options && options.logger) {
        if (!isFunction(options.logger)) logger("new logger isn't a function, not replacing");
        else logger = options.logger;
    }
}
function wrap(nodule, name, wrapper) {
    if (!nodule || !nodule[name]) {
        logger('no original function ' + name + ' to wrap');
        return;
    }
    if (!wrapper) {
        logger('no wrapper function');
        logger(new Error().stack);
        return;
    }
    if (!isFunction(nodule[name]) || !isFunction(wrapper)) {
        logger('original object and wrapper must be functions');
        return;
    }
    var original = nodule[name];
    var wrapped = wrapper(original, name);
    defineProperty(wrapped, '__original', original);
    defineProperty(wrapped, '__unwrap', function() {
        if (nodule[name] === wrapped) defineProperty(nodule, name, original);
    });
    defineProperty(wrapped, '__wrapped', true);
    defineProperty(nodule, name, wrapped);
    return wrapped;
}
function massWrap(nodules, names, wrapper) {
    if (!nodules) {
        logger('must provide one or more modules to patch');
        logger(new Error().stack);
        return;
    } else if (!Array.isArray(nodules)) {
        nodules = [
            nodules
        ];
    }
    if (!(names && Array.isArray(names))) {
        logger('must provide one or more functions to wrap on modules');
        return;
    }
    nodules.forEach(function(nodule) {
        names.forEach(function(name) {
            wrap(nodule, name, wrapper);
        });
    });
}
function unwrap(nodule, name) {
    if (!nodule || !nodule[name]) {
        logger('no function to unwrap.');
        logger(new Error().stack);
        return;
    }
    if (!nodule[name].__unwrap) {
        logger('no original to unwrap to -- has ' + name + ' already been unwrapped?');
    } else {
        return nodule[name].__unwrap();
    }
}
function massUnwrap(nodules, names) {
    if (!nodules) {
        logger('must provide one or more modules to patch');
        logger(new Error().stack);
        return;
    } else if (!Array.isArray(nodules)) {
        nodules = [
            nodules
        ];
    }
    if (!(names && Array.isArray(names))) {
        logger('must provide one or more functions to unwrap on modules');
        return;
    }
    nodules.forEach(function(nodule) {
        names.forEach(function(name) {
            unwrap(nodule, name);
        });
    });
}
shimmer.wrap = wrap;
shimmer.massWrap = massWrap;
shimmer.unwrap = unwrap;
shimmer.massUnwrap = massUnwrap;
module.exports = shimmer;
}}),
"[project]/node_modules/@protobufjs/aspromise/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = asPromise;
/**
 * Callback as used by {@link util.asPromise}.
 * @typedef asPromiseCallback
 * @type {function}
 * @param {Error|null} error Error, if any
 * @param {...*} params Additional arguments
 * @returns {undefined}
 */ /**
 * Returns a promise from a node-style callback function.
 * @memberof util
 * @param {asPromiseCallback} fn Function to call
 * @param {*} ctx Function context
 * @param {...*} params Function arguments
 * @returns {Promise<*>} Promisified function
 */ function asPromise(fn, ctx /*, varargs */ ) {
    var params = new Array(arguments.length - 1), offset = 0, index = 2, pending = true;
    while(index < arguments.length)params[offset++] = arguments[index++];
    return new Promise(function executor(resolve, reject) {
        params[offset] = function callback(err /*, varargs */ ) {
            if (pending) {
                pending = false;
                if (err) reject(err);
                else {
                    var params = new Array(arguments.length - 1), offset = 0;
                    while(offset < params.length)params[offset++] = arguments[offset];
                    resolve.apply(null, params);
                }
            }
        };
        try {
            fn.apply(ctx || null, params);
        } catch (err) {
            if (pending) {
                pending = false;
                reject(err);
            }
        }
    });
}
}}),
"[project]/node_modules/@protobufjs/base64/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/**
 * A minimal base64 implementation for number arrays.
 * @memberof util
 * @namespace
 */ var base64 = exports;
/**
 * Calculates the byte length of a base64 encoded string.
 * @param {string} string Base64 encoded string
 * @returns {number} Byte length
 */ base64.length = function length(string) {
    var p = string.length;
    if (!p) return 0;
    var n = 0;
    while(--p % 4 > 1 && string.charAt(p) === "=")++n;
    return Math.ceil(string.length * 3) / 4 - n;
};
// Base64 encoding table
var b64 = new Array(64);
// Base64 decoding table
var s64 = new Array(123);
// 65..90, 97..122, 48..57, 43, 47
for(var i = 0; i < 64;)s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;
/**
 * Encodes a buffer to a base64 encoded string.
 * @param {Uint8Array} buffer Source buffer
 * @param {number} start Source start
 * @param {number} end Source end
 * @returns {string} Base64 encoded string
 */ base64.encode = function encode(buffer, start, end) {
    var parts = null, chunk = [];
    var i = 0, j = 0, t; // temporary
    while(start < end){
        var b = buffer[start++];
        switch(j){
            case 0:
                chunk[i++] = b64[b >> 2];
                t = (b & 3) << 4;
                j = 1;
                break;
            case 1:
                chunk[i++] = b64[t | b >> 4];
                t = (b & 15) << 2;
                j = 2;
                break;
            case 2:
                chunk[i++] = b64[t | b >> 6];
                chunk[i++] = b64[b & 63];
                j = 0;
                break;
        }
        if (i > 8191) {
            (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
            i = 0;
        }
    }
    if (j) {
        chunk[i++] = b64[t];
        chunk[i++] = 61;
        if (j === 1) chunk[i++] = 61;
    }
    if (parts) {
        if (i) parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
        return parts.join("");
    }
    return String.fromCharCode.apply(String, chunk.slice(0, i));
};
var invalidEncoding = "invalid encoding";
/**
 * Decodes a base64 encoded string to a buffer.
 * @param {string} string Source string
 * @param {Uint8Array} buffer Destination buffer
 * @param {number} offset Destination offset
 * @returns {number} Number of bytes written
 * @throws {Error} If encoding is invalid
 */ base64.decode = function decode(string, buffer, offset) {
    var start = offset;
    var j = 0, t; // temporary
    for(var i = 0; i < string.length;){
        var c = string.charCodeAt(i++);
        if (c === 61 && j > 1) break;
        if ((c = s64[c]) === undefined) throw Error(invalidEncoding);
        switch(j){
            case 0:
                t = c;
                j = 1;
                break;
            case 1:
                buffer[offset++] = t << 2 | (c & 48) >> 4;
                t = c;
                j = 2;
                break;
            case 2:
                buffer[offset++] = (t & 15) << 4 | (c & 60) >> 2;
                t = c;
                j = 3;
                break;
            case 3:
                buffer[offset++] = (t & 3) << 6 | c;
                j = 0;
                break;
        }
    }
    if (j === 1) throw Error(invalidEncoding);
    return offset - start;
};
/**
 * Tests if the specified string appears to be base64 encoded.
 * @param {string} string String to test
 * @returns {boolean} `true` if probably base64 encoded, otherwise false
 */ base64.test = function test(string) {
    return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
};
}}),
"[project]/node_modules/@protobufjs/eventemitter/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = EventEmitter;
/**
 * Constructs a new event emitter instance.
 * @classdesc A minimal event emitter.
 * @memberof util
 * @constructor
 */ function EventEmitter() {
    /**
     * Registered listeners.
     * @type {Object.<string,*>}
     * @private
     */ this._listeners = {};
}
/**
 * Registers an event listener.
 * @param {string} evt Event name
 * @param {function} fn Listener
 * @param {*} [ctx] Listener context
 * @returns {util.EventEmitter} `this`
 */ EventEmitter.prototype.on = function on(evt, fn, ctx) {
    (this._listeners[evt] || (this._listeners[evt] = [])).push({
        fn: fn,
        ctx: ctx || this
    });
    return this;
};
/**
 * Removes an event listener or any matching listeners if arguments are omitted.
 * @param {string} [evt] Event name. Removes all listeners if omitted.
 * @param {function} [fn] Listener to remove. Removes all listeners of `evt` if omitted.
 * @returns {util.EventEmitter} `this`
 */ EventEmitter.prototype.off = function off(evt, fn) {
    if (evt === undefined) this._listeners = {};
    else {
        if (fn === undefined) this._listeners[evt] = [];
        else {
            var listeners = this._listeners[evt];
            for(var i = 0; i < listeners.length;)if (listeners[i].fn === fn) listeners.splice(i, 1);
            else ++i;
        }
    }
    return this;
};
/**
 * Emits an event by calling its listeners with the specified arguments.
 * @param {string} evt Event name
 * @param {...*} args Arguments
 * @returns {util.EventEmitter} `this`
 */ EventEmitter.prototype.emit = function emit(evt) {
    var listeners = this._listeners[evt];
    if (listeners) {
        var args = [], i = 1;
        for(; i < arguments.length;)args.push(arguments[i++]);
        for(i = 0; i < listeners.length;)listeners[i].fn.apply(listeners[i++].ctx, args);
    }
    return this;
};
}}),
"[project]/node_modules/@protobufjs/float/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = factory(factory);
/**
 * Reads / writes floats / doubles from / to buffers.
 * @name util.float
 * @namespace
 */ /**
 * Writes a 32 bit float to a buffer using little endian byte order.
 * @name util.float.writeFloatLE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */ /**
 * Writes a 32 bit float to a buffer using big endian byte order.
 * @name util.float.writeFloatBE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */ /**
 * Reads a 32 bit float from a buffer using little endian byte order.
 * @name util.float.readFloatLE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */ /**
 * Reads a 32 bit float from a buffer using big endian byte order.
 * @name util.float.readFloatBE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */ /**
 * Writes a 64 bit double to a buffer using little endian byte order.
 * @name util.float.writeDoubleLE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */ /**
 * Writes a 64 bit double to a buffer using big endian byte order.
 * @name util.float.writeDoubleBE
 * @function
 * @param {number} val Value to write
 * @param {Uint8Array} buf Target buffer
 * @param {number} pos Target buffer offset
 * @returns {undefined}
 */ /**
 * Reads a 64 bit double from a buffer using little endian byte order.
 * @name util.float.readDoubleLE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */ /**
 * Reads a 64 bit double from a buffer using big endian byte order.
 * @name util.float.readDoubleBE
 * @function
 * @param {Uint8Array} buf Source buffer
 * @param {number} pos Source buffer offset
 * @returns {number} Value read
 */ // Factory function for the purpose of node-based testing in modified global environments
function factory(exports) {
    // float: typed array
    if (typeof Float32Array !== "undefined") (function() {
        var f32 = new Float32Array([
            -0
        ]), f8b = new Uint8Array(f32.buffer), le = f8b[3] === 128;
        function writeFloat_f32_cpy(val, buf, pos) {
            f32[0] = val;
            buf[pos] = f8b[0];
            buf[pos + 1] = f8b[1];
            buf[pos + 2] = f8b[2];
            buf[pos + 3] = f8b[3];
        }
        function writeFloat_f32_rev(val, buf, pos) {
            f32[0] = val;
            buf[pos] = f8b[3];
            buf[pos + 1] = f8b[2];
            buf[pos + 2] = f8b[1];
            buf[pos + 3] = f8b[0];
        }
        /* istanbul ignore next */ exports.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
        /* istanbul ignore next */ exports.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;
        function readFloat_f32_cpy(buf, pos) {
            f8b[0] = buf[pos];
            f8b[1] = buf[pos + 1];
            f8b[2] = buf[pos + 2];
            f8b[3] = buf[pos + 3];
            return f32[0];
        }
        function readFloat_f32_rev(buf, pos) {
            f8b[3] = buf[pos];
            f8b[2] = buf[pos + 1];
            f8b[1] = buf[pos + 2];
            f8b[0] = buf[pos + 3];
            return f32[0];
        }
        /* istanbul ignore next */ exports.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
        /* istanbul ignore next */ exports.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;
    // float: ieee754
    })();
    else (function() {
        function writeFloat_ieee754(writeUint, val, buf, pos) {
            var sign = val < 0 ? 1 : 0;
            if (sign) val = -val;
            if (val === 0) writeUint(1 / val > 0 ? /* positive */ 0 : /* negative 0 */ 2147483648, buf, pos);
            else if (isNaN(val)) writeUint(2143289344, buf, pos);
            else if (val > 3.4028234663852886e+38) writeUint((sign << 31 | 2139095040) >>> 0, buf, pos);
            else if (val < 1.1754943508222875e-38) writeUint((sign << 31 | Math.round(val / 1.401298464324817e-45)) >>> 0, buf, pos);
            else {
                var exponent = Math.floor(Math.log(val) / Math.LN2), mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
                writeUint((sign << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
            }
        }
        exports.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
        exports.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);
        function readFloat_ieee754(readUint, buf, pos) {
            var uint = readUint(buf, pos), sign = (uint >> 31) * 2 + 1, exponent = uint >>> 23 & 255, mantissa = uint & 8388607;
            return exponent === 255 ? mantissa ? NaN : sign * Infinity : exponent === 0 // denormal
             ? sign * 1.401298464324817e-45 * mantissa : sign * Math.pow(2, exponent - 150) * (mantissa + 8388608);
        }
        exports.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
        exports.readFloatBE = readFloat_ieee754.bind(null, readUintBE);
    })();
    // double: typed array
    if (typeof Float64Array !== "undefined") (function() {
        var f64 = new Float64Array([
            -0
        ]), f8b = new Uint8Array(f64.buffer), le = f8b[7] === 128;
        function writeDouble_f64_cpy(val, buf, pos) {
            f64[0] = val;
            buf[pos] = f8b[0];
            buf[pos + 1] = f8b[1];
            buf[pos + 2] = f8b[2];
            buf[pos + 3] = f8b[3];
            buf[pos + 4] = f8b[4];
            buf[pos + 5] = f8b[5];
            buf[pos + 6] = f8b[6];
            buf[pos + 7] = f8b[7];
        }
        function writeDouble_f64_rev(val, buf, pos) {
            f64[0] = val;
            buf[pos] = f8b[7];
            buf[pos + 1] = f8b[6];
            buf[pos + 2] = f8b[5];
            buf[pos + 3] = f8b[4];
            buf[pos + 4] = f8b[3];
            buf[pos + 5] = f8b[2];
            buf[pos + 6] = f8b[1];
            buf[pos + 7] = f8b[0];
        }
        /* istanbul ignore next */ exports.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
        /* istanbul ignore next */ exports.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;
        function readDouble_f64_cpy(buf, pos) {
            f8b[0] = buf[pos];
            f8b[1] = buf[pos + 1];
            f8b[2] = buf[pos + 2];
            f8b[3] = buf[pos + 3];
            f8b[4] = buf[pos + 4];
            f8b[5] = buf[pos + 5];
            f8b[6] = buf[pos + 6];
            f8b[7] = buf[pos + 7];
            return f64[0];
        }
        function readDouble_f64_rev(buf, pos) {
            f8b[7] = buf[pos];
            f8b[6] = buf[pos + 1];
            f8b[5] = buf[pos + 2];
            f8b[4] = buf[pos + 3];
            f8b[3] = buf[pos + 4];
            f8b[2] = buf[pos + 5];
            f8b[1] = buf[pos + 6];
            f8b[0] = buf[pos + 7];
            return f64[0];
        }
        /* istanbul ignore next */ exports.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
        /* istanbul ignore next */ exports.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;
    // double: ieee754
    })();
    else (function() {
        function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
            var sign = val < 0 ? 1 : 0;
            if (sign) val = -val;
            if (val === 0) {
                writeUint(0, buf, pos + off0);
                writeUint(1 / val > 0 ? /* positive */ 0 : /* negative 0 */ 2147483648, buf, pos + off1);
            } else if (isNaN(val)) {
                writeUint(0, buf, pos + off0);
                writeUint(2146959360, buf, pos + off1);
            } else if (val > 1.7976931348623157e+308) {
                writeUint(0, buf, pos + off0);
                writeUint((sign << 31 | 2146435072) >>> 0, buf, pos + off1);
            } else {
                var mantissa;
                if (val < 2.2250738585072014e-308) {
                    mantissa = val / 5e-324;
                    writeUint(mantissa >>> 0, buf, pos + off0);
                    writeUint((sign << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
                } else {
                    var exponent = Math.floor(Math.log(val) / Math.LN2);
                    if (exponent === 1024) exponent = 1023;
                    mantissa = val * Math.pow(2, -exponent);
                    writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
                    writeUint((sign << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
                }
            }
        }
        exports.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
        exports.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);
        function readDouble_ieee754(readUint, off0, off1, buf, pos) {
            var lo = readUint(buf, pos + off0), hi = readUint(buf, pos + off1);
            var sign = (hi >> 31) * 2 + 1, exponent = hi >>> 20 & 2047, mantissa = 4294967296 * (hi & 1048575) + lo;
            return exponent === 2047 ? mantissa ? NaN : sign * Infinity : exponent === 0 // denormal
             ? sign * 5e-324 * mantissa : sign * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
        }
        exports.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
        exports.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);
    })();
    return exports;
}
// uint helpers
function writeUintLE(val, buf, pos) {
    buf[pos] = val & 255;
    buf[pos + 1] = val >>> 8 & 255;
    buf[pos + 2] = val >>> 16 & 255;
    buf[pos + 3] = val >>> 24;
}
function writeUintBE(val, buf, pos) {
    buf[pos] = val >>> 24;
    buf[pos + 1] = val >>> 16 & 255;
    buf[pos + 2] = val >>> 8 & 255;
    buf[pos + 3] = val & 255;
}
function readUintLE(buf, pos) {
    return (buf[pos] | buf[pos + 1] << 8 | buf[pos + 2] << 16 | buf[pos + 3] << 24) >>> 0;
}
function readUintBE(buf, pos) {
    return (buf[pos] << 24 | buf[pos + 1] << 16 | buf[pos + 2] << 8 | buf[pos + 3]) >>> 0;
}
}}),
"[project]/node_modules/@protobufjs/inquire/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = inquire;
/**
 * Requires a module only if available.
 * @memberof util
 * @param {string} moduleName Module to require
 * @returns {?Object} Required module if available and not empty, otherwise `null`
 */ function inquire(moduleName) {
    try {
        var mod = eval("quire".replace(/^/, "re"))(moduleName); // eslint-disable-line no-eval
        if (mod && (mod.length || Object.keys(mod).length)) return mod;
    } catch (e) {} // eslint-disable-line no-empty
    return null;
}
}}),
"[project]/node_modules/@protobufjs/utf8/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/**
 * A minimal UTF8 implementation for number arrays.
 * @memberof util
 * @namespace
 */ var utf8 = exports;
/**
 * Calculates the UTF8 byte length of a string.
 * @param {string} string String
 * @returns {number} Byte length
 */ utf8.length = function utf8_length(string) {
    var len = 0, c = 0;
    for(var i = 0; i < string.length; ++i){
        c = string.charCodeAt(i);
        if (c < 128) len += 1;
        else if (c < 2048) len += 2;
        else if ((c & 0xFC00) === 0xD800 && (string.charCodeAt(i + 1) & 0xFC00) === 0xDC00) {
            ++i;
            len += 4;
        } else len += 3;
    }
    return len;
};
/**
 * Reads UTF8 bytes as a string.
 * @param {Uint8Array} buffer Source buffer
 * @param {number} start Source start
 * @param {number} end Source end
 * @returns {string} String read
 */ utf8.read = function utf8_read(buffer, start, end) {
    var len = end - start;
    if (len < 1) return "";
    var parts = null, chunk = [], i = 0, t; // temporary
    while(start < end){
        t = buffer[start++];
        if (t < 128) chunk[i++] = t;
        else if (t > 191 && t < 224) chunk[i++] = (t & 31) << 6 | buffer[start++] & 63;
        else if (t > 239 && t < 365) {
            t = ((t & 7) << 18 | (buffer[start++] & 63) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63) - 0x10000;
            chunk[i++] = 0xD800 + (t >> 10);
            chunk[i++] = 0xDC00 + (t & 1023);
        } else chunk[i++] = (t & 15) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63;
        if (i > 8191) {
            (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
            i = 0;
        }
    }
    if (parts) {
        if (i) parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
        return parts.join("");
    }
    return String.fromCharCode.apply(String, chunk.slice(0, i));
};
/**
 * Writes a string as UTF8 bytes.
 * @param {string} string Source string
 * @param {Uint8Array} buffer Destination buffer
 * @param {number} offset Destination offset
 * @returns {number} Bytes written
 */ utf8.write = function utf8_write(string, buffer, offset) {
    var start = offset, c1, c2; // character 2
    for(var i = 0; i < string.length; ++i){
        c1 = string.charCodeAt(i);
        if (c1 < 128) {
            buffer[offset++] = c1;
        } else if (c1 < 2048) {
            buffer[offset++] = c1 >> 6 | 192;
            buffer[offset++] = c1 & 63 | 128;
        } else if ((c1 & 0xFC00) === 0xD800 && ((c2 = string.charCodeAt(i + 1)) & 0xFC00) === 0xDC00) {
            c1 = 0x10000 + ((c1 & 0x03FF) << 10) + (c2 & 0x03FF);
            ++i;
            buffer[offset++] = c1 >> 18 | 240;
            buffer[offset++] = c1 >> 12 & 63 | 128;
            buffer[offset++] = c1 >> 6 & 63 | 128;
            buffer[offset++] = c1 & 63 | 128;
        } else {
            buffer[offset++] = c1 >> 12 | 224;
            buffer[offset++] = c1 >> 6 & 63 | 128;
            buffer[offset++] = c1 & 63 | 128;
        }
    }
    return offset - start;
};
}}),
"[project]/node_modules/@protobufjs/pool/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = pool;
/**
 * An allocator as used by {@link util.pool}.
 * @typedef PoolAllocator
 * @type {function}
 * @param {number} size Buffer size
 * @returns {Uint8Array} Buffer
 */ /**
 * A slicer as used by {@link util.pool}.
 * @typedef PoolSlicer
 * @type {function}
 * @param {number} start Start offset
 * @param {number} end End offset
 * @returns {Uint8Array} Buffer slice
 * @this {Uint8Array}
 */ /**
 * A general purpose buffer pool.
 * @memberof util
 * @function
 * @param {PoolAllocator} alloc Allocator
 * @param {PoolSlicer} slice Slicer
 * @param {number} [size=8192] Slab size
 * @returns {PoolAllocator} Pooled allocator
 */ function pool(alloc, slice, size) {
    var SIZE = size || 8192;
    var MAX = SIZE >>> 1;
    var slab = null;
    var offset = SIZE;
    return function pool_alloc(size) {
        if (size < 1 || size > MAX) return alloc(size);
        if (offset + size > SIZE) {
            slab = alloc(SIZE);
            offset = 0;
        }
        var buf = slice.call(slab, offset, offset += size);
        if (offset & 7) offset = (offset | 7) + 1;
        return buf;
    };
}
}}),
"[project]/node_modules/@protobufjs/codegen/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = codegen;
/**
 * Begins generating a function.
 * @memberof util
 * @param {string[]} functionParams Function parameter names
 * @param {string} [functionName] Function name if not anonymous
 * @returns {Codegen} Appender that appends code to the function's body
 */ function codegen(functionParams, functionName) {
    /* istanbul ignore if */ if (typeof functionParams === "string") {
        functionName = functionParams;
        functionParams = undefined;
    }
    var body = [];
    /**
     * Appends code to the function's body or finishes generation.
     * @typedef Codegen
     * @type {function}
     * @param {string|Object.<string,*>} [formatStringOrScope] Format string or, to finish the function, an object of additional scope variables, if any
     * @param {...*} [formatParams] Format parameters
     * @returns {Codegen|Function} Itself or the generated function if finished
     * @throws {Error} If format parameter counts do not match
     */ function Codegen(formatStringOrScope) {
        // note that explicit array handling below makes this ~50% faster
        // finish the function
        if (typeof formatStringOrScope !== "string") {
            var source = toString();
            if (codegen.verbose) console.log("codegen: " + source); // eslint-disable-line no-console
            source = "return " + source;
            if (formatStringOrScope) {
                var scopeKeys = Object.keys(formatStringOrScope), scopeParams = new Array(scopeKeys.length + 1), scopeValues = new Array(scopeKeys.length), scopeOffset = 0;
                while(scopeOffset < scopeKeys.length){
                    scopeParams[scopeOffset] = scopeKeys[scopeOffset];
                    scopeValues[scopeOffset] = formatStringOrScope[scopeKeys[scopeOffset++]];
                }
                scopeParams[scopeOffset] = source;
                return Function.apply(null, scopeParams).apply(null, scopeValues); // eslint-disable-line no-new-func
            }
            return Function(source)(); // eslint-disable-line no-new-func
        }
        // otherwise append to body
        var formatParams = new Array(arguments.length - 1), formatOffset = 0;
        while(formatOffset < formatParams.length)formatParams[formatOffset] = arguments[++formatOffset];
        formatOffset = 0;
        formatStringOrScope = formatStringOrScope.replace(/%([%dfijs])/g, function replace($0, $1) {
            var value = formatParams[formatOffset++];
            switch($1){
                case "d":
                case "f":
                    return String(Number(value));
                case "i":
                    return String(Math.floor(value));
                case "j":
                    return JSON.stringify(value);
                case "s":
                    return String(value);
            }
            return "%";
        });
        if (formatOffset !== formatParams.length) throw Error("parameter count mismatch");
        body.push(formatStringOrScope);
        return Codegen;
    }
    function toString(functionNameOverride) {
        return "function " + (functionNameOverride || functionName || "") + "(" + (functionParams && functionParams.join(",") || "") + "){\n  " + body.join("\n  ") + "\n}";
    }
    Codegen.toString = toString;
    return Codegen;
}
/**
 * Begins generating a function.
 * @memberof util
 * @function codegen
 * @param {string} [functionName] Function name if not anonymous
 * @returns {Codegen} Appender that appends code to the function's body
 * @variation 2
 */ /**
 * When set to `true`, codegen will log generated code to console. Useful for debugging.
 * @name util.codegen.verbose
 * @type {boolean}
 */ codegen.verbose = false;
}}),
"[project]/node_modules/@protobufjs/fetch/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
module.exports = fetch;
var asPromise = __turbopack_context__.r("[project]/node_modules/@protobufjs/aspromise/index.js [app-rsc] (ecmascript)"), inquire = __turbopack_context__.r("[project]/node_modules/@protobufjs/inquire/index.js [app-rsc] (ecmascript)");
var fs = inquire("fs");
/**
 * Node-style callback as used by {@link util.fetch}.
 * @typedef FetchCallback
 * @type {function}
 * @param {?Error} error Error, if any, otherwise `null`
 * @param {string} [contents] File contents, if there hasn't been an error
 * @returns {undefined}
 */ /**
 * Options as used by {@link util.fetch}.
 * @typedef FetchOptions
 * @type {Object}
 * @property {boolean} [binary=false] Whether expecting a binary response
 * @property {boolean} [xhr=false] If `true`, forces the use of XMLHttpRequest
 */ /**
 * Fetches the contents of a file.
 * @memberof util
 * @param {string} filename File path or url
 * @param {FetchOptions} options Fetch options
 * @param {FetchCallback} callback Callback function
 * @returns {undefined}
 */ function fetch(filename, options, callback) {
    if (typeof options === "function") {
        callback = options;
        options = {};
    } else if (!options) options = {};
    if (!callback) return asPromise(fetch, this, filename, options); // eslint-disable-line no-invalid-this
    // if a node-like filesystem is present, try it first but fall back to XHR if nothing is found.
    if (!options.xhr && fs && fs.readFile) return fs.readFile(filename, function fetchReadFileCallback(err, contents) {
        return err && typeof XMLHttpRequest !== "undefined" ? fetch.xhr(filename, options, callback) : err ? callback(err) : callback(null, options.binary ? contents : contents.toString("utf8"));
    });
    // use the XHR version otherwise.
    return fetch.xhr(filename, options, callback);
}
/**
 * Fetches the contents of a file.
 * @name util.fetch
 * @function
 * @param {string} path File path or url
 * @param {FetchCallback} callback Callback function
 * @returns {undefined}
 * @variation 2
 */ /**
 * Fetches the contents of a file.
 * @name util.fetch
 * @function
 * @param {string} path File path or url
 * @param {FetchOptions} [options] Fetch options
 * @returns {Promise<string|Uint8Array>} Promise
 * @variation 3
 */ /**/ fetch.xhr = function fetch_xhr(filename, options, callback) {
    var xhr = new XMLHttpRequest();
    xhr.onreadystatechange = function fetchOnReadyStateChange() {
        if (xhr.readyState !== 4) return undefined;
        // local cors security errors return status 0 / empty string, too. afaik this cannot be
        // reliably distinguished from an actually empty file for security reasons. feel free
        // to send a pull request if you are aware of a solution.
        if (xhr.status !== 0 && xhr.status !== 200) return callback(Error("status " + xhr.status));
        // if binary data is expected, make sure that some sort of array is returned, even if
        // ArrayBuffers are not supported. the binary string fallback, however, is unsafe.
        if (options.binary) {
            var buffer = xhr.response;
            if (!buffer) {
                buffer = [];
                for(var i = 0; i < xhr.responseText.length; ++i)buffer.push(xhr.responseText.charCodeAt(i) & 255);
            }
            return callback(null, typeof Uint8Array !== "undefined" ? new Uint8Array(buffer) : buffer);
        }
        return callback(null, xhr.responseText);
    };
    if (options.binary) {
        // ref: https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/Sending_and_Receiving_Binary_Data#Receiving_binary_data_in_older_browsers
        if ("overrideMimeType" in xhr) xhr.overrideMimeType("text/plain; charset=x-user-defined");
        xhr.responseType = "arraybuffer";
    }
    xhr.open("GET", filename);
    xhr.send();
};
}}),
"[project]/node_modules/@protobufjs/path/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/**
 * A minimal path module to resolve Unix, Windows and URL paths alike.
 * @memberof util
 * @namespace
 */ var path = exports;
var isAbsolute = /**
 * Tests if the specified path is absolute.
 * @param {string} path Path to test
 * @returns {boolean} `true` if path is absolute
 */ path.isAbsolute = function isAbsolute(path) {
    return /^(?:\/|\w+:)/.test(path);
};
var normalize = /**
 * Normalizes the specified path.
 * @param {string} path Path to normalize
 * @returns {string} Normalized path
 */ path.normalize = function normalize(path) {
    path = path.replace(/\\/g, "/").replace(/\/{2,}/g, "/");
    var parts = path.split("/"), absolute = isAbsolute(path), prefix = "";
    if (absolute) prefix = parts.shift() + "/";
    for(var i = 0; i < parts.length;){
        if (parts[i] === "..") {
            if (i > 0 && parts[i - 1] !== "..") parts.splice(--i, 2);
            else if (absolute) parts.splice(i, 1);
            else ++i;
        } else if (parts[i] === ".") parts.splice(i, 1);
        else ++i;
    }
    return prefix + parts.join("/");
};
/**
 * Resolves the specified include path against the specified origin path.
 * @param {string} originPath Path to the origin file
 * @param {string} includePath Include path relative to origin path
 * @param {boolean} [alreadyNormalized=false] `true` if both paths are already known to be normalized
 * @returns {string} Path to the include file
 */ path.resolve = function resolve(originPath, includePath, alreadyNormalized) {
    if (!alreadyNormalized) includePath = normalize(includePath);
    if (isAbsolute(includePath)) return includePath;
    if (!alreadyNormalized) originPath = normalize(originPath);
    return (originPath = originPath.replace(/(?:\/|^)[^/]+$/, "")).length ? normalize(originPath + "/" + includePath) : includePath;
};
}}),
"[project]/node_modules/@js-sdsl/ordered-map/dist/esm/index.js [app-rsc] (ecmascript)": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "OrderedMap": (()=>OrderedMap)
});
var extendStatics = function(e, r) {
    extendStatics = Object.setPrototypeOf || ({
        __proto__: []
    }) instanceof Array && function(e, r) {
        e.__proto__ = r;
    } || function(e, r) {
        for(var t in r)if (Object.prototype.hasOwnProperty.call(r, t)) e[t] = r[t];
    };
    return extendStatics(e, r);
};
function __extends(e, r) {
    if (typeof r !== "function" && r !== null) throw new TypeError("Class extends value " + String(r) + " is not a constructor or null");
    extendStatics(e, r);
    function __() {
        this.constructor = e;
    }
    e.prototype = r === null ? Object.create(r) : (__.prototype = r.prototype, new __);
}
function __generator(e, r) {
    var t = {
        label: 0,
        sent: function() {
            if (s[0] & 1) throw s[1];
            return s[1];
        },
        trys: [],
        ops: []
    }, i, n, s, h;
    return h = {
        next: verb(0),
        throw: verb(1),
        return: verb(2)
    }, typeof Symbol === "function" && (h[Symbol.iterator] = function() {
        return this;
    }), h;
    "TURBOPACK unreachable";
    function verb(e) {
        return function(r) {
            return step([
                e,
                r
            ]);
        };
    }
    function step(a) {
        if (i) throw new TypeError("Generator is already executing.");
        while(h && (h = 0, a[0] && (t = 0)), t)try {
            if (i = 1, n && (s = a[0] & 2 ? n["return"] : a[0] ? n["throw"] || ((s = n["return"]) && s.call(n), 0) : n.next) && !(s = s.call(n, a[1])).done) return s;
            if (n = 0, s) a = [
                a[0] & 2,
                s.value
            ];
            switch(a[0]){
                case 0:
                case 1:
                    s = a;
                    break;
                case 4:
                    t.label++;
                    return {
                        value: a[1],
                        done: false
                    };
                case 5:
                    t.label++;
                    n = a[1];
                    a = [
                        0
                    ];
                    continue;
                case 7:
                    a = t.ops.pop();
                    t.trys.pop();
                    continue;
                default:
                    if (!(s = t.trys, s = s.length > 0 && s[s.length - 1]) && (a[0] === 6 || a[0] === 2)) {
                        t = 0;
                        continue;
                    }
                    if (a[0] === 3 && (!s || a[1] > s[0] && a[1] < s[3])) {
                        t.label = a[1];
                        break;
                    }
                    if (a[0] === 6 && t.label < s[1]) {
                        t.label = s[1];
                        s = a;
                        break;
                    }
                    if (s && t.label < s[2]) {
                        t.label = s[2];
                        t.ops.push(a);
                        break;
                    }
                    if (s[2]) t.ops.pop();
                    t.trys.pop();
                    continue;
            }
            a = r.call(e, t);
        } catch (e) {
            a = [
                6,
                e
            ];
            n = 0;
        } finally{
            i = s = 0;
        }
        if (a[0] & 5) throw a[1];
        return {
            value: a[0] ? a[1] : void 0,
            done: true
        };
    }
}
typeof SuppressedError === "function" ? SuppressedError : function(e, r, t) {
    var i = new Error(t);
    return i.name = "SuppressedError", i.error = e, i.suppressed = r, i;
};
var TreeNode = function() {
    function TreeNode(e, r, t) {
        if (t === void 0) {
            t = 1;
        }
        this.t = undefined;
        this.i = undefined;
        this.h = undefined;
        this.u = e;
        this.o = r;
        this.l = t;
    }
    TreeNode.prototype.v = function() {
        var e = this;
        var r = e.h.h === e;
        if (r && e.l === 1) {
            e = e.i;
        } else if (e.t) {
            e = e.t;
            while(e.i){
                e = e.i;
            }
        } else {
            if (r) {
                return e.h;
            }
            var t = e.h;
            while(t.t === e){
                e = t;
                t = e.h;
            }
            e = t;
        }
        return e;
    };
    TreeNode.prototype.p = function() {
        var e = this;
        if (e.i) {
            e = e.i;
            while(e.t){
                e = e.t;
            }
            return e;
        } else {
            var r = e.h;
            while(r.i === e){
                e = r;
                r = e.h;
            }
            if (e.i !== r) {
                return r;
            } else return e;
        }
    };
    TreeNode.prototype.T = function() {
        var e = this.h;
        var r = this.i;
        var t = r.t;
        if (e.h === this) e.h = r;
        else if (e.t === this) e.t = r;
        else e.i = r;
        r.h = e;
        r.t = this;
        this.h = r;
        this.i = t;
        if (t) t.h = this;
        return r;
    };
    TreeNode.prototype.I = function() {
        var e = this.h;
        var r = this.t;
        var t = r.i;
        if (e.h === this) e.h = r;
        else if (e.t === this) e.t = r;
        else e.i = r;
        r.h = e;
        r.i = this;
        this.h = r;
        this.t = t;
        if (t) t.h = this;
        return r;
    };
    return TreeNode;
}();
var TreeNodeEnableIndex = function(e) {
    __extends(TreeNodeEnableIndex, e);
    function TreeNodeEnableIndex() {
        var r = e !== null && e.apply(this, arguments) || this;
        r.O = 1;
        return r;
    }
    TreeNodeEnableIndex.prototype.T = function() {
        var r = e.prototype.T.call(this);
        this.M();
        r.M();
        return r;
    };
    TreeNodeEnableIndex.prototype.I = function() {
        var r = e.prototype.I.call(this);
        this.M();
        r.M();
        return r;
    };
    TreeNodeEnableIndex.prototype.M = function() {
        this.O = 1;
        if (this.t) {
            this.O += this.t.O;
        }
        if (this.i) {
            this.O += this.i.O;
        }
    };
    return TreeNodeEnableIndex;
}(TreeNode);
var ContainerIterator = function() {
    function ContainerIterator(e) {
        if (e === void 0) {
            e = 0;
        }
        this.iteratorType = e;
    }
    ContainerIterator.prototype.equals = function(e) {
        return this.C === e.C;
    };
    return ContainerIterator;
}();
var Base = function() {
    function Base() {
        this._ = 0;
    }
    Object.defineProperty(Base.prototype, "length", {
        get: function() {
            return this._;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.size = function() {
        return this._;
    };
    Base.prototype.empty = function() {
        return this._ === 0;
    };
    return Base;
}();
var Container = function(e) {
    __extends(Container, e);
    function Container() {
        return e !== null && e.apply(this, arguments) || this;
    }
    return Container;
}(Base);
function throwIteratorAccessError() {
    throw new RangeError("Iterator access denied!");
}
var TreeContainer = function(e) {
    __extends(TreeContainer, e);
    function TreeContainer(r, t) {
        if (r === void 0) {
            r = function(e, r) {
                if (e < r) return -1;
                if (e > r) return 1;
                return 0;
            };
        }
        if (t === void 0) {
            t = false;
        }
        var i = e.call(this) || this;
        i.N = undefined;
        i.g = r;
        i.enableIndex = t;
        i.S = t ? TreeNodeEnableIndex : TreeNode;
        i.A = new i.S;
        return i;
    }
    TreeContainer.prototype.m = function(e, r) {
        var t = this.A;
        while(e){
            var i = this.g(e.u, r);
            if (i < 0) {
                e = e.i;
            } else if (i > 0) {
                t = e;
                e = e.t;
            } else return e;
        }
        return t;
    };
    TreeContainer.prototype.B = function(e, r) {
        var t = this.A;
        while(e){
            var i = this.g(e.u, r);
            if (i <= 0) {
                e = e.i;
            } else {
                t = e;
                e = e.t;
            }
        }
        return t;
    };
    TreeContainer.prototype.j = function(e, r) {
        var t = this.A;
        while(e){
            var i = this.g(e.u, r);
            if (i < 0) {
                t = e;
                e = e.i;
            } else if (i > 0) {
                e = e.t;
            } else return e;
        }
        return t;
    };
    TreeContainer.prototype.k = function(e, r) {
        var t = this.A;
        while(e){
            var i = this.g(e.u, r);
            if (i < 0) {
                t = e;
                e = e.i;
            } else {
                e = e.t;
            }
        }
        return t;
    };
    TreeContainer.prototype.R = function(e) {
        while(true){
            var r = e.h;
            if (r === this.A) return;
            if (e.l === 1) {
                e.l = 0;
                return;
            }
            if (e === r.t) {
                var t = r.i;
                if (t.l === 1) {
                    t.l = 0;
                    r.l = 1;
                    if (r === this.N) {
                        this.N = r.T();
                    } else r.T();
                } else {
                    if (t.i && t.i.l === 1) {
                        t.l = r.l;
                        r.l = 0;
                        t.i.l = 0;
                        if (r === this.N) {
                            this.N = r.T();
                        } else r.T();
                        return;
                    } else if (t.t && t.t.l === 1) {
                        t.l = 1;
                        t.t.l = 0;
                        t.I();
                    } else {
                        t.l = 1;
                        e = r;
                    }
                }
            } else {
                var t = r.t;
                if (t.l === 1) {
                    t.l = 0;
                    r.l = 1;
                    if (r === this.N) {
                        this.N = r.I();
                    } else r.I();
                } else {
                    if (t.t && t.t.l === 1) {
                        t.l = r.l;
                        r.l = 0;
                        t.t.l = 0;
                        if (r === this.N) {
                            this.N = r.I();
                        } else r.I();
                        return;
                    } else if (t.i && t.i.l === 1) {
                        t.l = 1;
                        t.i.l = 0;
                        t.T();
                    } else {
                        t.l = 1;
                        e = r;
                    }
                }
            }
        }
    };
    TreeContainer.prototype.G = function(e) {
        if (this._ === 1) {
            this.clear();
            return;
        }
        var r = e;
        while(r.t || r.i){
            if (r.i) {
                r = r.i;
                while(r.t)r = r.t;
            } else {
                r = r.t;
            }
            var t = e.u;
            e.u = r.u;
            r.u = t;
            var i = e.o;
            e.o = r.o;
            r.o = i;
            e = r;
        }
        if (this.A.t === r) {
            this.A.t = r.h;
        } else if (this.A.i === r) {
            this.A.i = r.h;
        }
        this.R(r);
        var n = r.h;
        if (r === n.t) {
            n.t = undefined;
        } else n.i = undefined;
        this._ -= 1;
        this.N.l = 0;
        if (this.enableIndex) {
            while(n !== this.A){
                n.O -= 1;
                n = n.h;
            }
        }
    };
    TreeContainer.prototype.P = function(e) {
        var r = typeof e === "number" ? e : undefined;
        var t = typeof e === "function" ? e : undefined;
        var i = typeof e === "undefined" ? [] : undefined;
        var n = 0;
        var s = this.N;
        var h = [];
        while(h.length || s){
            if (s) {
                h.push(s);
                s = s.t;
            } else {
                s = h.pop();
                if (n === r) return s;
                i && i.push(s);
                t && t(s, n, this);
                n += 1;
                s = s.i;
            }
        }
        return i;
    };
    TreeContainer.prototype.q = function(e) {
        while(true){
            var r = e.h;
            if (r.l === 0) return;
            var t = r.h;
            if (r === t.t) {
                var i = t.i;
                if (i && i.l === 1) {
                    i.l = r.l = 0;
                    if (t === this.N) return;
                    t.l = 1;
                    e = t;
                    continue;
                } else if (e === r.i) {
                    e.l = 0;
                    if (e.t) {
                        e.t.h = r;
                    }
                    if (e.i) {
                        e.i.h = t;
                    }
                    r.i = e.t;
                    t.t = e.i;
                    e.t = r;
                    e.i = t;
                    if (t === this.N) {
                        this.N = e;
                        this.A.h = e;
                    } else {
                        var n = t.h;
                        if (n.t === t) {
                            n.t = e;
                        } else n.i = e;
                    }
                    e.h = t.h;
                    r.h = e;
                    t.h = e;
                    t.l = 1;
                } else {
                    r.l = 0;
                    if (t === this.N) {
                        this.N = t.I();
                    } else t.I();
                    t.l = 1;
                    return;
                }
            } else {
                var i = t.t;
                if (i && i.l === 1) {
                    i.l = r.l = 0;
                    if (t === this.N) return;
                    t.l = 1;
                    e = t;
                    continue;
                } else if (e === r.t) {
                    e.l = 0;
                    if (e.t) {
                        e.t.h = t;
                    }
                    if (e.i) {
                        e.i.h = r;
                    }
                    t.i = e.t;
                    r.t = e.i;
                    e.t = t;
                    e.i = r;
                    if (t === this.N) {
                        this.N = e;
                        this.A.h = e;
                    } else {
                        var n = t.h;
                        if (n.t === t) {
                            n.t = e;
                        } else n.i = e;
                    }
                    e.h = t.h;
                    r.h = e;
                    t.h = e;
                    t.l = 1;
                } else {
                    r.l = 0;
                    if (t === this.N) {
                        this.N = t.T();
                    } else t.T();
                    t.l = 1;
                    return;
                }
            }
            if (this.enableIndex) {
                r.M();
                t.M();
                e.M();
            }
            return;
        }
    };
    TreeContainer.prototype.D = function(e, r, t) {
        if (this.N === undefined) {
            this._ += 1;
            this.N = new this.S(e, r, 0);
            this.N.h = this.A;
            this.A.h = this.A.t = this.A.i = this.N;
            return this._;
        }
        var i;
        var n = this.A.t;
        var s = this.g(n.u, e);
        if (s === 0) {
            n.o = r;
            return this._;
        } else if (s > 0) {
            n.t = new this.S(e, r);
            n.t.h = n;
            i = n.t;
            this.A.t = i;
        } else {
            var h = this.A.i;
            var a = this.g(h.u, e);
            if (a === 0) {
                h.o = r;
                return this._;
            } else if (a < 0) {
                h.i = new this.S(e, r);
                h.i.h = h;
                i = h.i;
                this.A.i = i;
            } else {
                if (t !== undefined) {
                    var u = t.C;
                    if (u !== this.A) {
                        var f = this.g(u.u, e);
                        if (f === 0) {
                            u.o = r;
                            return this._;
                        } else if (f > 0) {
                            var o = u.v();
                            var d = this.g(o.u, e);
                            if (d === 0) {
                                o.o = r;
                                return this._;
                            } else if (d < 0) {
                                i = new this.S(e, r);
                                if (o.i === undefined) {
                                    o.i = i;
                                    i.h = o;
                                } else {
                                    u.t = i;
                                    i.h = u;
                                }
                            }
                        }
                    }
                }
                if (i === undefined) {
                    i = this.N;
                    while(true){
                        var c = this.g(i.u, e);
                        if (c > 0) {
                            if (i.t === undefined) {
                                i.t = new this.S(e, r);
                                i.t.h = i;
                                i = i.t;
                                break;
                            }
                            i = i.t;
                        } else if (c < 0) {
                            if (i.i === undefined) {
                                i.i = new this.S(e, r);
                                i.i.h = i;
                                i = i.i;
                                break;
                            }
                            i = i.i;
                        } else {
                            i.o = r;
                            return this._;
                        }
                    }
                }
            }
        }
        if (this.enableIndex) {
            var l = i.h;
            while(l !== this.A){
                l.O += 1;
                l = l.h;
            }
        }
        this.q(i);
        this._ += 1;
        return this._;
    };
    TreeContainer.prototype.F = function(e, r) {
        while(e){
            var t = this.g(e.u, r);
            if (t < 0) {
                e = e.i;
            } else if (t > 0) {
                e = e.t;
            } else return e;
        }
        return e || this.A;
    };
    TreeContainer.prototype.clear = function() {
        this._ = 0;
        this.N = undefined;
        this.A.h = undefined;
        this.A.t = this.A.i = undefined;
    };
    TreeContainer.prototype.updateKeyByIterator = function(e, r) {
        var t = e.C;
        if (t === this.A) {
            throwIteratorAccessError();
        }
        if (this._ === 1) {
            t.u = r;
            return true;
        }
        var i = t.p().u;
        if (t === this.A.t) {
            if (this.g(i, r) > 0) {
                t.u = r;
                return true;
            }
            return false;
        }
        var n = t.v().u;
        if (t === this.A.i) {
            if (this.g(n, r) < 0) {
                t.u = r;
                return true;
            }
            return false;
        }
        if (this.g(n, r) >= 0 || this.g(i, r) <= 0) return false;
        t.u = r;
        return true;
    };
    TreeContainer.prototype.eraseElementByPos = function(e) {
        if (e < 0 || e > this._ - 1) {
            throw new RangeError;
        }
        var r = this.P(e);
        this.G(r);
        return this._;
    };
    TreeContainer.prototype.eraseElementByKey = function(e) {
        if (this._ === 0) return false;
        var r = this.F(this.N, e);
        if (r === this.A) return false;
        this.G(r);
        return true;
    };
    TreeContainer.prototype.eraseElementByIterator = function(e) {
        var r = e.C;
        if (r === this.A) {
            throwIteratorAccessError();
        }
        var t = r.i === undefined;
        var i = e.iteratorType === 0;
        if (i) {
            if (t) e.next();
        } else {
            if (!t || r.t === undefined) e.next();
        }
        this.G(r);
        return e;
    };
    TreeContainer.prototype.getHeight = function() {
        if (this._ === 0) return 0;
        function traversal(e) {
            if (!e) return 0;
            return Math.max(traversal(e.t), traversal(e.i)) + 1;
        }
        return traversal(this.N);
    };
    return TreeContainer;
}(Container);
var TreeIterator = function(e) {
    __extends(TreeIterator, e);
    function TreeIterator(r, t, i) {
        var n = e.call(this, i) || this;
        n.C = r;
        n.A = t;
        if (n.iteratorType === 0) {
            n.pre = function() {
                if (this.C === this.A.t) {
                    throwIteratorAccessError();
                }
                this.C = this.C.v();
                return this;
            };
            n.next = function() {
                if (this.C === this.A) {
                    throwIteratorAccessError();
                }
                this.C = this.C.p();
                return this;
            };
        } else {
            n.pre = function() {
                if (this.C === this.A.i) {
                    throwIteratorAccessError();
                }
                this.C = this.C.p();
                return this;
            };
            n.next = function() {
                if (this.C === this.A) {
                    throwIteratorAccessError();
                }
                this.C = this.C.v();
                return this;
            };
        }
        return n;
    }
    Object.defineProperty(TreeIterator.prototype, "index", {
        get: function() {
            var e = this.C;
            var r = this.A.h;
            if (e === this.A) {
                if (r) {
                    return r.O - 1;
                }
                return 0;
            }
            var t = 0;
            if (e.t) {
                t += e.t.O;
            }
            while(e !== r){
                var i = e.h;
                if (e === i.i) {
                    t += 1;
                    if (i.t) {
                        t += i.t.O;
                    }
                }
                e = i;
            }
            return t;
        },
        enumerable: false,
        configurable: true
    });
    TreeIterator.prototype.isAccessible = function() {
        return this.C !== this.A;
    };
    return TreeIterator;
}(ContainerIterator);
var OrderedMapIterator = function(e) {
    __extends(OrderedMapIterator, e);
    function OrderedMapIterator(r, t, i, n) {
        var s = e.call(this, r, t, n) || this;
        s.container = i;
        return s;
    }
    Object.defineProperty(OrderedMapIterator.prototype, "pointer", {
        get: function() {
            if (this.C === this.A) {
                throwIteratorAccessError();
            }
            var e = this;
            return new Proxy([], {
                get: function(r, t) {
                    if (t === "0") return e.C.u;
                    else if (t === "1") return e.C.o;
                    r[0] = e.C.u;
                    r[1] = e.C.o;
                    return r[t];
                },
                set: function(r, t, i) {
                    if (t !== "1") {
                        throw new TypeError("prop must be 1");
                    }
                    e.C.o = i;
                    return true;
                }
            });
        },
        enumerable: false,
        configurable: true
    });
    OrderedMapIterator.prototype.copy = function() {
        return new OrderedMapIterator(this.C, this.A, this.container, this.iteratorType);
    };
    return OrderedMapIterator;
}(TreeIterator);
var OrderedMap = function(e) {
    __extends(OrderedMap, e);
    function OrderedMap(r, t, i) {
        if (r === void 0) {
            r = [];
        }
        var n = e.call(this, t, i) || this;
        var s = n;
        r.forEach(function(e) {
            s.setElement(e[0], e[1]);
        });
        return n;
    }
    OrderedMap.prototype.begin = function() {
        return new OrderedMapIterator(this.A.t || this.A, this.A, this);
    };
    OrderedMap.prototype.end = function() {
        return new OrderedMapIterator(this.A, this.A, this);
    };
    OrderedMap.prototype.rBegin = function() {
        return new OrderedMapIterator(this.A.i || this.A, this.A, this, 1);
    };
    OrderedMap.prototype.rEnd = function() {
        return new OrderedMapIterator(this.A, this.A, this, 1);
    };
    OrderedMap.prototype.front = function() {
        if (this._ === 0) return;
        var e = this.A.t;
        return [
            e.u,
            e.o
        ];
    };
    OrderedMap.prototype.back = function() {
        if (this._ === 0) return;
        var e = this.A.i;
        return [
            e.u,
            e.o
        ];
    };
    OrderedMap.prototype.lowerBound = function(e) {
        var r = this.m(this.N, e);
        return new OrderedMapIterator(r, this.A, this);
    };
    OrderedMap.prototype.upperBound = function(e) {
        var r = this.B(this.N, e);
        return new OrderedMapIterator(r, this.A, this);
    };
    OrderedMap.prototype.reverseLowerBound = function(e) {
        var r = this.j(this.N, e);
        return new OrderedMapIterator(r, this.A, this);
    };
    OrderedMap.prototype.reverseUpperBound = function(e) {
        var r = this.k(this.N, e);
        return new OrderedMapIterator(r, this.A, this);
    };
    OrderedMap.prototype.forEach = function(e) {
        this.P(function(r, t, i) {
            e([
                r.u,
                r.o
            ], t, i);
        });
    };
    OrderedMap.prototype.setElement = function(e, r, t) {
        return this.D(e, r, t);
    };
    OrderedMap.prototype.getElementByPos = function(e) {
        if (e < 0 || e > this._ - 1) {
            throw new RangeError;
        }
        var r = this.P(e);
        return [
            r.u,
            r.o
        ];
    };
    OrderedMap.prototype.find = function(e) {
        var r = this.F(this.N, e);
        return new OrderedMapIterator(r, this.A, this);
    };
    OrderedMap.prototype.getElementByKey = function(e) {
        var r = this.F(this.N, e);
        return r.o;
    };
    OrderedMap.prototype.union = function(e) {
        var r = this;
        e.forEach(function(e) {
            r.setElement(e[0], e[1]);
        });
        return this._;
    };
    OrderedMap.prototype[Symbol.iterator] = function() {
        var e, r, t, i;
        return __generator(this, function(n) {
            switch(n.label){
                case 0:
                    e = this._;
                    r = this.P();
                    t = 0;
                    n.label = 1;
                case 1:
                    if (!(t < e)) return [
                        3,
                        4
                    ];
                    i = r[t];
                    return [
                        4,
                        [
                            i.u,
                            i.o
                        ]
                    ];
                case 2:
                    n.sent();
                    n.label = 3;
                case 3:
                    ++t;
                    return [
                        3,
                        1
                    ];
                case 4:
                    return [
                        2
                    ];
            }
        });
    };
    return OrderedMap;
}(TreeContainer);
;
 //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/lodash.camelcase/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */ /** Used as references for various `Number` constants. */ var INFINITY = 1 / 0;
/** `Object#toString` result references. */ var symbolTag = '[object Symbol]';
/** Used to match words composed of alphanumeric characters. */ var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
/** Used to match Latin Unicode letters (excluding mathematical operators). */ var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
/** Used to compose unicode character classes. */ var rsAstralRange = '\\ud800-\\udfff', rsComboMarksRange = '\\u0300-\\u036f\\ufe20-\\ufe23', rsComboSymbolsRange = '\\u20d0-\\u20f0', rsDingbatRange = '\\u2700-\\u27bf', rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff', rsMathOpRange = '\\xac\\xb1\\xd7\\xf7', rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf', rsPunctuationRange = '\\u2000-\\u206f', rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000', rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde', rsVarRange = '\\ufe0e\\ufe0f', rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;
/** Used to compose unicode capture groups. */ var rsApos = "['\u2019]", rsAstral = '[' + rsAstralRange + ']', rsBreak = '[' + rsBreakRange + ']', rsCombo = '[' + rsComboMarksRange + rsComboSymbolsRange + ']', rsDigits = '\\d+', rsDingbat = '[' + rsDingbatRange + ']', rsLower = '[' + rsLowerRange + ']', rsMisc = '[^' + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']', rsFitz = '\\ud83c[\\udffb-\\udfff]', rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')', rsNonAstral = '[^' + rsAstralRange + ']', rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}', rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]', rsUpper = '[' + rsUpperRange + ']', rsZWJ = '\\u200d';
/** Used to compose unicode regexes. */ var rsLowerMisc = '(?:' + rsLower + '|' + rsMisc + ')', rsUpperMisc = '(?:' + rsUpper + '|' + rsMisc + ')', rsOptLowerContr = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?', rsOptUpperContr = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?', reOptMod = rsModifier + '?', rsOptVar = '[' + rsVarRange + ']?', rsOptJoin = '(?:' + rsZWJ + '(?:' + [
    rsNonAstral,
    rsRegional,
    rsSurrPair
].join('|') + ')' + rsOptVar + reOptMod + ')*', rsSeq = rsOptVar + reOptMod + rsOptJoin, rsEmoji = '(?:' + [
    rsDingbat,
    rsRegional,
    rsSurrPair
].join('|') + ')' + rsSeq, rsSymbol = '(?:' + [
    rsNonAstral + rsCombo + '?',
    rsCombo,
    rsRegional,
    rsSurrPair,
    rsAstral
].join('|') + ')';
/** Used to match apostrophes. */ var reApos = RegExp(rsApos, 'g');
/**
 * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
 * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
 */ var reComboMark = RegExp(rsCombo, 'g');
/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */ var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');
/** Used to match complex or compound words. */ var reUnicodeWord = RegExp([
    rsUpper + '?' + rsLower + '+' + rsOptLowerContr + '(?=' + [
        rsBreak,
        rsUpper,
        '$'
    ].join('|') + ')',
    rsUpperMisc + '+' + rsOptUpperContr + '(?=' + [
        rsBreak,
        rsUpper + rsLowerMisc,
        '$'
    ].join('|') + ')',
    rsUpper + '?' + rsLowerMisc + '+' + rsOptLowerContr,
    rsUpper + '+' + rsOptUpperContr,
    rsDigits,
    rsEmoji
].join('|'), 'g');
/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */ var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange + rsComboMarksRange + rsComboSymbolsRange + rsVarRange + ']');
/** Used to detect strings that need a more robust regexp to match words. */ var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
/** Used to map Latin Unicode letters to basic Latin letters. */ var deburredLetters = {
    // Latin-1 Supplement block.
    '\xc0': 'A',
    '\xc1': 'A',
    '\xc2': 'A',
    '\xc3': 'A',
    '\xc4': 'A',
    '\xc5': 'A',
    '\xe0': 'a',
    '\xe1': 'a',
    '\xe2': 'a',
    '\xe3': 'a',
    '\xe4': 'a',
    '\xe5': 'a',
    '\xc7': 'C',
    '\xe7': 'c',
    '\xd0': 'D',
    '\xf0': 'd',
    '\xc8': 'E',
    '\xc9': 'E',
    '\xca': 'E',
    '\xcb': 'E',
    '\xe8': 'e',
    '\xe9': 'e',
    '\xea': 'e',
    '\xeb': 'e',
    '\xcc': 'I',
    '\xcd': 'I',
    '\xce': 'I',
    '\xcf': 'I',
    '\xec': 'i',
    '\xed': 'i',
    '\xee': 'i',
    '\xef': 'i',
    '\xd1': 'N',
    '\xf1': 'n',
    '\xd2': 'O',
    '\xd3': 'O',
    '\xd4': 'O',
    '\xd5': 'O',
    '\xd6': 'O',
    '\xd8': 'O',
    '\xf2': 'o',
    '\xf3': 'o',
    '\xf4': 'o',
    '\xf5': 'o',
    '\xf6': 'o',
    '\xf8': 'o',
    '\xd9': 'U',
    '\xda': 'U',
    '\xdb': 'U',
    '\xdc': 'U',
    '\xf9': 'u',
    '\xfa': 'u',
    '\xfb': 'u',
    '\xfc': 'u',
    '\xdd': 'Y',
    '\xfd': 'y',
    '\xff': 'y',
    '\xc6': 'Ae',
    '\xe6': 'ae',
    '\xde': 'Th',
    '\xfe': 'th',
    '\xdf': 'ss',
    // Latin Extended-A block.
    '\u0100': 'A',
    '\u0102': 'A',
    '\u0104': 'A',
    '\u0101': 'a',
    '\u0103': 'a',
    '\u0105': 'a',
    '\u0106': 'C',
    '\u0108': 'C',
    '\u010a': 'C',
    '\u010c': 'C',
    '\u0107': 'c',
    '\u0109': 'c',
    '\u010b': 'c',
    '\u010d': 'c',
    '\u010e': 'D',
    '\u0110': 'D',
    '\u010f': 'd',
    '\u0111': 'd',
    '\u0112': 'E',
    '\u0114': 'E',
    '\u0116': 'E',
    '\u0118': 'E',
    '\u011a': 'E',
    '\u0113': 'e',
    '\u0115': 'e',
    '\u0117': 'e',
    '\u0119': 'e',
    '\u011b': 'e',
    '\u011c': 'G',
    '\u011e': 'G',
    '\u0120': 'G',
    '\u0122': 'G',
    '\u011d': 'g',
    '\u011f': 'g',
    '\u0121': 'g',
    '\u0123': 'g',
    '\u0124': 'H',
    '\u0126': 'H',
    '\u0125': 'h',
    '\u0127': 'h',
    '\u0128': 'I',
    '\u012a': 'I',
    '\u012c': 'I',
    '\u012e': 'I',
    '\u0130': 'I',
    '\u0129': 'i',
    '\u012b': 'i',
    '\u012d': 'i',
    '\u012f': 'i',
    '\u0131': 'i',
    '\u0134': 'J',
    '\u0135': 'j',
    '\u0136': 'K',
    '\u0137': 'k',
    '\u0138': 'k',
    '\u0139': 'L',
    '\u013b': 'L',
    '\u013d': 'L',
    '\u013f': 'L',
    '\u0141': 'L',
    '\u013a': 'l',
    '\u013c': 'l',
    '\u013e': 'l',
    '\u0140': 'l',
    '\u0142': 'l',
    '\u0143': 'N',
    '\u0145': 'N',
    '\u0147': 'N',
    '\u014a': 'N',
    '\u0144': 'n',
    '\u0146': 'n',
    '\u0148': 'n',
    '\u014b': 'n',
    '\u014c': 'O',
    '\u014e': 'O',
    '\u0150': 'O',
    '\u014d': 'o',
    '\u014f': 'o',
    '\u0151': 'o',
    '\u0154': 'R',
    '\u0156': 'R',
    '\u0158': 'R',
    '\u0155': 'r',
    '\u0157': 'r',
    '\u0159': 'r',
    '\u015a': 'S',
    '\u015c': 'S',
    '\u015e': 'S',
    '\u0160': 'S',
    '\u015b': 's',
    '\u015d': 's',
    '\u015f': 's',
    '\u0161': 's',
    '\u0162': 'T',
    '\u0164': 'T',
    '\u0166': 'T',
    '\u0163': 't',
    '\u0165': 't',
    '\u0167': 't',
    '\u0168': 'U',
    '\u016a': 'U',
    '\u016c': 'U',
    '\u016e': 'U',
    '\u0170': 'U',
    '\u0172': 'U',
    '\u0169': 'u',
    '\u016b': 'u',
    '\u016d': 'u',
    '\u016f': 'u',
    '\u0171': 'u',
    '\u0173': 'u',
    '\u0174': 'W',
    '\u0175': 'w',
    '\u0176': 'Y',
    '\u0177': 'y',
    '\u0178': 'Y',
    '\u0179': 'Z',
    '\u017b': 'Z',
    '\u017d': 'Z',
    '\u017a': 'z',
    '\u017c': 'z',
    '\u017e': 'z',
    '\u0132': 'IJ',
    '\u0133': 'ij',
    '\u0152': 'Oe',
    '\u0153': 'oe',
    '\u0149': "'n",
    '\u017f': 'ss'
};
/** Detect free variable `global` from Node.js. */ var freeGlobal = typeof global == 'object' && global && global.Object === Object && global;
/** Detect free variable `self`. */ var freeSelf = typeof self == 'object' && self && self.Object === Object && self;
/** Used as a reference to the global object. */ var root = freeGlobal || freeSelf || Function('return this')();
/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */ function arrayReduce(array, iteratee, accumulator, initAccum) {
    var index = -1, length = array ? array.length : 0;
    if (initAccum && length) {
        accumulator = array[++index];
    }
    while(++index < length){
        accumulator = iteratee(accumulator, array[index], index, array);
    }
    return accumulator;
}
/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */ function asciiToArray(string) {
    return string.split('');
}
/**
 * Splits an ASCII `string` into an array of its words.
 *
 * @private
 * @param {string} The string to inspect.
 * @returns {Array} Returns the words of `string`.
 */ function asciiWords(string) {
    return string.match(reAsciiWord) || [];
}
/**
 * The base implementation of `_.propertyOf` without support for deep paths.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Function} Returns the new accessor function.
 */ function basePropertyOf(object) {
    return function(key) {
        return object == null ? undefined : object[key];
    };
}
/**
 * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
 * letters to basic Latin letters.
 *
 * @private
 * @param {string} letter The matched letter to deburr.
 * @returns {string} Returns the deburred letter.
 */ var deburrLetter = basePropertyOf(deburredLetters);
/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */ function hasUnicode(string) {
    return reHasUnicode.test(string);
}
/**
 * Checks if `string` contains a word composed of Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a word is found, else `false`.
 */ function hasUnicodeWord(string) {
    return reHasUnicodeWord.test(string);
}
/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */ function stringToArray(string) {
    return hasUnicode(string) ? unicodeToArray(string) : asciiToArray(string);
}
/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */ function unicodeToArray(string) {
    return string.match(reUnicode) || [];
}
/**
 * Splits a Unicode `string` into an array of its words.
 *
 * @private
 * @param {string} The string to inspect.
 * @returns {Array} Returns the words of `string`.
 */ function unicodeWords(string) {
    return string.match(reUnicodeWord) || [];
}
/** Used for built-in method references. */ var objectProto = Object.prototype;
/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */ var objectToString = objectProto.toString;
/** Built-in value references. */ var Symbol = root.Symbol;
/** Used to convert symbols to primitives and strings. */ var symbolProto = Symbol ? Symbol.prototype : undefined, symbolToString = symbolProto ? symbolProto.toString : undefined;
/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */ function baseSlice(array, start, end) {
    var index = -1, length = array.length;
    if (start < 0) {
        start = -start > length ? 0 : length + start;
    }
    end = end > length ? length : end;
    if (end < 0) {
        end += length;
    }
    length = start > end ? 0 : end - start >>> 0;
    start >>>= 0;
    var result = Array(length);
    while(++index < length){
        result[index] = array[index + start];
    }
    return result;
}
/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */ function baseToString(value) {
    // Exit early for strings to avoid a performance hit in some environments.
    if (typeof value == 'string') {
        return value;
    }
    if (isSymbol(value)) {
        return symbolToString ? symbolToString.call(value) : '';
    }
    var result = value + '';
    return result == '0' && 1 / value == -INFINITY ? '-0' : result;
}
/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */ function castSlice(array, start, end) {
    var length = array.length;
    end = end === undefined ? length : end;
    return !start && end >= length ? array : baseSlice(array, start, end);
}
/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */ function createCaseFirst(methodName) {
    return function(string) {
        string = toString(string);
        var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined;
        var chr = strSymbols ? strSymbols[0] : string.charAt(0);
        var trailing = strSymbols ? castSlice(strSymbols, 1).join('') : string.slice(1);
        return chr[methodName]() + trailing;
    };
}
/**
 * Creates a function like `_.camelCase`.
 *
 * @private
 * @param {Function} callback The function to combine each word.
 * @returns {Function} Returns the new compounder function.
 */ function createCompounder(callback) {
    return function(string) {
        return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
    };
}
/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */ function isObjectLike(value) {
    return !!value && typeof value == 'object';
}
/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */ function isSymbol(value) {
    return typeof value == 'symbol' || isObjectLike(value) && objectToString.call(value) == symbolTag;
}
/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */ function toString(value) {
    return value == null ? '' : baseToString(value);
}
/**
 * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the camel cased string.
 * @example
 *
 * _.camelCase('Foo Bar');
 * // => 'fooBar'
 *
 * _.camelCase('--foo-bar--');
 * // => 'fooBar'
 *
 * _.camelCase('__FOO_BAR__');
 * // => 'fooBar'
 */ var camelCase = createCompounder(function(result, word, index) {
    word = word.toLowerCase();
    return result + (index ? capitalize(word) : word);
});
/**
 * Converts the first character of `string` to upper case and the remaining
 * to lower case.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to capitalize.
 * @returns {string} Returns the capitalized string.
 * @example
 *
 * _.capitalize('FRED');
 * // => 'Fred'
 */ function capitalize(string) {
    return upperFirst(toString(string).toLowerCase());
}
/**
 * Deburrs `string` by converting
 * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
 * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
 * letters to basic Latin letters and removing
 * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to deburr.
 * @returns {string} Returns the deburred string.
 * @example
 *
 * _.deburr('déjà vu');
 * // => 'deja vu'
 */ function deburr(string) {
    string = toString(string);
    return string && string.replace(reLatin, deburrLetter).replace(reComboMark, '');
}
/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */ var upperFirst = createCaseFirst('toUpperCase');
/**
 * Splits `string` into an array of its words.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to inspect.
 * @param {RegExp|string} [pattern] The pattern to match words.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {Array} Returns the words of `string`.
 * @example
 *
 * _.words('fred, barney, & pebbles');
 * // => ['fred', 'barney', 'pebbles']
 *
 * _.words('fred, barney, & pebbles', /[^, ]+/g);
 * // => ['fred', 'barney', '&', 'pebbles']
 */ function words(string, pattern, guard) {
    string = toString(string);
    pattern = guard ? undefined : pattern;
    if (pattern === undefined) {
        return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
    }
    return string.match(pattern) || [];
}
module.exports = camelCase;
}}),
"[project]/node_modules/@grpc/proto-loader/build/src/util.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/**
 * @license
 * Copyright 2018 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.addCommonProtos = exports.loadProtosWithOptionsSync = exports.loadProtosWithOptions = void 0;
const fs = __turbopack_context__.r("[externals]/fs [external] (fs, cjs)");
const path = __turbopack_context__.r("[externals]/path [external] (path, cjs)");
const Protobuf = __turbopack_context__.r("[project]/node_modules/protobufjs/index.js [app-rsc] (ecmascript)");
function addIncludePathResolver(root, includePaths) {
    const originalResolvePath = root.resolvePath;
    root.resolvePath = (origin, target)=>{
        if (path.isAbsolute(target)) {
            return target;
        }
        for (const directory of includePaths){
            const fullPath = path.join(directory, target);
            try {
                fs.accessSync(fullPath, fs.constants.R_OK);
                return fullPath;
            } catch (err) {
                continue;
            }
        }
        process.emitWarning(`${target} not found in any of the include paths ${includePaths}`);
        return originalResolvePath(origin, target);
    };
}
async function loadProtosWithOptions(filename, options) {
    const root = new Protobuf.Root();
    options = options || {};
    if (!!options.includeDirs) {
        if (!Array.isArray(options.includeDirs)) {
            return Promise.reject(new Error('The includeDirs option must be an array'));
        }
        addIncludePathResolver(root, options.includeDirs);
    }
    const loadedRoot = await root.load(filename, options);
    loadedRoot.resolveAll();
    return loadedRoot;
}
exports.loadProtosWithOptions = loadProtosWithOptions;
function loadProtosWithOptionsSync(filename, options) {
    const root = new Protobuf.Root();
    options = options || {};
    if (!!options.includeDirs) {
        if (!Array.isArray(options.includeDirs)) {
            throw new Error('The includeDirs option must be an array');
        }
        addIncludePathResolver(root, options.includeDirs);
    }
    const loadedRoot = root.loadSync(filename, options);
    loadedRoot.resolveAll();
    return loadedRoot;
}
exports.loadProtosWithOptionsSync = loadProtosWithOptionsSync;
/**
 * Load Google's well-known proto files that aren't exposed by Protobuf.js.
 */ function addCommonProtos() {
    // Protobuf.js exposes: any, duration, empty, field_mask, struct, timestamp,
    // and wrappers. compiler/plugin is excluded in Protobuf.js and here.
    // Using constant strings for compatibility with tools like Webpack
    const apiDescriptor = __turbopack_context__.r("[project]/node_modules/protobufjs/google/protobuf/api.json (json)");
    const descriptorDescriptor = __turbopack_context__.r("[project]/node_modules/protobufjs/google/protobuf/descriptor.json (json)");
    const sourceContextDescriptor = __turbopack_context__.r("[project]/node_modules/protobufjs/google/protobuf/source_context.json (json)");
    const typeDescriptor = __turbopack_context__.r("[project]/node_modules/protobufjs/google/protobuf/type.json (json)");
    Protobuf.common('api', apiDescriptor.nested.google.nested.protobuf.nested);
    Protobuf.common('descriptor', descriptorDescriptor.nested.google.nested.protobuf.nested);
    Protobuf.common('source_context', sourceContextDescriptor.nested.google.nested.protobuf.nested);
    Protobuf.common('type', typeDescriptor.nested.google.nested.protobuf.nested);
}
exports.addCommonProtos = addCommonProtos; //# sourceMappingURL=util.js.map
}}),
"[project]/node_modules/@grpc/proto-loader/build/src/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/**
 * @license
 * Copyright 2018 gRPC authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */ Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.loadFileDescriptorSetFromObject = exports.loadFileDescriptorSetFromBuffer = exports.fromJSON = exports.loadSync = exports.load = exports.IdempotencyLevel = exports.isAnyExtension = exports.Long = void 0;
const camelCase = __turbopack_context__.r("[project]/node_modules/lodash.camelcase/index.js [app-rsc] (ecmascript)");
const Protobuf = __turbopack_context__.r("[project]/node_modules/protobufjs/index.js [app-rsc] (ecmascript)");
const descriptor = __turbopack_context__.r("[project]/node_modules/protobufjs/ext/descriptor/index.js [app-rsc] (ecmascript)");
const util_1 = __turbopack_context__.r("[project]/node_modules/@grpc/proto-loader/build/src/util.js [app-rsc] (ecmascript)");
const Long = __turbopack_context__.r("[project]/node_modules/long/umd/index.js [app-rsc] (ecmascript)");
exports.Long = Long;
function isAnyExtension(obj) {
    return '@type' in obj && typeof obj['@type'] === 'string';
}
exports.isAnyExtension = isAnyExtension;
var IdempotencyLevel;
(function(IdempotencyLevel) {
    IdempotencyLevel["IDEMPOTENCY_UNKNOWN"] = "IDEMPOTENCY_UNKNOWN";
    IdempotencyLevel["NO_SIDE_EFFECTS"] = "NO_SIDE_EFFECTS";
    IdempotencyLevel["IDEMPOTENT"] = "IDEMPOTENT";
})(IdempotencyLevel = exports.IdempotencyLevel || (exports.IdempotencyLevel = {}));
const descriptorOptions = {
    longs: String,
    enums: String,
    bytes: String,
    defaults: true,
    oneofs: true,
    json: true
};
function joinName(baseName, name) {
    if (baseName === '') {
        return name;
    } else {
        return baseName + '.' + name;
    }
}
function isHandledReflectionObject(obj) {
    return obj instanceof Protobuf.Service || obj instanceof Protobuf.Type || obj instanceof Protobuf.Enum;
}
function isNamespaceBase(obj) {
    return obj instanceof Protobuf.Namespace || obj instanceof Protobuf.Root;
}
function getAllHandledReflectionObjects(obj, parentName) {
    const objName = joinName(parentName, obj.name);
    if (isHandledReflectionObject(obj)) {
        return [
            [
                objName,
                obj
            ]
        ];
    } else {
        if (isNamespaceBase(obj) && typeof obj.nested !== 'undefined') {
            return Object.keys(obj.nested).map((name)=>{
                return getAllHandledReflectionObjects(obj.nested[name], objName);
            }).reduce((accumulator, currentValue)=>accumulator.concat(currentValue), []);
        }
    }
    return [];
}
function createDeserializer(cls, options) {
    return function deserialize(argBuf) {
        return cls.toObject(cls.decode(argBuf), options);
    };
}
function createSerializer(cls) {
    return function serialize(arg) {
        if (Array.isArray(arg)) {
            throw new Error(`Failed to serialize message: expected object with ${cls.name} structure, got array instead`);
        }
        const message = cls.fromObject(arg);
        return cls.encode(message).finish();
    };
}
function mapMethodOptions(options) {
    return (options || []).reduce((obj, item)=>{
        for (const [key, value] of Object.entries(item)){
            switch(key){
                case 'uninterpreted_option':
                    obj.uninterpreted_option.push(item.uninterpreted_option);
                    break;
                default:
                    obj[key] = value;
            }
        }
        return obj;
    }, {
        deprecated: false,
        idempotency_level: IdempotencyLevel.IDEMPOTENCY_UNKNOWN,
        uninterpreted_option: []
    });
}
function createMethodDefinition(method, serviceName, options, fileDescriptors) {
    /* This is only ever called after the corresponding root.resolveAll(), so we
     * can assume that the resolved request and response types are non-null */ const requestType = method.resolvedRequestType;
    const responseType = method.resolvedResponseType;
    return {
        path: '/' + serviceName + '/' + method.name,
        requestStream: !!method.requestStream,
        responseStream: !!method.responseStream,
        requestSerialize: createSerializer(requestType),
        requestDeserialize: createDeserializer(requestType, options),
        responseSerialize: createSerializer(responseType),
        responseDeserialize: createDeserializer(responseType, options),
        // TODO(murgatroid99): Find a better way to handle this
        originalName: camelCase(method.name),
        requestType: createMessageDefinition(requestType, fileDescriptors),
        responseType: createMessageDefinition(responseType, fileDescriptors),
        options: mapMethodOptions(method.parsedOptions)
    };
}
function createServiceDefinition(service, name, options, fileDescriptors) {
    const def = {};
    for (const method of service.methodsArray){
        def[method.name] = createMethodDefinition(method, name, options, fileDescriptors);
    }
    return def;
}
function createMessageDefinition(message, fileDescriptors) {
    const messageDescriptor = message.toDescriptor('proto3');
    return {
        format: 'Protocol Buffer 3 DescriptorProto',
        type: messageDescriptor.$type.toObject(messageDescriptor, descriptorOptions),
        fileDescriptorProtos: fileDescriptors
    };
}
function createEnumDefinition(enumType, fileDescriptors) {
    const enumDescriptor = enumType.toDescriptor('proto3');
    return {
        format: 'Protocol Buffer 3 EnumDescriptorProto',
        type: enumDescriptor.$type.toObject(enumDescriptor, descriptorOptions),
        fileDescriptorProtos: fileDescriptors
    };
}
/**
 * function createDefinition(obj: Protobuf.Service, name: string, options:
 * Options): ServiceDefinition; function createDefinition(obj: Protobuf.Type,
 * name: string, options: Options): MessageTypeDefinition; function
 * createDefinition(obj: Protobuf.Enum, name: string, options: Options):
 * EnumTypeDefinition;
 */ function createDefinition(obj, name, options, fileDescriptors) {
    if (obj instanceof Protobuf.Service) {
        return createServiceDefinition(obj, name, options, fileDescriptors);
    } else if (obj instanceof Protobuf.Type) {
        return createMessageDefinition(obj, fileDescriptors);
    } else if (obj instanceof Protobuf.Enum) {
        return createEnumDefinition(obj, fileDescriptors);
    } else {
        throw new Error('Type mismatch in reflection object handling');
    }
}
function createPackageDefinition(root, options) {
    const def = {};
    root.resolveAll();
    const descriptorList = root.toDescriptor('proto3').file;
    const bufferList = descriptorList.map((value)=>Buffer.from(descriptor.FileDescriptorProto.encode(value).finish()));
    for (const [name, obj] of getAllHandledReflectionObjects(root, '')){
        def[name] = createDefinition(obj, name, options, bufferList);
    }
    return def;
}
function createPackageDefinitionFromDescriptorSet(decodedDescriptorSet, options) {
    options = options || {};
    const root = Protobuf.Root.fromDescriptor(decodedDescriptorSet);
    root.resolveAll();
    return createPackageDefinition(root, options);
}
/**
 * Load a .proto file with the specified options.
 * @param filename One or multiple file paths to load. Can be an absolute path
 *     or relative to an include path.
 * @param options.keepCase Preserve field names. The default is to change them
 *     to camel case.
 * @param options.longs The type that should be used to represent `long` values.
 *     Valid options are `Number` and `String`. Defaults to a `Long` object type
 *     from a library.
 * @param options.enums The type that should be used to represent `enum` values.
 *     The only valid option is `String`. Defaults to the numeric value.
 * @param options.bytes The type that should be used to represent `bytes`
 *     values. Valid options are `Array` and `String`. The default is to use
 *     `Buffer`.
 * @param options.defaults Set default values on output objects. Defaults to
 *     `false`.
 * @param options.arrays Set empty arrays for missing array values even if
 *     `defaults` is `false`. Defaults to `false`.
 * @param options.objects Set empty objects for missing object values even if
 *     `defaults` is `false`. Defaults to `false`.
 * @param options.oneofs Set virtual oneof properties to the present field's
 *     name
 * @param options.json Represent Infinity and NaN as strings in float fields,
 *     and automatically decode google.protobuf.Any values.
 * @param options.includeDirs Paths to search for imported `.proto` files.
 */ function load(filename, options) {
    return (0, util_1.loadProtosWithOptions)(filename, options).then((loadedRoot)=>{
        return createPackageDefinition(loadedRoot, options);
    });
}
exports.load = load;
function loadSync(filename, options) {
    const loadedRoot = (0, util_1.loadProtosWithOptionsSync)(filename, options);
    return createPackageDefinition(loadedRoot, options);
}
exports.loadSync = loadSync;
function fromJSON(json, options) {
    options = options || {};
    const loadedRoot = Protobuf.Root.fromJSON(json);
    loadedRoot.resolveAll();
    return createPackageDefinition(loadedRoot, options);
}
exports.fromJSON = fromJSON;
function loadFileDescriptorSetFromBuffer(descriptorSet, options) {
    const decodedDescriptorSet = descriptor.FileDescriptorSet.decode(descriptorSet);
    return createPackageDefinitionFromDescriptorSet(decodedDescriptorSet, options);
}
exports.loadFileDescriptorSetFromBuffer = loadFileDescriptorSetFromBuffer;
function loadFileDescriptorSetFromObject(descriptorSet, options) {
    const decodedDescriptorSet = descriptor.FileDescriptorSet.fromObject(descriptorSet);
    return createPackageDefinitionFromDescriptorSet(decodedDescriptorSet, options);
}
exports.loadFileDescriptorSetFromObject = loadFileDescriptorSetFromObject;
(0, util_1.addCommonProtos)(); //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/long/umd/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// GENERATED FILE. DO NOT EDIT.
var Long = function(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = void 0;
    /**
   * @license
   * Copyright 2009 The Closure Library Authors
   * Copyright 2020 Daniel Wirtz / The long.js Authors.
   *
   * Licensed under the Apache License, Version 2.0 (the "License");
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   *
   * SPDX-License-Identifier: Apache-2.0
   */ // WebAssembly optimizations to do native i64 multiplication and divide
    var wasm = null;
    try {
        wasm = new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([
            // \0asm
            0,
            97,
            115,
            109,
            // version 1
            1,
            0,
            0,
            0,
            // section "type"
            1,
            13,
            2,
            // 0, () => i32
            96,
            0,
            1,
            127,
            // 1, (i32, i32, i32, i32) => i32
            96,
            4,
            127,
            127,
            127,
            127,
            1,
            127,
            // section "function"
            3,
            7,
            6,
            // 0, type 0
            0,
            // 1, type 1
            1,
            // 2, type 1
            1,
            // 3, type 1
            1,
            // 4, type 1
            1,
            // 5, type 1
            1,
            // section "global"
            6,
            6,
            1,
            // 0, "high", mutable i32
            127,
            1,
            65,
            0,
            11,
            // section "export"
            7,
            50,
            6,
            // 0, "mul"
            3,
            109,
            117,
            108,
            0,
            1,
            // 1, "div_s"
            5,
            100,
            105,
            118,
            95,
            115,
            0,
            2,
            // 2, "div_u"
            5,
            100,
            105,
            118,
            95,
            117,
            0,
            3,
            // 3, "rem_s"
            5,
            114,
            101,
            109,
            95,
            115,
            0,
            4,
            // 4, "rem_u"
            5,
            114,
            101,
            109,
            95,
            117,
            0,
            5,
            // 5, "get_high"
            8,
            103,
            101,
            116,
            95,
            104,
            105,
            103,
            104,
            0,
            0,
            // section "code"
            10,
            191,
            1,
            6,
            // 0, "get_high"
            4,
            0,
            35,
            0,
            11,
            // 1, "mul"
            36,
            1,
            1,
            126,
            32,
            0,
            173,
            32,
            1,
            173,
            66,
            32,
            134,
            132,
            32,
            2,
            173,
            32,
            3,
            173,
            66,
            32,
            134,
            132,
            126,
            34,
            4,
            66,
            32,
            135,
            167,
            36,
            0,
            32,
            4,
            167,
            11,
            // 2, "div_s"
            36,
            1,
            1,
            126,
            32,
            0,
            173,
            32,
            1,
            173,
            66,
            32,
            134,
            132,
            32,
            2,
            173,
            32,
            3,
            173,
            66,
            32,
            134,
            132,
            127,
            34,
            4,
            66,
            32,
            135,
            167,
            36,
            0,
            32,
            4,
            167,
            11,
            // 3, "div_u"
            36,
            1,
            1,
            126,
            32,
            0,
            173,
            32,
            1,
            173,
            66,
            32,
            134,
            132,
            32,
            2,
            173,
            32,
            3,
            173,
            66,
            32,
            134,
            132,
            128,
            34,
            4,
            66,
            32,
            135,
            167,
            36,
            0,
            32,
            4,
            167,
            11,
            // 4, "rem_s"
            36,
            1,
            1,
            126,
            32,
            0,
            173,
            32,
            1,
            173,
            66,
            32,
            134,
            132,
            32,
            2,
            173,
            32,
            3,
            173,
            66,
            32,
            134,
            132,
            129,
            34,
            4,
            66,
            32,
            135,
            167,
            36,
            0,
            32,
            4,
            167,
            11,
            // 5, "rem_u"
            36,
            1,
            1,
            126,
            32,
            0,
            173,
            32,
            1,
            173,
            66,
            32,
            134,
            132,
            32,
            2,
            173,
            32,
            3,
            173,
            66,
            32,
            134,
            132,
            130,
            34,
            4,
            66,
            32,
            135,
            167,
            36,
            0,
            32,
            4,
            167,
            11
        ])), {}).exports;
    } catch  {
    // no wasm support :(
    }
    /**
   * Constructs a 64 bit two's-complement integer, given its low and high 32 bit values as *signed* integers.
   *  See the from* functions below for more convenient ways of constructing Longs.
   * @exports Long
   * @class A Long class for representing a 64 bit two's-complement integer value.
   * @param {number} low The low (signed) 32 bits of the long
   * @param {number} high The high (signed) 32 bits of the long
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @constructor
   */ function Long(low, high, unsigned) {
        /**
     * The low 32 bits as a signed value.
     * @type {number}
     */ this.low = low | 0;
        /**
     * The high 32 bits as a signed value.
     * @type {number}
     */ this.high = high | 0;
        /**
     * Whether unsigned or not.
     * @type {boolean}
     */ this.unsigned = !!unsigned;
    }
    // The internal representation of a long is the two given signed, 32-bit values.
    // We use 32-bit pieces because these are the size of integers on which
    // Javascript performs bit-operations.  For operations like addition and
    // multiplication, we split each number into 16 bit pieces, which can easily be
    // multiplied within Javascript's floating-point representation without overflow
    // or change in sign.
    //
    // In the algorithms below, we frequently reduce the negative case to the
    // positive case by negating the input(s) and then post-processing the result.
    // Note that we must ALWAYS check specially whether those values are MIN_VALUE
    // (-2^63) because -MIN_VALUE == MIN_VALUE (since 2^63 cannot be represented as
    // a positive number, it overflows back into a negative).  Not handling this
    // case would often result in infinite recursion.
    //
    // Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the from*
    // methods on which they depend.
    /**
   * An indicator used to reliably determine if an object is a Long or not.
   * @type {boolean}
   * @const
   * @private
   */ Long.prototype.__isLong__;
    Object.defineProperty(Long.prototype, "__isLong__", {
        value: true
    });
    /**
   * @function
   * @param {*} obj Object
   * @returns {boolean}
   * @inner
   */ function isLong(obj) {
        return (obj && obj["__isLong__"]) === true;
    }
    /**
   * @function
   * @param {*} value number
   * @returns {number}
   * @inner
   */ function ctz32(value) {
        var c = Math.clz32(value & -value);
        return value ? 31 - c : c;
    }
    /**
   * Tests if the specified object is a Long.
   * @function
   * @param {*} obj Object
   * @returns {boolean}
   */ Long.isLong = isLong;
    /**
   * A cache of the Long representations of small integer values.
   * @type {!Object}
   * @inner
   */ var INT_CACHE = {};
    /**
   * A cache of the Long representations of small unsigned integer values.
   * @type {!Object}
   * @inner
   */ var UINT_CACHE = {};
    /**
   * @param {number} value
   * @param {boolean=} unsigned
   * @returns {!Long}
   * @inner
   */ function fromInt(value, unsigned) {
        var obj, cachedObj, cache;
        if (unsigned) {
            value >>>= 0;
            if (cache = 0 <= value && value < 256) {
                cachedObj = UINT_CACHE[value];
                if (cachedObj) return cachedObj;
            }
            obj = fromBits(value, 0, true);
            if (cache) UINT_CACHE[value] = obj;
            return obj;
        } else {
            value |= 0;
            if (cache = -128 <= value && value < 128) {
                cachedObj = INT_CACHE[value];
                if (cachedObj) return cachedObj;
            }
            obj = fromBits(value, value < 0 ? -1 : 0, false);
            if (cache) INT_CACHE[value] = obj;
            return obj;
        }
    }
    /**
   * Returns a Long representing the given 32 bit integer value.
   * @function
   * @param {number} value The 32 bit integer in question
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @returns {!Long} The corresponding Long value
   */ Long.fromInt = fromInt;
    /**
   * @param {number} value
   * @param {boolean=} unsigned
   * @returns {!Long}
   * @inner
   */ function fromNumber(value, unsigned) {
        if (isNaN(value)) return unsigned ? UZERO : ZERO;
        if (unsigned) {
            if (value < 0) return UZERO;
            if (value >= TWO_PWR_64_DBL) return MAX_UNSIGNED_VALUE;
        } else {
            if (value <= -TWO_PWR_63_DBL) return MIN_VALUE;
            if (value + 1 >= TWO_PWR_63_DBL) return MAX_VALUE;
        }
        if (value < 0) return fromNumber(-value, unsigned).neg();
        return fromBits(value % TWO_PWR_32_DBL | 0, value / TWO_PWR_32_DBL | 0, unsigned);
    }
    /**
   * Returns a Long representing the given value, provided that it is a finite number. Otherwise, zero is returned.
   * @function
   * @param {number} value The number in question
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @returns {!Long} The corresponding Long value
   */ Long.fromNumber = fromNumber;
    /**
   * @param {number} lowBits
   * @param {number} highBits
   * @param {boolean=} unsigned
   * @returns {!Long}
   * @inner
   */ function fromBits(lowBits, highBits, unsigned) {
        return new Long(lowBits, highBits, unsigned);
    }
    /**
   * Returns a Long representing the 64 bit integer that comes by concatenating the given low and high bits. Each is
   *  assumed to use 32 bits.
   * @function
   * @param {number} lowBits The low 32 bits
   * @param {number} highBits The high 32 bits
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @returns {!Long} The corresponding Long value
   */ Long.fromBits = fromBits;
    /**
   * @function
   * @param {number} base
   * @param {number} exponent
   * @returns {number}
   * @inner
   */ var pow_dbl = Math.pow; // Used 4 times (4*8 to 15+4)
    /**
   * @param {string} str
   * @param {(boolean|number)=} unsigned
   * @param {number=} radix
   * @returns {!Long}
   * @inner
   */ function fromString(str, unsigned, radix) {
        if (str.length === 0) throw Error('empty string');
        if (typeof unsigned === 'number') {
            // For goog.math.long compatibility
            radix = unsigned;
            unsigned = false;
        } else {
            unsigned = !!unsigned;
        }
        if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity") return unsigned ? UZERO : ZERO;
        radix = radix || 10;
        if (radix < 2 || 36 < radix) throw RangeError('radix');
        var p;
        if ((p = str.indexOf('-')) > 0) throw Error('interior hyphen');
        else if (p === 0) {
            return fromString(str.substring(1), unsigned, radix).neg();
        }
        // Do several (8) digits each time through the loop, so as to
        // minimize the calls to the very expensive emulated div.
        var radixToPower = fromNumber(pow_dbl(radix, 8));
        var result = ZERO;
        for(var i = 0; i < str.length; i += 8){
            var size = Math.min(8, str.length - i), value = parseInt(str.substring(i, i + size), radix);
            if (size < 8) {
                var power = fromNumber(pow_dbl(radix, size));
                result = result.mul(power).add(fromNumber(value));
            } else {
                result = result.mul(radixToPower);
                result = result.add(fromNumber(value));
            }
        }
        result.unsigned = unsigned;
        return result;
    }
    /**
   * Returns a Long representation of the given string, written using the specified radix.
   * @function
   * @param {string} str The textual representation of the Long
   * @param {(boolean|number)=} unsigned Whether unsigned or not, defaults to signed
   * @param {number=} radix The radix in which the text is written (2-36), defaults to 10
   * @returns {!Long} The corresponding Long value
   */ Long.fromString = fromString;
    /**
   * @function
   * @param {!Long|number|string|!{low: number, high: number, unsigned: boolean}} val
   * @param {boolean=} unsigned
   * @returns {!Long}
   * @inner
   */ function fromValue(val, unsigned) {
        if (typeof val === 'number') return fromNumber(val, unsigned);
        if (typeof val === 'string') return fromString(val, unsigned);
        // Throws for non-objects, converts non-instanceof Long:
        return fromBits(val.low, val.high, typeof unsigned === 'boolean' ? unsigned : val.unsigned);
    }
    /**
   * Converts the specified value to a Long using the appropriate from* function for its type.
   * @function
   * @param {!Long|number|bigint|string|!{low: number, high: number, unsigned: boolean}} val Value
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @returns {!Long}
   */ Long.fromValue = fromValue;
    // NOTE: the compiler should inline these constant values below and then remove these variables, so there should be
    // no runtime penalty for these.
    /**
   * @type {number}
   * @const
   * @inner
   */ var TWO_PWR_16_DBL = 1 << 16;
    /**
   * @type {number}
   * @const
   * @inner
   */ var TWO_PWR_24_DBL = 1 << 24;
    /**
   * @type {number}
   * @const
   * @inner
   */ var TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;
    /**
   * @type {number}
   * @const
   * @inner
   */ var TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;
    /**
   * @type {number}
   * @const
   * @inner
   */ var TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;
    /**
   * @type {!Long}
   * @const
   * @inner
   */ var TWO_PWR_24 = fromInt(TWO_PWR_24_DBL);
    /**
   * @type {!Long}
   * @inner
   */ var ZERO = fromInt(0);
    /**
   * Signed zero.
   * @type {!Long}
   */ Long.ZERO = ZERO;
    /**
   * @type {!Long}
   * @inner
   */ var UZERO = fromInt(0, true);
    /**
   * Unsigned zero.
   * @type {!Long}
   */ Long.UZERO = UZERO;
    /**
   * @type {!Long}
   * @inner
   */ var ONE = fromInt(1);
    /**
   * Signed one.
   * @type {!Long}
   */ Long.ONE = ONE;
    /**
   * @type {!Long}
   * @inner
   */ var UONE = fromInt(1, true);
    /**
   * Unsigned one.
   * @type {!Long}
   */ Long.UONE = UONE;
    /**
   * @type {!Long}
   * @inner
   */ var NEG_ONE = fromInt(-1);
    /**
   * Signed negative one.
   * @type {!Long}
   */ Long.NEG_ONE = NEG_ONE;
    /**
   * @type {!Long}
   * @inner
   */ var MAX_VALUE = fromBits(0xFFFFFFFF | 0, 0x7FFFFFFF | 0, false);
    /**
   * Maximum signed value.
   * @type {!Long}
   */ Long.MAX_VALUE = MAX_VALUE;
    /**
   * @type {!Long}
   * @inner
   */ var MAX_UNSIGNED_VALUE = fromBits(0xFFFFFFFF | 0, 0xFFFFFFFF | 0, true);
    /**
   * Maximum unsigned value.
   * @type {!Long}
   */ Long.MAX_UNSIGNED_VALUE = MAX_UNSIGNED_VALUE;
    /**
   * @type {!Long}
   * @inner
   */ var MIN_VALUE = fromBits(0, 0x80000000 | 0, false);
    /**
   * Minimum signed value.
   * @type {!Long}
   */ Long.MIN_VALUE = MIN_VALUE;
    /**
   * @alias Long.prototype
   * @inner
   */ var LongPrototype = Long.prototype;
    /**
   * Converts the Long to a 32 bit integer, assuming it is a 32 bit integer.
   * @this {!Long}
   * @returns {number}
   */ LongPrototype.toInt = function toInt() {
        return this.unsigned ? this.low >>> 0 : this.low;
    };
    /**
   * Converts the Long to a the nearest floating-point representation of this value (double, 53 bit mantissa).
   * @this {!Long}
   * @returns {number}
   */ LongPrototype.toNumber = function toNumber() {
        if (this.unsigned) return (this.high >>> 0) * TWO_PWR_32_DBL + (this.low >>> 0);
        return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
    };
    /**
   * Converts the Long to a string written in the specified radix.
   * @this {!Long}
   * @param {number=} radix Radix (2-36), defaults to 10
   * @returns {string}
   * @override
   * @throws {RangeError} If `radix` is out of range
   */ LongPrototype.toString = function toString(radix) {
        radix = radix || 10;
        if (radix < 2 || 36 < radix) throw RangeError('radix');
        if (this.isZero()) return '0';
        if (this.isNegative()) {
            // Unsigned Longs are never negative
            if (this.eq(MIN_VALUE)) {
                // We need to change the Long value before it can be negated, so we remove
                // the bottom-most digit in this base and then recurse to do the rest.
                var radixLong = fromNumber(radix), div = this.div(radixLong), rem1 = div.mul(radixLong).sub(this);
                return div.toString(radix) + rem1.toInt().toString(radix);
            } else return '-' + this.neg().toString(radix);
        }
        // Do several (6) digits each time through the loop, so as to
        // minimize the calls to the very expensive emulated div.
        var radixToPower = fromNumber(pow_dbl(radix, 6), this.unsigned), rem = this;
        var result = '';
        while(true){
            var remDiv = rem.div(radixToPower), intval = rem.sub(remDiv.mul(radixToPower)).toInt() >>> 0, digits = intval.toString(radix);
            rem = remDiv;
            if (rem.isZero()) return digits + result;
            else {
                while(digits.length < 6)digits = '0' + digits;
                result = '' + digits + result;
            }
        }
    };
    /**
   * Gets the high 32 bits as a signed integer.
   * @this {!Long}
   * @returns {number} Signed high bits
   */ LongPrototype.getHighBits = function getHighBits() {
        return this.high;
    };
    /**
   * Gets the high 32 bits as an unsigned integer.
   * @this {!Long}
   * @returns {number} Unsigned high bits
   */ LongPrototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
        return this.high >>> 0;
    };
    /**
   * Gets the low 32 bits as a signed integer.
   * @this {!Long}
   * @returns {number} Signed low bits
   */ LongPrototype.getLowBits = function getLowBits() {
        return this.low;
    };
    /**
   * Gets the low 32 bits as an unsigned integer.
   * @this {!Long}
   * @returns {number} Unsigned low bits
   */ LongPrototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
        return this.low >>> 0;
    };
    /**
   * Gets the number of bits needed to represent the absolute value of this Long.
   * @this {!Long}
   * @returns {number}
   */ LongPrototype.getNumBitsAbs = function getNumBitsAbs() {
        if (this.isNegative()) // Unsigned Longs are never negative
        return this.eq(MIN_VALUE) ? 64 : this.neg().getNumBitsAbs();
        var val = this.high != 0 ? this.high : this.low;
        for(var bit = 31; bit > 0; bit--)if ((val & 1 << bit) != 0) break;
        return this.high != 0 ? bit + 33 : bit + 1;
    };
    /**
   * Tests if this Long can be safely represented as a JavaScript number.
   * @this {!Long}
   * @returns {boolean}
   */ LongPrototype.isSafeInteger = function isSafeInteger() {
        // 2^53-1 is the maximum safe value
        var top11Bits = this.high >> 21;
        // [0, 2^53-1]
        if (!top11Bits) return true;
        // > 2^53-1
        if (this.unsigned) return false;
        // [-2^53, -1] except -2^53
        return top11Bits === -1 && !(this.low === 0 && this.high === -0x200000);
    };
    /**
   * Tests if this Long's value equals zero.
   * @this {!Long}
   * @returns {boolean}
   */ LongPrototype.isZero = function isZero() {
        return this.high === 0 && this.low === 0;
    };
    /**
   * Tests if this Long's value equals zero. This is an alias of {@link Long#isZero}.
   * @returns {boolean}
   */ LongPrototype.eqz = LongPrototype.isZero;
    /**
   * Tests if this Long's value is negative.
   * @this {!Long}
   * @returns {boolean}
   */ LongPrototype.isNegative = function isNegative() {
        return !this.unsigned && this.high < 0;
    };
    /**
   * Tests if this Long's value is positive or zero.
   * @this {!Long}
   * @returns {boolean}
   */ LongPrototype.isPositive = function isPositive() {
        return this.unsigned || this.high >= 0;
    };
    /**
   * Tests if this Long's value is odd.
   * @this {!Long}
   * @returns {boolean}
   */ LongPrototype.isOdd = function isOdd() {
        return (this.low & 1) === 1;
    };
    /**
   * Tests if this Long's value is even.
   * @this {!Long}
   * @returns {boolean}
   */ LongPrototype.isEven = function isEven() {
        return (this.low & 1) === 0;
    };
    /**
   * Tests if this Long's value equals the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.equals = function equals(other) {
        if (!isLong(other)) other = fromValue(other);
        if (this.unsigned !== other.unsigned && this.high >>> 31 === 1 && other.high >>> 31 === 1) return false;
        return this.high === other.high && this.low === other.low;
    };
    /**
   * Tests if this Long's value equals the specified's. This is an alias of {@link Long#equals}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.eq = LongPrototype.equals;
    /**
   * Tests if this Long's value differs from the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.notEquals = function notEquals(other) {
        return !this.eq(/* validates */ other);
    };
    /**
   * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.neq = LongPrototype.notEquals;
    /**
   * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.ne = LongPrototype.notEquals;
    /**
   * Tests if this Long's value is less than the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.lessThan = function lessThan(other) {
        return this.comp(/* validates */ other) < 0;
    };
    /**
   * Tests if this Long's value is less than the specified's. This is an alias of {@link Long#lessThan}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.lt = LongPrototype.lessThan;
    /**
   * Tests if this Long's value is less than or equal the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.lessThanOrEqual = function lessThanOrEqual(other) {
        return this.comp(/* validates */ other) <= 0;
    };
    /**
   * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.lte = LongPrototype.lessThanOrEqual;
    /**
   * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.le = LongPrototype.lessThanOrEqual;
    /**
   * Tests if this Long's value is greater than the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.greaterThan = function greaterThan(other) {
        return this.comp(/* validates */ other) > 0;
    };
    /**
   * Tests if this Long's value is greater than the specified's. This is an alias of {@link Long#greaterThan}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.gt = LongPrototype.greaterThan;
    /**
   * Tests if this Long's value is greater than or equal the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
        return this.comp(/* validates */ other) >= 0;
    };
    /**
   * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.gte = LongPrototype.greaterThanOrEqual;
    /**
   * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {boolean}
   */ LongPrototype.ge = LongPrototype.greaterThanOrEqual;
    /**
   * Compares this Long's value with the specified's.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other value
   * @returns {number} 0 if they are the same, 1 if the this is greater and -1
   *  if the given one is greater
   */ LongPrototype.compare = function compare(other) {
        if (!isLong(other)) other = fromValue(other);
        if (this.eq(other)) return 0;
        var thisNeg = this.isNegative(), otherNeg = other.isNegative();
        if (thisNeg && !otherNeg) return -1;
        if (!thisNeg && otherNeg) return 1;
        // At this point the sign bits are the same
        if (!this.unsigned) return this.sub(other).isNegative() ? -1 : 1;
        // Both are positive if at least one is unsigned
        return other.high >>> 0 > this.high >>> 0 || other.high === this.high && other.low >>> 0 > this.low >>> 0 ? -1 : 1;
    };
    /**
   * Compares this Long's value with the specified's. This is an alias of {@link Long#compare}.
   * @function
   * @param {!Long|number|bigint|string} other Other value
   * @returns {number} 0 if they are the same, 1 if the this is greater and -1
   *  if the given one is greater
   */ LongPrototype.comp = LongPrototype.compare;
    /**
   * Negates this Long's value.
   * @this {!Long}
   * @returns {!Long} Negated Long
   */ LongPrototype.negate = function negate() {
        if (!this.unsigned && this.eq(MIN_VALUE)) return MIN_VALUE;
        return this.not().add(ONE);
    };
    /**
   * Negates this Long's value. This is an alias of {@link Long#negate}.
   * @function
   * @returns {!Long} Negated Long
   */ LongPrototype.neg = LongPrototype.negate;
    /**
   * Returns the sum of this and the specified Long.
   * @this {!Long}
   * @param {!Long|number|bigint|string} addend Addend
   * @returns {!Long} Sum
   */ LongPrototype.add = function add(addend) {
        if (!isLong(addend)) addend = fromValue(addend);
        // Divide each number into 4 chunks of 16 bits, and then sum the chunks.
        var a48 = this.high >>> 16;
        var a32 = this.high & 0xFFFF;
        var a16 = this.low >>> 16;
        var a00 = this.low & 0xFFFF;
        var b48 = addend.high >>> 16;
        var b32 = addend.high & 0xFFFF;
        var b16 = addend.low >>> 16;
        var b00 = addend.low & 0xFFFF;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 + b00;
        c16 += c00 >>> 16;
        c00 &= 0xFFFF;
        c16 += a16 + b16;
        c32 += c16 >>> 16;
        c16 &= 0xFFFF;
        c32 += a32 + b32;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c48 += a48 + b48;
        c48 &= 0xFFFF;
        return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
    };
    /**
   * Returns the difference of this and the specified Long.
   * @this {!Long}
   * @param {!Long|number|bigint|string} subtrahend Subtrahend
   * @returns {!Long} Difference
   */ LongPrototype.subtract = function subtract(subtrahend) {
        if (!isLong(subtrahend)) subtrahend = fromValue(subtrahend);
        return this.add(subtrahend.neg());
    };
    /**
   * Returns the difference of this and the specified Long. This is an alias of {@link Long#subtract}.
   * @function
   * @param {!Long|number|bigint|string} subtrahend Subtrahend
   * @returns {!Long} Difference
   */ LongPrototype.sub = LongPrototype.subtract;
    /**
   * Returns the product of this and the specified Long.
   * @this {!Long}
   * @param {!Long|number|bigint|string} multiplier Multiplier
   * @returns {!Long} Product
   */ LongPrototype.multiply = function multiply(multiplier) {
        if (this.isZero()) return this;
        if (!isLong(multiplier)) multiplier = fromValue(multiplier);
        // use wasm support if present
        if (wasm) {
            var low = wasm["mul"](this.low, this.high, multiplier.low, multiplier.high);
            return fromBits(low, wasm["get_high"](), this.unsigned);
        }
        if (multiplier.isZero()) return this.unsigned ? UZERO : ZERO;
        if (this.eq(MIN_VALUE)) return multiplier.isOdd() ? MIN_VALUE : ZERO;
        if (multiplier.eq(MIN_VALUE)) return this.isOdd() ? MIN_VALUE : ZERO;
        if (this.isNegative()) {
            if (multiplier.isNegative()) return this.neg().mul(multiplier.neg());
            else return this.neg().mul(multiplier).neg();
        } else if (multiplier.isNegative()) return this.mul(multiplier.neg()).neg();
        // If both longs are small, use float multiplication
        if (this.lt(TWO_PWR_24) && multiplier.lt(TWO_PWR_24)) return fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned);
        // Divide each long into 4 chunks of 16 bits, and then add up 4x4 products.
        // We can skip products that would overflow.
        var a48 = this.high >>> 16;
        var a32 = this.high & 0xFFFF;
        var a16 = this.low >>> 16;
        var a00 = this.low & 0xFFFF;
        var b48 = multiplier.high >>> 16;
        var b32 = multiplier.high & 0xFFFF;
        var b16 = multiplier.low >>> 16;
        var b00 = multiplier.low & 0xFFFF;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 * b00;
        c16 += c00 >>> 16;
        c00 &= 0xFFFF;
        c16 += a16 * b00;
        c32 += c16 >>> 16;
        c16 &= 0xFFFF;
        c16 += a00 * b16;
        c32 += c16 >>> 16;
        c16 &= 0xFFFF;
        c32 += a32 * b00;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c32 += a16 * b16;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c32 += a00 * b32;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
        c48 &= 0xFFFF;
        return fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
    };
    /**
   * Returns the product of this and the specified Long. This is an alias of {@link Long#multiply}.
   * @function
   * @param {!Long|number|bigint|string} multiplier Multiplier
   * @returns {!Long} Product
   */ LongPrototype.mul = LongPrototype.multiply;
    /**
   * Returns this Long divided by the specified. The result is signed if this Long is signed or
   *  unsigned if this Long is unsigned.
   * @this {!Long}
   * @param {!Long|number|bigint|string} divisor Divisor
   * @returns {!Long} Quotient
   */ LongPrototype.divide = function divide(divisor) {
        if (!isLong(divisor)) divisor = fromValue(divisor);
        if (divisor.isZero()) throw Error('division by zero');
        // use wasm support if present
        if (wasm) {
            // guard against signed division overflow: the largest
            // negative number / -1 would be 1 larger than the largest
            // positive number, due to two's complement.
            if (!this.unsigned && this.high === -0x80000000 && divisor.low === -1 && divisor.high === -1) {
                // be consistent with non-wasm code path
                return this;
            }
            var low = (this.unsigned ? wasm["div_u"] : wasm["div_s"])(this.low, this.high, divisor.low, divisor.high);
            return fromBits(low, wasm["get_high"](), this.unsigned);
        }
        if (this.isZero()) return this.unsigned ? UZERO : ZERO;
        var approx, rem, res;
        if (!this.unsigned) {
            // This section is only relevant for signed longs and is derived from the
            // closure library as a whole.
            if (this.eq(MIN_VALUE)) {
                if (divisor.eq(ONE) || divisor.eq(NEG_ONE)) return MIN_VALUE; // recall that -MIN_VALUE == MIN_VALUE
                else if (divisor.eq(MIN_VALUE)) return ONE;
                else {
                    // At this point, we have |other| >= 2, so |this/other| < |MIN_VALUE|.
                    var halfThis = this.shr(1);
                    approx = halfThis.div(divisor).shl(1);
                    if (approx.eq(ZERO)) {
                        return divisor.isNegative() ? ONE : NEG_ONE;
                    } else {
                        rem = this.sub(divisor.mul(approx));
                        res = approx.add(rem.div(divisor));
                        return res;
                    }
                }
            } else if (divisor.eq(MIN_VALUE)) return this.unsigned ? UZERO : ZERO;
            if (this.isNegative()) {
                if (divisor.isNegative()) return this.neg().div(divisor.neg());
                return this.neg().div(divisor).neg();
            } else if (divisor.isNegative()) return this.div(divisor.neg()).neg();
            res = ZERO;
        } else {
            // The algorithm below has not been made for unsigned longs. It's therefore
            // required to take special care of the MSB prior to running it.
            if (!divisor.unsigned) divisor = divisor.toUnsigned();
            if (divisor.gt(this)) return UZERO;
            if (divisor.gt(this.shru(1))) // 15 >>> 1 = 7 ; with divisor = 8 ; true
            return UONE;
            res = UZERO;
        }
        // Repeat the following until the remainder is less than other:  find a
        // floating-point that approximates remainder / other *from below*, add this
        // into the result, and subtract it from the remainder.  It is critical that
        // the approximate value is less than or equal to the real value so that the
        // remainder never becomes negative.
        rem = this;
        while(rem.gte(divisor)){
            // Approximate the result of division. This may be a little greater or
            // smaller than the actual value.
            approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber()));
            // We will tweak the approximate result by changing it in the 48-th digit or
            // the smallest non-fractional digit, whichever is larger.
            var log2 = Math.ceil(Math.log(approx) / Math.LN2), delta = log2 <= 48 ? 1 : pow_dbl(2, log2 - 48), // Decrease the approximation until it is smaller than the remainder.  Note
            // that if it is too large, the product overflows and is negative.
            approxRes = fromNumber(approx), approxRem = approxRes.mul(divisor);
            while(approxRem.isNegative() || approxRem.gt(rem)){
                approx -= delta;
                approxRes = fromNumber(approx, this.unsigned);
                approxRem = approxRes.mul(divisor);
            }
            // We know the answer can't be zero... and actually, zero would cause
            // infinite recursion since we would make no progress.
            if (approxRes.isZero()) approxRes = ONE;
            res = res.add(approxRes);
            rem = rem.sub(approxRem);
        }
        return res;
    };
    /**
   * Returns this Long divided by the specified. This is an alias of {@link Long#divide}.
   * @function
   * @param {!Long|number|bigint|string} divisor Divisor
   * @returns {!Long} Quotient
   */ LongPrototype.div = LongPrototype.divide;
    /**
   * Returns this Long modulo the specified.
   * @this {!Long}
   * @param {!Long|number|bigint|string} divisor Divisor
   * @returns {!Long} Remainder
   */ LongPrototype.modulo = function modulo(divisor) {
        if (!isLong(divisor)) divisor = fromValue(divisor);
        // use wasm support if present
        if (wasm) {
            var low = (this.unsigned ? wasm["rem_u"] : wasm["rem_s"])(this.low, this.high, divisor.low, divisor.high);
            return fromBits(low, wasm["get_high"](), this.unsigned);
        }
        return this.sub(this.div(divisor).mul(divisor));
    };
    /**
   * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
   * @function
   * @param {!Long|number|bigint|string} divisor Divisor
   * @returns {!Long} Remainder
   */ LongPrototype.mod = LongPrototype.modulo;
    /**
   * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
   * @function
   * @param {!Long|number|bigint|string} divisor Divisor
   * @returns {!Long} Remainder
   */ LongPrototype.rem = LongPrototype.modulo;
    /**
   * Returns the bitwise NOT of this Long.
   * @this {!Long}
   * @returns {!Long}
   */ LongPrototype.not = function not() {
        return fromBits(~this.low, ~this.high, this.unsigned);
    };
    /**
   * Returns count leading zeros of this Long.
   * @this {!Long}
   * @returns {!number}
   */ LongPrototype.countLeadingZeros = function countLeadingZeros() {
        return this.high ? Math.clz32(this.high) : Math.clz32(this.low) + 32;
    };
    /**
   * Returns count leading zeros. This is an alias of {@link Long#countLeadingZeros}.
   * @function
   * @param {!Long}
   * @returns {!number}
   */ LongPrototype.clz = LongPrototype.countLeadingZeros;
    /**
   * Returns count trailing zeros of this Long.
   * @this {!Long}
   * @returns {!number}
   */ LongPrototype.countTrailingZeros = function countTrailingZeros() {
        return this.low ? ctz32(this.low) : ctz32(this.high) + 32;
    };
    /**
   * Returns count trailing zeros. This is an alias of {@link Long#countTrailingZeros}.
   * @function
   * @param {!Long}
   * @returns {!number}
   */ LongPrototype.ctz = LongPrototype.countTrailingZeros;
    /**
   * Returns the bitwise AND of this Long and the specified.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other Long
   * @returns {!Long}
   */ LongPrototype.and = function and(other) {
        if (!isLong(other)) other = fromValue(other);
        return fromBits(this.low & other.low, this.high & other.high, this.unsigned);
    };
    /**
   * Returns the bitwise OR of this Long and the specified.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other Long
   * @returns {!Long}
   */ LongPrototype.or = function or(other) {
        if (!isLong(other)) other = fromValue(other);
        return fromBits(this.low | other.low, this.high | other.high, this.unsigned);
    };
    /**
   * Returns the bitwise XOR of this Long and the given one.
   * @this {!Long}
   * @param {!Long|number|bigint|string} other Other Long
   * @returns {!Long}
   */ LongPrototype.xor = function xor(other) {
        if (!isLong(other)) other = fromValue(other);
        return fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
    };
    /**
   * Returns this Long with bits shifted to the left by the given amount.
   * @this {!Long}
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shiftLeft = function shiftLeft(numBits) {
        if (isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        else if (numBits < 32) return fromBits(this.low << numBits, this.high << numBits | this.low >>> 32 - numBits, this.unsigned);
        else return fromBits(0, this.low << numBits - 32, this.unsigned);
    };
    /**
   * Returns this Long with bits shifted to the left by the given amount. This is an alias of {@link Long#shiftLeft}.
   * @function
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shl = LongPrototype.shiftLeft;
    /**
   * Returns this Long with bits arithmetically shifted to the right by the given amount.
   * @this {!Long}
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shiftRight = function shiftRight(numBits) {
        if (isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        else if (numBits < 32) return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >> numBits, this.unsigned);
        else return fromBits(this.high >> numBits - 32, this.high >= 0 ? 0 : -1, this.unsigned);
    };
    /**
   * Returns this Long with bits arithmetically shifted to the right by the given amount. This is an alias of {@link Long#shiftRight}.
   * @function
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shr = LongPrototype.shiftRight;
    /**
   * Returns this Long with bits logically shifted to the right by the given amount.
   * @this {!Long}
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
        if (isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        if (numBits < 32) return fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >>> numBits, this.unsigned);
        if (numBits === 32) return fromBits(this.high, 0, this.unsigned);
        return fromBits(this.high >>> numBits - 32, 0, this.unsigned);
    };
    /**
   * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
   * @function
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shru = LongPrototype.shiftRightUnsigned;
    /**
   * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
   * @function
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Shifted Long
   */ LongPrototype.shr_u = LongPrototype.shiftRightUnsigned;
    /**
   * Returns this Long with bits rotated to the left by the given amount.
   * @this {!Long}
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Rotated Long
   */ LongPrototype.rotateLeft = function rotateLeft(numBits) {
        var b;
        if (isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        if (numBits === 32) return fromBits(this.high, this.low, this.unsigned);
        if (numBits < 32) {
            b = 32 - numBits;
            return fromBits(this.low << numBits | this.high >>> b, this.high << numBits | this.low >>> b, this.unsigned);
        }
        numBits -= 32;
        b = 32 - numBits;
        return fromBits(this.high << numBits | this.low >>> b, this.low << numBits | this.high >>> b, this.unsigned);
    };
    /**
   * Returns this Long with bits rotated to the left by the given amount. This is an alias of {@link Long#rotateLeft}.
   * @function
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Rotated Long
   */ LongPrototype.rotl = LongPrototype.rotateLeft;
    /**
   * Returns this Long with bits rotated to the right by the given amount.
   * @this {!Long}
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Rotated Long
   */ LongPrototype.rotateRight = function rotateRight(numBits) {
        var b;
        if (isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        if (numBits === 32) return fromBits(this.high, this.low, this.unsigned);
        if (numBits < 32) {
            b = 32 - numBits;
            return fromBits(this.high << b | this.low >>> numBits, this.low << b | this.high >>> numBits, this.unsigned);
        }
        numBits -= 32;
        b = 32 - numBits;
        return fromBits(this.low << b | this.high >>> numBits, this.high << b | this.low >>> numBits, this.unsigned);
    };
    /**
   * Returns this Long with bits rotated to the right by the given amount. This is an alias of {@link Long#rotateRight}.
   * @function
   * @param {number|!Long} numBits Number of bits
   * @returns {!Long} Rotated Long
   */ LongPrototype.rotr = LongPrototype.rotateRight;
    /**
   * Converts this Long to signed.
   * @this {!Long}
   * @returns {!Long} Signed long
   */ LongPrototype.toSigned = function toSigned() {
        if (!this.unsigned) return this;
        return fromBits(this.low, this.high, false);
    };
    /**
   * Converts this Long to unsigned.
   * @this {!Long}
   * @returns {!Long} Unsigned long
   */ LongPrototype.toUnsigned = function toUnsigned() {
        if (this.unsigned) return this;
        return fromBits(this.low, this.high, true);
    };
    /**
   * Converts this Long to its byte representation.
   * @param {boolean=} le Whether little or big endian, defaults to big endian
   * @this {!Long}
   * @returns {!Array.<number>} Byte representation
   */ LongPrototype.toBytes = function toBytes(le) {
        return le ? this.toBytesLE() : this.toBytesBE();
    };
    /**
   * Converts this Long to its little endian byte representation.
   * @this {!Long}
   * @returns {!Array.<number>} Little endian byte representation
   */ LongPrototype.toBytesLE = function toBytesLE() {
        var hi = this.high, lo = this.low;
        return [
            lo & 0xff,
            lo >>> 8 & 0xff,
            lo >>> 16 & 0xff,
            lo >>> 24,
            hi & 0xff,
            hi >>> 8 & 0xff,
            hi >>> 16 & 0xff,
            hi >>> 24
        ];
    };
    /**
   * Converts this Long to its big endian byte representation.
   * @this {!Long}
   * @returns {!Array.<number>} Big endian byte representation
   */ LongPrototype.toBytesBE = function toBytesBE() {
        var hi = this.high, lo = this.low;
        return [
            hi >>> 24,
            hi >>> 16 & 0xff,
            hi >>> 8 & 0xff,
            hi & 0xff,
            lo >>> 24,
            lo >>> 16 & 0xff,
            lo >>> 8 & 0xff,
            lo & 0xff
        ];
    };
    /**
   * Creates a Long from its byte representation.
   * @param {!Array.<number>} bytes Byte representation
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @param {boolean=} le Whether little or big endian, defaults to big endian
   * @returns {Long} The corresponding Long value
   */ Long.fromBytes = function fromBytes(bytes, unsigned, le) {
        return le ? Long.fromBytesLE(bytes, unsigned) : Long.fromBytesBE(bytes, unsigned);
    };
    /**
   * Creates a Long from its little endian byte representation.
   * @param {!Array.<number>} bytes Little endian byte representation
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @returns {Long} The corresponding Long value
   */ Long.fromBytesLE = function fromBytesLE(bytes, unsigned) {
        return new Long(bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[3] << 24, bytes[4] | bytes[5] << 8 | bytes[6] << 16 | bytes[7] << 24, unsigned);
    };
    /**
   * Creates a Long from its big endian byte representation.
   * @param {!Array.<number>} bytes Big endian byte representation
   * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
   * @returns {Long} The corresponding Long value
   */ Long.fromBytesBE = function fromBytesBE(bytes, unsigned) {
        return new Long(bytes[4] << 24 | bytes[5] << 16 | bytes[6] << 8 | bytes[7], bytes[0] << 24 | bytes[1] << 16 | bytes[2] << 8 | bytes[3], unsigned);
    };
    // Support conversion to/from BigInt where available
    if (typeof BigInt === "function") {
        /**
     * Returns a Long representing the given big integer.
     * @function
     * @param {number} value The big integer value
     * @param {boolean=} unsigned Whether unsigned or not, defaults to signed
     * @returns {!Long} The corresponding Long value
     */ Long.fromBigInt = function fromBigInt1(value, unsigned) {
            var lowBits = Number(BigInt.asIntN(32, value));
            var highBits = Number(BigInt.asIntN(32, value >> BigInt(32)));
            return fromBits(lowBits, highBits, unsigned);
        };
        // Override
        Long.fromValue = function fromValueWithBigInt(value, unsigned) {
            if (typeof value === "bigint") return fromBigInt(value, unsigned);
            return fromValue(value, unsigned);
        };
        /**
     * Converts the Long to its big integer representation.
     * @this {!Long}
     * @returns {bigint}
     */ LongPrototype.toBigInt = function toBigInt() {
            var lowBigInt = BigInt(this.low >>> 0);
            var highBigInt = BigInt(this.unsigned ? this.high >>> 0 : this.high);
            return highBigInt << BigInt(32) | lowBigInt;
        };
    }
    var _default = exports.default = Long;
    return "default" in exports ? exports.default : exports;
}({});
if (typeof define === 'function' && define.amd) ((r)=>r !== undefined && __turbopack_context__.v(r))(function() {
    return Long;
}());
else if ("TURBOPACK compile-time truthy", 1) module.exports = Long;
}}),
"[project]/node_modules/thriftrw/node_modules/long/dist/Long.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/*
 Copyright 2013 Daniel Wirtz <dcode@dcode.io>
 Copyright 2009 The Closure Library Authors. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS-IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */ /**
 * @license Long.js (c) 2013 Daniel Wirtz <dcode@dcode.io>
 * Released under the Apache License, Version 2.0
 * see: https://github.com/dcodeIO/Long.js for details
 */ (function(global, factory) {
    /* AMD */ if (typeof define === 'function' && define["amd"]) ((r)=>r !== undefined && __turbopack_context__.v(r))(factory());
    else if (("TURBOPACK compile-time value", "function") === 'function' && ("TURBOPACK compile-time value", "object") === "object" && module && module["exports"]) module["exports"] = factory();
    else (global["dcodeIO"] = global["dcodeIO"] || {})["Long"] = factory();
})(this, function() {
    "use strict";
    /**
     * Constructs a 64 bit two's-complement integer, given its low and high 32 bit values as *signed* integers.
     *  See the from* functions below for more convenient ways of constructing Longs.
     * @exports Long
     * @class A Long class for representing a 64 bit two's-complement integer value.
     * @param {number} low The low (signed) 32 bits of the long
     * @param {number} high The high (signed) 32 bits of the long
     * @param {boolean=} unsigned Whether unsigned or not, defaults to `false` for signed
     * @constructor
     */ function Long(low, high, unsigned) {
        /**
         * The low 32 bits as a signed value.
         * @type {number}
         * @expose
         */ this.low = low | 0;
        /**
         * The high 32 bits as a signed value.
         * @type {number}
         * @expose
         */ this.high = high | 0;
        /**
         * Whether unsigned or not.
         * @type {boolean}
         * @expose
         */ this.unsigned = !!unsigned;
    }
    // The internal representation of a long is the two given signed, 32-bit values.
    // We use 32-bit pieces because these are the size of integers on which
    // Javascript performs bit-operations.  For operations like addition and
    // multiplication, we split each number into 16 bit pieces, which can easily be
    // multiplied within Javascript's floating-point representation without overflow
    // or change in sign.
    //
    // In the algorithms below, we frequently reduce the negative case to the
    // positive case by negating the input(s) and then post-processing the result.
    // Note that we must ALWAYS check specially whether those values are MIN_VALUE
    // (-2^63) because -MIN_VALUE == MIN_VALUE (since 2^63 cannot be represented as
    // a positive number, it overflows back into a negative).  Not handling this
    // case would often result in infinite recursion.
    //
    // Common constant values ZERO, ONE, NEG_ONE, etc. are defined below the from*
    // methods on which they depend.
    /**
     * An indicator used to reliably determine if an object is a Long or not.
     * @type {boolean}
     * @const
     * @expose
     * @private
     */ Long.__isLong__;
    Object.defineProperty(Long.prototype, "__isLong__", {
        value: true,
        enumerable: false,
        configurable: false
    });
    /**
     * Tests if the specified object is a Long.
     * @param {*} obj Object
     * @returns {boolean}
     * @expose
     */ Long.isLong = function isLong(obj) {
        return (obj && obj["__isLong__"]) === true;
    };
    /**
     * A cache of the Long representations of small integer values.
     * @type {!Object}
     * @inner
     */ var INT_CACHE = {};
    /**
     * A cache of the Long representations of small unsigned integer values.
     * @type {!Object}
     * @inner
     */ var UINT_CACHE = {};
    /**
     * Returns a Long representing the given 32 bit integer value.
     * @param {number} value The 32 bit integer in question
     * @param {boolean=} unsigned Whether unsigned or not, defaults to `false` for signed
     * @returns {!Long} The corresponding Long value
     * @expose
     */ Long.fromInt = function fromInt(value, unsigned) {
        var obj, cachedObj;
        if (!unsigned) {
            value = value | 0;
            if (-128 <= value && value < 128) {
                cachedObj = INT_CACHE[value];
                if (cachedObj) return cachedObj;
            }
            obj = new Long(value, value < 0 ? -1 : 0, false);
            if (-128 <= value && value < 128) INT_CACHE[value] = obj;
            return obj;
        } else {
            value = value >>> 0;
            if (0 <= value && value < 256) {
                cachedObj = UINT_CACHE[value];
                if (cachedObj) return cachedObj;
            }
            obj = new Long(value, (value | 0) < 0 ? -1 : 0, true);
            if (0 <= value && value < 256) UINT_CACHE[value] = obj;
            return obj;
        }
    };
    /**
     * Returns a Long representing the given value, provided that it is a finite number. Otherwise, zero is returned.
     * @param {number} value The number in question
     * @param {boolean=} unsigned Whether unsigned or not, defaults to `false` for signed
     * @returns {!Long} The corresponding Long value
     * @expose
     */ Long.fromNumber = function fromNumber(value, unsigned) {
        unsigned = !!unsigned;
        if (isNaN(value) || !isFinite(value)) return Long.ZERO;
        if (!unsigned && value <= -TWO_PWR_63_DBL) return Long.MIN_VALUE;
        if (!unsigned && value + 1 >= TWO_PWR_63_DBL) return Long.MAX_VALUE;
        if (unsigned && value >= TWO_PWR_64_DBL) return Long.MAX_UNSIGNED_VALUE;
        if (value < 0) return Long.fromNumber(-value, unsigned).negate();
        return new Long(value % TWO_PWR_32_DBL | 0, value / TWO_PWR_32_DBL | 0, unsigned);
    };
    /**
     * Returns a Long representing the 64 bit integer that comes by concatenating the given low and high bits. Each is
     *  assumed to use 32 bits.
     * @param {number} lowBits The low 32 bits
     * @param {number} highBits The high 32 bits
     * @param {boolean=} unsigned Whether unsigned or not, defaults to `false` for signed
     * @returns {!Long} The corresponding Long value
     * @expose
     */ Long.fromBits = function fromBits(lowBits, highBits, unsigned) {
        return new Long(lowBits, highBits, unsigned);
    };
    /**
     * Returns a Long representation of the given string, written using the specified radix.
     * @param {string} str The textual representation of the Long
     * @param {(boolean|number)=} unsigned Whether unsigned or not, defaults to `false` for signed
     * @param {number=} radix The radix in which the text is written (2-36), defaults to 10
     * @returns {!Long} The corresponding Long value
     * @expose
     */ Long.fromString = function fromString(str, unsigned, radix) {
        if (str.length === 0) throw Error('number format error: empty string');
        if (str === "NaN" || str === "Infinity" || str === "+Infinity" || str === "-Infinity") return Long.ZERO;
        if (typeof unsigned === 'number') radix = unsigned, unsigned = false;
        radix = radix || 10;
        if (radix < 2 || 36 < radix) throw Error('radix out of range: ' + radix);
        var p;
        if ((p = str.indexOf('-')) > 0) throw Error('number format error: interior "-" character: ' + str);
        else if (p === 0) return Long.fromString(str.substring(1), unsigned, radix).negate();
        // Do several (8) digits each time through the loop, so as to
        // minimize the calls to the very expensive emulated div.
        var radixToPower = Long.fromNumber(Math.pow(radix, 8));
        var result = Long.ZERO;
        for(var i = 0; i < str.length; i += 8){
            var size = Math.min(8, str.length - i);
            var value = parseInt(str.substring(i, i + size), radix);
            if (size < 8) {
                var power = Long.fromNumber(Math.pow(radix, size));
                result = result.multiply(power).add(Long.fromNumber(value));
            } else {
                result = result.multiply(radixToPower);
                result = result.add(Long.fromNumber(value));
            }
        }
        result.unsigned = unsigned;
        return result;
    };
    /**
     * Converts the specified value to a Long.
     * @param {!Long|number|string|!{low: number, high: number, unsigned: boolean}} val Value
     * @returns {!Long}
     * @expose
     */ Long.fromValue = function fromValue(val) {
        if (val /* is compatible */  instanceof Long) return val;
        if (typeof val === 'number') return Long.fromNumber(val);
        if (typeof val === 'string') return Long.fromString(val);
        // Throws for non-objects, converts non-instanceof Long:
        return new Long(val.low, val.high, val.unsigned);
    };
    // NOTE: the compiler should inline these constant values below and then remove these variables, so there should be
    // no runtime penalty for these.
    /**
     * @type {number}
     * @const
     * @inner
     */ var TWO_PWR_16_DBL = 1 << 16;
    /**
     * @type {number}
     * @const
     * @inner
     */ var TWO_PWR_24_DBL = 1 << 24;
    /**
     * @type {number}
     * @const
     * @inner
     */ var TWO_PWR_32_DBL = TWO_PWR_16_DBL * TWO_PWR_16_DBL;
    /**
     * @type {number}
     * @const
     * @inner
     */ var TWO_PWR_64_DBL = TWO_PWR_32_DBL * TWO_PWR_32_DBL;
    /**
     * @type {number}
     * @const
     * @inner
     */ var TWO_PWR_63_DBL = TWO_PWR_64_DBL / 2;
    /**
     * @type {!Long}
     * @const
     * @inner
     */ var TWO_PWR_24 = Long.fromInt(TWO_PWR_24_DBL);
    /**
     * Signed zero.
     * @type {!Long}
     * @expose
     */ Long.ZERO = Long.fromInt(0);
    /**
     * Unsigned zero.
     * @type {!Long}
     * @expose
     */ Long.UZERO = Long.fromInt(0, true);
    /**
     * Signed one.
     * @type {!Long}
     * @expose
     */ Long.ONE = Long.fromInt(1);
    /**
     * Unsigned one.
     * @type {!Long}
     * @expose
     */ Long.UONE = Long.fromInt(1, true);
    /**
     * Signed negative one.
     * @type {!Long}
     * @expose
     */ Long.NEG_ONE = Long.fromInt(-1);
    /**
     * Maximum signed value.
     * @type {!Long}
     * @expose
     */ Long.MAX_VALUE = Long.fromBits(0xFFFFFFFF | 0, 0x7FFFFFFF | 0, false);
    /**
     * Maximum unsigned value.
     * @type {!Long}
     * @expose
     */ Long.MAX_UNSIGNED_VALUE = Long.fromBits(0xFFFFFFFF | 0, 0xFFFFFFFF | 0, true);
    /**
     * Minimum signed value.
     * @type {!Long}
     * @expose
     */ Long.MIN_VALUE = Long.fromBits(0, 0x80000000 | 0, false);
    /**
     * Converts the Long to a 32 bit integer, assuming it is a 32 bit integer.
     * @returns {number}
     * @expose
     */ Long.prototype.toInt = function toInt() {
        return this.unsigned ? this.low >>> 0 : this.low;
    };
    /**
     * Converts the Long to a the nearest floating-point representation of this value (double, 53 bit mantissa).
     * @returns {number}
     * @expose
     */ Long.prototype.toNumber = function toNumber() {
        if (this.unsigned) {
            return (this.high >>> 0) * TWO_PWR_32_DBL + (this.low >>> 0);
        }
        return this.high * TWO_PWR_32_DBL + (this.low >>> 0);
    };
    /**
     * Converts the Long to a string written in the specified radix.
     * @param {number=} radix Radix (2-36), defaults to 10
     * @returns {string}
     * @override
     * @throws {RangeError} If `radix` is out of range
     * @expose
     */ Long.prototype.toString = function toString(radix) {
        radix = radix || 10;
        if (radix < 2 || 36 < radix) throw RangeError('radix out of range: ' + radix);
        if (this.isZero()) return '0';
        var rem;
        if (this.isNegative()) {
            if (this.equals(Long.MIN_VALUE)) {
                // We need to change the Long value before it can be negated, so we remove
                // the bottom-most digit in this base and then recurse to do the rest.
                var radixLong = Long.fromNumber(radix);
                var div = this.divide(radixLong);
                rem = div.multiply(radixLong).subtract(this);
                return div.toString(radix) + rem.toInt().toString(radix);
            } else return '-' + this.negate().toString(radix);
        }
        // Do several (6) digits each time through the loop, so as to
        // minimize the calls to the very expensive emulated div.
        var radixToPower = Long.fromNumber(Math.pow(radix, 6), this.unsigned);
        rem = this;
        var result = '';
        while(true){
            var remDiv = rem.divide(radixToPower), intval = rem.subtract(remDiv.multiply(radixToPower)).toInt() >>> 0, digits = intval.toString(radix);
            rem = remDiv;
            if (rem.isZero()) return digits + result;
            else {
                while(digits.length < 6)digits = '0' + digits;
                result = '' + digits + result;
            }
        }
    };
    /**
     * Gets the high 32 bits as a signed integer.
     * @returns {number} Signed high bits
     * @expose
     */ Long.prototype.getHighBits = function getHighBits() {
        return this.high;
    };
    /**
     * Gets the high 32 bits as an unsigned integer.
     * @returns {number} Unsigned high bits
     * @expose
     */ Long.prototype.getHighBitsUnsigned = function getHighBitsUnsigned() {
        return this.high >>> 0;
    };
    /**
     * Gets the low 32 bits as a signed integer.
     * @returns {number} Signed low bits
     * @expose
     */ Long.prototype.getLowBits = function getLowBits() {
        return this.low;
    };
    /**
     * Gets the low 32 bits as an unsigned integer.
     * @returns {number} Unsigned low bits
     * @expose
     */ Long.prototype.getLowBitsUnsigned = function getLowBitsUnsigned() {
        return this.low >>> 0;
    };
    /**
     * Gets the number of bits needed to represent the absolute value of this Long.
     * @returns {number}
     * @expose
     */ Long.prototype.getNumBitsAbs = function getNumBitsAbs() {
        if (this.isNegative()) return this.equals(Long.MIN_VALUE) ? 64 : this.negate().getNumBitsAbs();
        var val = this.high != 0 ? this.high : this.low;
        for(var bit = 31; bit > 0; bit--)if ((val & 1 << bit) != 0) break;
        return this.high != 0 ? bit + 33 : bit + 1;
    };
    /**
     * Tests if this Long's value equals zero.
     * @returns {boolean}
     * @expose
     */ Long.prototype.isZero = function isZero() {
        return this.high === 0 && this.low === 0;
    };
    /**
     * Tests if this Long's value is negative.
     * @returns {boolean}
     * @expose
     */ Long.prototype.isNegative = function isNegative() {
        return !this.unsigned && this.high < 0;
    };
    /**
     * Tests if this Long's value is positive.
     * @returns {boolean}
     * @expose
     */ Long.prototype.isPositive = function isPositive() {
        return this.unsigned || this.high >= 0;
    };
    /**
     * Tests if this Long's value is odd.
     * @returns {boolean}
     * @expose
     */ Long.prototype.isOdd = function isOdd() {
        return (this.low & 1) === 1;
    };
    /**
     * Tests if this Long's value is even.
     * @returns {boolean}
     * @expose
     */ Long.prototype.isEven = function isEven() {
        return (this.low & 1) === 0;
    };
    /**
     * Tests if this Long's value equals the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.equals = function equals(other) {
        if (!Long.isLong(other)) other = Long.fromValue(other);
        if (this.unsigned !== other.unsigned && this.high >>> 31 === 1 && other.high >>> 31 === 1) return false;
        return this.high === other.high && this.low === other.low;
    };
    /**
     * Tests if this Long's value equals the specified's. This is an alias of {@link Long#equals}.
     * @function
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.eq = Long.prototype.equals;
    /**
     * Tests if this Long's value differs from the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.notEquals = function notEquals(other) {
        return !this.equals(/* validates */ other);
    };
    /**
     * Tests if this Long's value differs from the specified's. This is an alias of {@link Long#notEquals}.
     * @function
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.neq = Long.prototype.notEquals;
    /**
     * Tests if this Long's value is less than the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.lessThan = function lessThan(other) {
        return this.compare(/* validates */ other) < 0;
    };
    /**
     * Tests if this Long's value is less than the specified's. This is an alias of {@link Long#lessThan}.
     * @function
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.lt = Long.prototype.lessThan;
    /**
     * Tests if this Long's value is less than or equal the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.lessThanOrEqual = function lessThanOrEqual(other) {
        return this.compare(/* validates */ other) <= 0;
    };
    /**
     * Tests if this Long's value is less than or equal the specified's. This is an alias of {@link Long#lessThanOrEqual}.
     * @function
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.lte = Long.prototype.lessThanOrEqual;
    /**
     * Tests if this Long's value is greater than the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.greaterThan = function greaterThan(other) {
        return this.compare(/* validates */ other) > 0;
    };
    /**
     * Tests if this Long's value is greater than the specified's. This is an alias of {@link Long#greaterThan}.
     * @function
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.gt = Long.prototype.greaterThan;
    /**
     * Tests if this Long's value is greater than or equal the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.greaterThanOrEqual = function greaterThanOrEqual(other) {
        return this.compare(/* validates */ other) >= 0;
    };
    /**
     * Tests if this Long's value is greater than or equal the specified's. This is an alias of {@link Long#greaterThanOrEqual}.
     * @function
     * @param {!Long|number|string} other Other value
     * @returns {boolean}
     * @expose
     */ Long.prototype.gte = Long.prototype.greaterThanOrEqual;
    /**
     * Compares this Long's value with the specified's.
     * @param {!Long|number|string} other Other value
     * @returns {number} 0 if they are the same, 1 if the this is greater and -1
     *  if the given one is greater
     * @expose
     */ Long.prototype.compare = function compare(other) {
        if (!Long.isLong(other)) other = Long.fromValue(other);
        if (this.equals(other)) return 0;
        var thisNeg = this.isNegative(), otherNeg = other.isNegative();
        if (thisNeg && !otherNeg) return -1;
        if (!thisNeg && otherNeg) return 1;
        // At this point the sign bits are the same
        if (!this.unsigned) return this.subtract(other).isNegative() ? -1 : 1;
        // Both are positive if at least one is unsigned
        return other.high >>> 0 > this.high >>> 0 || other.high === this.high && other.low >>> 0 > this.low >>> 0 ? -1 : 1;
    };
    /**
     * Negates this Long's value.
     * @returns {!Long} Negated Long
     * @expose
     */ Long.prototype.negate = function negate() {
        if (!this.unsigned && this.equals(Long.MIN_VALUE)) return Long.MIN_VALUE;
        return this.not().add(Long.ONE);
    };
    /**
     * Negates this Long's value. This is an alias of {@link Long#negate}.
     * @function
     * @returns {!Long} Negated Long
     * @expose
     */ Long.prototype.neg = Long.prototype.negate;
    /**
     * Returns the sum of this and the specified Long.
     * @param {!Long|number|string} addend Addend
     * @returns {!Long} Sum
     * @expose
     */ Long.prototype.add = function add(addend) {
        if (!Long.isLong(addend)) addend = Long.fromValue(addend);
        // Divide each number into 4 chunks of 16 bits, and then sum the chunks.
        var a48 = this.high >>> 16;
        var a32 = this.high & 0xFFFF;
        var a16 = this.low >>> 16;
        var a00 = this.low & 0xFFFF;
        var b48 = addend.high >>> 16;
        var b32 = addend.high & 0xFFFF;
        var b16 = addend.low >>> 16;
        var b00 = addend.low & 0xFFFF;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 + b00;
        c16 += c00 >>> 16;
        c00 &= 0xFFFF;
        c16 += a16 + b16;
        c32 += c16 >>> 16;
        c16 &= 0xFFFF;
        c32 += a32 + b32;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c48 += a48 + b48;
        c48 &= 0xFFFF;
        return Long.fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
    };
    /**
     * Returns the difference of this and the specified Long.
     * @param {!Long|number|string} subtrahend Subtrahend
     * @returns {!Long} Difference
     * @expose
     */ Long.prototype.subtract = function subtract(subtrahend) {
        if (!Long.isLong(subtrahend)) subtrahend = Long.fromValue(subtrahend);
        return this.add(subtrahend.negate());
    };
    /**
     * Returns the difference of this and the specified Long. This is an alias of {@link Long#subtract}.
     * @function
     * @param {!Long|number|string} subtrahend Subtrahend
     * @returns {!Long} Difference
     * @expose
     */ Long.prototype.sub = Long.prototype.subtract;
    /**
     * Returns the product of this and the specified Long.
     * @param {!Long|number|string} multiplier Multiplier
     * @returns {!Long} Product
     * @expose
     */ Long.prototype.multiply = function multiply(multiplier) {
        if (this.isZero()) return Long.ZERO;
        if (!Long.isLong(multiplier)) multiplier = Long.fromValue(multiplier);
        if (multiplier.isZero()) return Long.ZERO;
        if (this.equals(Long.MIN_VALUE)) return multiplier.isOdd() ? Long.MIN_VALUE : Long.ZERO;
        if (multiplier.equals(Long.MIN_VALUE)) return this.isOdd() ? Long.MIN_VALUE : Long.ZERO;
        if (this.isNegative()) {
            if (multiplier.isNegative()) return this.negate().multiply(multiplier.negate());
            else return this.negate().multiply(multiplier).negate();
        } else if (multiplier.isNegative()) return this.multiply(multiplier.negate()).negate();
        // If both longs are small, use float multiplication
        if (this.lessThan(TWO_PWR_24) && multiplier.lessThan(TWO_PWR_24)) return Long.fromNumber(this.toNumber() * multiplier.toNumber(), this.unsigned);
        // Divide each long into 4 chunks of 16 bits, and then add up 4x4 products.
        // We can skip products that would overflow.
        var a48 = this.high >>> 16;
        var a32 = this.high & 0xFFFF;
        var a16 = this.low >>> 16;
        var a00 = this.low & 0xFFFF;
        var b48 = multiplier.high >>> 16;
        var b32 = multiplier.high & 0xFFFF;
        var b16 = multiplier.low >>> 16;
        var b00 = multiplier.low & 0xFFFF;
        var c48 = 0, c32 = 0, c16 = 0, c00 = 0;
        c00 += a00 * b00;
        c16 += c00 >>> 16;
        c00 &= 0xFFFF;
        c16 += a16 * b00;
        c32 += c16 >>> 16;
        c16 &= 0xFFFF;
        c16 += a00 * b16;
        c32 += c16 >>> 16;
        c16 &= 0xFFFF;
        c32 += a32 * b00;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c32 += a16 * b16;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c32 += a00 * b32;
        c48 += c32 >>> 16;
        c32 &= 0xFFFF;
        c48 += a48 * b00 + a32 * b16 + a16 * b32 + a00 * b48;
        c48 &= 0xFFFF;
        return Long.fromBits(c16 << 16 | c00, c48 << 16 | c32, this.unsigned);
    };
    /**
     * Returns the product of this and the specified Long. This is an alias of {@link Long#multiply}.
     * @function
     * @param {!Long|number|string} multiplier Multiplier
     * @returns {!Long} Product
     * @expose
     */ Long.prototype.mul = Long.prototype.multiply;
    /**
     * Returns this Long divided by the specified.
     * @param {!Long|number|string} divisor Divisor
     * @returns {!Long} Quotient
     * @expose
     */ Long.prototype.divide = function divide(divisor) {
        if (!Long.isLong(divisor)) divisor = Long.fromValue(divisor);
        if (divisor.isZero()) throw new Error('division by zero');
        if (this.isZero()) return this.unsigned ? Long.UZERO : Long.ZERO;
        var approx, rem, res;
        if (this.equals(Long.MIN_VALUE)) {
            if (divisor.equals(Long.ONE) || divisor.equals(Long.NEG_ONE)) return Long.MIN_VALUE; // recall that -MIN_VALUE == MIN_VALUE
            else if (divisor.equals(Long.MIN_VALUE)) return Long.ONE;
            else {
                // At this point, we have |other| >= 2, so |this/other| < |MIN_VALUE|.
                var halfThis = this.shiftRight(1);
                approx = halfThis.divide(divisor).shiftLeft(1);
                if (approx.equals(Long.ZERO)) {
                    return divisor.isNegative() ? Long.ONE : Long.NEG_ONE;
                } else {
                    rem = this.subtract(divisor.multiply(approx));
                    res = approx.add(rem.divide(divisor));
                    return res;
                }
            }
        } else if (divisor.equals(Long.MIN_VALUE)) return this.unsigned ? Long.UZERO : Long.ZERO;
        if (this.isNegative()) {
            if (divisor.isNegative()) return this.negate().divide(divisor.negate());
            return this.negate().divide(divisor).negate();
        } else if (divisor.isNegative()) return this.divide(divisor.negate()).negate();
        // Repeat the following until the remainder is less than other:  find a
        // floating-point that approximates remainder / other *from below*, add this
        // into the result, and subtract it from the remainder.  It is critical that
        // the approximate value is less than or equal to the real value so that the
        // remainder never becomes negative.
        res = Long.ZERO;
        rem = this;
        while(rem.greaterThanOrEqual(divisor)){
            // Approximate the result of division. This may be a little greater or
            // smaller than the actual value.
            approx = Math.max(1, Math.floor(rem.toNumber() / divisor.toNumber()));
            // We will tweak the approximate result by changing it in the 48-th digit or
            // the smallest non-fractional digit, whichever is larger.
            var log2 = Math.ceil(Math.log(approx) / Math.LN2), delta = log2 <= 48 ? 1 : Math.pow(2, log2 - 48), // Decrease the approximation until it is smaller than the remainder.  Note
            // that if it is too large, the product overflows and is negative.
            approxRes = Long.fromNumber(approx), approxRem = approxRes.multiply(divisor);
            while(approxRem.isNegative() || approxRem.greaterThan(rem)){
                approx -= delta;
                approxRes = Long.fromNumber(approx, this.unsigned);
                approxRem = approxRes.multiply(divisor);
            }
            // We know the answer can't be zero... and actually, zero would cause
            // infinite recursion since we would make no progress.
            if (approxRes.isZero()) approxRes = Long.ONE;
            res = res.add(approxRes);
            rem = rem.subtract(approxRem);
        }
        return res;
    };
    /**
     * Returns this Long divided by the specified. This is an alias of {@link Long#divide}.
     * @function
     * @param {!Long|number|string} divisor Divisor
     * @returns {!Long} Quotient
     * @expose
     */ Long.prototype.div = Long.prototype.divide;
    /**
     * Returns this Long modulo the specified.
     * @param {!Long|number|string} divisor Divisor
     * @returns {!Long} Remainder
     * @expose
     */ Long.prototype.modulo = function modulo(divisor) {
        if (!Long.isLong(divisor)) divisor = Long.fromValue(divisor);
        return this.subtract(this.divide(divisor).multiply(divisor));
    };
    /**
     * Returns this Long modulo the specified. This is an alias of {@link Long#modulo}.
     * @function
     * @param {!Long|number|string} divisor Divisor
     * @returns {!Long} Remainder
     * @expose
     */ Long.prototype.mod = Long.prototype.modulo;
    /**
     * Returns the bitwise NOT of this Long.
     * @returns {!Long}
     * @expose
     */ Long.prototype.not = function not() {
        return Long.fromBits(~this.low, ~this.high, this.unsigned);
    };
    /**
     * Returns the bitwise AND of this Long and the specified.
     * @param {!Long|number|string} other Other Long
     * @returns {!Long}
     * @expose
     */ Long.prototype.and = function and(other) {
        if (!Long.isLong(other)) other = Long.fromValue(other);
        return Long.fromBits(this.low & other.low, this.high & other.high, this.unsigned);
    };
    /**
     * Returns the bitwise OR of this Long and the specified.
     * @param {!Long|number|string} other Other Long
     * @returns {!Long}
     * @expose
     */ Long.prototype.or = function or(other) {
        if (!Long.isLong(other)) other = Long.fromValue(other);
        return Long.fromBits(this.low | other.low, this.high | other.high, this.unsigned);
    };
    /**
     * Returns the bitwise XOR of this Long and the given one.
     * @param {!Long|number|string} other Other Long
     * @returns {!Long}
     * @expose
     */ Long.prototype.xor = function xor(other) {
        if (!Long.isLong(other)) other = Long.fromValue(other);
        return Long.fromBits(this.low ^ other.low, this.high ^ other.high, this.unsigned);
    };
    /**
     * Returns this Long with bits shifted to the left by the given amount.
     * @param {number|!Long} numBits Number of bits
     * @returns {!Long} Shifted Long
     * @expose
     */ Long.prototype.shiftLeft = function shiftLeft(numBits) {
        if (Long.isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        else if (numBits < 32) return Long.fromBits(this.low << numBits, this.high << numBits | this.low >>> 32 - numBits, this.unsigned);
        else return Long.fromBits(0, this.low << numBits - 32, this.unsigned);
    };
    /**
     * Returns this Long with bits shifted to the left by the given amount. This is an alias of {@link Long#shiftLeft}.
     * @function
     * @param {number|!Long} numBits Number of bits
     * @returns {!Long} Shifted Long
     * @expose
     */ Long.prototype.shl = Long.prototype.shiftLeft;
    /**
     * Returns this Long with bits arithmetically shifted to the right by the given amount.
     * @param {number|!Long} numBits Number of bits
     * @returns {!Long} Shifted Long
     * @expose
     */ Long.prototype.shiftRight = function shiftRight(numBits) {
        if (Long.isLong(numBits)) numBits = numBits.toInt();
        if ((numBits &= 63) === 0) return this;
        else if (numBits < 32) return Long.fromBits(this.low >>> numBits | this.high << 32 - numBits, this.high >> numBits, this.unsigned);
        else return Long.fromBits(this.high >> numBits - 32, this.high >= 0 ? 0 : -1, this.unsigned);
    };
    /**
     * Returns this Long with bits arithmetically shifted to the right by the given amount. This is an alias of {@link Long#shiftRight}.
     * @function
     * @param {number|!Long} numBits Number of bits
     * @returns {!Long} Shifted Long
     * @expose
     */ Long.prototype.shr = Long.prototype.shiftRight;
    /**
     * Returns this Long with bits logically shifted to the right by the given amount.
     * @param {number|!Long} numBits Number of bits
     * @returns {!Long} Shifted Long
     * @expose
     */ Long.prototype.shiftRightUnsigned = function shiftRightUnsigned(numBits) {
        if (Long.isLong(numBits)) numBits = numBits.toInt();
        numBits &= 63;
        if (numBits === 0) return this;
        else {
            var high = this.high;
            if (numBits < 32) {
                var low = this.low;
                return Long.fromBits(low >>> numBits | high << 32 - numBits, high >>> numBits, this.unsigned);
            } else if (numBits === 32) return Long.fromBits(high, 0, this.unsigned);
            else return Long.fromBits(high >>> numBits - 32, 0, this.unsigned);
        }
    };
    /**
     * Returns this Long with bits logically shifted to the right by the given amount. This is an alias of {@link Long#shiftRightUnsigned}.
     * @function
     * @param {number|!Long} numBits Number of bits
     * @returns {!Long} Shifted Long
     * @expose
     */ Long.prototype.shru = Long.prototype.shiftRightUnsigned;
    /**
     * Converts this Long to signed.
     * @returns {!Long} Signed long
     * @expose
     */ Long.prototype.toSigned = function toSigned() {
        if (!this.unsigned) return this;
        return new Long(this.low, this.high, false);
    };
    /**
     * Converts this Long to unsigned.
     * @returns {!Long} Unsigned long
     * @expose
     */ Long.prototype.toUnsigned = function toUnsigned() {
        if (this.unsigned) return this;
        return new Long(this.low, this.high, true);
    };
    return Long;
});
}}),
"[project]/node_modules/xtend/immutable.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
module.exports = extend;
var hasOwnProperty = Object.prototype.hasOwnProperty;
function extend() {
    var target = {};
    for(var i = 0; i < arguments.length; i++){
        var source = arguments[i];
        for(var key in source){
            if (hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }
    return target;
}
}}),
"[project]/node_modules/xtend/mutable.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
module.exports = extend;
var hasOwnProperty = Object.prototype.hasOwnProperty;
function extend(target) {
    for(var i = 1; i < arguments.length; i++){
        var source = arguments[i];
        for(var key in source){
            if (hasOwnProperty.call(source, key)) {
                target[key] = source[key];
            }
        }
    }
    return target;
}
}}),
"[project]/node_modules/ansi-color/lib/ansi-color.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// ANSI color code outputs for strings
var ANSI_CODES = {
    "off": 0,
    "bold": 1,
    "italic": 3,
    "underline": 4,
    "blink": 5,
    "inverse": 7,
    "hidden": 8,
    "black": 30,
    "red": 31,
    "green": 32,
    "yellow": 33,
    "blue": 34,
    "magenta": 35,
    "cyan": 36,
    "white": 37,
    "black_bg": 40,
    "red_bg": 41,
    "green_bg": 42,
    "yellow_bg": 43,
    "blue_bg": 44,
    "magenta_bg": 45,
    "cyan_bg": 46,
    "white_bg": 47
};
exports.set = function(str, color) {
    if (!color) return str;
    var color_attrs = color.split("+");
    var ansi_str = "";
    for(var i = 0, attr; attr = color_attrs[i]; i++){
        ansi_str += "\033[" + ANSI_CODES[attr] + "m";
    }
    ansi_str += str + "\033[" + ANSI_CODES["off"] + "m";
    return ansi_str;
};
}}),
"[project]/node_modules/hexer/render.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
var color = __turbopack_context__.r("[project]/node_modules/ansi-color/lib/ansi-color.js [app-rsc] (ecmascript)").set;
function pad(c, s, width) {
    while(s.length < width)s = c + s;
    return s;
}
function byte2hex(b) {
    return pad('0', b.toString(16), 2);
}
function byte2char(c) {
    if (c > 0x1f && c < 0x7f) {
        return String.fromCharCode(c);
    } else {
        return '.';
    }
// TODO: could provide perhaps some unicode renderings for certain control chars
}
function renderColoredHuman(c) {
    if (c > 0x1f && c < 0x7f) {
        return String.fromCharCode(c);
    } else {
        return color('.', 'black+bold');
    }
}
// istanbul ignore next
function stripColor(str) {
    while(true){
        var i = str.indexOf('\x1b[');
        if (i < 0) return str;
        var j = str.indexOf('m', i);
        if (j < 0) return str;
        str = str.slice(0, i) + str.slice(j + 1);
    }
}
module.exports.coloredHeadSep = color(':', 'cyan') + ' ';
module.exports.coloredOptions = {
    headSep: module.exports.coloredHeadSep,
    renderHuman: renderColoredHuman
};
module.exports.pad = pad;
module.exports.byte2hex = byte2hex;
module.exports.byte2char = byte2char;
module.exports.renderHuman = renderColoredHuman;
module.exports.stripColor = stripColor;
}}),
"[project]/node_modules/hexer/hex_transform.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var extend = __turbopack_context__.r("[project]/node_modules/xtend/immutable.js [app-rsc] (ecmascript)");
var util = __turbopack_context__.r("[externals]/util [external] (util, cjs)");
var Transform = __turbopack_context__.r("[externals]/stream [external] (stream, cjs)").Transform;
var render = __turbopack_context__.r("[project]/node_modules/hexer/render.js [app-rsc] (ecmascript)");
function HexTransform(options) {
    if (!(this instanceof HexTransform)) {
        return new HexTransform(options);
    }
    // istanbul ignore next
    if (!options) options = {};
    if (options.colored) options = extend(render.coloredOptions, options);
    Transform.call(this, options);
    var self = this;
    self.options = options;
    self.prefix = self.options.prefix || '';
    self.cols = self.options.cols || 16;
    self.group = self.options.group || 2;
    self.gutter = self.options.gutter || 0;
    // istanbul ignore if
    self.annotateLine = options.annotateLine || null;
    self.decorateHexen = self.options.decorateHexen || noopDecorate;
    self.decorateHuman = self.options.decorateHuman || noopDecorate;
    self.renderHexen = self.options.renderHexen || render.byte2hex;
    self.renderHuman = self.options.renderHuman || render.byte2char;
    // istanbul ignore next
    self.groupSeparator = self.options.groupSeparator === undefined ? ' ' : self.options.groupSeparator;
    self.headSep = self.options.headSep === undefined ? ': ' : self.options.headSep;
    // istanbul ignore next
    self.divide = self.options.divide === undefined ? '  ' : self.options.divide;
    // istanbul ignore next
    self.emptyHexen = self.options.emptyHexen === undefined ? '  ' : self.options.emptyHexen;
    self.emptyHuman = self.options.emptyHuman || '';
    self.nullHuman = self.options.nullHuman || '';
    self.offsetWidth = self.options.offsetWidth || 8;
    self.gutter = Math.max(self.offsetWidth, self.gutter);
    self.line = '';
    self.hexen = '';
    self.human = '';
    self.reset();
}
util.inherits(HexTransform, Transform);
HexTransform.prototype.reset = function reset() {
    var self = this;
    self._finishLine();
    self.screenOffset = 0;
    self.totalOffset = 0;
};
HexTransform.prototype._transform = function transform(chunk, encoding, done) {
    var self = this;
    for(var offset = 0; offset < chunk.length; offset++){
        if (self.screenOffset % self.cols === 0) {
            self._finishLine();
            self._startLine();
        }
        self._addByte(chunk[offset]);
    }
    done(null);
};
HexTransform.prototype._flush = function flush(done) {
    var self = this;
    if (self.totalOffset === 0 && self.nullHuman) {
        self._startLine();
        self.human += self.nullHuman;
    }
    self._finishLine();
    done(null);
};
HexTransform.prototype._startLine = function startLine() {
    var self = this;
    var head = render.pad('0', self.totalOffset.toString(16), self.offsetWidth);
    self.line = self.prefix + render.pad(' ', head, self.gutter) + self.headSep;
};
HexTransform.prototype._finishLine = function finishLine() {
    var self = this;
    if (self.line.length) {
        var rem = self.screenOffset % self.cols;
        if (rem !== 0 || self.totalOffset === 0 && self.nullHuman) {
            rem = self.cols - rem;
            for(var i = 0; i < rem; i++){
                self._addEmpty();
            }
        }
        self.line += self.hexen + self.divide + self.human;
        // istanbul ignore if
        if (self.annotateLine) {
            self.line += self.annotateLine(self.totalOffset - self.cols, self.totalOffset);
        }
        self.line += '\n';
        self.push(self.line);
        self.line = '';
        self.hexen = '';
        self.human = '';
    }
};
HexTransform.prototype._addEmpty = function addEmpty() {
    var self = this;
    self._addPart(self.emptyHexen, self.emptyHuman);
};
HexTransform.prototype._addByte = function addByte(b) {
    var self = this;
    var hexen = self.renderHexen(b);
    var human = self.renderHuman(b);
    self._addPart(hexen, human, b);
};
HexTransform.prototype._addPart = function addByte(hexen, human, b) {
    var self = this;
    hexen = self.decorateHexen(self.totalOffset, self.screenOffset, hexen, b);
    human = self.decorateHuman(self.totalOffset, self.screenOffset, human, b);
    var isStartOfRow = self.screenOffset % self.cols === 0;
    var isStartOfGroup = self.screenOffset % self.group === 0;
    if (!isStartOfRow && isStartOfGroup) {
        self.hexen += self.groupSeparator;
    }
    self.hexen += hexen;
    self.human += human;
    self.totalOffset++;
    self.screenOffset++;
};
function noopDecorate(offset, screenOffset, s) {
    return s;
}
module.exports = HexTransform;
}}),
"[project]/node_modules/hexer/chunked_hex_transform.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
var util = __turbopack_context__.r("[externals]/util [external] (util, cjs)");
var HexTransform = __turbopack_context__.r("[project]/node_modules/hexer/hex_transform.js [app-rsc] (ecmascript)");
function ChunkedHexTransform(options) {
    if (!(this instanceof ChunkedHexTransform)) {
        return new ChunkedHexTransform(options);
    }
    // istanbul ignore next
    if (!options) options = {};
    HexTransform.call(this, options);
    var self = this;
    if (typeof options.header === 'function') {
        self.header = options.header;
    } else if (typeof options.header === 'object') {
        self.header = simpleHeader(options.header);
    } else if (typeof options.header === 'string') {
        self.header = simpleHeader({
            label: options.header
        });
    } else {
        self.header = simpleHeader();
    }
    self.chunkNum = 0;
}
util.inherits(ChunkedHexTransform, HexTransform);
ChunkedHexTransform.prototype._transform = function transform(chunk, encoding, done) {
    var self = this;
    // istanbul ignore next
    if (self.totalOffset) {
        self.reset();
    }
    ++self.chunkNum;
    var header = self.header(self.chunkNum, chunk);
    if (header.length) {
        self.push(header);
    }
    HexTransform.prototype._transform.call(self, chunk, encoding, function subDone(err) {
        self.reset();
        done(err);
    });
};
function simpleHeader(opts) {
    opts = opts || {};
    var fmt = '-- ';
    if (opts.label) fmt += opts.label + ' ';
    fmt += 'chunk[%s] length: %s (0x%s)\n';
    return function header(chunkNum, chunk) {
        var len = chunk.length;
        var hexlen = len.toString(16);
        return util.format(fmt, chunkNum, len, hexlen);
    };
}
module.exports = ChunkedHexTransform;
}}),
"[project]/node_modules/hexer/hex_spy.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
var util = __turbopack_context__.r("[externals]/util [external] (util, cjs)");
var Transform = __turbopack_context__.r("[externals]/stream [external] (stream, cjs)").Transform;
var ChunkedHexTransform = __turbopack_context__.r("[project]/node_modules/hexer/chunked_hex_transform.js [app-rsc] (ecmascript)");
module.exports = HexSpy;
function HexSpy(sink, options) {
    if (!(this instanceof HexSpy)) {
        return new HexSpy(sink, options);
    }
    // istanbul ignore next
    if (!options) options = {};
    // istanbul ignore else
    if (options.highWaterMark === undefined) {
        options.highWaterMark = 1;
    }
    var self = this;
    Transform.call(self, options);
    self.hex = ChunkedHexTransform(options);
    self.hex.pipe(sink);
}
util.inherits(HexSpy, Transform);
HexSpy.prototype._transform = function _transform(chunk, encoding, callback) {
    var self = this;
    self.hex.write(chunk, encoding, function writeDone() {
        self.push(chunk);
        callback();
    });
};
HexSpy.prototype._flush = function _flush(callback) {
    var self = this;
    self.hex.end(null, null, callback);
};
}}),
"[project]/node_modules/hexer/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
hex.Transform = __turbopack_context__.r("[project]/node_modules/hexer/hex_transform.js [app-rsc] (ecmascript)");
hex.ChunkedTransform = __turbopack_context__.r("[project]/node_modules/hexer/chunked_hex_transform.js [app-rsc] (ecmascript)");
hex.Spy = __turbopack_context__.r("[project]/node_modules/hexer/hex_spy.js [app-rsc] (ecmascript)");
module.exports = hex;
function hex(buffer, options) {
    if (typeof buffer === 'string') {
        return hex(Buffer(buffer), options);
    }
    if (!Buffer.isBuffer(buffer)) {
        throw new Error('invalid argument to hex, expected a buffer or string');
    }
    options = options || {};
    if (!options.offsetWidth) {
        options.offsetWidth = 2 * Math.ceil(buffer.length.toString(16).length / 2);
    }
    var stream = hex.Transform(options);
    stream.write(buffer);
    stream.end();
    var out = stream.read();
    if (out === null) {
        return '';
    }
    out = String(out);
    out = out.replace(/\n+$/, '');
    return out;
}
}}),
"[project]/node_modules/bufrw/result.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = Result;
function Result(err, value) {
    this.err = err || null;
    this.value = value;
}
Result.prototype.toValue = function toValue() {
    if (this.err) {
        throw this.err;
    } else {
        return this.value;
    }
};
/* istanbul ignore next */ Result.prototype.toCallback = function toCallback(callback) {
    callback(this.err, this.value);
};
// XXX to be phased out of use in favor of using Result return values.
/* istanbul ignore next */ Result.prototype.toTuple = function toTuple() {
    return [
        this.err,
        this.value
    ];
};
}}),
"[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
var TypedError = __turbopack_context__.r("[project]/node_modules/error/typed.js [app-rsc] (ecmascript)");
var WrappedError = __turbopack_context__.r("[project]/node_modules/error/wrapped.js [app-rsc] (ecmascript)");
module.exports.expected = function expected(got, descr) {
    return module.exports.InvalidArgument({
        expected: descr,
        argType: typeof got,
        argConstructor: got && got.constructor.name
    });
};
module.exports.BrokenReaderState = TypedError({
    type: 'bufrw.broken-reader-state',
    message: 'reader in invalid state {state} expecting {expecting} avail {aval}',
    state: null,
    expecting: null,
    avail: null
});
module.exports.FixedLengthMismatch = TypedError({
    type: 'bufrw.fixed-length-mismatch',
    message: 'supplied length {got} mismatches fixed length {expected}',
    expected: null,
    got: null
});
module.exports.RangeError = TypedError({
    type: 'bufrw.range-error',
    message: 'value {value} out of range, min: {min} max: {max}',
    value: null,
    min: null,
    max: null
});
module.exports.InvalidArgument = TypedError({
    type: 'bufrw.invalid-argument',
    message: 'invalid argument, expected {expected}',
    expected: null,
    argType: null,
    argConstructor: null
});
module.exports.ReadInvalidSwitchValue = TypedError({
    type: 'bufrw.read.invalid-switch-value',
    message: 'read invalid switch value {value}',
    value: null
});
module.exports.WriteInvalidSwitchValue = TypedError({
    type: 'bufrw.write.invalid-switch-value',
    message: 'write invalid switch value {value}',
    value: null
});
module.exports.MissingStructField = TypedError({
    type: 'bufrw.missing.struct-field',
    message: 'missing field {field} on {struct}',
    field: null,
    struct: null
});
module.exports.ShortBuffer = TypedError({
    type: 'bufrw.short-buffer',
    message: 'expected at least {expected} bytes, only have {actual} @{offset}',
    expected: null,
    actual: null,
    buffer: null,
    offset: null
});
module.exports.ShortBufferRanged = TypedError({
    type: 'bufrw.short-buffer',
    message: 'expected at least {expected} bytes, only have {actual} @[{offset}:{endOffset}]',
    expected: null,
    actual: null,
    offset: null,
    endOffset: null
});
module.exports.ShortRead = TypedError({
    type: 'bufrw.short-read',
    message: 'short read, {remaining} byte left over after consuming {offset}',
    remaining: null,
    buffer: null,
    offset: null
});
module.exports.ShortWrite = TypedError({
    type: 'bufrw.short-write',
    message: 'short write, {remaining} byte left over after writing {offset}',
    remaining: null,
    buffer: null,
    offset: null
});
module.exports.TruncatedRead = TypedError({
    type: 'bufrw.truncated-read',
    message: 'read truncated by end of stream with {length} bytes in buffer',
    length: null,
    buffer: null,
    state: null,
    expecting: null
});
module.exports.UnstableRW = WrappedError({
    type: 'bufrw.unstable-rw',
    message: 'Unstable RW error: {origMessage} (other: {otherMessage})',
    otherMessage: null
});
module.exports.ZeroLengthChunk = TypedError({
    type: 'bufrw.zero-length-chunk',
    message: 'zero length chunk encountered'
});
module.exports.classify = classify;
function classify(err) {
    switch(err.type){
        case 'bufrw.broken-reader-state':
        case 'bufrw.unstable-rw':
            return 'Internal';
        case 'bufrw.invalid-argument':
        case 'bufrw.read.invalid-switch-value':
        case 'bufrw.short-buffer':
        case 'bufrw.short-read':
        case 'bufrw.truncated-read':
        case 'bufrw.zero-length-chunk':
            return 'Read';
        case 'bufrw.fixed-length-mismatch':
        case 'bufrw.missing.struct-field':
        case 'bufrw.range-error':
        case 'bufrw.short-write':
        case 'bufrw.write.invalid-switch-value':
            return 'Write';
        // istanbul ignore next
        default:
            return null;
    }
}
}}),
"[project]/node_modules/bufrw/lib/strip_color.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
module.exports = stripColor;
// istanbul ignore next
function stripColor(str) {
    while(true){
        var i = str.indexOf('\x1b[');
        if (i < 0) return str;
        var j = str.indexOf('m', i);
        if (j < 0) return str;
        str = str.slice(0, i) + str.slice(j + 1);
    }
}
}}),
"[project]/node_modules/bufrw/annotated_buffer.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
var hex = __turbopack_context__.r("[project]/node_modules/hexer/index.js [app-rsc] (ecmascript)");
var color = __turbopack_context__.r("[project]/node_modules/ansi-color/lib/ansi-color.js [app-rsc] (ecmascript)").set;
var stripColor = __turbopack_context__.r("[project]/node_modules/bufrw/lib/strip_color.js [app-rsc] (ecmascript)");
var extend = __turbopack_context__.r("[project]/node_modules/xtend/immutable.js [app-rsc] (ecmascript)");
var inspect = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inspect;
function AnnotatedBuffer(buffer) {
    this.buffer = buffer;
    this.annotations = [];
}
Object.defineProperty(AnnotatedBuffer.prototype, 'length', {
    enumerable: true,
    get: function getLength() {
        return this.buffer.length;
    }
});
// -- strings
AnnotatedBuffer.prototype.toString = function toString(encoding, start, end) {
    var value = this.buffer.toString(encoding, start, end);
    this.annotations.push({
        kind: 'read',
        name: 'string',
        value: value,
        encoding: encoding,
        start: start,
        end: end
    });
    return value;
};
// -- bytes
// istanbul ignore next
AnnotatedBuffer.prototype.copy = function copy(targetBuffer, targetStart, sourceStart, sourceEnd) {
    var copied = this.buffer.copy(targetBuffer, targetStart, sourceStart, sourceEnd);
    // istanbul ignore next
    var start = sourceStart || 0;
    var end = sourceEnd || start + copied;
    this.annotations.push({
        kind: 'read',
        name: 'copy',
        value: this.buffer.slice(start, end),
        start: start,
        end: end
    });
    return copied;
};
// istanbul ignore next
AnnotatedBuffer.prototype.slice = function slice(start, end) {
    var value = this.buffer.slice(start, end);
    this.annotations.push({
        kind: 'read',
        name: 'slice',
        value: value,
        start: start,
        end: end
    });
    return value;
};
// -- atom readers
// istanbul ignore next
AnnotatedBuffer.prototype.readInt8 = function readInt8(offset, noAssert) {
    var value = this.buffer.readInt8(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'Int8',
        value: value,
        start: offset,
        end: offset + 1
    });
    return value;
};
AnnotatedBuffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
    var value = this.buffer.readUInt8(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'UInt8',
        value: value,
        start: offset,
        end: offset + 1
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
    var value = this.buffer.readUInt16LE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'UInt16LE',
        value: value,
        start: offset,
        end: offset + 2
    });
    return value;
};
AnnotatedBuffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
    var value = this.buffer.readUInt16BE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'UInt16BE',
        value: value,
        start: offset,
        end: offset + 2
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
    var value = this.buffer.readUInt32LE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'UInt32LE',
        value: value,
        start: offset,
        end: offset + 4
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
    var value = this.buffer.readUInt32BE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'UInt32BE',
        value: value,
        start: offset,
        end: offset + 4
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
    var value = this.buffer.readInt16LE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'Int16LE',
        value: value,
        start: offset,
        end: offset + 2
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
    var value = this.buffer.readInt16BE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'Int16BE',
        value: value,
        start: offset,
        end: offset + 2
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
    var value = this.buffer.readInt32LE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'Int32LE',
        value: value,
        start: offset,
        end: offset + 4
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
    var value = this.buffer.readInt32BE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'Int32BE',
        value: value,
        start: offset,
        end: offset + 4
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
    var value = this.buffer.readFloatLE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'FloatLE',
        value: value,
        start: offset,
        end: offset + 4
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
    var value = this.buffer.readFloatBE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'FloatBE',
        value: value,
        start: offset,
        end: offset + 4
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
    var value = this.buffer.readDoubleLE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'DoubleLE',
        value: value,
        start: offset,
        end: offset + 8
    });
    return value;
};
// istanbul ignore next
AnnotatedBuffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
    var value = this.buffer.readDoubleBE(offset, noAssert);
    this.annotations.push({
        kind: 'read',
        name: 'DoubleBE',
        value: value,
        start: offset,
        end: offset + 8
    });
    return value;
};
// -- extras
// istanbul ignore next
AnnotatedBuffer.prototype.hexdump = function hexdump(options) {
    var self = this;
    options = extend(options, {
        emptyHuman: ' ',
        annotateLine: annotateLine
    });
    if (options.boldStart === undefined) options.boldStart = true;
    options.decorateHexen = colorRegions;
    options.decorateHuman = colorRegions;
    var colors = options.colors || [
        'magenta',
        'cyan',
        'yellow',
        'green'
    ];
    var colorI = 0;
    var annI = 0;
    var last = 0;
    return hex(this.buffer, options);
    "TURBOPACK unreachable";
    function annotateLine(start, end) {
        var parts = [];
        for(var i = last; i <= annI; i++){
            var ann = self.annotations[i];
            if (ann && ann.start >= start && ann.start < end) {
                if (options.colored) {
                    ann.color = colors[i % colors.length];
                }
                parts.push(ann);
                last = i + 1;
            }
        }
        return '  ' + parts.map(function(part) {
            var desc = part.name;
            if (typeof part.value !== 'string' && !Buffer.isBuffer(part.value)) {
                desc += '(' + inspect(part.value) + ')';
            }
            if (part.color) {
                desc = color(desc, part.color);
            } else if (part.start === part.end) {
                desc += '@' + part.start.toString(16);
            } else {
                desc += '@[' + part.start.toString(16) + ',' + part.end.toString(16) + ']';
            }
            if (options.highlight) {
                desc = options.highlight(part.start, 0, desc);
            }
            return desc;
        }).join(' ');
    }
    function colorRegions(i, j, str) {
        var ann = self.annotations[annI];
        while(ann && i >= ann.end){
            ann = self.annotations[++annI];
            colorI = (colorI + 1) % colors.length;
        }
        if (ann && options.colored && i >= ann.start && i < ann.end) {
            str = stripColor(str);
            str = color(str, colors[colorI]);
            if (i === ann.start && options.boldStart) str = color(str, 'bold');
        }
        if (options.highlight) {
            str = options.highlight(i, j, str);
        }
        return str;
    }
};
module.exports = AnnotatedBuffer;
}}),
"[project]/node_modules/bufrw/error_highlighter.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
var color = __turbopack_context__.r("[project]/node_modules/ansi-color/lib/ansi-color.js [app-rsc] (ecmascript)").set;
var stripColor = __turbopack_context__.r("[project]/node_modules/bufrw/lib/strip_color.js [app-rsc] (ecmascript)");
module.exports = errorHighlighter;
// istanbul ignore next
function errorHighlighter(err, options) {
    options = options || {};
    var errColor = colorer(options.errorColor || 'red+bold');
    var hasOffset = !(err.offset === undefined || err.offset === null);
    var hasEnd = !(err.endOffset === undefined || err.endOffset === null);
    var within = false;
    if (!hasOffset) return null;
    if (hasEnd) {
        return decorateRangedError;
    } else {
        return decorateError;
    }
    "TURBOPACK unreachable";
    function decorateRangedError(totalOffset, screenOffset, str) {
        if (totalOffset === err.offset) {
            within = totalOffset !== err.endOffset - 1;
            return errColor(stripColor(str));
        } else if (totalOffset === err.endOffset - 1) {
            within = false;
            return errColor(stripColor(str));
        } else if (within) {
            return errColor(stripColor(str));
        } else {
            return str;
        }
    }
    function decorateError(totalOffset, screenOffset, str) {
        if (totalOffset === err.offset) {
            return errColor(stripColor(str));
        } else {
            return str;
        }
    }
}
// istanbul ignore next
function colorer(col) {
    if (typeof col === 'function') return col;
    return function colorIt(str) {
        return color(str, col);
    };
}
}}),
"[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
var hex = __turbopack_context__.r("[project]/node_modules/hexer/index.js [app-rsc] (ecmascript)");
var util = __turbopack_context__.r("[externals]/util [external] (util, cjs)");
var Result = __turbopack_context__.r("[project]/node_modules/bufrw/result.js [app-rsc] (ecmascript)");
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
var AnnotatedBuffer = __turbopack_context__.r("[project]/node_modules/bufrw/annotated_buffer.js [app-rsc] (ecmascript)");
var errorHighlighter = __turbopack_context__.r("[project]/node_modules/bufrw/error_highlighter.js [app-rsc] (ecmascript)");
function makeAnnotatedBuffer(buffer, start, clear) {
    // istanbul ignore if
    if (start > 0) buffer = buffer.slice(start);
    // istanbul ignore if
    if (clear) buffer.fill(0);
    return new AnnotatedBuffer(buffer);
}
function annotateError(res1, res2, start, annBuf) {
    // istanbul ignore if
    if (!res2.err || res2.offset !== res1.offset - start || res2.err.type !== res1.err.type || res2.err.message !== res1.err.message) {
        res1.err = errors.UnstableRW(res1.err, {
            otherMessage: res2.err && res2.err.message
        });
    } else {
        res1.err.buffer = annBuf;
    }
}
var emptyBuffer = Buffer.alloc(0);
function fromBuffer(rw, buffer, offset) {
    return fromBufferResult(rw, buffer, offset).toValue();
}
function byteLength(rw, value) {
    return byteLengthResult(rw, value).toValue();
}
function toBuffer(rw, value) {
    return toBufferResult(rw, value).toValue();
}
function intoBuffer(rw, buffer, value) {
    return intoBufferResult(rw, buffer, value).toValue();
}
// The "Tuple" methods are deprecated
/* istanbul ignore next */ function fromBufferTuple(rw, buffer, offset) {
    return fromBufferResult(rw, buffer, offset).toTuple();
}
/* istanbul ignore next */ function byteLengthTuple(rw, value) {
    return byteLengthResult(rw, value).toTuple();
}
/* istanbul ignore next */ function toBufferTuple(rw, value) {
    return toBufferResult(rw, value).toTuple();
}
/* istanbul ignore next */ function intoBufferTuple(rw, buffer, value) {
    return intoBufferResult(rw, buffer, value).toTuple();
}
function checkAllReadFrom(res, buffer) {
    if (!res.err && res.offset !== buffer.length) {
        res.err = errors.ShortRead({
            remaining: buffer.length - res.offset,
            buffer: buffer,
            offset: res.offset
        });
    }
    return res;
}
function genericResult(err, value, buffer, offset) {
    if (err) {
        if (err.offset === undefined) err.offset = offset;
        if (err.buffer === undefined) err.buffer = buffer;
    }
    return new Result(err, value);
}
function fromBufferResult(rw, buffer, offset) {
    var start = offset || 0;
    var res = rw.readFrom(buffer, start);
    res = checkAllReadFrom(res, buffer);
    if (res.err) {
        var annBuf = makeAnnotatedBuffer(buffer, start, false);
        var res2 = rw.readFrom(annBuf, 0);
        res2 = checkAllReadFrom(res2, buffer);
        annotateError(res, res2, start, annBuf);
    }
    return genericResult(res.err, res.value, buffer, res.offset);
}
function byteLengthResult(rw, value) {
    var lenRes = rw.byteLength(value);
    if (lenRes.err) return new Result(lenRes.err, 0);
    else return new Result(null, lenRes.length);
}
function toBufferResult(rw, value) {
    var lenRes = rw.byteLength(value);
    if (lenRes.err) return new Result(lenRes.err, emptyBuffer);
    var length = lenRes.length;
    var buffer = Buffer.alloc(length);
    return intoBufferResult(rw, buffer, value);
}
function checkAllWroteOver(res, buffer) {
    if (!res.err && res.offset !== buffer.length) {
        res.err = errors.ShortWrite({
            remaining: buffer.length - res.offset,
            buffer: buffer,
            offset: res.offset
        });
    }
    return res;
}
function intoBufferResult(rw, buffer, value) {
    var res = rw.writeInto(value, buffer, 0);
    res = checkAllWroteOver(res, buffer);
    return genericResult(res.err, buffer, buffer, res.offset);
}
// istanbul ignore next TODO
function formatError(err, options) {
    options = options || {};
    var name = err.name || err.constructor.name;
    var str = util.format('%s: %s\n', name, err.message);
    if (err.buffer && err.buffer.hexdump) {
        str += err.buffer.hexdump({
            colored: options.color,
            boldStart: false,
            highlight: options.color ? errorHighlighter(err, options) : null
        });
    } else if (Buffer.isBuffer(err.buffer)) {
        if (options.color) {
            str += formatBufferColored(err, options);
        } else {
            str += formatBufferUncolored(err, options);
        }
    }
    return str;
}
// istanbul ignore next TODO
function formatBufferColored(err, options) {
    // istanbul ignore else
    if (!hex) {
        return err.buffer.toString('hex');
    }
    options = options || {};
    var opts = options.hexerOptions ? Object.create(options.hexerOptions) : {};
    if (opts.colored === undefined) {
        opts.colored = true;
    }
    var highlight = errorHighlighter(err, options);
    opts.decorateHexen = highlight;
    opts.decorateHuman = highlight;
    return hex(err.buffer, opts);
}
// istanbul ignore next TODO
function formatBufferUncolored(err, options) {
    // istanbul ignore else
    if (!hex) {
        return err.buffer.toString('hex');
    }
    options = options || {};
    var hasOffset = !(err.offset === undefined || err.offset === null);
    var hasEnd = !(err.endOffset === undefined || err.endOffset === null);
    var markStart = options.markStart || '>';
    var markEnd = options.markEnd || '<';
    var accum = 0;
    var opts = options.hexerOptions ? Object.create(options.hexerOptions) : {};
    if (hasOffset) {
        opts.groupSeparator = '';
        if (hasEnd) {
            opts.decorateHexen = decorateRangedError;
        } else {
            opts.decorateHexen = decorateError;
        }
    }
    return hex(err.buffer, opts);
    "TURBOPACK unreachable";
    // TODO: suspected broken across lines, should either test and complete or
    // use some sort of alternate notation such as interstitial lines
    function decorateRangedError(totalOffset, screenOffset, hexen) {
        var s;
        if (totalOffset === err.offset) {
            accum = 1;
            s = markStart + hexen;
            if (totalOffset === err.endOffset - 1) {
                s += markEnd;
                accum = 0;
            } else {
                s = ' ' + s;
            }
            return s;
        } else if (totalOffset === err.endOffset - 1) {
            s = hexen + markEnd;
            while(accum-- > 0)s += ' ';
            accum = 0;
            return s;
        } else if (accum) {
            accum += 2;
            return hexen;
        } else {
            return ' ' + hexen + ' ';
        }
    }
    function decorateError(totalOffset, screenOffset, hexen) {
        if (totalOffset === err.offset) {
            return markStart + hexen + markEnd;
        } else {
            return ' ' + hexen + ' ';
        }
    }
}
module.exports.fromBuffer = fromBuffer;
module.exports.byteLength = byteLength;
module.exports.toBuffer = toBuffer;
module.exports.intoBuffer = intoBuffer;
module.exports.formatError = formatError;
module.exports.fromBufferTuple = fromBufferTuple;
module.exports.byteLengthTuple = byteLengthTuple;
module.exports.toBufferTuple = toBufferTuple;
module.exports.intoBufferTuple = intoBufferTuple;
module.exports.fromBufferResult = fromBufferResult;
module.exports.byteLengthResult = byteLengthResult;
module.exports.toBufferResult = toBufferResult;
module.exports.intoBufferResult = intoBufferResult;
module.exports.makeAnnotatedBuffer = makeAnnotatedBuffer;
module.exports.checkAllReadFrom = checkAllReadFrom;
module.exports.annotateError = annotateError;
}}),
"[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
var assert = __turbopack_context__.r("[externals]/assert [external] (assert, cjs)");
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
module.exports.BufferRW = BufferRW;
module.exports.LengthResult = LengthResult;
module.exports.WriteResult = WriteResult;
module.exports.ReadResult = ReadResult;
function BufferRW(byteLength, readFrom, writeInto, isPooled) {
    if (!(this instanceof BufferRW)) {
        return new BufferRW(byteLength, readFrom, writeInto, isPooled);
    }
    // istanbul ignore else
    if (byteLength && readFrom && writeInto) {
        assert(typeof byteLength === 'function', 'expected byteLength to be function');
        assert(typeof readFrom === 'function', 'expected readFrom to be function');
        assert(typeof writeInto === 'function', 'expected writeInto to be function');
        // istanbul ignore else
        if (isPooled) {
            this.poolByteLength = byteLength;
            this.poolReadFrom = readFrom;
            this.poolWriteInto = writeInto;
        } else {
            this.byteLength = byteLength;
            this.readFrom = readFrom;
            this.writeInto = writeInto;
        }
    } else {
        // Args weren't specified. Expect either pool methods or regular
        // methods to be overriden.
        assert(this.poolReadFrom !== BufferRW.prototype.poolReadFrom || this.readFrom !== BufferRW.prototype.readFrom, 'expected either poolReadFrom or readFrom to be overriden');
        assert(this.poolWriteInto !== BufferRW.prototype.poolWriteInto || this.writeInto !== BufferRW.prototype.writeInto, 'expected either poolWriteInto or writeInto to be overriden');
        assert(this.poolByteLength !== BufferRW.prototype.poolByteLength || this.byteLength !== BufferRW.prototype.byteLength, 'expected either poolByteLength or byteLength to be overriden');
    }
}
BufferRW.prototype.readFrom = function readFrom(arg1, arg2, arg3) {
    assert(this.poolReadFrom !== BufferRW.prototype.poolReadFrom, 'poolReadFrom is overridden');
    var readResult = new ReadResult();
    this.poolReadFrom(readResult, arg1, arg2, arg3);
    return readResult;
};
BufferRW.prototype.writeInto = function writeInto(value, buffer, offset) {
    assert(this.poolWriteInto !== BufferRW.prototype.poolWriteInto, 'poolWriteInto is overridden');
    var writeResult = new WriteResult();
    this.poolWriteInto(writeResult, value, buffer, offset);
    return writeResult;
};
BufferRW.prototype.byteLength = function byteLength(arg1, arg2, arg3) {
    assert(this.poolbyteLength !== BufferRW.prototype.poolByteLength, 'poolByteLength is overridden');
    var lengthResult = new LengthResult();
    this.poolByteLength(lengthResult, arg1, arg2, arg3);
    return lengthResult;
};
// istanbul ignore next
BufferRW.prototype.poolReadFrom = function poolReadFrom(destResult, arg1, arg2, arg3) {
    var res = this.readFrom(arg1, arg2, arg3);
    return destResult.copyFrom(res);
};
// istanbul ignore next
BufferRW.prototype.poolWriteInto = function poolWriteInto(destResult, value, buffer, offset) {
    var res = this.writeInto(value, buffer, offset);
    return destResult.copyFrom(res);
};
// istanbul ignore next
BufferRW.prototype.poolByteLength = function poolByteLength(destResult, arg1, arg2, arg3) {
    var res = this.byteLength(arg1, arg2, arg3);
    return destResult.copyFrom(res);
};
function LengthResult(err, length) {
    this.err = err || null;
    this.length = length || 0;
}
LengthResult.prototype.reset = function reset(err, length) {
    this.err = err;
    this.length = length;
    return this;
};
// istanbul ignore next
LengthResult.prototype.copyFrom = function copyFrom(srcRes) {
    this.err = srcRes.err;
    this.length = srcRes.length;
    return this;
};
// istanbul ignore next
LengthResult.error = function error(err, length) {
    return new LengthResult(err, length);
};
// istanbul ignore next
LengthResult.just = function just(length) {
    return new LengthResult(null, length);
};
function WriteResult(err, offset) {
    this.err = err || null;
    this.offset = offset || 0;
}
WriteResult.prototype.reset = function reset(err, offset) {
    this.err = err;
    this.offset = offset;
    return this;
};
// istanbul ignore next
WriteResult.prototype.copyFrom = function copyFrom(srcResult) {
    this.err = srcResult.err;
    this.offset = srcResult.offset;
};
// istanbul ignore next
WriteResult.error = function error(err, offset) {
    return new WriteResult(err, offset);
};
// istanbul ignore next
/*jshint maxparams:6*/ WriteResult.poolRangedError = function poolRangedError(destResult, err, start, end, value) {
    assert(typeof destResult === 'object' && destResult.constructor.name === 'WriteResult');
    err.offest = start;
    err.endOffset = end;
    return destResult.reset(err, start, value);
};
// istanbul ignore next
WriteResult.rangedError = function rangedError(err, start, end, value) {
    return WriteResult.poolRangedError(new WriteResult(), start, end, value);
};
// istanbul ignore next
WriteResult.just = function just(offset) {
    return new WriteResult(null, offset);
};
// istanbul ignore next
WriteResult.shortError = function shortError(expected, actual, offset) {
    return WriteResult.poolShortError(new WriteResult(), expected, actual, offset);
};
// istanbul ignore next
WriteResult.poolShortError = function poolShortError(destResult, expected, actual, offset) {
    assert(typeof destResult === 'object' && destResult.constructor.name === 'WriteResult');
    return destResult.reset(new errors.ShortBuffer({
        expected: expected,
        actual: actual,
        offset: offset
    }), offset);
};
function ReadResult(err, offset, value) {
    this.err = err || null;
    this.offset = offset || 0;
    // istanbul ignore next
    this.value = value === undefined ? null : value;
}
// istanbul ignore next
ReadResult.prototype.copyFrom = function copyFrom(srcResult) {
    this.err = srcResult.err;
    this.offset = srcResult.offset;
    this.value = srcResult.value;
    return this;
};
// istanbul ignore next
ReadResult.prototype.reset = function reset(err, offset, value) {
    this.err = err;
    this.offset = offset;
    this.value = value;
    return this;
};
// istanbul ignore next
ReadResult.error = function error(err, offset, value) {
    return new ReadResult(err, offset, value);
};
// istanbul ignore next
ReadResult.poolRangedError = function poolRangedError(destResult, err, start, end, value) {
    assert(typeof destResult === 'object' && destResult.constructor.name === 'ReadResult');
    err.offest = start;
    err.endOffset = end;
    return destResult.reset(err, start, value);
};
// istanbul ignore next
ReadResult.rangedError = function rangedError(err, start, end, value) {
    return ReadResult.poolRangedError(new ReadResult(), err, start, end, value);
};
// istanbul ignore next
ReadResult.just = function just(offset, value) {
    return new ReadResult(null, offset, value);
};
// istanbul ignore next
ReadResult.shortError = function shortError(destResult, expected, actual, offset, endOffset) {
    return ReadResult.poolShortError(new ReadResult(), expected, actual, offset, endOffset);
};
ReadResult.poolShortError = function poolShortError(destResult, expected, actual, offset, endOffset) {
    assert(typeof destResult === 'object' && destResult.constructor.name === 'ReadResult');
    var err;
    if (endOffset === undefined) {
        err = new errors.ShortBuffer({
            expected: expected,
            actual: actual,
            offset: offset
        });
    } else {
        err = new errors.ShortBufferRanged({
            expected: expected,
            actual: actual,
            offset: offset,
            endOffset: endOffset
        });
    }
    return destResult.reset(err, offset);
};
}}),
"[project]/node_modules/bufrw/atoms.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var WriteResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").WriteResult;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
function AtomRW(width, readAtomFrom, writeAtomInto) {
    if (!(this instanceof AtomRW)) {
        return new AtomRW(width, readAtomFrom, writeAtomInto);
    }
    this.width = width;
    this.readAtomFrom = readAtomFrom;
    this.writeAtomInto = writeAtomInto;
    BufferRW.call(this);
}
inherits(AtomRW, BufferRW);
AtomRW.prototype.poolByteLength = function byteLength(destResult) {
    return destResult.reset(null, this.width);
};
AtomRW.prototype.poolReadFrom = function readFrom(destResult, buffer, offset) {
    var remain = buffer.length - offset;
    if (remain < this.width) {
        return ReadResult.poolShortError(destResult, this.width, remain, offset);
    }
    return this.readAtomFrom(destResult, buffer, offset);
};
AtomRW.prototype.poolWriteInto = function writeInto(destResult, value, buffer, offset) {
    var remain = buffer.length - offset;
    // istanbul ignore next
    if (remain < this.width) {
        WriteResult.poolShortError(destResult, this.width, remain, offset);
    }
    return this.writeAtomInto(destResult, value, buffer, offset);
};
// jshint maxparams:5
function IntegerRW(width, min, max, readAtomFrom, writeAtomInto) {
    if (!(this instanceof IntegerRW)) {
        return new IntegerRW(width, min, max, readAtomFrom, writeAtomInto);
    }
    AtomRW.call(this, width, readAtomFrom, writeAtomInto);
    this.min = min;
    this.max = max;
}
inherits(IntegerRW, AtomRW);
IntegerRW.prototype.poolWriteInto = function poolWriteInto(destResult, value, buffer, offset) {
    if (typeof value !== 'number') {
        return destResult.reset(errors.expected(value, 'a number'));
    }
    if (value < this.min || value > this.max) {
        return destResult.reset(errors.RangeError({
            value: value,
            min: this.min,
            max: this.max
        }), offset);
    }
    var remain = buffer.length - offset;
    if (remain < this.width) {
        return WriteResult.poolShortError(destResult, this.width, remain, offset);
    }
    return this.writeAtomInto(destResult, value, buffer, offset);
};
var Int8 = IntegerRW(1, -0x80, 0x7f, function readInt8From(destResult, buffer, offset) {
    var value = buffer.readInt8(offset, true);
    return destResult.reset(null, offset + 1, value);
}, function writeInt8Into(destResult, value, buffer, offset) {
    buffer.writeInt8(value, offset, true);
    return destResult.reset(null, offset + 1);
});
var Int16BE = IntegerRW(2, -0x8000, 0x7fff, function readInt16BEFrom(destResult, buffer, offset) {
    var value = buffer.readInt16BE(offset, true);
    return destResult.reset(null, offset + 2, value);
}, function writeInt16BEInto(destResult, value, buffer, offset) {
    buffer.writeInt16BE(value, offset, true);
    return destResult.reset(null, offset + 2);
});
var Int32BE = IntegerRW(4, -0x80000000, 0x7fffffff, function readInt32BEFrom(destResult, buffer, offset) {
    var value = buffer.readInt32BE(offset, true);
    return destResult.reset(null, offset + 4, value);
}, function writeInt32BEInto(destResult, value, buffer, offset) {
    buffer.writeInt32BE(value, offset, true);
    return destResult.reset(null, offset + 4);
});
var Int16LE = IntegerRW(2, -0x8000, 0x7fff, function readInt16LEFrom(destResult, buffer, offset) {
    var value = buffer.readInt16LE(offset, true);
    return destResult.reset(null, offset + 2, value);
}, function writeInt16LEInto(destResult, value, buffer, offset) {
    buffer.writeInt16LE(value, offset, true);
    return destResult.reset(null, offset + 2);
});
var Int32LE = IntegerRW(4, -0x80000000, 0x7fffffff, function readInt32LEFrom(destResult, buffer, offset) {
    var value = buffer.readInt32LE(offset, true);
    return destResult.reset(null, offset + 4, value);
}, function writeInt32LEInto(destResult, value, buffer, offset) {
    buffer.writeInt32LE(value, offset, true);
    return destResult.reset(null, offset + 4);
});
var UInt8 = IntegerRW(1, 0, 0xff, function readUInt8From(destResult, buffer, offset) {
    var value = buffer.readUInt8(offset, true);
    return destResult.reset(null, offset + 1, value);
}, function writeUInt8Into(destResult, value, buffer, offset) {
    buffer.writeUInt8(value, offset, true);
    return destResult.reset(null, offset + 1);
});
var UInt16BE = IntegerRW(2, 0, 0xffff, function readUInt16BEFrom(destResult, buffer, offset) {
    var value = buffer.readUInt16BE(offset, true);
    return destResult.reset(null, offset + 2, value);
}, function writeUInt16BEInto(destResult, value, buffer, offset) {
    buffer.writeUInt16BE(value, offset, true);
    return destResult.reset(null, offset + 2);
});
var UInt32BE = IntegerRW(4, 0, 0xffffffff, function readUInt32BEFrom(destResult, buffer, offset) {
    var value = buffer.readUInt32BE(offset, true);
    return destResult.reset(null, offset + 4, value);
}, function writeUInt32BEInto(destResult, value, buffer, offset) {
    buffer.writeUInt32BE(value, offset, true);
    return destResult.reset(null, offset + 4);
});
var UInt16LE = IntegerRW(2, 0, 0xffff, function readUInt16LEFrom(destResult, buffer, offset) {
    var value = buffer.readUInt16LE(offset, true);
    return destResult.reset(null, offset + 2, value);
}, function writeUInt16LEInto(destResult, value, buffer, offset) {
    buffer.writeUInt16LE(value, offset, true);
    return destResult.reset(null, offset + 2);
});
var UInt32LE = IntegerRW(4, 0, 0xffffffff, function readUInt32LEFrom(destResult, buffer, offset) {
    var value = buffer.readUInt32LE(offset, true);
    return destResult.reset(null, offset + 4, value);
}, function writeUInt32LEInto(destResult, value, buffer, offset) {
    buffer.writeUInt32LE(value, offset, true);
    return destResult.reset(null, offset + 4);
});
var FloatLE = AtomRW(4, function readFloatLEFrom(destResult, buffer, offset) {
    var value = buffer.readFloatLE(offset, true);
    return destResult.reset(null, offset + 4, value);
}, function writeFloatLEInto(destResult, value, buffer, offset) {
    // istanbul ignore if
    if (typeof value !== 'number') {
        return destResult.reset(errors.expected(value, 'a number'), null);
    } else {
        buffer.writeFloatLE(value, offset);
        return destResult.reset(null, offset + 4);
    }
});
var FloatBE = AtomRW(4, function readFloatBEFrom(destResult, buffer, offset) {
    var value = buffer.readFloatBE(offset, true);
    return destResult.reset(null, offset + 4, value);
}, function writeFloatBEInto(destResult, value, buffer, offset) {
    // istanbul ignore if
    if (typeof value !== 'number') {
        return destResult.reset(errors.expected(value, 'a number'), null);
    } else {
        buffer.writeFloatBE(value, offset);
        return destResult.reset(null, offset + 4);
    }
});
var DoubleLE = AtomRW(8, function readDoubleLEFrom(destResult, buffer, offset) {
    var value = buffer.readDoubleLE(offset, true);
    return destResult.reset(null, offset + 8, value);
}, function writeDoubleLEInto(destResult, value, buffer, offset) {
    // istanbul ignore if
    if (typeof value !== 'number') {
        return destResult.reset(errors.expected(value, 'a number'), null);
    } else {
        buffer.writeDoubleLE(value, offset);
        return destResult.reset(null, offset + 8);
    }
});
var DoubleBE = AtomRW(8, function readDoubleBEFrom(destResult, buffer, offset) {
    var value = buffer.readDoubleBE(offset, true);
    return destResult.reset(null, offset + 8, value);
}, function writeDoubleBEInto(destResult, value, buffer, offset) {
    // istanbul ignore if
    if (typeof value !== 'number') {
        return destResult.reset(errors.expected(value, 'a number'), null);
    } else {
        buffer.writeDoubleBE(value, offset);
        return destResult.reset(null, offset + 8);
    }
});
module.exports.AtomRW = AtomRW;
module.exports.Int8 = Int8;
module.exports.Int16BE = Int16BE;
module.exports.Int32BE = Int32BE;
module.exports.Int16LE = Int16LE;
module.exports.Int32LE = Int32LE;
module.exports.UInt8 = UInt8;
module.exports.UInt16BE = UInt16BE;
module.exports.UInt32BE = UInt32BE;
module.exports.UInt16LE = UInt16LE;
module.exports.UInt32LE = UInt32LE;
module.exports.FloatLE = FloatLE;
module.exports.FloatBE = FloatBE;
module.exports.DoubleLE = DoubleLE;
module.exports.DoubleBE = DoubleBE;
}}),
"[project]/node_modules/bufrw/null.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
var AtomRW = __turbopack_context__.r("[project]/node_modules/bufrw/atoms.js [app-rsc] (ecmascript)").AtomRW;
function nullWriteInto(destResult, val, buffer, offset) {
    //return new WriteResult(null, offset);
    return destResult.reset(null, offset);
}
function nullReadFrom(destResult, buffer, offset) {
    //return new ReadResult(null, offset, null);
    return destResult.reset(null, offset, null);
}
var NullRW = AtomRW(0, nullReadFrom, nullWriteInto);
module.exports = NullRW;
}}),
"[project]/node_modules/bufrw/fixed_width_rw.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
module.exports = FixedWidthRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
function FixedWidthRW(length, readFrom, writeInto) {
    if (!(this instanceof FixedWidthRW)) {
        return new FixedWidthRW(length, readFrom, writeInto);
    }
    this.length = length;
// BufferRW.call(this);
}
inherits(FixedWidthRW, BufferRW);
FixedWidthRW.prototype.poolByteLength = function poolByteLength(destResult, slice) {
    if (slice.length !== this.length) {
        return destResult.reset(errors.FixedLengthMismatch({
            expected: this.length,
            got: slice.length
        }), null);
    } else {
        return destResult.reset(null, this.length);
    }
};
FixedWidthRW.prototype.poolWriteInto = function poolWriteInto(destResult, slice, buffer, offset) {
    if (slice.length !== this.length) {
        return destResult.reset(errors.FixedLengthMismatch({
            expected: this.length,
            got: slice.length
        }), offset);
    }
    slice.copy(buffer, offset);
    //return new WriteResult(null, offset + this.length);
    return destResult.reset(null, offset + this.length);
};
FixedWidthRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    var end = offset + this.length;
    if (end > buffer.length) {
        return ReadResult.poolShortError(destResult, this.length, buffer.length - offset, offset);
    } else {
        //var res = new ReadResult(null, end, buffer.slice(offset, end));
        return destResult.reset(null, end, buffer.slice(offset, end));
    }
};
}}),
"[project]/node_modules/bufrw/variable_buffer_rw.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = VariableBufferRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
function VariableBufferRW(sizerw, lazy) {
    if (!(this instanceof VariableBufferRW)) {
        return new VariableBufferRW(sizerw, lazy);
    }
    this.sizerw = sizerw;
    if (lazy) {
        this.poolReadFrom = this.lazyPoolReadFrom;
    } else {
        this.poolReadFrom = this.eagerPoolReadFrom;
    }
    BufferRW.call(this);
}
inherits(VariableBufferRW, BufferRW);
VariableBufferRW.prototype.poolByteLength = function poolByteLength(destResult, buf) {
    var length = 0;
    if (Buffer.isBuffer(buf)) {
        length = buf.length;
    } else if (buf === null || buf === undefined) {
        length = 0;
    } else {
        return destResult.reset(errors.expected(buf, 'buffer, null, or undefined'), null);
    }
    this.sizerw.poolByteLength(destResult, length);
    if (destResult.err) return destResult;
    return destResult.reset(null, destResult.length + length);
};
VariableBufferRW.prototype.poolWriteInto = function poolWriteInto(destResult, buf, buffer, offset) {
    var start = offset + this.sizerw.width;
    var length = 0;
    if (Buffer.isBuffer(buf)) {
        length = buf.copy(buffer, start);
    } else if (buf === null || buf === undefined) {
        length = 0;
    } else {
        return destResult.reset(errors.expected(buf, 'buffer, null, or undefined'), offset);
    }
    this.sizerw.poolWriteInto(destResult, length, buffer, offset);
    if (destResult.err) return destResult;
    return destResult.reset(null, start + length);
};
VariableBufferRW.prototype.eagerPoolReadFrom = function eagerPoolReadFrom(destResult, buffer, offset) {
    this.sizerw.poolReadFrom(destResult, buffer, offset);
    if (destResult.err) return destResult;
    var length = destResult.value;
    var remain = buffer.length - destResult.offset;
    if (remain < length) {
        return ReadResult.poolShortError(destResult, length, remain, offset, destResult.offset);
    } else {
        offset = destResult.offset;
        var buf = Buffer.alloc(length);
        buffer.copy(buf, 0, offset);
        return destResult.reset(null, offset + length, buf);
    }
};
VariableBufferRW.prototype.lazyPoolReadFrom = function lazyPoolReadFrom(destResult, buffer, offset) {
    this.sizerw.poolReadFrom(destResult, buffer, offset);
    if (destResult.err) return destResult;
    var length = destResult.value;
    var remain = buffer.length - destResult.offset;
    if (remain < length) {
        return ReadResult.poolShortError(destResult, length, remain, offset, destResult.offset);
    } else {
        offset = destResult.offset;
        var end = offset + length;
        var buf = buffer.slice(offset, end);
        return destResult.reset(null, end, buf);
    }
};
}}),
"[project]/node_modules/bufrw/string_rw.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
module.exports = StringRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
function StringRW(sizerw, encoding) {
    if (!(this instanceof StringRW)) {
        return new StringRW(sizerw, encoding);
    }
    this.sizerw = sizerw;
    this.encoding = encoding || 'utf8';
    if (!this.sizerw.width) {
        this.poolWriteInto = this.poolWriteVariableWidthInto;
    } else {
        this.poolWriteInto = this.poolWriteFixedWidthInto;
    }
    BufferRW.call(this);
}
inherits(StringRW, BufferRW);
StringRW.prototype.poolByteLength = function poolByteLength(destResult, str) {
    var length = 0;
    if (typeof str === 'string') {
        length = Buffer.byteLength(str, this.encoding);
    } else if (str !== null && str !== undefined) {
        return destResult.reset(errors.expected(str, 'string, null, or undefined'), null);
    }
    this.sizerw.poolByteLength(destResult, length);
    if (destResult.err) return destResult;
    return destResult.reset(null, destResult.length + length);
};
StringRW.prototype.poolWriteFixedWidthInto = function poolWriteFixedWidthInto(destResult, str, buffer, offset) {
    var start = offset + this.sizerw.width;
    var length = 0;
    if (typeof str === 'string') {
        length = buffer.write(str, start, this.encoding);
    } else if (str !== null && str !== undefined) {
        return destResult.reset(errors.expected(str, 'string, null, or undefined'), offset);
    }
    this.sizerw.poolWriteInto(destResult, length, buffer, offset);
    // istanbul ignore if
    if (destResult.err) return destResult;
    return destResult.reset(null, start + length);
};
StringRW.prototype.poolWriteVariableWidthInto = function poolWriteVariableWidthInto(destResult, str, buffer, offset) {
    var size = 0;
    if (typeof str === 'string') {
        size = Buffer.byteLength(str, this.encoding);
    } else if (str !== null && str !== undefined) {
        return destResult.reset(errors.expected(str, 'string, null, or undefined'), offset);
    }
    var res = this.sizerw.poolWriteInto(destResult, size, buffer, offset);
    if (res.err) return res;
    offset = res.offset;
    if (typeof str === 'string') {
        res.offset += buffer.write(str, offset, this.encoding);
    }
    return res;
};
StringRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    var res = this.sizerw.poolReadFrom(destResult, buffer, offset);
    if (res.err) return res;
    var length = res.value;
    var remain = buffer.length - res.offset;
    if (remain < length) {
        return ReadResult.poolShortError(destResult, length, remain, offset, res.offset);
    } else {
        offset = res.offset;
        var end = offset + length;
        var str = buffer.toString(this.encoding, offset, end);
        return destResult.reset(null, end, str);
    }
};
}}),
"[project]/node_modules/bufrw/varint.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
'use strict';
var WriteResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").WriteResult;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
// TODO: zigzag support for signed-s
module.exports.unsigned = BufferRW(unsignedVarIntByteLength, readUnsignedVarIntFrom, writeUnsignedVarIntInto, true);
function unsignedVarIntByteLength(destResult, n) {
    if (typeof n !== 'number' || n < 0) {
        // TODO: integer check
        return destResult.reset(errors.expected(n, 'unsigned integer'));
    }
    if (n === 0) return destResult.reset(null, 1);
    var needed = Math.ceil(countBits(n) / 7);
    return destResult.reset(null, needed);
}
function writeUnsignedVarIntInto(destResult, n, buffer, offset) {
    if (typeof n !== 'number' || n < 0) {
        // TODO: integer check
        return destResult.reset(errors.expected(n, 'unsigned integer'), null);
    }
    var needed = Math.ceil(countBits(n) / 7);
    var start = offset;
    var end = offset + needed;
    if (end > buffer.length) {
        var remain = buffer.length - offset;
        return WriteResult.poolShortError(destResult, needed, remain, offset);
    }
    offset = end;
    while(offset > start){
        var b = n & 0x7f;
        n >>= 7;
        if (offset !== end) b |= 0x80;
        buffer.writeUInt8(b, --offset, true);
        if (n <= 0) break;
    }
    return destResult.reset(null, end);
}
function readUnsignedVarIntFrom(destResult, buffer, offset) {
    var start = offset;
    var n = 0;
    while(offset < buffer.length){
        var b = buffer.readUInt8(offset++, true);
        if (n !== 0) n <<= 7;
        n += b & 0x7f;
        if (!(b & 0x80)) {
            return destResult.reset(null, offset, n);
        }
    }
    var got = offset - start;
    return ReadResult.poolShortError(destResult, got + 1, got, start, offset);
}
function countBits(n) {
    var res = 1;
    while(n >>= 1)res++;
    return res;
}
}}),
"[project]/node_modules/bufrw/series.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = SeriesRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
function SeriesRW(rws) {
    if (!Array.isArray(rws) || arguments.length > 1) {
        rws = Array.prototype.slice.call(arguments);
    }
    if (!(this instanceof SeriesRW)) {
        return new SeriesRW(rws);
    }
    this.rws = rws;
    BufferRW.call(this);
}
inherits(SeriesRW, BufferRW);
SeriesRW.prototype.poolByteLength = function poolByteLength(destResult, values) {
    if (!Array.isArray(values) && values !== null) {
        return destResult.reset(errors.expected(values, 'an array or null'));
    }
    var length = 0;
    for(var i = 0; i < this.rws.length; i++){
        this.rws[i].poolByteLength(destResult, values && values[i]);
        if (destResult.err) return destResult;
        length += destResult.length;
    }
    return destResult.reset(null, length);
};
SeriesRW.prototype.poolWriteInto = function poolWriteInto(destResult, values, buffer, offset) {
    if (!Array.isArray(values) && values !== null) {
        return destResult.reset(errors.expected(values, 'an array or null'), offset);
    }
    for(var i = 0; i < this.rws.length; i++){
        this.rws[i].poolWriteInto(destResult, values && values[i], buffer, offset);
        if (destResult.err) return destResult;
        offset = destResult.offset;
    }
    return destResult;
};
var readResult = new ReadResult();
SeriesRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    // The prior value cannot be reused, even if it is already an array of the right size.
    // The array may have been captured by reference by the prior consumer.
    var values = new Array(this.rws.length);
    for(var i = 0; i < this.rws.length; i++){
        this.rws[i].poolReadFrom(readResult, buffer, offset);
        if (readResult.err) return destResult.copyFrom(readResult);
        offset = readResult.offset;
        values[i] = readResult.value;
    }
    // The values must be assigned to the result last so reading a series is reentrant.
    destResult.value = values;
    return destResult.reset(null, offset, destResult.value);
};
}}),
"[project]/node_modules/bufrw/struct.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = StructRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
function StructRW(cons, fields, opts) {
    if (!(this instanceof StructRW)) {
        return new StructRW(cons, fields);
    }
    if (typeof cons === 'object') {
        fields = cons;
        cons = null;
    }
    var i;
    opts = opts || {};
    this.cons = cons || Object;
    this.fields = [];
    // TODO: useful to have a StructRWField prototype?
    if (Array.isArray(fields)) {
        this.fields.push.apply(this.fields, fields);
    } else {
        var fieldNames = Object.keys(fields);
        for(i = 0; i < fieldNames.length; ++i){
            var field = {};
            field.name = fieldNames[i];
            field.rw = fields[field.name];
            this.fields.push(field);
        }
    }
    this.namedFields = {};
    for(i = 0; i < this.fields.length; ++i){
        if (this.fields[i].name) {
            this.namedFields[this.fields[i].name] = this.fields[i];
        }
    }
}
inherits(StructRW, BufferRW);
StructRW.prototype.poolByteLength = function poolByteLength(destResult, obj) {
    var length = 0;
    for(var i = 0; i < this.fields.length; i++){
        var field = this.fields[i];
        if (field.name && !obj.hasOwnProperty(field.name)) {
            return destResult.reset(errors.MissingStructField({
                field: field.name,
                struct: this.cons.name
            }), null);
        }
        var value = field.name && obj && obj[field.name];
        if (field.call) {
            if (field.call.poolByteLength) {
                field.call.poolByteLength(destResult, obj);
            } else if (field.call.byteLength) {
                var res = field.call.byteLength(obj);
                destResult.copyFrom(res);
            } else {
                continue;
            }
        } else {
            field.rw.poolByteLength(destResult, value);
        }
        if (destResult.err) return destResult;
        length += destResult.length;
    }
    return destResult.reset(null, length);
};
StructRW.prototype.poolWriteInto = function poolWriteInto(destResult, obj, buffer, offset) {
    destResult.reset(null, offset);
    for(var i = 0; i < this.fields.length; i++){
        var field = this.fields[i];
        if (field.name && !obj.hasOwnProperty(field.name)) {
            return destResult.reset(errors.MissingStructField({
                field: field.name,
                struct: this.cons.name
            }), null);
        }
        var value = field.name && obj[field.name];
        if (field.call) {
            if (field.call.poolWriteInto) {
                field.call.poolWriteInto(destResult, obj, buffer, offset);
            } else if (field.call.writeInto) {
                var res = field.call.writeInto(obj, buffer, offset);
                destResult.copyFrom(res);
            } else {
                continue;
            }
        } else {
            field.rw.poolWriteInto(destResult, value, buffer, offset);
        }
        if (destResult.err) return destResult;
        offset = destResult.offset;
    }
    return destResult;
};
var readRes = new ReadResult();
StructRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    if (typeof destResult.value === 'object' && destResult.value !== null) {
        if (destResult.value.constructor !== this.cons) {
            destResult.value = new this.cons();
        }
    } else {
        destResult.value = new this.cons();
    }
    for(var i = 0; i < this.fields.length; i++){
        var field = this.fields[i];
        if (field.call) {
            if (field.call.poolReadFrom) {
                field.call.poolReadFrom(readRes, destResult.value, buffer, offset);
            } else if (field.call.readFrom) {
                var res = field.call.readFrom(destResult.value, buffer, offset);
                readRes.copyFrom(res);
            } else {
                continue;
            }
        } else {
            field.rw.poolReadFrom(readRes, buffer, offset);
        }
        if (readRes.err) return destResult.copyFrom(readRes);
        offset = readRes.offset;
        if (field.name) {
            destResult.value[field.name] = readRes.value;
        }
    }
    return destResult.reset(null, offset, destResult.value);
};
}}),
"[project]/node_modules/bufrw/switch.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = SwitchRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
// TODO: cases should be an es6 map
function SwitchRW(valrw, cases, opts) {
    if (!(this instanceof SwitchRW)) {
        return new SwitchRW(valrw, cases, opts);
    }
    opts = opts || {};
    this.valrw = valrw;
    this.cases = cases;
    this.cons = opts.cons || Pair;
    this.valKey = opts.valKey || '0';
    this.dataKey = opts.dataKey || '1';
    // istanbul ignore if TODO
    if (opts.structMode) {
        this.poolReadFrom = this.structReadFrom;
    }
    BufferRW.call(this);
}
inherits(SwitchRW, BufferRW);
SwitchRW.prototype.poolByteLength = function poolByteLength(destResult, obj) {
    var val = obj[this.valKey];
    var data = obj[this.dataKey];
    var datarw = this.cases[val];
    if (datarw === undefined) {
        return destResult.reset(errors.WriteInvalidSwitchValue({
            value: val
        }));
    }
    this.valrw.poolByteLength(destResult, val);
    if (destResult.err) return destResult;
    var vallen = destResult.length;
    datarw.poolByteLength(destResult, data);
    if (destResult.err) return destResult;
    var caselen = destResult.length;
    return destResult.reset(null, caselen + vallen);
};
SwitchRW.prototype.poolWriteInto = function poolWriteInto(destResult, obj, buffer, offset) {
    var val = obj[this.valKey];
    var data = obj[this.dataKey];
    var datarw = this.cases[val];
    if (datarw === undefined) {
        return destResult.reset(errors.WriteInvalidSwitchValue({
            value: val
        }), offset);
    }
    var res = this.valrw.poolWriteInto(destResult, val, buffer, offset);
    if (res.err) return res;
    res = datarw.poolWriteInto(destResult, data, buffer, res.offset);
    return res;
};
SwitchRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    var res = this.valrw.poolReadFrom(destResult, buffer, offset);
    if (res.err) return res;
    offset = res.offset;
    var val = res.value;
    var datarw = this.cases[val];
    if (datarw === undefined) {
        return destResult.reset(errors.ReadInvalidSwitchValue({
            value: val
        }), offset);
    }
    res = datarw.poolReadFrom(destResult, buffer, offset);
    if (res.err) return res;
    offset = res.offset;
    var data = res.value;
    var obj = new this.cons(val, data);
    return destResult.reset(null, offset, obj);
};
// istanbul ignore next TODO
SwitchRW.prototype.poolStructReadFrom = function poolStructReadFrom(destResult, obj, buffer, offset) {
    var res = this.valrw.poolReadFrom(destResult, buffer, offset);
    if (res.err) return res;
    offset = res.offset;
    var val = res.value;
    var datarw = this.cases[val];
    if (datarw === undefined) {
        return destResult.reset(errors.ReadInvalidSwitchValue({
            value: val
        }), offset);
    }
    obj[this.valKey] = val;
    res = datarw.poolReadFrom(destResult, buffer, offset);
    if (!res.err) {
        obj[this.dataKey] = res.value;
    }
    return res;
};
function Pair(a, b) {
    Array.call(this);
    this[0] = a;
    this[1] = b;
}
inherits(Pair, Array);
SwitchRW.Pair = Pair;
}}),
"[project]/node_modules/bufrw/repeat.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = RepeatRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var BufferRW = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW;
var errors = __turbopack_context__.r("[project]/node_modules/bufrw/errors.js [app-rsc] (ecmascript)");
function RepeatRW(countrw, repeatedrw) {
    if (!(this instanceof RepeatRW)) {
        return new RepeatRW(countrw, repeatedrw);
    }
    this.countrw = countrw;
    this.repeatedrw = repeatedrw;
    BufferRW.call(this);
}
inherits(RepeatRW, BufferRW);
RepeatRW.prototype.poolByteLength = function poolByteLength(destResult, values) {
    if (!Array.isArray(values)) {
        return destResult.reset(errors.expected(values, 'an array'));
    }
    var res = this.countrw.poolByteLength(destResult, values.length);
    if (res.err) return res;
    var length = res.length;
    for(var i = 0; i < values.length; i++){
        var partres = this.repeatedrw.poolByteLength(destResult, values[i]);
        if (partres.err) return partres;
        length += res.length;
    }
    return destResult.reset(null, length);
};
RepeatRW.prototype.poolWriteInto = function poolWriteInto(destResult, values, buffer, offset) {
    if (!Array.isArray(values)) {
        return destResult.reset(errors.expected(values, 'an array'), offset);
    }
    var res = this.countrw.poolWriteInto(destResult, values.length, buffer, offset);
    if (res.err) return res;
    offset = res.offset;
    for(var i = 0; i < values.length; i++){
        res = this.repeatedrw.poolWriteInto(destResult, values[i], buffer, offset);
        if (res.err) return res;
        offset = res.offset;
    }
    return res;
};
RepeatRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    var res = this.countrw.poolReadFrom(destResult, buffer, offset);
    if (res.err) return res;
    offset = res.offset;
    var count = res.value;
    var values = new Array(count);
    for(var i = 0; i < count; i++){
        res = this.repeatedrw.poolReadFrom(destResult, buffer, offset);
        if (res.err) return res;
        offset = res.offset;
        if (Array.isArray(res.value)) values[i] = res.value.slice(0);
        else if (typeof res.value === 'object') values[i] = shallowCopy(res.value);
        else values[i] = res.value;
    }
    return destResult.reset(null, offset, values);
};
function shallowCopy(obj) {
    var keys = Object.keys(obj);
    var i;
    var dest = {};
    for(i = 0; i < keys.length; i++){
        dest[keys[i]] = obj[keys[i]];
    }
    return dest;
}
}}),
"[project]/node_modules/bufrw/skip.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports = SkipRW;
var inherits = __turbopack_context__.r("[externals]/util [external] (util, cjs)").inherits;
var ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var FixedWidthRW = __turbopack_context__.r("[project]/node_modules/bufrw/fixed_width_rw.js [app-rsc] (ecmascript)");
function SkipRW(length, fill) {
    if (!(this instanceof SkipRW)) {
        return new SkipRW(length, fill);
    }
    this.fill = fill || 0;
    FixedWidthRW.call(this, length);
}
inherits(SkipRW, FixedWidthRW);
SkipRW.prototype.poolByteLength = function poolByteLength(destResult) {
    return destResult.reset(null, this.length);
};
SkipRW.prototype.poolWriteInto = function poolWriteInto(destResult, val, buffer, offset) {
    var end = offset + this.length;
    buffer.fill(this.fill, offset, end);
    return destResult.reset(null, end);
};
SkipRW.prototype.poolReadFrom = function poolReadFrom(destResult, buffer, offset) {
    var end = offset + this.length;
    if (end > buffer.length) {
        return ReadResult.poolShortError(destResult, this.length, buffer.length - offset, offset);
    } else {
        return destResult.reset(null, end, null);
    }
};
}}),
"[project]/node_modules/bufrw/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
module.exports.fromBuffer = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").fromBuffer;
module.exports.byteLength = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").byteLength;
module.exports.toBuffer = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").toBuffer;
module.exports.intoBuffer = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").intoBuffer;
module.exports.fromBufferTuple = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").fromBufferTuple;
module.exports.byteLengthTuple = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").byteLengthTuple;
module.exports.toBufferTuple = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").toBufferTuple;
module.exports.intoBufferTuple = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").intoBufferTuple;
module.exports.fromBufferResult = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").fromBufferResult;
module.exports.byteLengthResult = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").byteLengthResult;
module.exports.toBufferResult = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").toBufferResult;
module.exports.intoBufferResult = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").intoBufferResult;
module.exports.formatError = __turbopack_context__.r("[project]/node_modules/bufrw/interface.js [app-rsc] (ecmascript)").formatError;
module.exports.Base = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").BufferRW; // TODO: align names
module.exports.LengthResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").LengthResult;
module.exports.WriteResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").WriteResult;
module.exports.ReadResult = __turbopack_context__.r("[project]/node_modules/bufrw/base.js [app-rsc] (ecmascript)").ReadResult;
var atoms = __turbopack_context__.r("[project]/node_modules/bufrw/atoms.js [app-rsc] (ecmascript)");
module.exports.AtomRW = atoms.AtomRW;
module.exports.Int8 = atoms.Int8;
module.exports.Int16BE = atoms.Int16BE;
module.exports.Int32BE = atoms.Int32BE;
module.exports.Int16LE = atoms.Int16LE;
module.exports.Int32LE = atoms.Int32LE;
module.exports.UInt8 = atoms.UInt8;
module.exports.UInt16BE = atoms.UInt16BE;
module.exports.UInt32BE = atoms.UInt32BE;
module.exports.UInt16LE = atoms.UInt16LE;
module.exports.UInt32LE = atoms.UInt32LE;
module.exports.FloatLE = atoms.FloatLE;
module.exports.FloatBE = atoms.FloatBE;
module.exports.DoubleLE = atoms.DoubleLE;
module.exports.DoubleBE = atoms.DoubleBE;
module.exports.Null = __turbopack_context__.r("[project]/node_modules/bufrw/null.js [app-rsc] (ecmascript)");
module.exports.FixedWidth = __turbopack_context__.r("[project]/node_modules/bufrw/fixed_width_rw.js [app-rsc] (ecmascript)");
var VariableBuffer = __turbopack_context__.r("[project]/node_modules/bufrw/variable_buffer_rw.js [app-rsc] (ecmascript)");
var buf1 = VariableBuffer(atoms.UInt8);
var buf2 = VariableBuffer(atoms.UInt16BE);
module.exports.buf1 = buf1;
module.exports.buf2 = buf2;
module.exports.VariableBuffer = VariableBuffer;
var StringRW = __turbopack_context__.r("[project]/node_modules/bufrw/string_rw.js [app-rsc] (ecmascript)");
var varint = __turbopack_context__.r("[project]/node_modules/bufrw/varint.js [app-rsc] (ecmascript)");
var str1 = StringRW(atoms.UInt8, 'utf8');
var str2 = StringRW(atoms.UInt16BE, 'utf8');
var strn = StringRW(varint.unsigned, 'utf8');
module.exports.str1 = str1;
module.exports.str2 = str2;
module.exports.strn = strn;
module.exports.String = StringRW;
module.exports.varint = varint;
module.exports.Series = __turbopack_context__.r("[project]/node_modules/bufrw/series.js [app-rsc] (ecmascript)");
module.exports.Struct = __turbopack_context__.r("[project]/node_modules/bufrw/struct.js [app-rsc] (ecmascript)");
module.exports.Switch = __turbopack_context__.r("[project]/node_modules/bufrw/switch.js [app-rsc] (ecmascript)");
module.exports.Repeat = __turbopack_context__.r("[project]/node_modules/bufrw/repeat.js [app-rsc] (ecmascript)");
module.exports.Skip = __turbopack_context__.r("[project]/node_modules/bufrw/skip.js [app-rsc] (ecmascript)");
}}),
"[project]/node_modules/string-template/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
var nargs = /\{([0-9a-zA-Z]+)\}/g;
var slice = Array.prototype.slice;
module.exports = template;
function template(string) {
    var args;
    if (arguments.length === 2 && typeof arguments[1] === "object") {
        args = arguments[1];
    } else {
        args = slice.call(arguments, 1);
    }
    if (!args || !args.hasOwnProperty) {
        args = {};
    }
    return string.replace(nargs, function replaceArg(match, i, index) {
        var result;
        if (string[index - 1] === "{" && string[index + match.length] === "}") {
            return i;
        } else {
            result = args.hasOwnProperty(i) ? args[i] : null;
            if (result === null || result === undefined) {
                return "";
            }
            return result;
        }
    });
}
}}),
"[project]/node_modules/error/typed.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
var template = __turbopack_context__.r("[project]/node_modules/string-template/index.js [app-rsc] (ecmascript)");
var extend = __turbopack_context__.r("[project]/node_modules/xtend/mutable.js [app-rsc] (ecmascript)");
var assert = __turbopack_context__.r("[externals]/assert [external] (assert, cjs)");
var isWordBoundary = /[_.-](\w|$)/g;
module.exports = TypedError;
function TypedError(args) {
    assert(args, 'TypedError: must specify options');
    assert(args.type, 'TypedError: must specify options.type');
    assert(args.message, 'TypedError: must specify options.message');
    assert(!has(args, 'fullType'), 'TypedError: fullType field is reserved');
    var message = args.message;
    if (args.type && !args.name) {
        var errorName = camelCase(args.type) + 'Error';
        args.name = errorName[0].toUpperCase() + errorName.substr(1);
    }
    extend(createError, args);
    createError._name = args.name;
    return createError;
    "TURBOPACK unreachable";
    function createError(opts) {
        var result = new Error();
        Object.defineProperty(result, 'type', {
            value: result.type,
            enumerable: true,
            writable: true,
            configurable: true
        });
        var options = extend({}, args, opts);
        if (!options.fullType) {
            options.fullType = options.type;
        }
        extend(result, options);
        if (opts && opts.message) {
            result.message = template(opts.message, options);
        } else if (message) {
            result.message = template(message, options);
        }
        return result;
    }
}
function camelCase(str) {
    return str.replace(isWordBoundary, upperCase);
}
function upperCase(_, x) {
    return x.toUpperCase();
}
function has(obj, key) {
    return Object.prototype.hasOwnProperty.call(obj, key);
}
}}),
"[project]/node_modules/error/wrapped.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
var extend = __turbopack_context__.r("[project]/node_modules/xtend/mutable.js [app-rsc] (ecmascript)");
var assert = __turbopack_context__.r("[externals]/assert [external] (assert, cjs)");
var TypedError = __turbopack_context__.r("[project]/node_modules/error/typed.js [app-rsc] (ecmascript)");
var objectToString = Object.prototype.toString;
var ERROR_TYPE = '[object Error]';
var causeMessageRegex = /\{causeMessage\}/g;
var origMessageRegex = /\{origMessage\}/g;
module.exports = WrappedError;
function WrappedError(options) {
    assert(options, 'WrappedError: must specify options');
    assert(options.type, 'WrappedError: must specify type');
    assert(options.message, 'WrappedError: must specify message');
    assert(!has(options, 'cause'), 'WrappedError: cause field is reserved');
    assert(!has(options, 'fullType'), 'WrappedError: fullType field is reserved');
    assert(!has(options, 'causeMessage'), 'WrappedError: causeMessage field is reserved');
    assert(!has(options, 'origMessage'), 'WrappedError: origMessage field is reserved');
    var createTypedError = TypedError(options);
    extend(createError, options);
    createError._name = options.name;
    return createError;
    "TURBOPACK unreachable";
    function createError(cause, opts) {
        /*eslint max-statements: [2, 25]*/ assert(cause, 'an error is required');
        assert(isError(cause), 'WrappedError: first argument must be an error');
        var causeMessage = cause.message;
        if (causeMessage.indexOf('{causeMessage}') >= 0) {
            // recover
            causeMessage = causeMessage.replace(causeMessageRegex, '$INVALID_CAUSE_MESSAGE_LITERAL');
        }
        if (causeMessage.indexOf('{origMessage}') >= 0) {
            causeMessage = causeMessage.replace(origMessageRegex, '$INVALID_ORIG_MESSAGE_LITERAL');
        }
        var nodeCause = false;
        var errOptions = extend({}, opts, {
            causeMessage: causeMessage,
            origMessage: causeMessage
        });
        if (has(cause, 'code') && !has(errOptions, 'code')) {
            errOptions.code = cause.code;
        }
        if (has(cause, 'errno') && !has(errOptions, 'errno')) {
            errOptions.errno = cause.errno;
            nodeCause = true;
        }
        if (has(cause, 'syscall') && !has(errOptions, 'syscall')) {
            errOptions.syscall = cause.syscall;
            nodeCause = true;
        }
        var causeType = cause.type;
        if (!causeType && nodeCause) {
            causeType = 'error.wrapped-io.' + (cause.syscall || 'unknown') + '.' + (cause.errno || 'unknown');
        } else {
            causeType = 'error.wrapped-unknown';
        }
        errOptions.fullType = options.type + '~!~' + (cause.fullType || cause.type || causeType);
        var err = createTypedError(errOptions);
        Object.defineProperty(err, 'cause', {
            value: cause,
            configurable: true,
            enumerable: false
        });
        return err;
    }
}
function has(obj, key) {
    return Object.prototype.hasOwnProperty.call(obj, key);
}
function isError(err) {
    return objectToString.call(err) === ERROR_TYPE;
}
}}),
"[project]/node_modules/jaeger-client/dist/src/logger.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _createClass = function() {
    function defineProperties(target, props) {
        for(var i = 0; i < props.length; i++){
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
}();
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
// Copyright (c) 2016 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under
// the License.
var NullLogger = function() {
    function NullLogger() {
        _classCallCheck(this, NullLogger);
    }
    _createClass(NullLogger, [
        {
            key: "info",
            value: function info(msg) {}
        },
        {
            key: "error",
            value: function error(msg) {}
        }
    ]);
    return NullLogger;
}();
exports.default = NullLogger; //# sourceMappingURL=logger.js.map
}}),
"[project]/node_modules/jaeger-client/dist/src/reporters/sender_utils.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _createClass = function() {
    function defineProperties(target, props) {
        for(var i = 0; i < props.length; i++){
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
}();
// Copyright (c) 2018 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under
// the License.
var _thriftrw = __turbopack_context__.r("[project]/node_modules/thriftrw/index.js [app-rsc] (ecmascript)");
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
var SenderUtils = function() {
    function SenderUtils() {
        _classCallCheck(this, SenderUtils);
    }
    _createClass(SenderUtils, null, [
        {
            key: 'invokeCallback',
            value: function invokeCallback(callback, numSpans, error) {
                if (callback) {
                    callback(numSpans, error);
                }
            }
        },
        {
            key: 'convertProcessToThrift',
            value: function convertProcessToThrift(t, process) {
                var tagMessages = [];
                for(var j = 0; j < process.tags.length; j++){
                    var tag = process.tags[j];
                    tagMessages.push(new t.Tag(tag));
                }
                return new t.Process({
                    serviceName: process.serviceName,
                    tags: tagMessages
                });
            }
        }
    ]);
    return SenderUtils;
}();
exports.default = SenderUtils; //# sourceMappingURL=sender_utils.js.map
}}),
"[project]/node_modules/jaeger-client/dist/src/util.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _createClass = function() {
    function defineProperties(target, props) {
        for(var i = 0; i < props.length; i++){
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
}();
// Copyright (c) 2016 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under
// the License.
var _xorshift = __turbopack_context__.r("[project]/node_modules/xorshift/xorshift.js [app-rsc] (ecmascript)");
var _xorshift2 = _interopRequireDefault(_xorshift);
var _nodeInt = __turbopack_context__.r("[project]/node_modules/node-int64/Int64.js [app-rsc] (ecmascript)");
var _nodeInt2 = _interopRequireDefault(_nodeInt);
var _os = __turbopack_context__.r("[externals]/os [external] (os, cjs)");
var _os2 = _interopRequireDefault(_os);
var _http = __turbopack_context__.r("[externals]/http [external] (http, cjs)");
var _http2 = _interopRequireDefault(_http);
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
var Utils = function() {
    function Utils() {
        _classCallCheck(this, Utils);
    }
    _createClass(Utils, null, [
        {
            key: 'startsWith',
            /**
     * Determines whether a string contains a given prefix.
     *
     * @param {string} text - the string for to search for a prefix
     * @param {string} prefix - the prefix to search for in the text given.
     * @return {boolean} - boolean representing whether or not the
     * string contains the prefix.
     **/ value: function startsWith(text, prefix) {
                return text.indexOf(prefix) === 0;
            }
        },
        {
            key: 'endsWith',
            value: function endsWith(text, suffix) {
                return text.lastIndexOf(suffix) === text.length - suffix.length;
            }
        },
        {
            key: 'getRandom64',
            value: function getRandom64() {
                var randint = _xorshift2.default.randomint();
                var buf = this.newBuffer(8);
                buf.writeUInt32BE(randint[0], 0);
                buf.writeUInt32BE(randint[1], 4);
                return buf;
            }
        },
        {
            key: 'getRandom128',
            value: function getRandom128() {
                var randint1 = _xorshift2.default.randomint();
                var randint2 = _xorshift2.default.randomint();
                var buf = this.newBuffer(16);
                buf.writeUInt32BE(randint1[0], 0);
                buf.writeUInt32BE(randint1[1], 4);
                buf.writeUInt32BE(randint2[0], 8);
                buf.writeUInt32BE(randint2[1], 12);
                return buf;
            }
        },
        {
            key: 'encodeInt64',
            value: function encodeInt64(numberValue) {
                return new _nodeInt2.default(numberValue).toBuffer();
            }
        },
        {
            key: 'removeLeadingZeros',
            value: function removeLeadingZeros(input) {
                var counter = 0;
                var length = input.length - 1;
                for(var i = 0; i < length; i++){
                    if (input.charAt(i) === '0') {
                        counter++;
                    } else {
                        break;
                    }
                }
                return input.substring(counter);
            }
        },
        {
            key: 'myIp',
            value: function myIp() {
                var myIp = '0.0.0.0';
                var ifaces = _os2.default.networkInterfaces();
                var keys = Object.keys(ifaces);
                loop1: for(var i = 0; i < keys.length; i++){
                    var iface = ifaces[keys[i]];
                    for(var j = 0; j < iface.length; j++){
                        if (iface[j].family === 'IPv4' && !iface[j].internal) {
                            myIp = iface[j].address;
                            break loop1;
                        }
                    }
                }
                return myIp;
            }
        },
        {
            key: 'clone',
            value: function clone(obj) {
                var newObj = {};
                for(var key in obj){
                    if (Object.prototype.hasOwnProperty.call(obj, key)) {
                        newObj[key] = obj[key];
                    }
                }
                return newObj;
            }
        },
        {
            key: 'convertObjectToTags',
            value: function convertObjectToTags(dict) {
                var tags = [];
                for(var key in dict){
                    var value = dict[key];
                    if (Object.prototype.hasOwnProperty.call(dict, key)) {
                        tags.push({
                            key: key,
                            value: value
                        });
                    }
                }
                return tags;
            }
        },
        {
            key: 'httpGet',
            value: function httpGet(host, port, path, success, error) {
                _http2.default.get({
                    host: host,
                    port: port,
                    path: path
                }, function(res) {
                    // explicitly treat incoming data as utf8 (avoids issues with multi-byte chars)
                    res.setEncoding('utf8');
                    // incrementally capture the incoming response body
                    var body = '';
                    res.on('data', function(chunk) {
                        body += chunk;
                    });
                    res.on('end', function() {
                        success(body);
                    });
                }).on('error', function(err) {
                    error(err);
                });
            }
        },
        {
            key: 'newBufferFromHex',
            value: function newBufferFromHex(input) {
                var encoding = 'hex';
                // check that 'Buffer.from' exists based on node's documentation
                // https://nodejs.org/en/docs/guides/buffer-constructor-deprecation/#variant-3
                if (Buffer.from && Buffer.from !== Uint8Array.from) {
                    return Buffer.from(input, encoding);
                }
                return new Buffer(input, encoding);
            }
        },
        {
            key: 'newBuffer',
            value: function newBuffer(size) {
                if (Buffer.alloc) {
                    return Buffer.alloc(size);
                }
                var buffer = new Buffer(size);
                buffer.fill(0);
                return buffer;
            }
        },
        {
            key: 'countdownCallback',
            value: function countdownCallback(limit, callback) {
                var count = 0;
                return function() {
                    count++;
                    if (count >= limit && callback) {
                        callback();
                    }
                };
            }
        }
    ]);
    return Utils;
}();
exports.default = Utils; //# sourceMappingURL=util.js.map
}}),
"[project]/node_modules/jaeger-client/dist/src/thrift.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function(obj) {
    return typeof obj;
} : function(obj) {
    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};
var _createClass = function() {
    function defineProperties(target, props) {
        for(var i = 0; i < props.length; i++){
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
}();
// Copyright (c) 2016 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under
// the License.
var _fs = __turbopack_context__.r("[externals]/fs [external] (fs, cjs)");
var _fs2 = _interopRequireDefault(_fs);
var _opentracing = __turbopack_context__.r("[project]/node_modules/opentracing/lib/index.js [app-rsc] (ecmascript)");
var opentracing = _interopRequireWildcard(_opentracing);
var _path = __turbopack_context__.r("[externals]/path [external] (path, cjs)");
var _path2 = _interopRequireDefault(_path);
var _thriftrw = __turbopack_context__.r("[project]/node_modules/thriftrw/index.js [app-rsc] (ecmascript)");
var _util = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/util.js [app-rsc] (ecmascript)");
var _util2 = _interopRequireDefault(_util);
function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
        return obj;
    } else {
        var newObj = {};
        if (obj != null) {
            for(var key in obj){
                if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
            }
        }
        newObj.default = obj;
        return newObj;
    }
}
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
var ThriftUtils = function() {
    function ThriftUtils() {
        _classCallCheck(this, ThriftUtils);
    }
    _createClass(ThriftUtils, null, [
        {
            key: 'loadJaegerThriftDefinition',
            value: function loadJaegerThriftDefinition() {
                return _fs2.default.readFileSync(_path2.default.join(__dirname, './jaeger-idl/thrift/jaeger.thrift'), 'ascii');
            }
        },
        {
            key: 'buildAgentThriftPath',
            value: function buildAgentThriftPath() {
                return _path2.default.join(__dirname, './thriftrw-idl/agent.thrift');
            }
        },
        {
            key: 'getThriftTags',
            value: function getThriftTags(initialTags) {
                var thriftTags = [];
                for(var i = 0; i < initialTags.length; i++){
                    var tag = initialTags[i];
                    var key = tag.key;
                    var vLong = ThriftUtils.emptyBuffer;
                    var vBinary = ThriftUtils.emptyBuffer;
                    var vBool = false;
                    var vDouble = 0;
                    var vStr = '';
                    var vType = '';
                    var valueType = _typeof(tag.value);
                    if (valueType === 'number') {
                        vType = ThriftUtils._thrift.TagType.DOUBLE;
                        vDouble = tag.value;
                    } else if (valueType === 'boolean') {
                        vType = ThriftUtils._thrift.TagType.BOOL;
                        vBool = tag.value;
                    } else if (tag.value instanceof Buffer) {
                        vType = ThriftUtils._thrift.TagType.BINARY;
                        vBinary = tag.value;
                    } else if (valueType === 'object') {
                        vType = ThriftUtils._thrift.TagType.STRING;
                        vStr = JSON.stringify(tag.value);
                    } else {
                        vType = ThriftUtils._thrift.TagType.STRING;
                        if (valueType === 'string') {
                            vStr = tag.value;
                        } else {
                            vStr = String(tag.value);
                        }
                    }
                    thriftTags.push({
                        key: key,
                        vType: vType,
                        vStr: vStr,
                        vDouble: vDouble,
                        vBool: vBool,
                        vLong: vLong,
                        vBinary: vBinary
                    });
                }
                return thriftTags;
            }
        },
        {
            key: 'getThriftLogs',
            value: function getThriftLogs(logs) {
                var thriftLogs = [];
                for(var i = 0; i < logs.length; i++){
                    var log = logs[i];
                    thriftLogs.push({
                        timestamp: _util2.default.encodeInt64(log.timestamp * 1000),
                        fields: ThriftUtils.getThriftTags(log.fields)
                    });
                }
                return thriftLogs;
            }
        },
        {
            key: 'spanRefsToThriftRefs',
            value: function spanRefsToThriftRefs(refs) {
                var thriftRefs = [];
                for(var i = 0; i < refs.length; i++){
                    var refEnum = void 0;
                    var ref = refs[i];
                    var context = refs[i].referencedContext();
                    if (ref.type() === opentracing.REFERENCE_CHILD_OF) {
                        refEnum = ThriftUtils._thrift.SpanRefType.CHILD_OF;
                    } else if (ref.type() === opentracing.REFERENCE_FOLLOWS_FROM) {
                        refEnum = ThriftUtils._thrift.SpanRefType.FOLLOWS_FROM;
                    } else {
                        continue;
                    }
                    thriftRefs.push({
                        refType: refEnum,
                        traceIdLow: ThriftUtils.getTraceIdLow(context.traceId),
                        traceIdHigh: ThriftUtils.getTraceIdHigh(context.traceId),
                        spanId: context.spanId
                    });
                }
                return thriftRefs;
            }
        },
        {
            key: 'getTraceIdLow',
            value: function getTraceIdLow(traceId) {
                if (traceId != null) {
                    return traceId.slice(-8);
                }
                return ThriftUtils.emptyBuffer;
            }
        },
        {
            key: 'getTraceIdHigh',
            value: function getTraceIdHigh(traceId) {
                if (traceId != null && traceId.length > 8) {
                    return traceId.slice(-16, -8);
                }
                return ThriftUtils.emptyBuffer;
            }
        },
        {
            key: 'spanToThrift',
            value: function spanToThrift(span) {
                var tags = ThriftUtils.getThriftTags(span._tags);
                var logs = ThriftUtils.getThriftLogs(span._logs);
                var unsigned = true;
                return {
                    traceIdLow: ThriftUtils.getTraceIdLow(span._spanContext.traceId),
                    traceIdHigh: ThriftUtils.getTraceIdHigh(span._spanContext.traceId),
                    spanId: span._spanContext.spanId,
                    parentSpanId: span._spanContext.parentId || ThriftUtils.emptyBuffer,
                    operationName: span._operationName,
                    references: ThriftUtils.spanRefsToThriftRefs(span._references),
                    flags: span._spanContext.flags,
                    startTime: _util2.default.encodeInt64(span._startTime * 1000),
                    duration: _util2.default.encodeInt64(span._duration * 1000),
                    tags: tags,
                    logs: logs
                };
            }
        }
    ]);
    return ThriftUtils;
}();
ThriftUtils._thrift = new _thriftrw.Thrift({
    source: ThriftUtils.loadJaegerThriftDefinition(),
    allowOptionalArguments: true
});
ThriftUtils.emptyBuffer = _util2.default.newBuffer(8);
exports.default = ThriftUtils; //# sourceMappingURL=thrift.js.map
}}),
"[project]/node_modules/jaeger-client/dist/src/reporters/udp_sender.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _createClass = function() {
    function defineProperties(target, props) {
        for(var i = 0; i < props.length; i++){
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
}();
// Copyright (c) 2016 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under
// the License.
var _dgram = __turbopack_context__.r("[externals]/dgram [external] (dgram, cjs)");
var _dgram2 = _interopRequireDefault(_dgram);
var _fs = __turbopack_context__.r("[externals]/fs [external] (fs, cjs)");
var _fs2 = _interopRequireDefault(_fs);
var _path = __turbopack_context__.r("[externals]/path [external] (path, cjs)");
var _path2 = _interopRequireDefault(_path);
var _thriftrw = __turbopack_context__.r("[project]/node_modules/thriftrw/index.js [app-rsc] (ecmascript)");
var _logger = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/logger.js [app-rsc] (ecmascript)");
var _logger2 = _interopRequireDefault(_logger);
var _sender_utils = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/reporters/sender_utils.js [app-rsc] (ecmascript)");
var _sender_utils2 = _interopRequireDefault(_sender_utils);
var _thrift = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/thrift.js [app-rsc] (ecmascript)");
var _thrift2 = _interopRequireDefault(_thrift);
var _util = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/util.js [app-rsc] (ecmascript)");
var _util2 = _interopRequireDefault(_util);
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
var HOST = 'localhost';
var PORT = 6832;
var SOCKET_TYPE = 'udp4';
var UDP_PACKET_MAX_LENGTH = 65000;
var UDPSender = function() {
    // size of currently batched spans as Thrift bytes
    function UDPSender() {
        var _this = this;
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        _classCallCheck(this, UDPSender);
        this._host = options.host || HOST;
        this._port = options.port || PORT;
        this._socketType = options.socketType || SOCKET_TYPE;
        this._maxPacketSize = options.maxPacketSize || UDP_PACKET_MAX_LENGTH;
        this._logger = options.logger || new _logger2.default();
        this._client = _dgram2.default.createSocket(this._socketType);
        this._client.on('error', function(err) {
            _this._logger.error('error sending spans over UDP: ' + err);
        });
        this._agentThrift = new _thriftrw.Thrift({
            entryPoint: _thrift2.default.buildAgentThriftPath(),
            allowOptionalArguments: true,
            allowFilesystemAccess: true
        });
        this._jaegerThrift = new _thriftrw.Thrift({
            source: _thrift2.default.loadJaegerThriftDefinition(),
            allowOptionalArguments: true
        });
        this._totalSpanBytes = 0;
    } // maxPacketSize - (batch + tags overhead)
    _createClass(UDPSender, [
        {
            key: '_calcBatchSize',
            value: function _calcBatchSize(batch) {
                return this._agentThrift.Agent.emitBatch.argumentsMessageRW.byteLength(this._convertBatchToThriftMessage()).length;
            }
        },
        {
            key: '_calcSpanSize',
            value: function _calcSpanSize(span) {
                return this._jaegerThrift.Span.rw.byteLength(new this._jaegerThrift.Span(span));
            }
        },
        {
            key: 'setProcess',
            value: function setProcess(process) {
                // This function is only called once during reporter construction, and thus will
                // give us the length of the batch before any spans have been added to the span
                // list in batch.
                this._process = process;
                this._batch = {
                    process: this._process,
                    spans: []
                };
                this._thriftProcessMessage = _sender_utils2.default.convertProcessToThrift(this._jaegerThrift, process);
                this._emitSpanBatchOverhead = this._calcBatchSize(this._batch);
                this._maxSpanBytes = this._maxPacketSize - this._emitSpanBatchOverhead;
            }
        },
        {
            key: 'append',
            value: function append(span, callback) {
                var _this2 = this;
                var _calcSpanSize2 = this._calcSpanSize(span), err = _calcSpanSize2.err, length = _calcSpanSize2.length;
                if (err) {
                    _sender_utils2.default.invokeCallback(callback, 1, 'error converting span to Thrift: ' + err);
                    return;
                }
                var spanSize = length;
                if (spanSize > this._maxSpanBytes) {
                    _sender_utils2.default.invokeCallback(callback, 1, 'span size ' + spanSize + ' is larger than maxSpanSize ' + this._maxSpanBytes);
                    return;
                }
                if (this._totalSpanBytes + spanSize <= this._maxSpanBytes) {
                    this._batch.spans.push(span);
                    this._totalSpanBytes += spanSize;
                    if (this._totalSpanBytes < this._maxSpanBytes) {
                        // still have space in the buffer, don't flush it yet
                        _sender_utils2.default.invokeCallback(callback, 0);
                        return;
                    }
                    // buffer size === this._maxSpanBytes
                    this.flush(callback);
                    return;
                }
                this.flush(function(numSpans, err) {
                    // TODO theoretically we can have buffer overflow here too, if many spans were appended during flush()
                    _this2._batch.spans.push(span);
                    _this2._totalSpanBytes += spanSize;
                    _sender_utils2.default.invokeCallback(callback, numSpans, err);
                });
            }
        },
        {
            key: 'flush',
            value: function flush(callback) {
                var numSpans = this._batch.spans.length;
                if (!numSpans) {
                    _sender_utils2.default.invokeCallback(callback, 0);
                    return;
                }
                var bufferLen = this._totalSpanBytes + this._emitSpanBatchOverhead;
                var thriftBuffer = _util2.default.newBuffer(bufferLen);
                var writeResult = this._agentThrift.Agent.emitBatch.argumentsMessageRW.writeInto(this._convertBatchToThriftMessage(), thriftBuffer, 0);
                this._reset();
                if (writeResult.err) {
                    _sender_utils2.default.invokeCallback(callback, numSpans, 'error writing Thrift object: ' + writeResult.err);
                    return;
                }
                // Having the error callback here does not prevent uncaught exception from being thrown,
                // that's why in the constructor we also add a general on('error') handler.
                this._client.send(thriftBuffer, 0, thriftBuffer.length, this._port, this._host, function(err, sent) {
                    if (err) {
                        var error = err && 'error sending spans over UDP: ' + err + ', packet size: ' + writeResult.offset + ', bytes sent: ' + sent;
                        _sender_utils2.default.invokeCallback(callback, numSpans, error);
                    } else {
                        _sender_utils2.default.invokeCallback(callback, numSpans);
                    }
                });
            }
        },
        {
            key: '_convertBatchToThriftMessage',
            value: function _convertBatchToThriftMessage() {
                var spanMessages = [];
                for(var i = 0; i < this._batch.spans.length; i++){
                    var span = this._batch.spans[i];
                    spanMessages.push(new this._jaegerThrift.Span(span));
                }
                return new this._agentThrift.Agent.emitBatch.ArgumentsMessage({
                    version: 1,
                    id: 0,
                    body: {
                        batch: new this._jaegerThrift.Batch({
                            process: this._thriftProcessMessage,
                            spans: spanMessages
                        })
                    }
                });
            }
        },
        {
            key: '_reset',
            value: function _reset() {
                this._batch.spans = [];
                this._totalSpanBytes = 0;
            }
        },
        {
            key: 'close',
            value: function close() {
                this._client.close();
            }
        }
    ]);
    return UDPSender;
}();
exports.default = UDPSender; //# sourceMappingURL=udp_sender.js.map
}}),
"[project]/node_modules/jaeger-client/dist/src/reporters/http_sender.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
Object.defineProperty(exports, "__esModule", {
    value: true
});
var _createClass = function() {
    function defineProperties(target, props) {
        for(var i = 0; i < props.length; i++){
            var descriptor = props[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target, descriptor.key, descriptor);
        }
    }
    return function(Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
}();
// Copyright (c) 2018 Uber Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
// in compliance with the License. You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed under the License
// is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
// or implied. See the License for the specific language governing permissions and limitations under
// the License.
var _fs = __turbopack_context__.r("[externals]/fs [external] (fs, cjs)");
var _fs2 = _interopRequireDefault(_fs);
var _http = __turbopack_context__.r("[externals]/http [external] (http, cjs)");
var _http2 = _interopRequireDefault(_http);
var _https = __turbopack_context__.r("[externals]/https [external] (https, cjs)");
var _https2 = _interopRequireDefault(_https);
var _path = __turbopack_context__.r("[externals]/path [external] (path, cjs)");
var _path2 = _interopRequireDefault(_path);
var _url = __turbopack_context__.r("[externals]/url [external] (url, cjs)");
var URL = _interopRequireWildcard(_url);
var _thriftrw = __turbopack_context__.r("[project]/node_modules/thriftrw/index.js [app-rsc] (ecmascript)");
var _logger = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/logger.js [app-rsc] (ecmascript)");
var _logger2 = _interopRequireDefault(_logger);
var _sender_utils = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/reporters/sender_utils.js [app-rsc] (ecmascript)");
var _sender_utils2 = _interopRequireDefault(_sender_utils);
var _thrift = __turbopack_context__.r("[project]/node_modules/jaeger-client/dist/src/thrift.js [app-rsc] (ecmascript)");
var _thrift2 = _interopRequireDefault(_thrift);
function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
        return obj;
    } else {
        var newObj = {};
        if (obj != null) {
            for(var key in obj){
                if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
            }
        }
        newObj.default = obj;
        return newObj;
    }
}
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
var DEFAULT_PATH = '/api/traces';
var DEFAULT_PORT = 14268;
var DEFAULT_TIMEOUT_MS = 5000;
var DEFAULT_MAX_SPAN_BATCH_SIZE = 100;
var HTTPSender = function() {
    function HTTPSender() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        _classCallCheck(this, HTTPSender);
        this._url = URL.parse(options.endpoint);
        this._username = options.username;
        this._password = options.password;
        this._timeoutMs = options.timeoutMs || options.timeoutMS || DEFAULT_TIMEOUT_MS;
        this._httpAgent = this._url.protocol === 'https:' ? new _https2.default.Agent({
            keepAlive: true
        }) : new _http2.default.Agent({
            keepAlive: true
        });
        this._maxSpanBatchSize = options.maxSpanBatchSize || DEFAULT_MAX_SPAN_BATCH_SIZE;
        this._logger = options.logger || new _logger2.default();
        this._jaegerThrift = new _thriftrw.Thrift({
            source: _thrift2.default.loadJaegerThriftDefinition(),
            allowOptionalArguments: true
        });
        this._httpOptions = {
            protocol: this._url.protocol,
            hostname: this._url.hostname,
            port: this._url.port,
            path: this._url.pathname,
            method: 'POST',
            auth: this._username && this._password ? this._username + ':' + this._password : undefined,
            headers: {
                'Content-Type': 'application/x-thrift',
                Connection: 'keep-alive'
            },
            agent: this._httpAgent,
            timeout: this._timeoutMs
        };
    }
    _createClass(HTTPSender, [
        {
            key: 'setProcess',
            value: function setProcess(process) {
                // Go ahead and initialize the Thrift batch that we will reuse for each
                // flush.
                this._batch = new this._jaegerThrift.Batch({
                    process: _sender_utils2.default.convertProcessToThrift(this._jaegerThrift, process),
                    spans: []
                });
            }
        },
        {
            key: 'append',
            value: function append(span, callback) {
                this._batch.spans.push(new this._jaegerThrift.Span(span));
                if (this._batch.spans.length >= this._maxSpanBatchSize) {
                    this.flush(callback);
                    return;
                }
                _sender_utils2.default.invokeCallback(callback, 0);
            }
        },
        {
            key: 'flush',
            value: function flush(callback) {
                var _this = this;
                var numSpans = this._batch.spans.length;
                if (!numSpans) {
                    _sender_utils2.default.invokeCallback(callback, 0);
                    return;
                }
                var result = this._jaegerThrift.Batch.rw.toBuffer(this._batch);
                this._reset(); // clear buffer for new spans, even if Thrift conversion fails
                if (result.err) {
                    _sender_utils2.default.invokeCallback(callback, numSpans, 'Error encoding Thrift batch: ' + result.err);
                    return;
                }
                var requester = this._url.protocol === 'https:' ? _https2.default.request : _http2.default.request;
                var req = requester(this._httpOptions, function(resp) {
                    // consume response data to free up memory
                    resp.resume();
                    var error = void 0;
                    if (resp.statusCode >= 400) {
                        error = 'error sending spans over HTTP: server responded with HTTP ' + resp.statusCode;
                        _this._logger.error(error);
                    }
                    _sender_utils2.default.invokeCallback(callback, numSpans, error);
                });
                req.on('error', function(err) {
                    var error = 'error sending spans over HTTP: ' + err;
                    _this._logger.error(error);
                    _sender_utils2.default.invokeCallback(callback, numSpans, error);
                });
                req.write(result.value);
                req.end();
            }
        },
        {
            key: '_reset',
            value: function _reset() {
                this._batch.spans = [];
            }
        },
        {
            key: 'close',
            value: function close() {
                // Older node versions don't have this.
                if (this._httpAgent.destroy) {
                    this._httpAgent.destroy();
                }
            }
        }
    ]);
    return HTTPSender;
}();
exports.default = HTTPSender; //# sourceMappingURL=http_sender.js.map
}}),
"[project]/node_modules/opentracing/lib/binary_carrier.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
/**
 * Convenience class to use as a binary carrier.
 *
 * Any valid Object with a field named `buffer` may be used as a binary carrier;
 * this class is only one such type of object that can be used.
 */ var BinaryCarrier = function() {
    function BinaryCarrier(buffer) {
        this.buffer = buffer;
    }
    return BinaryCarrier;
}();
exports.default = BinaryCarrier; //# sourceMappingURL=binary_carrier.js.map
}}),
"[project]/node_modules/opentracing/lib/ext/tags.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
/** SPAN_KIND hints at relationship between spans, e.g. client/server */ exports.SPAN_KIND = 'span.kind';
/** Marks a span representing the client-side of an RPC or other remote call */ exports.SPAN_KIND_RPC_CLIENT = 'client';
/** Marks a span representing the server-side of an RPC or other remote call */ exports.SPAN_KIND_RPC_SERVER = 'server';
/** Marks a span representing the producing-side within a messaging system or other remote call */ exports.SPAN_KIND_MESSAGING_PRODUCER = 'producer';
/** Marks a span representing the consuming-side within a messaging system or other remote call */ exports.SPAN_KIND_MESSAGING_CONSUMER = 'consumer';
/**
 * ERROR (boolean) true if and only if the application considers the operation
 * represented by the Span to have failed
 */ exports.ERROR = 'error';
/**
 * COMPONENT (string) ia s low-cardinality identifier of the module, library,
 * or package that is generating a span.
 */ exports.COMPONENT = 'component';
/**
 * SAMPLING_PRIORITY (number) determines the priority of sampling this Span.
 * If greater than 0, a hint to the Tracer to do its best to capture the trace.
 * If 0, a hint to the trace to not-capture the trace. If absent, the Tracer
 * should use its default sampling mechanism.
 */ exports.SAMPLING_PRIORITY = 'sampling.priority';
// ---------------------------------------------------------------------------
// PEER_* tags can be emitted by either client-side of server-side to describe
// the other side/service in a peer-to-peer communications, like an RPC call.
// ---------------------------------------------------------------------------
/**
 * PEER_SERVICE (string) Remote service name (for some unspecified
 * definition of "service"). E.g., "elasticsearch", "a_custom_microservice", "memcache"
 */ exports.PEER_SERVICE = 'peer.service';
/** PEER_HOSTNAME (string) Remote hostname. E.g., "opentracing.io", "internal.dns.name" */ exports.PEER_HOSTNAME = 'peer.hostname';
/**
 * PEER_ADDRESS (string) Remote "address", suitable for use in a
 * networking client library. This may be a "ip:port", a bare
 * "hostname", a FQDN, or even a JDBC substring like "mysql://prod-db:3306"
 */ exports.PEER_ADDRESS = 'peer.address';
/**
 * PEER_HOST_IPV4 (number) Remote IPv4 address as a .-separated tuple.
 * E.g., "127.0.0.1"
 */ exports.PEER_HOST_IPV4 = 'peer.ipv4';
// PEER_HOST_IPV6 (string) Remote IPv6 address as a string of
// colon-separated 4-char hex tuples. E.g., "2001:0db8:85a3:0000:0000:8a2e:0370:7334"
exports.PEER_HOST_IPV6 = 'peer.ipv6';
// PEER_PORT (number) Remote port. E.g., 80
exports.PEER_PORT = 'peer.port';
// ---------------------------------------------------------------------------
// HTTP tags
// ---------------------------------------------------------------------------
/**
 * HTTP_URL (string) URL of the request being handled in this segment of the
 * trace, in standard URI format. E.g., "https://domain.net/path/to?resource=here"
 */ exports.HTTP_URL = 'http.url';
/**
 * HTTP_METHOD (string) HTTP method of the request for the associated Span. E.g.,
 * "GET", "POST"
 */ exports.HTTP_METHOD = 'http.method';
/**
 * HTTP_STATUS_CODE (number) HTTP response status code for the associated Span.
 * E.g., 200, 503, 404
 */ exports.HTTP_STATUS_CODE = 'http.status_code';
// -------------------------------------------------------------------------
// Messaging tags
// -------------------------------------------------------------------------
/**
 * MESSAGE_BUS_DESTINATION (string) An address at which messages can be exchanged.
 * E.g. A Kafka record has an associated "topic name" that can be extracted
 * by the instrumented producer or consumer and stored using this tag.
 */ exports.MESSAGE_BUS_DESTINATION = 'message_bus.destination';
// --------------------------------------------------------------------------
// Database tags
// --------------------------------------------------------------------------
/**
 * DB_INSTANCE (string) Database instance name. E.g., In java, if the
 * jdbc.url="jdbc:mysql://127.0.0.1:3306/customers", the instance name is "customers".
 */ exports.DB_INSTANCE = 'db.instance';
/**
 * DB_STATEMENT (string) A database statement for the given database type.
 * E.g., for db.type="SQL", "SELECT * FROM wuser_table";
 * for db.type="redis", "SET mykey 'WuValue'".
 */ exports.DB_STATEMENT = 'db.statement';
/**
 * DB_TYPE (string) Database type. For any SQL database, "sql". For others,
 * the lower-case database category, e.g. "cassandra", "hbase", or "redis".
 */ exports.DB_TYPE = 'db.type';
/**
 * DB_USER (string) Username for accessing database. E.g., "readonly_user"
 * or "reporting_user"
 */ exports.DB_USER = 'db.user'; //# sourceMappingURL=tags.js.map
}}),
"[project]/node_modules/opentracing/lib/span.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var noop = __turbopack_context__.r("[project]/node_modules/opentracing/lib/noop.js [app-rsc] (ecmascript)");
/**
 * Span represents a logical unit of work as part of a broader Trace. Examples
 * of span might include remote procedure calls or a in-process function calls
 * to sub-components. A Trace has a single, top-level "root" Span that in turn
 * may have zero or more child Spans, which in turn may have children.
 */ var Span = function() {
    function Span() {}
    // ---------------------------------------------------------------------- //
    // OpenTracing API methods
    // ---------------------------------------------------------------------- //
    /**
     * Returns the SpanContext object associated with this Span.
     *
     * @return {SpanContext}
     */ Span.prototype.context = function() {
        return this._context();
    };
    /**
     * Returns the Tracer object used to create this Span.
     *
     * @return {Tracer}
     */ Span.prototype.tracer = function() {
        return this._tracer();
    };
    /**
     * Sets the string name for the logical operation this span represents.
     *
     * @param {string} name
     */ Span.prototype.setOperationName = function(name) {
        this._setOperationName(name);
        return this;
    };
    /**
     * Sets a key:value pair on this Span that also propagates to future
     * children of the associated Span.
     *
     * setBaggageItem() enables powerful functionality given a full-stack
     * opentracing integration (e.g., arbitrary application data from a web
     * client can make it, transparently, all the way into the depths of a
     * storage system), and with it some powerful costs: use this feature with
     * care.
     *
     * IMPORTANT NOTE #1: setBaggageItem() will only propagate baggage items to
     * *future* causal descendants of the associated Span.
     *
     * IMPORTANT NOTE #2: Use this thoughtfully and with care. Every key and
     * value is copied into every local *and remote* child of the associated
     * Span, and that can add up to a lot of network and cpu overhead.
     *
     * @param {string} key
     * @param {string} value
     */ Span.prototype.setBaggageItem = function(key, value) {
        this._setBaggageItem(key, value);
        return this;
    };
    /**
     * Returns the value for a baggage item given its key.
     *
     * @param  {string} key
     *         The key for the given trace attribute.
     * @return {string}
     *         String value for the given key, or undefined if the key does not
     *         correspond to a set trace attribute.
     */ Span.prototype.getBaggageItem = function(key) {
        return this._getBaggageItem(key);
    };
    /**
     * Adds a single tag to the span.  See `addTags()` for details.
     *
     * @param {string} key
     * @param {any} value
     */ Span.prototype.setTag = function(key, value) {
        var _a;
        // NOTE: the call is normalized to a call to _addTags()
        this._addTags((_a = {}, _a[key] = value, _a));
        return this;
    };
    /**
     * Adds the given key value pairs to the set of span tags.
     *
     * Multiple calls to addTags() results in the tags being the superset of
     * all calls.
     *
     * The behavior of setting the same key multiple times on the same span
     * is undefined.
     *
     * The supported type of the values is implementation-dependent.
     * Implementations are expected to safely handle all types of values but
     * may choose to ignore unrecognized / unhandle-able values (e.g. objects
     * with cyclic references, function objects).
     *
     * @return {[type]} [description]
     */ Span.prototype.addTags = function(keyValueMap) {
        this._addTags(keyValueMap);
        return this;
    };
    /**
     * Add a log record to this Span, optionally at a user-provided timestamp.
     *
     * For example:
     *
     *     span.log({
     *         size: rpc.size(),  // numeric value
     *         URI: rpc.URI(),  // string value
     *         payload: rpc.payload(),  // Object value
     *         "keys can be arbitrary strings": rpc.foo(),
     *     });
     *
     *     span.log({
     *         "error.description": someError.description(),
     *     }, someError.timestampMillis());
     *
     * @param {object} keyValuePairs
     *        An object mapping string keys to arbitrary value types. All
     *        Tracer implementations should support bool, string, and numeric
     *        value types, and some may also support Object values.
     * @param {number} timestamp
     *        An optional parameter specifying the timestamp in milliseconds
     *        since the Unix epoch. Fractional values are allowed so that
     *        timestamps with sub-millisecond accuracy can be represented. If
     *        not specified, the implementation is expected to use its notion
     *        of the current time of the call.
     */ Span.prototype.log = function(keyValuePairs, timestamp) {
        this._log(keyValuePairs, timestamp);
        return this;
    };
    /**
     * DEPRECATED
     */ Span.prototype.logEvent = function(eventName, payload) {
        return this._log({
            event: eventName,
            payload: payload
        });
    };
    /**
     * Sets the end timestamp and finalizes Span state.
     *
     * With the exception of calls to Span.context() (which are always allowed),
     * finish() must be the last call made to any span instance, and to do
     * otherwise leads to undefined behavior.
     *
     * @param  {number} finishTime
     *         Optional finish time in milliseconds as a Unix timestamp. Decimal
     *         values are supported for timestamps with sub-millisecond accuracy.
     *         If not specified, the current time (as defined by the
     *         implementation) will be used.
     */ Span.prototype.finish = function(finishTime) {
        this._finish(finishTime);
    // Do not return `this`. The Span generally should not be used after it
    // is finished so chaining is not desired in this context.
    };
    // ---------------------------------------------------------------------- //
    // Derived classes can choose to implement the below
    // ---------------------------------------------------------------------- //
    // By default returns a no-op SpanContext.
    Span.prototype._context = function() {
        return noop.spanContext;
    };
    // By default returns a no-op tracer.
    //
    // The base class could store the tracer that created it, but it does not
    // in order to ensure the no-op span implementation has zero members,
    // which allows V8 to aggressively optimize calls to such objects.
    Span.prototype._tracer = function() {
        return noop.tracer;
    };
    // By default does nothing
    Span.prototype._setOperationName = function(name) {};
    // By default does nothing
    Span.prototype._setBaggageItem = function(key, value) {};
    // By default does nothing
    Span.prototype._getBaggageItem = function(key) {
        return undefined;
    };
    // By default does nothing
    //
    // NOTE: both setTag() and addTags() map to this function. keyValuePairs
    // will always be an associative array.
    Span.prototype._addTags = function(keyValuePairs) {};
    // By default does nothing
    Span.prototype._log = function(keyValuePairs, timestamp) {};
    // By default does nothing
    //
    // finishTime is expected to be either a number or undefined.
    Span.prototype._finish = function(finishTime) {};
    return Span;
}();
exports.Span = Span;
exports.default = Span; //# sourceMappingURL=span.js.map
}}),
"[project]/node_modules/opentracing/lib/span_context.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
/**
 * SpanContext represents Span state that must propagate to descendant Spans
 * and across process boundaries.
 *
 * SpanContext is logically divided into two pieces: the user-level "Baggage"
 * (see setBaggageItem and getBaggageItem) that propagates across Span
 * boundaries and any Tracer-implementation-specific fields that are needed to
 * identify or otherwise contextualize the associated Span instance (e.g., a
 * <trace_id, span_id, sampled> tuple).
 */ var SpanContext = function() {
    function SpanContext() {}
    // The SpanContext is entirely implementation dependent
    /**
     * Returns a string representation of the implementation internal trace ID.
     *
     * @returns {string}
     */ SpanContext.prototype.toTraceId = function() {
        return '';
    };
    /**
     * Returns a string representation of the implementation internal span ID.
     *
     * @returns {string}
     */ SpanContext.prototype.toSpanId = function() {
        return '';
    };
    return SpanContext;
}();
exports.SpanContext = SpanContext;
exports.default = SpanContext; //# sourceMappingURL=span_context.js.map
}}),
"[project]/node_modules/opentracing/lib/constants.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
/**
 * The FORMAT_BINARY format represents SpanContexts in an opaque binary
 * carrier.
 *
 * Tracer.inject() will set the buffer field to an Array-like (Array,
 * ArrayBuffer, or TypedBuffer) object containing the injected binary data.
 * Any valid Object can be used as long as the buffer field of the object
 * can be set.
 *
 * Tracer.extract() will look for `carrier.buffer`, and that field is
 * expected to be an Array-like object (Array, ArrayBuffer, or
 * TypedBuffer).
 */ exports.FORMAT_BINARY = 'binary';
/**
 * The FORMAT_TEXT_MAP format represents SpanContexts using a
 * string->string map (backed by a Javascript Object) as a carrier.
 *
 * NOTE: Unlike FORMAT_HTTP_HEADERS, FORMAT_TEXT_MAP places no restrictions
 * on the characters used in either the keys or the values of the map
 * entries.
 *
 * The FORMAT_TEXT_MAP carrier map may contain unrelated data (e.g.,
 * arbitrary gRPC metadata); as such, the Tracer implementation should use
 * a prefix or other convention to distinguish Tracer-specific key:value
 * pairs.
 */ exports.FORMAT_TEXT_MAP = 'text_map';
/**
 * The FORMAT_HTTP_HEADERS format represents SpanContexts using a
 * character-restricted string->string map (backed by a Javascript Object)
 * as a carrier.
 *
 * Keys and values in the FORMAT_HTTP_HEADERS carrier must be suitable for
 * use as HTTP headers (without modification or further escaping). That is,
 * the keys have a greatly restricted character set, casing for the keys
 * may not be preserved by various intermediaries, and the values should be
 * URL-escaped.
 *
 * The FORMAT_HTTP_HEADERS carrier map may contain unrelated data (e.g.,
 * arbitrary HTTP headers); as such, the Tracer implementation should use a
 * prefix or other convention to distinguish Tracer-specific key:value
 * pairs.
 */ exports.FORMAT_HTTP_HEADERS = 'http_headers';
/**
 * A Span may be the "child of" a parent Span. In a “child of” reference,
 * the parent Span depends on the child Span in some capacity.
 *
 * See more about reference types at https://github.com/opentracing/specification
 */ exports.REFERENCE_CHILD_OF = 'child_of';
/**
 * Some parent Spans do not depend in any way on the result of their child
 * Spans. In these cases, we say merely that the child Span “follows from”
 * the parent Span in a causal sense.
 *
 * See more about reference types at https://github.com/opentracing/specification
 */ exports.REFERENCE_FOLLOWS_FROM = 'follows_from'; //# sourceMappingURL=constants.js.map
}}),
"[project]/node_modules/opentracing/lib/reference.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span.js [app-rsc] (ecmascript)");
/**
 * Reference pairs a reference type constant (e.g., REFERENCE_CHILD_OF or
 * REFERENCE_FOLLOWS_FROM) with the SpanContext it points to.
 *
 * See the exported childOf() and followsFrom() functions at the package level.
 */ var Reference = function() {
    /**
     * Initialize a new Reference instance.
     *
     * @param {string} type - the Reference type constant (e.g.,
     *        REFERENCE_CHILD_OF or REFERENCE_FOLLOWS_FROM).
     * @param {SpanContext} referencedContext - the SpanContext being referred
     *        to. As a convenience, a Span instance may be passed in instead
     *        (in which case its .context() is used here).
     */ function Reference(type, referencedContext) {
        this._type = type;
        this._referencedContext = referencedContext instanceof span_1.default ? referencedContext.context() : referencedContext;
    }
    /**
     * @return {string} The Reference type (e.g., REFERENCE_CHILD_OF or
     *         REFERENCE_FOLLOWS_FROM).
     */ Reference.prototype.type = function() {
        return this._type;
    };
    /**
     * @return {SpanContext} The SpanContext being referred to (e.g., the
     *         parent in a REFERENCE_CHILD_OF Reference).
     */ Reference.prototype.referencedContext = function() {
        return this._referencedContext;
    };
    return Reference;
}();
exports.default = Reference; //# sourceMappingURL=reference.js.map
}}),
"[project]/node_modules/opentracing/lib/functions.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var Constants = __turbopack_context__.r("[project]/node_modules/opentracing/lib/constants.js [app-rsc] (ecmascript)");
var reference_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/reference.js [app-rsc] (ecmascript)");
var span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span.js [app-rsc] (ecmascript)");
/**
 * Return a new REFERENCE_CHILD_OF reference.
 *
 * @param {SpanContext} spanContext - the parent SpanContext instance to
 *        reference.
 * @return a REFERENCE_CHILD_OF reference pointing to `spanContext`
 */ function childOf(spanContext) {
    // Allow the user to pass a Span instead of a SpanContext
    if (spanContext instanceof span_1.default) {
        spanContext = spanContext.context();
    }
    return new reference_1.default(Constants.REFERENCE_CHILD_OF, spanContext);
}
exports.childOf = childOf;
/**
 * Return a new REFERENCE_FOLLOWS_FROM reference.
 *
 * @param {SpanContext} spanContext - the parent SpanContext instance to
 *        reference.
 * @return a REFERENCE_FOLLOWS_FROM reference pointing to `spanContext`
 */ function followsFrom(spanContext) {
    // Allow the user to pass a Span instead of a SpanContext
    if (spanContext instanceof span_1.default) {
        spanContext = spanContext.context();
    }
    return new reference_1.default(Constants.REFERENCE_FOLLOWS_FROM, spanContext);
}
exports.followsFrom = followsFrom; //# sourceMappingURL=functions.js.map
}}),
"[project]/node_modules/opentracing/lib/tracer.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var Functions = __turbopack_context__.r("[project]/node_modules/opentracing/lib/functions.js [app-rsc] (ecmascript)");
var Noop = __turbopack_context__.r("[project]/node_modules/opentracing/lib/noop.js [app-rsc] (ecmascript)");
var span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span.js [app-rsc] (ecmascript)");
/**
 * Tracer is the entry-point between the instrumentation API and the tracing
 * implementation.
 *
 * The default object acts as a no-op implementation.
 *
 * Note to implementators: derived classes can choose to directly implement the
 * methods in the "OpenTracing API methods" section, or optionally the subset of
 * underscore-prefixed methods to pick up the argument checking and handling
 * automatically from the base class.
 */ var Tracer = function() {
    function Tracer() {}
    // ---------------------------------------------------------------------- //
    // OpenTracing API methods
    // ---------------------------------------------------------------------- //
    /**
     * Starts and returns a new Span representing a logical unit of work.
     *
     * For example:
     *
     *     // Start a new (parentless) root Span:
     *     var parent = Tracer.startSpan('DoWork');
     *
     *     // Start a new (child) Span:
     *     var child = Tracer.startSpan('load-from-db', {
     *         childOf: parent.context(),
     *     });
     *
     *     // Start a new async (FollowsFrom) Span:
     *     var child = Tracer.startSpan('async-cache-write', {
     *         references: [
     *             opentracing.followsFrom(parent.context())
     *         ],
     *     });
     *
     * @param {string} name - the name of the operation (REQUIRED).
     * @param {SpanOptions} [options] - options for the newly created span.
     * @return {Span} - a new Span object.
     */ Tracer.prototype.startSpan = function(name, options) {
        if (options === void 0) {
            options = {};
        }
        // Convert options.childOf to fields.references as needed.
        if (options.childOf) {
            // Convert from a Span or a SpanContext into a Reference.
            var childOf = Functions.childOf(options.childOf);
            if (options.references) {
                options.references.push(childOf);
            } else {
                options.references = [
                    childOf
                ];
            }
            delete options.childOf;
        }
        return this._startSpan(name, options);
    };
    /**
     * Injects the given SpanContext instance for cross-process propagation
     * within `carrier`. The expected type of `carrier` depends on the value of
     * `format.
     *
     * OpenTracing defines a common set of `format` values (see
     * FORMAT_TEXT_MAP, FORMAT_HTTP_HEADERS, and FORMAT_BINARY), and each has
     * an expected carrier type.
     *
     * Consider this pseudocode example:
     *
     *     var clientSpan = ...;
     *     ...
     *     // Inject clientSpan into a text carrier.
     *     var headersCarrier = {};
     *     Tracer.inject(clientSpan.context(), Tracer.FORMAT_HTTP_HEADERS, headersCarrier);
     *     // Incorporate the textCarrier into the outbound HTTP request header
     *     // map.
     *     Object.assign(outboundHTTPReq.headers, headersCarrier);
     *     // ... send the httpReq
     *
     * @param  {SpanContext} spanContext - the SpanContext to inject into the
     *         carrier object. As a convenience, a Span instance may be passed
     *         in instead (in which case its .context() is used for the
     *         inject()).
     * @param  {string} format - the format of the carrier.
     * @param  {any} carrier - see the documentation for the chosen `format`
     *         for a description of the carrier object.
     */ Tracer.prototype.inject = function(spanContext, format, carrier) {
        // Allow the user to pass a Span instead of a SpanContext
        if (spanContext instanceof span_1.default) {
            spanContext = spanContext.context();
        }
        return this._inject(spanContext, format, carrier);
    };
    /**
     * Returns a SpanContext instance extracted from `carrier` in the given
     * `format`.
     *
     * OpenTracing defines a common set of `format` values (see
     * FORMAT_TEXT_MAP, FORMAT_HTTP_HEADERS, and FORMAT_BINARY), and each has
     * an expected carrier type.
     *
     * Consider this pseudocode example:
     *
     *     // Use the inbound HTTP request's headers as a text map carrier.
     *     var headersCarrier = inboundHTTPReq.headers;
     *     var wireCtx = Tracer.extract(Tracer.FORMAT_HTTP_HEADERS, headersCarrier);
     *     var serverSpan = Tracer.startSpan('...', { childOf : wireCtx });
     *
     * @param  {string} format - the format of the carrier.
     * @param  {any} carrier - the type of the carrier object is determined by
     *         the format.
     * @return {SpanContext}
     *         The extracted SpanContext, or null if no such SpanContext could
     *         be found in `carrier`
     */ Tracer.prototype.extract = function(format, carrier) {
        return this._extract(format, carrier);
    };
    // ---------------------------------------------------------------------- //
    // Derived classes can choose to implement the below
    // ---------------------------------------------------------------------- //
    // NOTE: the input to this method is *always* an associative array. The
    // public-facing startSpan() method normalizes the arguments so that
    // all N implementations do not need to worry about variations in the call
    // signature.
    //
    // The default behavior returns a no-op span.
    Tracer.prototype._startSpan = function(name, fields) {
        return Noop.span;
    };
    // The default behavior is a no-op.
    Tracer.prototype._inject = function(spanContext, format, carrier) {};
    // The default behavior is to return a no-op SpanContext.
    Tracer.prototype._extract = function(format, carrier) {
        return Noop.spanContext;
    };
    return Tracer;
}();
exports.Tracer = Tracer;
exports.default = Tracer; //# sourceMappingURL=tracer.js.map
}}),
"[project]/node_modules/opentracing/lib/noop.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span.js [app-rsc] (ecmascript)");
var span_context_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span_context.js [app-rsc] (ecmascript)");
var tracer_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/tracer.js [app-rsc] (ecmascript)");
exports.tracer = null;
exports.spanContext = null;
exports.span = null;
// Deferred initialization to avoid a dependency cycle where Tracer depends on
// Span which depends on the noop tracer.
function initialize() {
    exports.tracer = new tracer_1.default();
    exports.span = new span_1.default();
    exports.spanContext = new span_context_1.default();
}
exports.initialize = initialize; //# sourceMappingURL=noop.js.map
}}),
"[project]/node_modules/opentracing/lib/mock_tracer/mock_context.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __extends = this && this.__extends || function() {
    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || ({
            __proto__: []
        }) instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for(var p in b)if (b.hasOwnProperty(p)) d[p] = b[p];
        };
        return extendStatics(d, b);
    };
    return function(d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
Object.defineProperty(exports, "__esModule", {
    value: true
});
var span_context_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span_context.js [app-rsc] (ecmascript)");
/**
 * OpenTracing Context implementation designed for use in
 * unit tests.
 */ var MockContext = function(_super) {
    __extends(MockContext, _super);
    function MockContext(span) {
        var _this = _super.call(this) || this;
        // Store a reference to the span itself since this is a mock tracer
        // intended to make debugging and unit testing easier.
        _this._span = span;
        return _this;
    }
    MockContext.prototype.span = function() {
        return this._span;
    };
    return MockContext;
}(span_context_1.SpanContext);
exports.MockContext = MockContext;
exports.default = MockContext; //# sourceMappingURL=mock_context.js.map
}}),
"[project]/node_modules/opentracing/lib/mock_tracer/mock_span.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
/* eslint-disable import/no-extraneous-dependencies */ var __extends = this && this.__extends || function() {
    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || ({
            __proto__: []
        }) instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for(var p in b)if (b.hasOwnProperty(p)) d[p] = b[p];
        };
        return extendStatics(d, b);
    };
    return function(d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
Object.defineProperty(exports, "__esModule", {
    value: true
});
var opentracing = __turbopack_context__.r("[project]/node_modules/opentracing/lib/index.js [app-rsc] (ecmascript)");
var mock_context_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/mock_context.js [app-rsc] (ecmascript)");
/**
 * OpenTracing Span implementation designed for use in unit tests.
 */ var MockSpan = function(_super) {
    __extends(MockSpan, _super);
    //------------------------------------------------------------------------//
    // MockSpan-specific
    //------------------------------------------------------------------------//
    function MockSpan(tracer) {
        var _this = _super.call(this) || this;
        _this._mockTracer = tracer;
        _this._uuid = _this._generateUUID();
        _this._startMs = Date.now();
        _this._finishMs = 0;
        _this._operationName = '';
        _this._tags = {};
        _this._logs = [];
        return _this;
    }
    //------------------------------------------------------------------------//
    // OpenTracing implementation
    //------------------------------------------------------------------------//
    MockSpan.prototype._context = function() {
        return new mock_context_1.default(this);
    };
    MockSpan.prototype._setOperationName = function(name) {
        this._operationName = name;
    };
    MockSpan.prototype._addTags = function(set) {
        var keys = Object.keys(set);
        for(var _i = 0, keys_1 = keys; _i < keys_1.length; _i++){
            var key = keys_1[_i];
            this._tags[key] = set[key];
        }
    };
    MockSpan.prototype._log = function(fields, timestamp) {
        this._logs.push({
            fields: fields,
            timestamp: timestamp
        });
    };
    MockSpan.prototype._finish = function(finishTime) {
        this._finishMs = finishTime || Date.now();
    };
    MockSpan.prototype.uuid = function() {
        return this._uuid;
    };
    MockSpan.prototype.operationName = function() {
        return this._operationName;
    };
    MockSpan.prototype.durationMs = function() {
        return this._finishMs - this._startMs;
    };
    MockSpan.prototype.tags = function() {
        return this._tags;
    };
    MockSpan.prototype.tracer = function() {
        return this._mockTracer;
    };
    MockSpan.prototype._generateUUID = function() {
        var p0 = ("00000000" + Math.abs(Math.random() * 0xFFFFFFFF | 0).toString(16)).substr(-8);
        var p1 = ("00000000" + Math.abs(Math.random() * 0xFFFFFFFF | 0).toString(16)).substr(-8);
        return "" + p0 + p1;
    };
    MockSpan.prototype.addReference = function(ref) {};
    /**
     * Returns a simplified object better for console.log()'ing.
     */ MockSpan.prototype.debug = function() {
        var obj = {
            uuid: this._uuid,
            operation: this._operationName,
            millis: [
                this._finishMs - this._startMs,
                this._startMs,
                this._finishMs
            ]
        };
        if (Object.keys(this._tags).length) {
            obj.tags = this._tags;
        }
        return obj;
    };
    return MockSpan;
}(opentracing.Span);
exports.MockSpan = MockSpan;
exports.default = MockSpan; //# sourceMappingURL=mock_span.js.map
}}),
"[project]/node_modules/opentracing/lib/mock_tracer/mock_report.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
/**
 * Index a collection of reported MockSpans in a way that's easy to run unit
 * test assertions against.
 */ var MockReport = function() {
    function MockReport(spans) {
        var _this = this;
        this.spans = spans;
        this.spansByUUID = {};
        this.spansByTag = {};
        this.debugSpans = [];
        this.unfinishedSpans = [];
        spans.forEach(function(span) {
            if (span._finishMs === 0) {
                _this.unfinishedSpans.push(span);
            }
            _this.spansByUUID[span.uuid()] = span;
            _this.debugSpans.push(span.debug());
            var tags = span.tags();
            Object.keys(tags).forEach(function(key) {
                var val = tags[key];
                _this.spansByTag[key] = _this.spansByTag[key] || {};
                _this.spansByTag[key][val] = _this.spansByTag[key][val] || [];
                _this.spansByTag[key][val].push(span);
            });
        });
    }
    MockReport.prototype.firstSpanWithTagValue = function(key, val) {
        var m = this.spansByTag[key];
        if (!m) {
            return null;
        }
        var n = m[val];
        if (!n) {
            return null;
        }
        return n[0];
    };
    return MockReport;
}();
exports.MockReport = MockReport;
exports.default = MockReport; //# sourceMappingURL=mock_report.js.map
}}),
"[project]/node_modules/opentracing/lib/mock_tracer/mock_tracer.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __extends = this && this.__extends || function() {
    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || ({
            __proto__: []
        }) instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for(var p in b)if (b.hasOwnProperty(p)) d[p] = b[p];
        };
        return extendStatics(d, b);
    };
    return function(d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
Object.defineProperty(exports, "__esModule", {
    value: true
});
// TODO: Move mock-tracer to its own NPM package once it is complete and tested.
var opentracing = __turbopack_context__.r("[project]/node_modules/opentracing/lib/index.js [app-rsc] (ecmascript)");
var mock_report_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/mock_report.js [app-rsc] (ecmascript)");
var mock_span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/mock_span.js [app-rsc] (ecmascript)");
/**
 * OpenTracing Tracer implementation designed for use in unit tests.
 */ var MockTracer = function(_super) {
    __extends(MockTracer, _super);
    //------------------------------------------------------------------------//
    // MockTracer-specific
    //------------------------------------------------------------------------//
    function MockTracer() {
        var _this = _super.call(this) || this;
        _this._spans = [];
        return _this;
    }
    //------------------------------------------------------------------------//
    // OpenTracing implementation
    //------------------------------------------------------------------------//
    MockTracer.prototype._startSpan = function(name, fields) {
        // _allocSpan is given it's own method so that derived classes can
        // allocate any type of object they want, but not have to duplicate
        // the other common logic in startSpan().
        var span = this._allocSpan();
        span.setOperationName(name);
        this._spans.push(span);
        if (fields.references) {
            for(var _i = 0, _a = fields.references; _i < _a.length; _i++){
                var ref = _a[_i];
                span.addReference(ref);
            }
        }
        // Capture the stack at the time the span started
        span._startStack = new Error().stack;
        return span;
    };
    MockTracer.prototype._inject = function(span, format, carrier) {
        throw new Error('NOT YET IMPLEMENTED');
    };
    MockTracer.prototype._extract = function(format, carrier) {
        throw new Error('NOT YET IMPLEMENTED');
    };
    MockTracer.prototype._allocSpan = function() {
        return new mock_span_1.default(this);
    };
    /**
     * Discard any buffered data.
     */ MockTracer.prototype.clear = function() {
        this._spans = [];
    };
    /**
     * Return the buffered data in a format convenient for making unit test
     * assertions.
     */ MockTracer.prototype.report = function() {
        return new mock_report_1.default(this._spans);
    };
    return MockTracer;
}(opentracing.Tracer);
exports.MockTracer = MockTracer;
exports.default = MockTracer; //# sourceMappingURL=mock_tracer.js.map
}}),
"[project]/node_modules/opentracing/lib/mock_tracer/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
var mock_context_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/mock_context.js [app-rsc] (ecmascript)");
exports.MockContext = mock_context_1.default;
var mock_span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/mock_span.js [app-rsc] (ecmascript)");
exports.MockSpan = mock_span_1.default;
var mock_tracer_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/mock_tracer.js [app-rsc] (ecmascript)");
exports.MockTracer = mock_tracer_1.default; //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/opentracing/lib/global_tracer.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __extends = this && this.__extends || function() {
    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || ({
            __proto__: []
        }) instanceof Array && function(d, b) {
            d.__proto__ = b;
        } || function(d, b) {
            for(var p in b)if (b.hasOwnProperty(p)) d[p] = b[p];
        };
        return extendStatics(d, b);
    };
    return function(d, b) {
        extendStatics(d, b);
        function __() {
            this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
}();
Object.defineProperty(exports, "__esModule", {
    value: true
});
var tracer_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/tracer.js [app-rsc] (ecmascript)");
var noopTracer = new tracer_1.default();
var _globalTracer = null;
// Allows direct importing/requiring of the global tracer:
//
// let globalTracer = require('opentracing/global');
//      OR
// import globalTracer from 'opentracing/global';
//
// Acts a bridge to the global tracer that can be safely called before the
// global tracer is initialized. The purpose of the delegation is to avoid the
// sometimes nearly intractible initialization order problems that can arise in
// applications with a complex set of dependencies, while also avoiding the
// case where
var GlobalTracerDelegate = function(_super) {
    __extends(GlobalTracerDelegate, _super);
    function GlobalTracerDelegate() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GlobalTracerDelegate.prototype.startSpan = function() {
        var tracer = _globalTracer || noopTracer;
        return tracer.startSpan.apply(tracer, arguments);
    };
    GlobalTracerDelegate.prototype.inject = function() {
        var tracer = _globalTracer || noopTracer;
        return tracer.inject.apply(tracer, arguments);
    };
    GlobalTracerDelegate.prototype.extract = function() {
        var tracer = _globalTracer || noopTracer;
        return tracer.extract.apply(tracer, arguments);
    };
    return GlobalTracerDelegate;
}(tracer_1.default);
var globalTracerDelegate = new GlobalTracerDelegate();
/**
 * Set the global Tracer.
 *
 * The behavior is undefined if this function is called more than once.
 *
 * @param {Tracer} tracer - the Tracer implementation
 */ function initGlobalTracer(tracer) {
    _globalTracer = tracer;
}
exports.initGlobalTracer = initGlobalTracer;
/**
 * Returns the global tracer.
 */ function globalTracer() {
    // Return the delegate.  Since the global tracer is largely a convenience
    // (the user can always create their own tracers), the delegate is used to
    // give the added convenience of not needing to worry about initialization
    // order.
    return globalTracerDelegate;
}
exports.globalTracer = globalTracer; //# sourceMappingURL=global_tracer.js.map
}}),
"[project]/node_modules/opentracing/lib/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
function __export(m) {
    for(var p in m)if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", {
    value: true
});
var binary_carrier_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/binary_carrier.js [app-rsc] (ecmascript)");
exports.BinaryCarrier = binary_carrier_1.default;
var Tags = __turbopack_context__.r("[project]/node_modules/opentracing/lib/ext/tags.js [app-rsc] (ecmascript)");
exports.Tags = Tags;
var Noop = __turbopack_context__.r("[project]/node_modules/opentracing/lib/noop.js [app-rsc] (ecmascript)");
var reference_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/reference.js [app-rsc] (ecmascript)");
exports.Reference = reference_1.default;
var span_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span.js [app-rsc] (ecmascript)");
exports.Span = span_1.default;
var span_context_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/span_context.js [app-rsc] (ecmascript)");
exports.SpanContext = span_context_1.default;
var tracer_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/tracer.js [app-rsc] (ecmascript)");
exports.Tracer = tracer_1.Tracer;
var mock_tracer_1 = __turbopack_context__.r("[project]/node_modules/opentracing/lib/mock_tracer/index.js [app-rsc] (ecmascript)");
exports.MockTracer = mock_tracer_1.MockTracer;
__export(__turbopack_context__.r("[project]/node_modules/opentracing/lib/global_tracer.js [app-rsc] (ecmascript)"));
__export(__turbopack_context__.r("[project]/node_modules/opentracing/lib/constants.js [app-rsc] (ecmascript)"));
__export(__turbopack_context__.r("[project]/node_modules/opentracing/lib/functions.js [app-rsc] (ecmascript)"));
// Initialize the noops last to avoid a dependecy cycle between the classes.
Noop.initialize(); //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/xorshift/xorshift.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
/**
 * Create a pseudorandom number generator, with a seed.
 * @param {array} seed "128-bit" integer, composed of 4x32-bit
 * integers in big endian order.
 */ function XorShift(seed) {
    // Note the extension, this === module.exports is required because
    // the `constructor` function will be used to generate new instances.
    // In that case `this` will point to the default RNG, and `this` will
    // be an instance of XorShift.
    if (!(this instanceof XorShift) || this === module.exports) {
        return new XorShift(seed);
    }
    if (!Array.isArray(seed) || seed.length !== 4) {
        throw new TypeError('seed must be an array with 4 numbers');
    }
    // uint64_t s = [seed ...]
    this._state0U = seed[0] | 0;
    this._state0L = seed[1] | 0;
    this._state1U = seed[2] | 0;
    this._state1L = seed[3] | 0;
}
/**
 * Returns a 64bit random number as a 2x32bit array
 * @return {array}
 */ XorShift.prototype.randomint = function() {
    // uint64_t s1 = s[0]
    var s1U = this._state0U, s1L = this._state0L;
    // uint64_t s0 = s[1]
    var s0U = this._state1U, s0L = this._state1L;
    // result = s0 + s1
    var sumL = (s0L >>> 0) + (s1L >>> 0);
    var resU = s0U + s1U + (sumL / 2 >>> 31) >>> 0;
    var resL = sumL >>> 0;
    // s[0] = s0
    this._state0U = s0U;
    this._state0L = s0L;
    // - t1 = [0, 0]
    var t1U = 0, t1L = 0;
    // - t2 = [0, 0]
    var t2U = 0, t2L = 0;
    // s1 ^= s1 << 23;
    // :: t1 = s1 << 23
    var a1 = 23;
    var m1 = 0xFFFFFFFF << 32 - a1;
    t1U = s1U << a1 | (s1L & m1) >>> 32 - a1;
    t1L = s1L << a1;
    // :: s1 = s1 ^ t1
    s1U = s1U ^ t1U;
    s1L = s1L ^ t1L;
    // t1 = ( s1 ^ s0 ^ ( s1 >> 17 ) ^ ( s0 >> 26 ) )
    // :: t1 = s1 ^ s0
    t1U = s1U ^ s0U;
    t1L = s1L ^ s0L;
    // :: t2 = s1 >> 18
    var a2 = 18;
    var m2 = 0xFFFFFFFF >>> 32 - a2;
    t2U = s1U >>> a2;
    t2L = s1L >>> a2 | (s1U & m2) << 32 - a2;
    // :: t1 = t1 ^ t2
    t1U = t1U ^ t2U;
    t1L = t1L ^ t2L;
    // :: t2 = s0 >> 5
    var a3 = 5;
    var m3 = 0xFFFFFFFF >>> 32 - a3;
    t2U = s0U >>> a3;
    t2L = s0L >>> a3 | (s0U & m3) << 32 - a3;
    // :: t1 = t1 ^ t2
    t1U = t1U ^ t2U;
    t1L = t1L ^ t2L;
    // s[1] = t1
    this._state1U = t1U;
    this._state1L = t1L;
    // return result
    return [
        resU,
        resL
    ];
};
/**
 * Returns a random number normalized [0, 1), just like Math.random()
 * @return {number}
 */ XorShift.prototype.random = function() {
    var t2 = this.randomint();
    // Math.pow(2, -32) = 2.3283064365386963e-10
    // Math.pow(2, -52) = 2.220446049250313e-16
    return t2[0] * 2.3283064365386963e-10 + (t2[1] >>> 12) * 2.220446049250313e-16;
};
// Seed with Math.random() by default to prevent seed collision
function getRandomSeed() {
    return Math.random() * Math.pow(2, 32);
}
module.exports = new XorShift([
    getRandomSeed(),
    getRandomSeed(),
    getRandomSeed(),
    getRandomSeed()
]);
// Export constructor under its own name so that consumers using ES2015
// can write `import { XorShift } from 'xorshift'`.
module.exports.XorShift = XorShift;
}}),
"[project]/node_modules/node-int64/Int64.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
//     Int64.js
//
//     Copyright (c) 2012 Robert Kieffer
//     MIT License - http://opensource.org/licenses/mit-license.php
/**
 * Support for handling 64-bit int numbers in Javascript (node.js)
 *
 * JS Numbers are IEEE-754 binary double-precision floats, which limits the
 * range of values that can be represented with integer precision to:
 *
 * 2^^53 <= N <= 2^53
 *
 * Int64 objects wrap a node Buffer that holds the 8-bytes of int64 data.  These
 * objects operate directly on the buffer which means that if they are created
 * using an existing buffer then setting the value will modify the Buffer, and
 * vice-versa.
 *
 * Internal Representation
 *
 * The internal buffer format is Big Endian.  I.e. the most-significant byte is
 * at buffer[0], the least-significant at buffer[7].  For the purposes of
 * converting to/from JS native numbers, the value is assumed to be a signed
 * integer stored in 2's complement form.
 *
 * For details about IEEE-754 see:
 * http://en.wikipedia.org/wiki/Double_precision_floating-point_format
 */ // Useful masks and values for bit twiddling
var MASK31 = 0x7fffffff, VAL31 = 0x80000000;
var MASK32 = 0xffffffff, VAL32 = 0x100000000;
// Map for converting hex octets to strings
var _HEX = [];
for(var i = 0; i < 256; i++){
    _HEX[i] = (i > 0xF ? '' : '0') + i.toString(16);
}
//
// Int64
//
/**
 * Constructor accepts any of the following argument types:
 *
 * new Int64(buffer[, offset=0]) - Existing Buffer with byte offset
 * new Int64(Uint8Array[, offset=0]) - Existing Uint8Array with a byte offset
 * new Int64(string)             - Hex string (throws if n is outside int64 range)
 * new Int64(number)             - Number (throws if n is outside int64 range)
 * new Int64(hi, lo)             - Raw bits as two 32-bit values
 */ var Int64 = module.exports = function(a1, a2) {
    if (a1 instanceof Buffer) {
        this.buffer = a1;
        this.offset = a2 || 0;
    } else if (Object.prototype.toString.call(a1) == '[object Uint8Array]') {
        // Under Browserify, Buffers can extend Uint8Arrays rather than an
        // instance of Buffer. We could assume the passed in Uint8Array is actually
        // a buffer but that won't handle the case where a raw Uint8Array is passed
        // in. We construct a new Buffer just in case.
        this.buffer = new Buffer(a1);
        this.offset = a2 || 0;
    } else {
        this.buffer = this.buffer || new Buffer(8);
        this.offset = 0;
        this.setValue.apply(this, arguments);
    }
};
// Max integer value that JS can accurately represent
Int64.MAX_INT = Math.pow(2, 53);
// Min integer value that JS can accurately represent
Int64.MIN_INT = -Math.pow(2, 53);
Int64.prototype = {
    constructor: Int64,
    /**
   * Do in-place 2's compliment.  See
   * http://en.wikipedia.org/wiki/Two's_complement
   */ _2scomp: function() {
        var b = this.buffer, o = this.offset, carry = 1;
        for(var i = o + 7; i >= o; i--){
            var v = (b[i] ^ 0xff) + carry;
            b[i] = v & 0xff;
            carry = v >> 8;
        }
    },
    /**
   * Set the value. Takes any of the following arguments:
   *
   * setValue(string) - A hexidecimal string
   * setValue(number) - Number (throws if n is outside int64 range)
   * setValue(hi, lo) - Raw bits as two 32-bit values
   */ setValue: function(hi, lo) {
        var negate = false;
        if (arguments.length == 1) {
            if (typeof hi == 'number') {
                // Simplify bitfield retrieval by using abs() value.  We restore sign
                // later
                negate = hi < 0;
                hi = Math.abs(hi);
                lo = hi % VAL32;
                hi = hi / VAL32;
                if (hi > VAL32) throw new RangeError(hi + ' is outside Int64 range');
                hi = hi | 0;
            } else if (typeof hi == 'string') {
                hi = (hi + '').replace(/^0x/, '');
                lo = hi.substr(-8);
                hi = hi.length > 8 ? hi.substr(0, hi.length - 8) : '';
                hi = parseInt(hi, 16);
                lo = parseInt(lo, 16);
            } else {
                throw new Error(hi + ' must be a Number or String');
            }
        }
        // Technically we should throw if hi or lo is outside int32 range here, but
        // it's not worth the effort. Anything past the 32'nd bit is ignored.
        // Copy bytes to buffer
        var b = this.buffer, o = this.offset;
        for(var i = 7; i >= 0; i--){
            b[o + i] = lo & 0xff;
            lo = i == 4 ? hi : lo >>> 8;
        }
        // Restore sign of passed argument
        if (negate) this._2scomp();
    },
    /**
   * Convert to a native JS number.
   *
   * WARNING: Do not expect this value to be accurate to integer precision for
   * large (positive or negative) numbers!
   *
   * @param allowImprecise If true, no check is performed to verify the
   * returned value is accurate to integer precision.  If false, imprecise
   * numbers (very large positive or negative numbers) will be forced to +/-
   * Infinity.
   */ toNumber: function(allowImprecise) {
        var b = this.buffer, o = this.offset;
        // Running sum of octets, doing a 2's complement
        var negate = b[o] & 0x80, x = 0, carry = 1;
        for(var i = 7, m = 1; i >= 0; i--, m *= 256){
            var v = b[o + i];
            // 2's complement for negative numbers
            if (negate) {
                v = (v ^ 0xff) + carry;
                carry = v >> 8;
                v = v & 0xff;
            }
            x += v * m;
        }
        // Return Infinity if we've lost integer precision
        if (!allowImprecise && x >= Int64.MAX_INT) {
            return negate ? -Infinity : Infinity;
        }
        return negate ? -x : x;
    },
    /**
   * Convert to a JS Number. Returns +/-Infinity for values that can't be
   * represented to integer precision.
   */ valueOf: function() {
        return this.toNumber(false);
    },
    /**
   * Return string value
   *
   * @param radix Just like Number#toString()'s radix
   */ toString: function(radix) {
        return this.valueOf().toString(radix || 10);
    },
    /**
   * Return a string showing the buffer octets, with MSB on the left.
   *
   * @param sep separator string. default is '' (empty string)
   */ toOctetString: function(sep) {
        var out = new Array(8);
        var b = this.buffer, o = this.offset;
        for(var i = 0; i < 8; i++){
            out[i] = _HEX[b[o + i]];
        }
        return out.join(sep || '');
    },
    /**
   * Returns the int64's 8 bytes in a buffer.
   *
   * @param {bool} [rawBuffer=false]  If no offset and this is true, return the internal buffer.  Should only be used if
   *                                  you're discarding the Int64 afterwards, as it breaks encapsulation.
   */ toBuffer: function(rawBuffer) {
        if (rawBuffer && this.offset === 0) return this.buffer;
        var out = new Buffer(8);
        this.buffer.copy(out, 0, this.offset, this.offset + 8);
        return out;
    },
    /**
   * Copy 8 bytes of int64 into target buffer at target offset.
   *
   * @param {Buffer} targetBuffer       Buffer to copy into.
   * @param {number} [targetOffset=0]   Offset into target buffer.
   */ copy: function(targetBuffer, targetOffset) {
        this.buffer.copy(targetBuffer, targetOffset || 0, this.offset, this.offset + 8);
    },
    /**
   * Returns a number indicating whether this comes before or after or is the
   * same as the other in sort order.
   *
   * @param {Int64} other  Other Int64 to compare.
   */ compare: function(other) {
        // If sign bits differ ...
        if ((this.buffer[this.offset] & 0x80) != (other.buffer[other.offset] & 0x80)) {
            return other.buffer[other.offset] - this.buffer[this.offset];
        }
        // otherwise, compare bytes lexicographically
        for(var i = 0; i < 8; i++){
            if (this.buffer[this.offset + i] !== other.buffer[other.offset + i]) {
                return this.buffer[this.offset + i] - other.buffer[other.offset + i];
            }
        }
        return 0;
    },
    /**
   * Returns a boolean indicating if this integer is equal to other.
   *
   * @param {Int64} other  Other Int64 to compare.
   */ equals: function(other) {
        return this.compare(other) === 0;
    },
    /**
   * Pretty output in console.log
   */ inspect: function() {
        return '[Int64 value:' + this + ' octets:' + this.toOctetString(' ') + ']';
    }
};
}}),
"[project]/node_modules/genkit/lib/common.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var common_exports = {};
__export(common_exports, {
    BaseDataPointSchema: ()=>import_ai.BaseDataPointSchema,
    Chat: ()=>import_chat.Chat,
    Document: ()=>import_ai.Document,
    DocumentDataSchema: ()=>import_ai.DocumentDataSchema,
    GENKIT_CLIENT_HEADER: ()=>import_core.GENKIT_CLIENT_HEADER,
    GENKIT_VERSION: ()=>import_core.GENKIT_VERSION,
    GenerateResponse: ()=>import_ai.GenerateResponse,
    GenerateResponseChunk: ()=>import_ai.GenerateResponseChunk,
    GenerationBlockedError: ()=>import_ai.GenerationBlockedError,
    GenerationCommonConfigSchema: ()=>import_ai.GenerationCommonConfigSchema,
    GenerationResponseError: ()=>import_ai.GenerationResponseError,
    GenkitError: ()=>import_core.GenkitError,
    LlmResponseSchema: ()=>import_ai.LlmResponseSchema,
    LlmStatsSchema: ()=>import_ai.LlmStatsSchema,
    Message: ()=>import_ai.Message,
    MessageSchema: ()=>import_ai.MessageSchema,
    ModelRequestSchema: ()=>import_ai.ModelRequestSchema,
    ModelResponseSchema: ()=>import_ai.ModelResponseSchema,
    OperationSchema: ()=>import_core.OperationSchema,
    PartSchema: ()=>import_ai.PartSchema,
    ReflectionServer: ()=>import_core.ReflectionServer,
    RoleSchema: ()=>import_ai.RoleSchema,
    Session: ()=>import_session.Session,
    StatusCodes: ()=>import_core.StatusCodes,
    StatusSchema: ()=>import_core.StatusSchema,
    ToolCallSchema: ()=>import_ai.ToolCallSchema,
    ToolInterruptError: ()=>import_ai.ToolInterruptError,
    ToolSchema: ()=>import_ai.ToolSchema,
    UserFacingError: ()=>import_core.UserFacingError,
    defineJsonSchema: ()=>import_core.defineJsonSchema,
    defineSchema: ()=>import_core.defineSchema,
    dynamicResource: ()=>import_ai.dynamicResource,
    dynamicTool: ()=>import_tool.dynamicTool,
    embedderActionMetadata: ()=>import_ai.embedderActionMetadata,
    embedderRef: ()=>import_ai.embedderRef,
    evaluatorRef: ()=>import_ai.evaluatorRef,
    getClientHeader: ()=>import_core.getClientHeader,
    getCurrentEnv: ()=>import_core.getCurrentEnv,
    getStreamingCallback: ()=>import_core.getStreamingCallback,
    indexerRef: ()=>import_ai.indexerRef,
    isDevEnv: ()=>import_core.isDevEnv,
    modelActionMetadata: ()=>import_ai.modelActionMetadata,
    modelRef: ()=>import_ai.modelRef,
    rerankerRef: ()=>import_ai.rerankerRef,
    retrieverRef: ()=>import_ai.retrieverRef,
    runWithStreamingCallback: ()=>import_core.runWithStreamingCallback,
    z: ()=>import_core.z
});
module.exports = __toCommonJS(common_exports);
var import_ai = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/index.js [app-rsc] (ecmascript)");
var import_chat = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/chat.js [app-rsc] (ecmascript)");
var import_session = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/session.js [app-rsc] (ecmascript)");
var import_tool = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/tool.js [app-rsc] (ecmascript)");
var import_core = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/index.js [app-rsc] (ecmascript)");
var import_node = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/node.js [app-rsc] (ecmascript)");
(0, import_node.initNodeFeatures)();
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    BaseDataPointSchema,
    Chat,
    Document,
    DocumentDataSchema,
    GENKIT_CLIENT_HEADER,
    GENKIT_VERSION,
    GenerateResponse,
    GenerateResponseChunk,
    GenerationBlockedError,
    GenerationCommonConfigSchema,
    GenerationResponseError,
    GenkitError,
    LlmResponseSchema,
    LlmStatsSchema,
    Message,
    MessageSchema,
    ModelRequestSchema,
    ModelResponseSchema,
    OperationSchema,
    PartSchema,
    ReflectionServer,
    RoleSchema,
    Session,
    StatusCodes,
    StatusSchema,
    ToolCallSchema,
    ToolInterruptError,
    ToolSchema,
    UserFacingError,
    defineJsonSchema,
    defineSchema,
    dynamicResource,
    dynamicTool,
    embedderActionMetadata,
    embedderRef,
    evaluatorRef,
    getClientHeader,
    getCurrentEnv,
    getStreamingCallback,
    indexerRef,
    isDevEnv,
    modelActionMetadata,
    modelRef,
    rerankerRef,
    retrieverRef,
    runWithStreamingCallback,
    z
}); //# sourceMappingURL=common.js.map
}}),
"[project]/node_modules/genkit/lib/logging.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var logging_exports = {};
__export(logging_exports, {
    logger: ()=>import_logging.logger
});
module.exports = __toCommonJS(logging_exports);
var import_logging = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/logging.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    logger
}); //# sourceMappingURL=logging.js.map
}}),
"[project]/node_modules/genkit/lib/plugin.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var plugin_exports = {};
__export(plugin_exports, {
    backgroundModel: ()=>import_model.backgroundModel,
    embedder: ()=>import_embedder.embedder,
    embedderActionMetadata: ()=>import_embedder.embedderActionMetadata,
    evaluator: ()=>import_evaluator.evaluator,
    genkitPlugin: ()=>genkitPlugin,
    genkitPluginV2: ()=>genkitPluginV2,
    indexer: ()=>import_retriever.indexer,
    isPluginV2: ()=>isPluginV2,
    model: ()=>import_model.model,
    modelActionMetadata: ()=>import_model.modelActionMetadata,
    reranker: ()=>import_reranker.reranker,
    retriever: ()=>import_retriever.retriever
});
module.exports = __toCommonJS(plugin_exports);
var import_embedder = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/embedder.js [app-rsc] (ecmascript)");
var import_evaluator = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/evaluator.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/model.js [app-rsc] (ecmascript)");
var import_reranker = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/reranker.js [app-rsc] (ecmascript)");
var import_retriever = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/retriever.js [app-rsc] (ecmascript)");
function genkitPlugin(pluginName, initFn, resolveFn, listActionsFn) {
    return (genkit)=>({
            name: pluginName,
            initializer: async ()=>{
                await initFn(genkit);
            },
            resolver: async (action, target)=>{
                if (resolveFn) {
                    return await resolveFn(genkit, action, target);
                }
            },
            listActions: async ()=>{
                if (listActionsFn) {
                    return await listActionsFn();
                }
                return [];
            }
        });
}
function genkitPluginV2(options) {
    return {
        ...options,
        version: "v2"
    };
}
function isPluginV2(plugin) {
    return plugin.version === "v2";
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    backgroundModel,
    embedder,
    embedderActionMetadata,
    evaluator,
    genkitPlugin,
    genkitPluginV2,
    indexer,
    isPluginV2,
    model,
    modelActionMetadata,
    reranker,
    retriever
}); //# sourceMappingURL=plugin.js.map
}}),
"[project]/node_modules/genkit/lib/registry.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var registry_exports = {};
__export(registry_exports, {
    Registry: ()=>import_registry.Registry
});
module.exports = __toCommonJS(registry_exports);
var import_registry = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/registry.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    Registry
}); //# sourceMappingURL=registry.js.map
}}),
"[project]/node_modules/genkit/lib/tracing.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var tracing_exports = {};
__export(tracing_exports, {
    SPAN_TYPE_ATTR: ()=>import_tracing.SPAN_TYPE_ATTR,
    SpanContextSchema: ()=>import_tracing.SpanContextSchema,
    SpanDataSchema: ()=>import_tracing.SpanDataSchema,
    SpanMetadataSchema: ()=>import_tracing.SpanMetadataSchema,
    SpanStatusSchema: ()=>import_tracing.SpanStatusSchema,
    TimeEventSchema: ()=>import_tracing.TimeEventSchema,
    TraceDataSchema: ()=>import_tracing.TraceDataSchema,
    TraceMetadataSchema: ()=>import_tracing.TraceMetadataSchema,
    TraceServerExporter: ()=>import_tracing.TraceServerExporter,
    appendSpan: ()=>import_tracing.appendSpan,
    enableTelemetry: ()=>import_tracing.enableTelemetry,
    flushTracing: ()=>import_tracing.flushTracing,
    runInNewSpan: ()=>import_tracing.runInNewSpan,
    setCustomMetadataAttribute: ()=>import_tracing.setCustomMetadataAttribute,
    setCustomMetadataAttributes: ()=>import_tracing.setCustomMetadataAttributes,
    setTelemetryServerUrl: ()=>import_tracing.setTelemetryServerUrl,
    toDisplayPath: ()=>import_tracing.toDisplayPath
});
module.exports = __toCommonJS(tracing_exports);
var import_tracing = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/tracing.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    SPAN_TYPE_ATTR,
    SpanContextSchema,
    SpanDataSchema,
    SpanMetadataSchema,
    SpanStatusSchema,
    TimeEventSchema,
    TraceDataSchema,
    TraceMetadataSchema,
    TraceServerExporter,
    appendSpan,
    enableTelemetry,
    flushTracing,
    runInNewSpan,
    setCustomMetadataAttribute,
    setCustomMetadataAttributes,
    setTelemetryServerUrl,
    toDisplayPath
}); //# sourceMappingURL=tracing.js.map
}}),
"[project]/node_modules/genkit/lib/genkit.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var genkit_exports = {};
__export(genkit_exports, {
    Genkit: ()=>Genkit,
    __disableReflectionApi: ()=>__disableReflectionApi,
    genkit: ()=>genkit
});
module.exports = __toCommonJS(genkit_exports);
var import_ai = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/index.js [app-rsc] (ecmascript)");
var import_embedder = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/embedder.js [app-rsc] (ecmascript)");
var import_evaluator = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/evaluator.js [app-rsc] (ecmascript)");
var import_formats = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/formats/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/model.js [app-rsc] (ecmascript)");
var import_reranker = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/reranker.js [app-rsc] (ecmascript)");
var import_retriever = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/retriever.js [app-rsc] (ecmascript)");
var import_tool = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/tool.js [app-rsc] (ecmascript)");
var import_core = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/index.js [app-rsc] (ecmascript)");
var import_async = __turbopack_context__.r("[project]/node_modules/@genkit-ai/core/lib/async.js [app-rsc] (ecmascript)");
var import_logging = __turbopack_context__.r("[project]/node_modules/genkit/lib/logging.js [app-rsc] (ecmascript)");
var import_plugin = __turbopack_context__.r("[project]/node_modules/genkit/lib/plugin.js [app-rsc] (ecmascript)");
var import_registry = __turbopack_context__.r("[project]/node_modules/genkit/lib/registry.js [app-rsc] (ecmascript)");
var import_tracing = __turbopack_context__.r("[project]/node_modules/genkit/lib/tracing.js [app-rsc] (ecmascript)");
class Genkit {
    /** Developer-configured options. */ options;
    /** Registry instance that is exclusively modified by this Genkit instance. */ registry;
    /** Reflection server for this registry. May be null if not started. */ reflectionServer = null;
    /** List of flows that have been registered in this instance. */ flows = [];
    get apiStability() {
        return this.registry.apiStability;
    }
    constructor(options){
        this.options = options || {};
        this.registry = new import_registry.Registry();
        if (this.options.context) {
            this.registry.context = this.options.context;
        }
        this.configure();
        if ((0, import_core.isDevEnv)() && !disableReflectionApi) {
            this.reflectionServer = new import_core.ReflectionServer(this.registry, {
                configuredEnvs: [
                    "dev"
                ],
                name: this.options.name
            });
            this.reflectionServer.start().catch((e)=>import_logging.logger.error);
        }
        if (options?.clientHeader) {
            (0, import_core.setClientHeader)(options?.clientHeader);
        }
    }
    /**
   * Defines and registers a flow function.
   */ defineFlow(config, fn) {
        const flow = (0, import_core.defineFlow)(this.registry, config, fn);
        this.flows.push(flow);
        return flow;
    }
    /**
   * Defines and registers a tool.
   *
   * Tools can be passed to models by name or value during `generate` calls to be called automatically based on the prompt and situation.
   */ defineTool(config, fn) {
        return (0, import_ai.defineTool)(this.registry, config, fn);
    }
    /**
   * Defines a dynamic tool. Dynamic tools are just like regular tools ({@link Genkit.defineTool}) but will not be registered in the
   * Genkit registry and can be defined dynamically at runtime.
   */ dynamicTool(config, fn) {
        return (0, import_tool.dynamicTool)(config, fn);
    }
    /**
   * Defines and registers a schema from a Zod schema.
   *
   * Defined schemas can be referenced by `name` in prompts in place of inline schemas.
   */ defineSchema(name, schema) {
        return (0, import_core.defineSchema)(this.registry, name, schema);
    }
    /**
   * Defines and registers a schema from a JSON schema.
   *
   * Defined schemas can be referenced by `name` in prompts in place of inline schemas.
   */ defineJsonSchema(name, jsonSchema) {
        return (0, import_core.defineJsonSchema)(this.registry, name, jsonSchema);
    }
    /**
   * Defines a new model and adds it to the registry.
   */ defineModel(options, runner) {
        return (0, import_model.defineModel)(this.registry, options, runner);
    }
    /**
   * Defines a new background model and adds it to the registry.
   */ defineBackgroundModel(options) {
        return (0, import_model.defineBackgroundModel)(this.registry, options);
    }
    /**
   * Looks up a prompt by `name` (and optionally `variant`). Can be used to lookup
   * .prompt files or prompts previously defined with {@link Genkit.definePrompt}
   */ prompt(name, options) {
        return this.wrapExecutablePromptPromise(`${name}${options?.variant ? `.${options?.variant}` : ""}`, (0, import_ai.prompt)(this.registry, name, {
            ...options,
            dir: this.options.promptDir ?? "./prompts"
        }));
    }
    wrapExecutablePromptPromise(name, promise) {
        const executablePrompt = async (input, opts)=>{
            return (await promise)(input, opts);
        };
        executablePrompt.ref = {
            name
        };
        executablePrompt.render = async (input, opts)=>{
            return (await promise).render(input, opts);
        };
        executablePrompt.stream = (input, opts)=>{
            let channel = new import_async.Channel();
            const generated = (0, import_tracing.runInNewSpan)(this.registry, {
                metadata: {
                    name,
                    input
                },
                labels: {
                    [import_tracing.SPAN_TYPE_ATTR]: "dotprompt"
                }
            }, ()=>(0, import_ai.generate)(this.registry, promise.then((action)=>action.render(input, {
                        ...opts,
                        onChunk: (chunk)=>channel.send(chunk)
                    }))));
            generated.then(()=>channel.close(), (err)=>channel.error(err));
            return {
                response: generated,
                stream: channel
            };
        };
        executablePrompt.asTool = async ()=>{
            return (await promise).asTool();
        };
        return executablePrompt;
    }
    /**
   * Defines and registers a prompt based on a function.
   *
   * This is an alternative to defining and importing a .prompt file, providing
   * the most advanced control over how the final request to the model is made.
   *
   * @param options - Prompt metadata including model, model params,
   * input/output schemas, etc
   * @param fn - A function that returns a {@link GenerateRequest}. Any config
   * parameters specified by the {@link GenerateRequest} will take precedence
   * over any parameters specified by `options`.
   *
   * ```ts
   * const hi = ai.definePrompt(
   *   {
   *     name: 'hi',
   *     input: {
   *       schema: z.object({
   *         name: z.string(),
   *       }),
   *     },
   *     config: {
   *       temperature: 1,
   *     },
   *   },
   *   async (input) => {
   *     return {
   *       messages: [ { role: 'user', content: [{ text: `hi ${input.name}` }] } ],
   *     };
   *   }
   * );
   * const { text } = await hi({ name: 'Genkit' });
   * ```
   */ definePrompt(options, templateOrFn) {
        if (templateOrFn) {
            if (options.messages) {
                throw new import_core.GenkitError({
                    status: "INVALID_ARGUMENT",
                    message: "Cannot specify template/function argument and `options.messages` at the same time"
                });
            }
            if (typeof templateOrFn === "string") {
                return (0, import_ai.definePrompt)(this.registry, {
                    ...options,
                    messages: templateOrFn
                });
            } else {
                return (0, import_ai.definePrompt)(this.registry, {
                    ...options,
                    messages: async (input)=>{
                        const response = await templateOrFn(input);
                        return response.messages;
                    }
                });
            }
        }
        return (0, import_ai.definePrompt)(this.registry, options);
    }
    /**
   * Creates a retriever action for the provided {@link RetrieverFn} implementation.
   */ defineRetriever(options, runner) {
        return (0, import_retriever.defineRetriever)(this.registry, options, runner);
    }
    /**
   * defineSimpleRetriever makes it easy to map existing data into documents that
   * can be used for prompt augmentation.
   *
   * @param options Configuration options for the retriever.
   * @param handler A function that queries a datastore and returns items from which to extract documents.
   * @returns A Genkit retriever.
   */ defineSimpleRetriever(options, handler) {
        return (0, import_retriever.defineSimpleRetriever)(this.registry, options, handler);
    }
    /**
   * Creates an indexer action for the provided {@link IndexerFn} implementation.
   */ defineIndexer(options, runner) {
        return (0, import_retriever.defineIndexer)(this.registry, options, runner);
    }
    /**
   * Creates evaluator action for the provided {@link EvaluatorFn} implementation.
   */ defineEvaluator(options, runner) {
        return (0, import_evaluator.defineEvaluator)(this.registry, options, runner);
    }
    /**
   * Creates embedder model for the provided {@link EmbedderFn} model implementation.
   */ defineEmbedder(options, runner) {
        return (0, import_embedder.defineEmbedder)(this.registry, options, runner);
    }
    /**
   * create a handlebars helper (https://handlebarsjs.com/guide/block-helpers.html) to be used in dotprompt templates.
   */ defineHelper(name, fn) {
        (0, import_ai.defineHelper)(this.registry, name, fn);
    }
    /**
   * Creates a handlebars partial (https://handlebarsjs.com/guide/partials.html) to be used in dotprompt templates.
   */ definePartial(name, source) {
        (0, import_ai.definePartial)(this.registry, name, source);
    }
    /**
   *  Creates a reranker action for the provided {@link RerankerFn} implementation.
   */ defineReranker(options, runner) {
        return (0, import_reranker.defineReranker)(this.registry, options, runner);
    }
    /**
   * Embeds the given `content` using the specified `embedder`.
   */ embed(params) {
        return (0, import_ai.embed)(this.registry, params);
    }
    /**
   * A veneer for interacting with embedder models in bulk.
   */ embedMany(params) {
        return (0, import_embedder.embedMany)(this.registry, params);
    }
    /**
   * Evaluates the given `dataset` using the specified `evaluator`.
   */ evaluate(params) {
        return (0, import_ai.evaluate)(this.registry, params);
    }
    /**
   * Reranks documents from a {@link RerankerArgument} based on the provided query.
   */ rerank(params) {
        return (0, import_ai.rerank)(this.registry, params);
    }
    /**
   * Indexes `documents` using the provided `indexer`.
   */ index(params) {
        return (0, import_retriever.index)(this.registry, params);
    }
    /**
   * Retrieves documents from the `retriever` based on the provided `query`.
   */ retrieve(params) {
        return (0, import_ai.retrieve)(this.registry, params);
    }
    async generate(options) {
        let resolvedOptions;
        if (options instanceof Promise) {
            resolvedOptions = await options;
        } else if (typeof options === "string" || Array.isArray(options)) {
            resolvedOptions = {
                prompt: options
            };
        } else {
            resolvedOptions = options;
        }
        return (0, import_ai.generate)(this.registry, resolvedOptions);
    }
    generateStream(options) {
        if (typeof options === "string" || Array.isArray(options)) {
            options = {
                prompt: options
            };
        }
        return (0, import_ai.generateStream)(this.registry, options);
    }
    /**
   * Checks the status of of a given operation. Returns a new operation which will contain the updated status.
   *
   * ```ts
   * let operation = await ai.generateOperation({
   *   model: googleAI.model('veo-2.0-generate-001'),
   *   prompt: 'A banana riding a bicycle.',
   * });
   *
   * while (!operation.done) {
   *   operation = await ai.checkOperation(operation!);
   *   await new Promise((resolve) => setTimeout(resolve, 5000));
   * }
   * ```
   *
   * @param operation
   * @returns
   */ checkOperation(operation) {
        return (0, import_ai.checkOperation)(this.registry, operation);
    }
    run(name, funcOrInput, maybeFunc) {
        if (maybeFunc) {
            return (0, import_core.run)(name, funcOrInput, maybeFunc, this.registry);
        }
        return (0, import_core.run)(name, funcOrInput, this.registry);
    }
    /**
   * Returns current action (or flow) invocation context. Can be used to access things like auth
   * data set by HTTP server frameworks. If invoked outside of an action (e.g. flow or tool) will
   * return `undefined`.
   */ currentContext() {
        return (0, import_core.getContext)();
    }
    /**
   * Configures the Genkit instance.
   */ configure() {
        const activeRegistry = this.registry;
        (0, import_model.defineGenerateAction)(activeRegistry);
        (0, import_formats.configureFormats)(activeRegistry);
        const plugins = [
            ...this.options.plugins ?? []
        ];
        if (this.options.model) {
            this.registry.registerValue("defaultModel", "defaultModel", this.options.model);
        }
        if (this.options.promptDir !== null) {
            (0, import_ai.loadPromptFolder)(this.registry, this.options.promptDir ?? "./prompts", "");
        }
        plugins.forEach((plugin)=>{
            if ((0, import_plugin.isPluginV2)(plugin)) {
                import_logging.logger.debug(`Registering v2 plugin ${plugin.name}...`);
                activeRegistry.registerPluginProvider(plugin.name, {
                    name: plugin.name,
                    async initializer () {
                        import_logging.logger.debug(`Initializing plugin ${plugin.name}:`);
                        if (!plugin.init) return;
                        const resolvedActions = await plugin.init();
                        resolvedActions?.forEach((resolvedAction)=>{
                            registerActionV2(activeRegistry, resolvedAction, plugin);
                        });
                    },
                    async resolver (action, target) {
                        if (!plugin.resolve) return;
                        const resolvedAction = await plugin.resolve(action, target);
                        if (resolvedAction) {
                            registerActionV2(activeRegistry, resolvedAction, plugin);
                        }
                    },
                    async listActions () {
                        if (typeof plugin.list === "function") {
                            return (await plugin.list()).map((a)=>{
                                if (a.name.startsWith(`${plugin.name}/`)) {
                                    return a;
                                }
                                return {
                                    ...a,
                                    // Apply namespace for v2 plugins.
                                    name: `${plugin.name}/${a.name}`
                                };
                            });
                        }
                        return [];
                    }
                });
            } else {
                const loadedPlugin = plugin(this);
                import_logging.logger.debug(`Registering plugin ${loadedPlugin.name}...`);
                activeRegistry.registerPluginProvider(loadedPlugin.name, {
                    name: loadedPlugin.name,
                    async initializer () {
                        import_logging.logger.debug(`Initializing plugin ${loadedPlugin.name}:`);
                        await loadedPlugin.initializer();
                    },
                    async resolver (action, target) {
                        if (loadedPlugin.resolver) {
                            await loadedPlugin.resolver(action, target);
                        }
                    },
                    async listActions () {
                        if (loadedPlugin.listActions) {
                            return await loadedPlugin.listActions();
                        }
                        return [];
                    }
                });
            }
        });
    }
    /**
   * Stops all servers.
   */ async stopServers() {
        await this.reflectionServer?.stop();
        this.reflectionServer = null;
    }
}
function registerActionV2(registry, resolvedAction, plugin) {
    if ((0, import_core.isBackgroundAction)(resolvedAction)) {
        (0, import_core.registerBackgroundAction)(registry, resolvedAction, {
            namespace: plugin.name
        });
    } else if ((0, import_core.isAction)(resolvedAction)) {
        if (!resolvedAction.__action.actionType) {
            throw new import_core.GenkitError({
                status: "INVALID_ARGUMENT",
                message: "Action type is missing for " + resolvedAction.__action.name
            });
        }
        registry.registerAction(resolvedAction.__action.actionType, resolvedAction, {
            namespace: plugin.name
        });
    } else {
        throw new import_core.GenkitError({
            status: "INVALID_ARGUMENT",
            message: "Unknown action type returned from plugin " + plugin.name
        });
    }
}
function genkit(options) {
    return new Genkit(options);
}
const shutdown = async ()=>{
    import_logging.logger.info("Shutting down all Genkit servers...");
    await import_core.ReflectionServer.stopAll();
    process.exit(0);
};
process.on("SIGTERM", shutdown);
process.on("SIGINT", shutdown);
let disableReflectionApi = false;
function __disableReflectionApi() {
    disableReflectionApi = true;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    Genkit,
    __disableReflectionApi,
    genkit
}); //# sourceMappingURL=genkit.js.map
}}),
"[project]/node_modules/genkit/lib/index.mjs [app-rsc] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
/**
 * @license
 *
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ __turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/common.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$genkit$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/genkit.js [app-rsc] (ecmascript)");
;
;
;
 //# sourceMappingURL=index.mjs.map
}}),
"[project]/node_modules/genkit/lib/index.mjs [app-rsc] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/common.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$genkit$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/genkit.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$index$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/index.mjs [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/genkit/lib/logging.mjs [app-rsc] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$core$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/core/lib/logging.mjs [app-rsc] (ecmascript)");
;
;
 //# sourceMappingURL=logging.mjs.map
}}),
"[project]/node_modules/genkit/lib/logging.mjs [app-rsc] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$core$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/core/lib/logging.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/logging.mjs [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/genkit/lib/model.mjs [app-rsc] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>");
;
;
 //# sourceMappingURL=model.mjs.map
}}),
"[project]/node_modules/genkit/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/model.mjs [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/genkit/lib/plugin.mjs [app-rsc] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "genkitPlugin": (()=>genkitPlugin),
    "genkitPluginV2": (()=>genkitPluginV2),
    "isPluginV2": (()=>isPluginV2)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$embedder$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/embedder.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$evaluator$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/evaluator.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$reranker$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/reranker.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$retriever$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/retriever.mjs [app-rsc] (ecmascript) <module evaluation>");
;
;
;
;
;
function genkitPlugin(pluginName, initFn, resolveFn, listActionsFn) {
    return (genkit)=>({
            name: pluginName,
            initializer: async ()=>{
                await initFn(genkit);
            },
            resolver: async (action, target)=>{
                if (resolveFn) {
                    return await resolveFn(genkit, action, target);
                }
            },
            listActions: async ()=>{
                if (listActionsFn) {
                    return await listActionsFn();
                }
                return [];
            }
        });
}
function genkitPluginV2(options) {
    return {
        ...options,
        version: "v2"
    };
}
function isPluginV2(plugin) {
    return plugin.version === "v2";
}
;
 //# sourceMappingURL=plugin.mjs.map
}}),
"[project]/node_modules/genkit/lib/plugin.mjs [app-rsc] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$embedder$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/embedder.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$evaluator$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/evaluator.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$reranker$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/reranker.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$retriever$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/retriever.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$plugin$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/plugin.mjs [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __reExport = (target, mod, secondTarget)=>(__copyProps(target, mod, "default"), secondTarget && __copyProps(secondTarget, mod, "default"));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var index_exports = {};
__export(index_exports, {
    Genkit: ()=>import_genkit.Genkit,
    genkit: ()=>import_genkit.genkit
});
module.exports = __toCommonJS(index_exports);
__reExport(index_exports, __turbopack_context__.r("[project]/node_modules/genkit/lib/common.js [app-rsc] (ecmascript)"), module.exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/genkit.js [app-rsc] (ecmascript)");
/**
 * @license
 *
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ // Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    Genkit,
    genkit,
    ...__turbopack_context__.r("[project]/node_modules/genkit/lib/common.js [app-rsc] (ecmascript)")
}); //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/genkit/lib/embedder.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var embedder_exports = {};
__export(embedder_exports, {
    EmbedderInfoSchema: ()=>import_embedder.EmbedderInfoSchema,
    embedderRef: ()=>import_embedder.embedderRef
});
module.exports = __toCommonJS(embedder_exports);
var import_embedder = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/embedder.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    EmbedderInfoSchema,
    embedderRef
}); //# sourceMappingURL=embedder.js.map
}}),
"[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var model_exports = {};
__export(model_exports, {
    CandidateErrorSchema: ()=>import_model.CandidateErrorSchema,
    CandidateSchema: ()=>import_model.CandidateSchema,
    CustomPartSchema: ()=>import_model.CustomPartSchema,
    DataPartSchema: ()=>import_model.DataPartSchema,
    GenerateRequestSchema: ()=>import_model.GenerateRequestSchema,
    GenerateResponseChunkSchema: ()=>import_model.GenerateResponseChunkSchema,
    GenerateResponseSchema: ()=>import_model.GenerateResponseSchema,
    GenerationCommonConfigDescriptions: ()=>import_model.GenerationCommonConfigDescriptions,
    GenerationCommonConfigSchema: ()=>import_model.GenerationCommonConfigSchema,
    GenerationUsageSchema: ()=>import_model.GenerationUsageSchema,
    MediaPartSchema: ()=>import_model.MediaPartSchema,
    MessageSchema: ()=>import_model.MessageSchema,
    ModelInfoSchema: ()=>import_model.ModelInfoSchema,
    ModelRequestSchema: ()=>import_model.ModelRequestSchema,
    ModelResponseSchema: ()=>import_model.ModelResponseSchema,
    PartSchema: ()=>import_model.PartSchema,
    RoleSchema: ()=>import_model.RoleSchema,
    TextPartSchema: ()=>import_model.TextPartSchema,
    ToolDefinitionSchema: ()=>import_model.ToolDefinitionSchema,
    ToolRequestPartSchema: ()=>import_model.ToolRequestPartSchema,
    ToolResponsePartSchema: ()=>import_model.ToolResponsePartSchema,
    getBasicUsageStats: ()=>import_model.getBasicUsageStats,
    modelRef: ()=>import_model.modelRef,
    simulateConstrainedGeneration: ()=>import_model.simulateConstrainedGeneration
});
module.exports = __toCommonJS(model_exports);
var import_model = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/model.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    CandidateErrorSchema,
    CandidateSchema,
    CustomPartSchema,
    DataPartSchema,
    GenerateRequestSchema,
    GenerateResponseChunkSchema,
    GenerateResponseSchema,
    GenerationCommonConfigDescriptions,
    GenerationCommonConfigSchema,
    GenerationUsageSchema,
    MediaPartSchema,
    MessageSchema,
    ModelInfoSchema,
    ModelRequestSchema,
    ModelResponseSchema,
    PartSchema,
    RoleSchema,
    TextPartSchema,
    ToolDefinitionSchema,
    ToolRequestPartSchema,
    ToolResponsePartSchema,
    getBasicUsageStats,
    modelRef,
    simulateConstrainedGeneration
}); //# sourceMappingURL=model.js.map
}}),
"[project]/node_modules/genkit/lib/middleware.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var middleware_exports = {};
__export(middleware_exports, {
    augmentWithContext: ()=>import_middleware.augmentWithContext,
    downloadRequestMedia: ()=>import_middleware.downloadRequestMedia,
    simulateSystemPrompt: ()=>import_middleware.simulateSystemPrompt,
    validateSupport: ()=>import_middleware.validateSupport
});
module.exports = __toCommonJS(middleware_exports);
var import_middleware = __turbopack_context__.r("[project]/node_modules/@genkit-ai/ai/lib/model/middleware.js [app-rsc] (ecmascript)");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    augmentWithContext,
    downloadRequestMedia,
    simulateSystemPrompt,
    validateSupport
}); //# sourceMappingURL=middleware.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var common_exports = {};
__export(common_exports, {
    getApiKeyFromEnvVar: ()=>getApiKeyFromEnvVar,
    getGenkitClientHeader: ()=>getGenkitClientHeader
});
module.exports = __toCommonJS(common_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_process = __toESM(__turbopack_context__.r("[externals]/process [external] (process, cjs)"));
function getApiKeyFromEnvVar() {
    return import_process.default.env.GEMINI_API_KEY || import_process.default.env.GOOGLE_API_KEY || import_process.default.env.GOOGLE_GENAI_API_KEY;
}
function getGenkitClientHeader() {
    if (import_process.default.env.MONOSPACE_ENV == "true") {
        return (0, import_genkit.getClientHeader)() + " firebase-studio-vm";
    }
    return (0, import_genkit.getClientHeader)();
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    getApiKeyFromEnvVar,
    getGenkitClientHeader
}); //# sourceMappingURL=common.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/embedder.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var embedder_exports = {};
__export(embedder_exports, {
    GeminiEmbeddingConfigSchema: ()=>GeminiEmbeddingConfigSchema,
    SUPPORTED_MODELS: ()=>SUPPORTED_MODELS,
    TaskTypeSchema: ()=>TaskTypeSchema,
    defineGoogleAIEmbedder: ()=>defineGoogleAIEmbedder,
    geminiEmbedding001: ()=>geminiEmbedding001,
    textEmbedding004: ()=>textEmbedding004,
    textEmbeddingGecko001: ()=>textEmbeddingGecko001
});
module.exports = __toCommonJS(embedder_exports);
var import_generative_ai = __turbopack_context__.r("[project]/node_modules/@google/generative-ai/dist/index.js [app-rsc] (ecmascript)");
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_embedder = __turbopack_context__.r("[project]/node_modules/genkit/lib/embedder.js [app-rsc] (ecmascript)");
var import_common = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
const TaskTypeSchema = import_genkit.z.enum([
    "RETRIEVAL_DOCUMENT",
    "RETRIEVAL_QUERY",
    "SEMANTIC_SIMILARITY",
    "CLASSIFICATION",
    "CLUSTERING"
]);
const GeminiEmbeddingConfigSchema = import_genkit.z.object({
    /** Override the API key provided at plugin initialization. */ apiKey: import_genkit.z.string().optional(),
    /**
   * The `task_type` parameter is defined as the intended downstream application to help the model
   * produce better quality embeddings.
   **/ taskType: TaskTypeSchema.optional(),
    title: import_genkit.z.string().optional(),
    version: import_genkit.z.string().optional(),
    /**
   * The `outputDimensionality` parameter allows you to specify the dimensionality of the embedding output.
   * By default, the model generates embeddings with 768 dimensions. Models such as
   * `text-embedding-004`, `text-embedding-005`, and `text-multilingual-embedding-002`
   * allow the output dimensionality to be adjusted between 1 and 768.
   * By selecting a smaller output dimensionality, users can save memory and storage space, leading to more efficient computations.
   **/ outputDimensionality: import_genkit.z.number().min(1).max(768).optional()
});
const textEmbeddingGecko001 = (0, import_embedder.embedderRef)({
    name: "googleai/embedding-001",
    configSchema: GeminiEmbeddingConfigSchema,
    info: {
        dimensions: 768,
        label: "Google Gen AI - Text Embedding Gecko (Legacy)",
        supports: {
            input: [
                "text"
            ]
        }
    }
});
const textEmbedding004 = (0, import_embedder.embedderRef)({
    name: "googleai/text-embedding-004",
    configSchema: GeminiEmbeddingConfigSchema,
    info: {
        dimensions: 768,
        label: "Google Gen AI - Text Embedding 001",
        supports: {
            input: [
                "text"
            ]
        }
    }
});
const geminiEmbedding001 = (0, import_embedder.embedderRef)({
    name: "googleai/gemini-embedding-001",
    configSchema: GeminiEmbeddingConfigSchema,
    info: {
        dimensions: 768,
        label: "Google Gen AI - Gemini Embedding 001",
        supports: {
            input: [
                "text"
            ]
        }
    }
});
const SUPPORTED_MODELS = {
    "embedding-001": textEmbeddingGecko001,
    "text-embedding-004": textEmbedding004,
    "gemini-embedding-001": geminiEmbedding001
};
function defineGoogleAIEmbedder(ai, name, pluginOptions) {
    let apiKey;
    if (pluginOptions.apiKey !== false) {
        apiKey = pluginOptions?.apiKey || (0, import_common.getApiKeyFromEnvVar)();
        if (!apiKey) throw new Error("Please pass in the API key or set either GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai");
    }
    const embedder = SUPPORTED_MODELS[name] ?? (0, import_embedder.embedderRef)({
        name,
        configSchema: GeminiEmbeddingConfigSchema,
        info: {
            dimensions: 768,
            label: `Google AI - ${name}`,
            supports: {
                input: [
                    "text",
                    "image",
                    "video"
                ]
            }
        }
    });
    const apiModelName = embedder.name.startsWith("googleai/") ? embedder.name.substring("googleai/".length) : embedder.name;
    return ai.defineEmbedder({
        name: embedder.name,
        configSchema: GeminiEmbeddingConfigSchema,
        info: embedder.info
    }, async (input, options)=>{
        if (pluginOptions.apiKey === false && !options?.apiKey) {
            throw new import_genkit.GenkitError({
                status: "INVALID_ARGUMENT",
                message: "GoogleAI plugin was initialized with {apiKey: false} but no apiKey configuration was passed at call time."
            });
        }
        const client = new import_generative_ai.GoogleGenerativeAI(options?.apiKey || apiKey).getGenerativeModel({
            model: options?.version || embedder.config?.version || embedder.version || apiModelName
        });
        const embeddings = await Promise.all(input.map(async (doc)=>{
            const response = await client.embedContent({
                taskType: options?.taskType,
                title: options?.title,
                content: {
                    role: "",
                    parts: [
                        {
                            text: doc.text
                        }
                    ]
                },
                outputDimensionality: options?.outputDimensionality
            });
            const values = response.embedding.values;
            return {
                embedding: values
            };
        }));
        return {
            embeddings
        };
    });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    GeminiEmbeddingConfigSchema,
    SUPPORTED_MODELS,
    TaskTypeSchema,
    defineGoogleAIEmbedder,
    geminiEmbedding001,
    textEmbedding004,
    textEmbeddingGecko001
}); //# sourceMappingURL=embedder.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/context-caching/constants.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var constants_exports = {};
__export(constants_exports, {
    CONTEXT_CACHE_SUPPORTED_MODELS: ()=>CONTEXT_CACHE_SUPPORTED_MODELS,
    DEFAULT_TTL: ()=>DEFAULT_TTL,
    INVALID_ARGUMENT_MESSAGES: ()=>INVALID_ARGUMENT_MESSAGES
});
module.exports = __toCommonJS(constants_exports);
const CONTEXT_CACHE_SUPPORTED_MODELS = [
    "gemini-1.5-flash-001",
    "gemini-1.5-pro-001"
];
const INVALID_ARGUMENT_MESSAGES = {
    modelVersion: `Model version is required for context caching, supported only in ${CONTEXT_CACHE_SUPPORTED_MODELS.join(",")} models.`,
    tools: "Context caching cannot be used simultaneously with tools.",
    codeExecution: "Context caching cannot be used simultaneously with code execution."
};
const DEFAULT_TTL = 300;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    CONTEXT_CACHE_SUPPORTED_MODELS,
    DEFAULT_TTL,
    INVALID_ARGUMENT_MESSAGES
}); //# sourceMappingURL=constants.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/context-caching/types.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var types_exports = {};
__export(types_exports, {
    cacheConfigDetailsSchema: ()=>cacheConfigDetailsSchema,
    cacheConfigSchema: ()=>cacheConfigSchema
});
module.exports = __toCommonJS(types_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
const cacheConfigSchema = import_genkit.z.union([
    import_genkit.z.boolean(),
    import_genkit.z.object({
        ttlSeconds: import_genkit.z.number().optional()
    }).passthrough()
]);
const cacheConfigDetailsSchema = import_genkit.z.object({
    cacheConfig: cacheConfigSchema,
    endOfCachedContents: import_genkit.z.number()
});
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    cacheConfigDetailsSchema,
    cacheConfigSchema
}); //# sourceMappingURL=types.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/context-caching/utils.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var utils_exports = {};
__export(utils_exports, {
    calculateTTL: ()=>calculateTTL,
    extractCacheConfig: ()=>extractCacheConfig,
    findLastIndex: ()=>findLastIndex,
    generateCacheKey: ()=>generateCacheKey,
    getContentForCache: ()=>getContentForCache,
    lookupContextCache: ()=>lookupContextCache,
    validateContextCacheRequest: ()=>validateContextCacheRequest
});
module.exports = __toCommonJS(utils_exports);
var import_crypto = __toESM(__turbopack_context__.r("[externals]/crypto [external] (crypto, cjs)"));
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_constants = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/context-caching/constants.js [app-rsc] (ecmascript)");
var import_types = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/context-caching/types.js [app-rsc] (ecmascript)");
function generateCacheKey(request) {
    return import_crypto.default.createHash("sha256").update(JSON.stringify(request)).digest("hex");
}
function getContentForCache(request, chatRequest, modelVersion, cacheConfigDetails) {
    if (!modelVersion) {
        throw new Error("No model version provided for context caching");
    }
    if (!chatRequest.history?.length) {
        throw new Error("No history provided for context caching");
    }
    validateHistoryLength(request, chatRequest);
    const { endOfCachedContents, cacheConfig } = cacheConfigDetails;
    const cachedContent = {
        model: modelVersion,
        contents: chatRequest.history.slice(0, endOfCachedContents + 1)
    };
    chatRequest.history = chatRequest.history.slice(endOfCachedContents + 1);
    return {
        cachedContent,
        chatRequest,
        cacheConfig
    };
}
function validateHistoryLength(request, chatRequest) {
    if (chatRequest.history?.length !== request.messages.length - 1) {
        throw new import_genkit.GenkitError({
            status: "INTERNAL",
            message: "Genkit request history and Gemini chat request history length do not match"
        });
    }
}
async function lookupContextCache(cacheManager, cacheKey, maxPages = 100, pageSize = 100) {
    let currentPage = 0;
    let pageToken;
    try {
        while(currentPage < maxPages){
            const { cachedContents, nextPageToken } = await cacheManager.list({
                pageSize,
                pageToken
            });
            const found = cachedContents?.find((content)=>content.displayName === cacheKey);
            if (found) return found;
            if (!nextPageToken) break;
            pageToken = nextPageToken;
            currentPage++;
        }
    } catch (error) {
        const message = error instanceof Error ? error.message : "Unknown Network Error";
        throw new import_genkit.GenkitError({
            status: "INTERNAL",
            message: `Error looking up context cache: ${message}`
        });
    }
    return null;
}
const extractCacheConfig = (request)=>{
    const endOfCachedContents = findLastIndex(request.messages, (message)=>!!message.metadata?.cache);
    return endOfCachedContents === -1 ? null : {
        endOfCachedContents,
        cacheConfig: import_types.cacheConfigSchema.parse(request.messages[endOfCachedContents].metadata?.cache)
    };
};
function validateContextCacheRequest(request, modelVersion) {
    if (!modelVersion || !import_constants.CONTEXT_CACHE_SUPPORTED_MODELS.includes(modelVersion)) {
        throw new import_genkit.GenkitError({
            status: "INVALID_ARGUMENT",
            message: import_constants.INVALID_ARGUMENT_MESSAGES.modelVersion
        });
    }
    if (request.tools?.length) throw new import_genkit.GenkitError({
        status: "INVALID_ARGUMENT",
        message: import_constants.INVALID_ARGUMENT_MESSAGES.tools
    });
    if (request.config?.codeExecution) throw new import_genkit.GenkitError({
        status: "INVALID_ARGUMENT",
        message: import_constants.INVALID_ARGUMENT_MESSAGES.codeExecution
    });
    return true;
}
function findLastIndex(array, callback) {
    for(let i = array.length - 1; i >= 0; i--){
        if (callback(array[i], i, array)) return i;
    }
    return -1;
}
function calculateTTL(cacheConfig) {
    if (cacheConfig.cacheConfig === true) {
        return import_constants.DEFAULT_TTL;
    }
    if (cacheConfig.cacheConfig === false) {
        return 0;
    }
    return cacheConfig.cacheConfig.ttlSeconds || import_constants.DEFAULT_TTL;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    calculateTTL,
    extractCacheConfig,
    findLastIndex,
    generateCacheKey,
    getContentForCache,
    lookupContextCache,
    validateContextCacheRequest
}); //# sourceMappingURL=utils.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/context-caching/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var context_caching_exports = {};
__export(context_caching_exports, {
    handleCacheIfNeeded: ()=>handleCacheIfNeeded,
    handleContextCache: ()=>handleContextCache
});
module.exports = __toCommonJS(context_caching_exports);
var import_server = __turbopack_context__.r("[project]/node_modules/@google/generative-ai/dist/server/index.js [app-rsc] (ecmascript)");
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_logging = __turbopack_context__.r("[project]/node_modules/genkit/lib/logging.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/context-caching/utils.js [app-rsc] (ecmascript)");
async function handleContextCache(apiKey, request, chatRequest, modelVersion, cacheConfigDetails) {
    const cacheManager = new import_server.GoogleAICacheManager(apiKey);
    const { cachedContent, chatRequest: newChatRequest } = (0, import_utils.getContentForCache)(request, chatRequest, modelVersion, cacheConfigDetails);
    cachedContent.model = modelVersion;
    const cacheKey = (0, import_utils.generateCacheKey)(cachedContent);
    cachedContent.displayName = cacheKey;
    let cache = await (0, import_utils.lookupContextCache)(cacheManager, cacheKey);
    import_logging.logger.debug(`Cache hit: ${cache ? "true" : "false"}`);
    if (!cache) {
        try {
            import_logging.logger.debug("No cache found, creating one.");
            const createParams = {
                ...cachedContent,
                ttlSeconds: (0, import_utils.calculateTTL)(cacheConfigDetails)
            };
            cache = await cacheManager.create(createParams);
            import_logging.logger.debug(`Created new cache entry with key: ${cacheKey}`);
        } catch (cacheError) {
            import_logging.logger.error(`Failed to create cache with key ${cacheKey}: ${cacheError}`);
            throw new import_genkit.GenkitError({
                status: "INTERNAL",
                message: `Failed to create cache: ${cacheError}`
            });
        }
    }
    if (!cache) {
        throw new import_genkit.GenkitError({
            status: "INTERNAL",
            message: "Failed to use context cache feature"
        });
    }
    return {
        cache,
        newChatRequest
    };
}
async function handleCacheIfNeeded(apiKey, request, chatRequest, modelVersion, cacheConfigDetails) {
    if (!cacheConfigDetails || !(0, import_utils.validateContextCacheRequest)(request, modelVersion)) {
        return {
            chatRequest,
            cache: null
        };
    }
    const { cache, newChatRequest } = await handleContextCache(apiKey, request, chatRequest, modelVersion, cacheConfigDetails);
    return {
        chatRequest: newChatRequest,
        cache
    };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    handleCacheIfNeeded,
    handleContextCache
}); //# sourceMappingURL=index.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/gemini.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var gemini_exports = {};
__export(gemini_exports, {
    GENERIC_GEMINI_MODEL: ()=>GENERIC_GEMINI_MODEL,
    GeminiConfigSchema: ()=>GeminiConfigSchema,
    GeminiGemmaConfigSchema: ()=>GeminiGemmaConfigSchema,
    GeminiTtsConfigSchema: ()=>GeminiTtsConfigSchema,
    SUPPORTED_GEMINI_MODELS: ()=>SUPPORTED_GEMINI_MODELS,
    aggregateResponses: ()=>aggregateResponses,
    cleanSchema: ()=>cleanSchema,
    defineGoogleAIModel: ()=>defineGoogleAIModel,
    fromGeminiCandidate: ()=>fromGeminiCandidate,
    gemini: ()=>gemini,
    gemini10Pro: ()=>gemini10Pro,
    gemini15Flash: ()=>gemini15Flash,
    gemini15Flash8b: ()=>gemini15Flash8b,
    gemini15Pro: ()=>gemini15Pro,
    gemini20Flash: ()=>gemini20Flash,
    gemini20FlashExp: ()=>gemini20FlashExp,
    gemini20FlashLite: ()=>gemini20FlashLite,
    gemini20ProExp0205: ()=>gemini20ProExp0205,
    gemini25Flash: ()=>gemini25Flash,
    gemini25FlashLite: ()=>gemini25FlashLite,
    gemini25FlashPreview0417: ()=>gemini25FlashPreview0417,
    gemini25FlashPreviewTts: ()=>gemini25FlashPreviewTts,
    gemini25Pro: ()=>gemini25Pro,
    gemini25ProExp0325: ()=>gemini25ProExp0325,
    gemini25ProPreview0325: ()=>gemini25ProPreview0325,
    gemini25ProPreviewTts: ()=>gemini25ProPreviewTts,
    gemma312bit: ()=>gemma312bit,
    gemma31bit: ()=>gemma31bit,
    gemma327bit: ()=>gemma327bit,
    gemma34bit: ()=>gemma34bit,
    gemma3ne4bit: ()=>gemma3ne4bit,
    toGeminiMessage: ()=>toGeminiMessage,
    toGeminiSystemInstruction: ()=>toGeminiSystemInstruction,
    toGeminiTool: ()=>toGeminiTool
});
module.exports = __toCommonJS(gemini_exports);
var import_generative_ai = __turbopack_context__.r("[project]/node_modules/@google/generative-ai/dist/index.js [app-rsc] (ecmascript)");
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_middleware = __turbopack_context__.r("[project]/node_modules/genkit/lib/middleware.js [app-rsc] (ecmascript)");
var import_tracing = __turbopack_context__.r("[project]/node_modules/genkit/lib/tracing.js [app-rsc] (ecmascript)");
var import_common = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
var import_context_caching = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/context-caching/index.js [app-rsc] (ecmascript)");
var import_utils = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/context-caching/utils.js [app-rsc] (ecmascript)");
const SafetySettingsSchema = import_genkit.z.object({
    category: import_genkit.z.enum([
        "HARM_CATEGORY_UNSPECIFIED",
        "HARM_CATEGORY_HATE_SPEECH",
        "HARM_CATEGORY_SEXUALLY_EXPLICIT",
        "HARM_CATEGORY_HARASSMENT",
        "HARM_CATEGORY_DANGEROUS_CONTENT",
        "HARM_CATEGORY_CIVIC_INTEGRITY"
    ]),
    threshold: import_genkit.z.enum([
        "BLOCK_LOW_AND_ABOVE",
        "BLOCK_MEDIUM_AND_ABOVE",
        "BLOCK_ONLY_HIGH",
        "BLOCK_NONE"
    ])
});
const VoiceConfigSchema = import_genkit.z.object({
    prebuiltVoiceConfig: import_genkit.z.object({
        // TODO: Make this an array of objects so we can also specify the description
        // for each voiceName.
        voiceName: import_genkit.z.union([
            import_genkit.z.enum([
                "Zephyr",
                "Puck",
                "Charon",
                "Kore",
                "Fenrir",
                "Leda",
                "Orus",
                "Aoede",
                "Callirrhoe",
                "Autonoe",
                "Enceladus",
                "Iapetus",
                "Umbriel",
                "Algieba",
                "Despina",
                "Erinome",
                "Algenib",
                "Rasalgethi",
                "Laomedeia",
                "Achernar",
                "Alnilam",
                "Schedar",
                "Gacrux",
                "Pulcherrima",
                "Achird",
                "Zubenelgenubi",
                "Vindemiatrix",
                "Sadachbia",
                "Sadaltager",
                "Sulafat"
            ]),
            // To allow any new string values
            import_genkit.z.string()
        ]).describe("Name of the preset voice to use").optional()
    }).describe("Configuration for the prebuilt speaker to use").passthrough().optional()
}).describe("Configuration for the voice to use").passthrough();
const GeminiConfigSchema = import_model.GenerationCommonConfigSchema.extend({
    temperature: import_genkit.z.number().min(0).max(2).describe(import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0.").optional(),
    topP: import_genkit.z.number().min(0).max(1).describe(import_model.GenerationCommonConfigDescriptions.topP + " The default value is 0.95.").optional(),
    apiKey: import_genkit.z.string().describe("Overrides the plugin-configured API key, if specified.").optional(),
    safetySettings: import_genkit.z.array(SafetySettingsSchema).describe("Adjust how likely you are to see responses that could be harmful. Content is blocked based on the probability that it is harmful.").optional(),
    codeExecution: import_genkit.z.union([
        import_genkit.z.boolean(),
        import_genkit.z.object({}).strict()
    ]).describe("Enables the model to generate and run code.").optional(),
    contextCache: import_genkit.z.boolean().describe("Context caching allows you to save and reuse precomputed input tokens that you wish to use repeatedly.").optional(),
    functionCallingConfig: import_genkit.z.object({
        mode: import_genkit.z.enum([
            "MODE_UNSPECIFIED",
            "AUTO",
            "ANY",
            "NONE"
        ]).optional(),
        allowedFunctionNames: import_genkit.z.array(import_genkit.z.string()).optional()
    }).describe("Controls how the model uses the provided tools (function declarations). With AUTO (Default) mode, the model decides whether to generate a natural language response or suggest a function call based on the prompt and context. With ANY, the model is constrained to always predict a function call and guarantee function schema adherence. With NONE, the model is prohibited from making function calls.").optional(),
    responseModalities: import_genkit.z.array(import_genkit.z.enum([
        "TEXT",
        "IMAGE",
        "AUDIO"
    ])).describe("The modalities to be used in response. Only supported for 'gemini-2.0-flash-exp' model at present.").optional(),
    googleSearchRetrieval: import_genkit.z.union([
        import_genkit.z.boolean(),
        import_genkit.z.object({}).passthrough()
    ]).describe("Retrieve public web data for grounding, powered by Google Search.").optional(),
    thinkingConfig: import_genkit.z.object({
        includeThoughts: import_genkit.z.boolean().describe("Indicates whether to include thoughts in the response.If true, thoughts are returned only when available.").optional(),
        thinkingBudget: import_genkit.z.number().min(0).max(24576).describe("The thinking budget parameter gives the model guidance on the number of thinking tokens it can use when generating a response. A greater number of tokens is typically associated with more detailed thinking, which is needed for solving more complex tasks. Setting the thinking budget to 0 disables thinking.").optional()
    }).optional()
}).passthrough();
const GeminiGemmaConfigSchema = GeminiConfigSchema.extend({
    temperature: import_genkit.z.number().min(0).max(1).describe(import_model.GenerationCommonConfigDescriptions.temperature + " The default value is 1.0.").optional()
}).passthrough();
const GeminiTtsConfigSchema = GeminiConfigSchema.extend({
    speechConfig: import_genkit.z.object({
        voiceConfig: VoiceConfigSchema.optional(),
        multiSpeakerVoiceConfig: import_genkit.z.object({
            speakerVoiceConfigs: import_genkit.z.array(import_genkit.z.object({
                speaker: import_genkit.z.string().describe("Name of the speaker to use"),
                voiceConfig: VoiceConfigSchema
            }).describe("Configuration for a single speaker in a multi speaker setup").passthrough()).describe("Configuration for all the enabled speaker voices")
        }).describe("Configuration for multi-speaker setup").passthrough().optional()
    }).describe("Speech generation config").passthrough().optional()
}).passthrough();
const gemini10Pro = (0, import_model.modelRef)({
    name: "googleai/gemini-1.0-pro",
    info: {
        label: "Google AI - Gemini Pro",
        versions: [
            "gemini-pro",
            "gemini-1.0-pro-latest",
            "gemini-1.0-pro-001"
        ],
        supports: {
            multiturn: true,
            media: false,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini15Pro = (0, import_model.modelRef)({
    name: "googleai/gemini-1.5-pro",
    info: {
        label: "Google AI - Gemini 1.5 Pro",
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        },
        versions: [
            "gemini-1.5-pro-latest",
            "gemini-1.5-pro-001",
            "gemini-1.5-pro-002"
        ]
    },
    configSchema: GeminiConfigSchema
});
const gemini15Flash = (0, import_model.modelRef)({
    name: "googleai/gemini-1.5-flash",
    info: {
        label: "Google AI - Gemini 1.5 Flash",
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools",
            // @ts-ignore
            contextCache: true
        },
        versions: [
            "gemini-1.5-flash-latest",
            "gemini-1.5-flash-001",
            "gemini-1.5-flash-002"
        ]
    },
    configSchema: GeminiConfigSchema
});
const gemini15Flash8b = (0, import_model.modelRef)({
    name: "googleai/gemini-1.5-flash-8b",
    info: {
        label: "Google AI - Gemini 1.5 Flash",
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        },
        versions: [
            "gemini-1.5-flash-8b-latest",
            "gemini-1.5-flash-8b-001"
        ]
    },
    configSchema: GeminiConfigSchema
});
const gemini20Flash = (0, import_model.modelRef)({
    name: "googleai/gemini-2.0-flash",
    info: {
        label: "Google AI - Gemini 2.0 Flash",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini20FlashExp = (0, import_model.modelRef)({
    name: "googleai/gemini-2.0-flash-exp",
    info: {
        label: "Google AI - Gemini 2.0 Flash (Experimental)",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini20FlashLite = (0, import_model.modelRef)({
    name: "googleai/gemini-2.0-flash-lite",
    info: {
        label: "Google AI - Gemini 2.0 Flash Lite",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini20ProExp0205 = (0, import_model.modelRef)({
    name: "googleai/gemini-2.0-pro-exp-02-05",
    info: {
        label: "Google AI - Gemini 2.0 Pro Exp 02-05",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini25FlashPreview0417 = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-flash-preview-04-17",
    info: {
        label: "Google AI - Gemini 2.5 Flash Preview 04-17",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini25FlashPreviewTts = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-flash-preview-tts",
    info: {
        label: "Google AI - Gemini 2.5 Flash Preview TTS",
        versions: [],
        supports: {
            multiturn: false,
            media: false,
            tools: false,
            toolChoice: false,
            systemRole: false,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiTtsConfigSchema
});
const gemini25ProExp0325 = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-pro-exp-03-25",
    info: {
        label: "Google AI - Gemini 2.5 Pro Exp 03-25",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini25ProPreview0325 = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-pro-preview-03-25",
    info: {
        label: "Google AI - Gemini 2.5 Pro Preview 03-25",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini25ProPreviewTts = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-pro-preview-tts",
    info: {
        label: "Google AI - Gemini 2.5 Pro Preview TTS",
        versions: [],
        supports: {
            multiturn: false,
            media: false,
            tools: false,
            toolChoice: false,
            systemRole: false,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiTtsConfigSchema
});
const gemini25Pro = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-pro",
    info: {
        label: "Google AI - Gemini 2.5 Pro",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini25Flash = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-flash",
    info: {
        label: "Google AI - Gemini 2.5 Flash",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemini25FlashLite = (0, import_model.modelRef)({
    name: "googleai/gemini-2.5-flash-lite",
    info: {
        label: "Google AI - Gemini 2.5 Flash Lite",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiConfigSchema
});
const gemma312bit = (0, import_model.modelRef)({
    name: "googleai/gemma-3-12b-it",
    info: {
        label: "Google AI - Gemma 3 12B",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiGemmaConfigSchema
});
const gemma31bit = (0, import_model.modelRef)({
    name: "googleai/gemma-3-1b-it",
    info: {
        label: "Google AI - Gemma 3 1B",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiGemmaConfigSchema
});
const gemma327bit = (0, import_model.modelRef)({
    name: "googleai/gemma-3-27b-it",
    info: {
        label: "Google AI - Gemma 3 27B",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiGemmaConfigSchema
});
const gemma34bit = (0, import_model.modelRef)({
    name: "googleai/gemma-3-4b-it",
    info: {
        label: "Google AI - Gemma 3 4B",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiGemmaConfigSchema
});
const gemma3ne4bit = (0, import_model.modelRef)({
    name: "googleai/gemma-3n-e4b-it",
    info: {
        label: "Google AI - Gemma 3n E4B",
        versions: [],
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    },
    configSchema: GeminiGemmaConfigSchema
});
const SUPPORTED_GEMINI_MODELS = {
    "gemini-1.5-pro": gemini15Pro,
    "gemini-1.5-flash": gemini15Flash,
    "gemini-1.5-flash-8b": gemini15Flash8b,
    "gemini-2.0-pro-exp-02-05": gemini20ProExp0205,
    "gemini-2.0-flash": gemini20Flash,
    "gemini-2.0-flash-lite": gemini20FlashLite,
    "gemini-2.0-flash-exp": gemini20FlashExp,
    "gemini-2.5-pro-exp-03-25": gemini25ProExp0325,
    "gemini-2.5-pro-preview-03-25": gemini25ProPreview0325,
    "gemini-2.5-pro-preview-tts": gemini25ProPreviewTts,
    "gemini-2.5-flash-preview-04-17": gemini25FlashPreview0417,
    "gemini-2.5-flash-preview-tts": gemini25FlashPreviewTts,
    "gemini-2.5-flash": gemini25Flash,
    "gemini-2.5-flash-lite": gemini25FlashLite,
    "gemini-2.5-pro": gemini25Pro,
    "gemma-3-12b-it": gemma312bit,
    "gemma-3-1b-it": gemma31bit,
    "gemma-3-27b-it": gemma327bit,
    "gemma-3-4b-it": gemma34bit,
    "gemma-3n-e4b-it": gemma3ne4bit
};
const GENERIC_GEMINI_MODEL = (0, import_model.modelRef)({
    name: "googleai/gemini",
    configSchema: GeminiConfigSchema,
    info: {
        label: "Google Gemini",
        supports: {
            multiturn: true,
            media: true,
            tools: true,
            toolChoice: true,
            systemRole: true,
            constrained: "no-tools"
        }
    }
});
function longestMatchingPrefix(version, potentialMatches) {
    return potentialMatches.filter((p)=>version.startsWith(p)).reduce((longest, current)=>current.length > longest.length ? current : longest, "");
}
function gemini(version, options = {}) {
    const nearestModel = nearestGeminiModelRef(version);
    return (0, import_model.modelRef)({
        name: `googleai/${version}`,
        config: options,
        configSchema: GeminiConfigSchema,
        info: {
            ...nearestModel.info,
            // If exact suffix match for a known model, use its label, otherwise create a new label
            label: nearestModel.name.endsWith(version) ? nearestModel.info?.label : `Google AI - ${version}`
        }
    });
}
function nearestGeminiModelRef(version, options = {}) {
    const matchingKey = longestMatchingPrefix(version, Object.keys(SUPPORTED_GEMINI_MODELS));
    if (matchingKey) {
        return SUPPORTED_GEMINI_MODELS[matchingKey].withConfig({
            ...options,
            version
        });
    }
    return GENERIC_GEMINI_MODEL.withConfig({
        ...options,
        version
    });
}
function toGeminiRole(role, model) {
    switch(role){
        case "user":
            return "user";
        case "model":
            return "model";
        case "system":
            if (model?.info?.supports?.systemRole) {
                throw new Error("system role is only supported for a single message in the first position");
            } else {
                throw new Error("system role is not supported");
            }
        case "tool":
            return "function";
        default:
            return "user";
    }
}
function convertSchemaProperty(property) {
    if (!property || !property.type) {
        return void 0;
    }
    const baseSchema = {};
    if (property.description) {
        baseSchema.description = property.description;
    }
    if (property.enum) {
        baseSchema.type = import_generative_ai.SchemaType.STRING;
        baseSchema.enum = property.enum;
    }
    if (property.nullable) {
        baseSchema.nullable = property.nullable;
    }
    let propertyType;
    if (Array.isArray(property.type)) {
        const types = property.type;
        if (types.includes("null")) {
            baseSchema.nullable = true;
        }
        propertyType = types.find((t)=>t !== "null");
    } else {
        propertyType = property.type;
    }
    if (propertyType === "object") {
        const nestedProperties = {};
        Object.keys(property.properties ?? {}).forEach((key)=>{
            nestedProperties[key] = convertSchemaProperty(property.properties[key]);
        });
        return {
            ...baseSchema,
            type: import_generative_ai.SchemaType.OBJECT,
            properties: nestedProperties,
            required: property.required
        };
    } else if (propertyType === "array") {
        return {
            ...baseSchema,
            type: import_generative_ai.SchemaType.ARRAY,
            items: convertSchemaProperty(property.items)
        };
    } else {
        const schemaType = import_generative_ai.SchemaType[propertyType.toUpperCase()];
        if (!schemaType) {
            throw new import_genkit.GenkitError({
                status: "INVALID_ARGUMENT",
                message: `Unsupported property type ${propertyType.toUpperCase()}`
            });
        }
        return {
            ...baseSchema,
            type: schemaType
        };
    }
}
function toGeminiTool(tool) {
    const declaration = {
        name: tool.name.replace(/\//g, "__"),
        // Gemini throws on '/' in tool name
        description: tool.description,
        parameters: convertSchemaProperty(tool.inputSchema)
    };
    return declaration;
}
function toInlineData(part) {
    const dataUrl = part.media.url;
    const b64Data = dataUrl.substring(dataUrl.indexOf(",") + 1);
    const contentType = part.media.contentType || dataUrl.substring(dataUrl.indexOf(":") + 1, dataUrl.indexOf(";"));
    return {
        inlineData: {
            mimeType: contentType,
            data: b64Data
        }
    };
}
function toFileData(part) {
    if (!part.media.contentType) throw new Error("Must supply a `contentType` when sending File URIs to Gemini.");
    return {
        fileData: {
            mimeType: part.media.contentType,
            fileUri: part.media.url
        }
    };
}
function fromInlineData(inlinePart) {
    if (!inlinePart.inlineData || !inlinePart.inlineData.hasOwnProperty("mimeType") || !inlinePart.inlineData.hasOwnProperty("data")) {
        throw new Error("Invalid InlineDataPart: missing required properties");
    }
    const { mimeType, data } = inlinePart.inlineData;
    const dataUrl = `data:${mimeType};base64,${data}`;
    return {
        media: {
            url: dataUrl,
            contentType: mimeType
        }
    };
}
function toFunctionCall(part) {
    if (!part?.toolRequest?.input) {
        throw Error("Invalid ToolRequestPart: input was missing.");
    }
    return {
        functionCall: {
            name: part.toolRequest.name,
            args: part.toolRequest.input
        }
    };
}
function fromFunctionCall(part, ref) {
    if (!part.functionCall) {
        throw Error("Invalid FunctionCallPart");
    }
    return {
        toolRequest: {
            name: part.functionCall.name,
            input: part.functionCall.args,
            ref
        }
    };
}
function toFunctionResponse(part) {
    if (!part?.toolResponse?.output) {
        throw Error("Invalid ToolResponsePart: output was missing.");
    }
    return {
        functionResponse: {
            name: part.toolResponse.name,
            response: {
                name: part.toolResponse.name,
                content: part.toolResponse.output
            }
        }
    };
}
function fromFunctionResponse(part) {
    if (!part.functionResponse) {
        throw new Error("Invalid FunctionResponsePart.");
    }
    return {
        toolResponse: {
            name: part.functionResponse.name.replace(/__/g, "/"),
            // restore slashes
            output: part.functionResponse.response
        }
    };
}
function fromExecutableCode(part) {
    if (!part.executableCode) {
        throw new Error("Invalid GeminiPart: missing executableCode");
    }
    return {
        custom: {
            executableCode: {
                language: part.executableCode.language,
                code: part.executableCode.code
            }
        }
    };
}
function fromCodeExecutionResult(part) {
    if (!part.codeExecutionResult) {
        throw new Error("Invalid GeminiPart: missing codeExecutionResult");
    }
    return {
        custom: {
            codeExecutionResult: {
                outcome: part.codeExecutionResult.outcome,
                output: part.codeExecutionResult.output
            }
        }
    };
}
function fromThought(part) {
    return {
        reasoning: part.text || "",
        metadata: {
            thoughtSignature: part.thoughtSignature
        }
    };
}
function toCustomPart(part) {
    if (!part.custom) {
        throw new Error("Invalid GeminiPart: missing custom");
    }
    if (part.custom.codeExecutionResult) {
        return {
            codeExecutionResult: part.custom.codeExecutionResult
        };
    }
    if (part.custom.executableCode) {
        return {
            executableCode: part.custom.executableCode
        };
    }
    throw new Error("Unsupported Custom Part type");
}
function toThought(part) {
    const outPart = {
        thought: true
    };
    if (part.metadata?.thoughtSignature) outPart.thoughtSignature = part.metadata.thoughtSignature;
    if (part.reasoning?.length) outPart.text = part.reasoning;
    return outPart;
}
function toGeminiPart(part) {
    if (part.text !== void 0) return {
        text: part.text || " "
    };
    if (part.media) {
        if (part.media.url.startsWith("data:")) return toInlineData(part);
        return toFileData(part);
    }
    if (part.toolRequest) return toFunctionCall(part);
    if (part.toolResponse) return toFunctionResponse(part);
    if (part.custom) return toCustomPart(part);
    if (typeof part.reasoning === "string") return toThought(part);
    throw new Error("Unsupported Part type" + JSON.stringify(part));
}
function fromGeminiPart(part, jsonMode, ref) {
    if ("thought" in part) return fromThought(part);
    if (typeof part.text === "string") return {
        text: part.text
    };
    if (part.inlineData) return fromInlineData(part);
    if (part.functionCall) return fromFunctionCall(part, ref);
    if (part.functionResponse) return fromFunctionResponse(part);
    if (part.executableCode) return fromExecutableCode(part);
    if (part.codeExecutionResult) return fromCodeExecutionResult(part);
    throw new Error("Unsupported GeminiPart type: " + JSON.stringify(part));
}
function toGeminiMessage(message, model) {
    let sortedParts = message.content;
    if (message.role === "tool") {
        sortedParts = [
            ...message.content
        ].sort((a, b)=>{
            const aRef = a.toolResponse?.ref;
            const bRef = b.toolResponse?.ref;
            if (!aRef && !bRef) return 0;
            if (!aRef) return 1;
            if (!bRef) return -1;
            return Number.parseInt(aRef, 10) - Number.parseInt(bRef, 10);
        });
    }
    return {
        role: toGeminiRole(message.role, model),
        parts: sortedParts.map(toGeminiPart)
    };
}
function toGeminiSystemInstruction(message) {
    return {
        role: "user",
        parts: message.content.map(toGeminiPart)
    };
}
function fromGeminiFinishReason(reason) {
    if (!reason) return "unknown";
    switch(reason){
        case "STOP":
            return "stop";
        case "MAX_TOKENS":
            return "length";
        case "SAFETY":
        // blocked for safety
        case "RECITATION":
            return "blocked";
        default:
            return "unknown";
    }
}
function fromGeminiCandidate(candidate, jsonMode = false) {
    const parts = candidate.content?.parts || [];
    const genkitCandidate = {
        index: candidate.index || 0,
        message: {
            role: "model",
            content: parts.map((part, index)=>fromGeminiPart(part, jsonMode, index.toString()))
        },
        finishReason: fromGeminiFinishReason(candidate.finishReason),
        finishMessage: candidate.finishMessage,
        custom: {
            safetyRatings: candidate.safetyRatings,
            citationMetadata: candidate.citationMetadata
        }
    };
    return genkitCandidate;
}
function cleanSchema(schema) {
    const out = structuredClone(schema);
    for(const key in out){
        if (key === "$schema" || key === "additionalProperties") {
            delete out[key];
            continue;
        }
        if (typeof out[key] === "object") {
            out[key] = cleanSchema(out[key]);
        }
        if (key === "type" && Array.isArray(out[key])) {
            out[key] = out[key].find((t)=>t !== "null");
        }
    }
    return out;
}
function defineGoogleAIModel({ ai, name, apiKey: apiKeyOption, apiVersion, baseUrl, info, defaultConfig, debugTraces }) {
    let apiKey;
    if (apiKeyOption !== false) {
        apiKey = apiKeyOption || (0, import_common.getApiKeyFromEnvVar)();
        if (!apiKey) {
            throw new import_genkit.GenkitError({
                status: "FAILED_PRECONDITION",
                message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai"
            });
        }
    }
    const apiModelName = name.startsWith("googleai/") ? name.substring("googleai/".length) : name;
    const model = SUPPORTED_GEMINI_MODELS[apiModelName] ?? (0, import_model.modelRef)({
        name: `googleai/${apiModelName}`,
        info: {
            label: `Google AI - ${apiModelName}`,
            supports: {
                multiturn: true,
                media: true,
                tools: true,
                systemRole: true,
                output: [
                    "text",
                    "json"
                ]
            },
            ...info
        },
        configSchema: GeminiConfigSchema
    });
    const middleware = [];
    if (model.info?.supports?.media) {
        middleware.push((0, import_middleware.downloadRequestMedia)({
            maxBytes: 1024 * 1024 * 10,
            // don't downlaod files that have been uploaded using the Files API
            filter: (part)=>{
                try {
                    const url = new URL(part.media.url);
                    if (// Gemini can handle these URLs
                    [
                        "generativelanguage.googleapis.com",
                        "www.youtube.com",
                        "youtube.com",
                        "youtu.be"
                    ].includes(url.hostname)) return false;
                } catch  {}
                return true;
            }
        }));
    }
    return ai.defineModel({
        apiVersion: "v2",
        name: model.name,
        ...model.info,
        configSchema: model.configSchema,
        use: middleware
    }, async (request, { streamingRequested, sendChunk, abortSignal })=>{
        const options = {
            apiClient: (0, import_common.getGenkitClientHeader)()
        };
        if (apiVersion) {
            options.apiVersion = apiVersion;
        }
        if (apiVersion) {
            options.baseUrl = baseUrl;
        }
        const requestConfig = {
            ...defaultConfig,
            ...request.config
        };
        const messages = [
            ...request.messages
        ];
        if (messages.length === 0) throw new Error("No messages provided.");
        let systemInstruction = void 0;
        if (model.info?.supports?.systemRole) {
            const systemMessage = messages.find((m)=>m.role === "system");
            if (systemMessage) {
                messages.splice(messages.indexOf(systemMessage), 1);
                systemInstruction = toGeminiSystemInstruction(systemMessage);
            }
        }
        const tools = [];
        if (request.tools?.length) {
            tools.push({
                functionDeclarations: request.tools.map(toGeminiTool)
            });
        }
        const { apiKey: apiKeyFromConfig, safetySettings: safetySettingsFromConfig, codeExecution: codeExecutionFromConfig, version: versionFromConfig, functionCallingConfig, googleSearchRetrieval, tools: toolsFromConfig, ...restOfConfigOptions } = requestConfig;
        if (codeExecutionFromConfig) {
            tools.push({
                codeExecution: request.config.codeExecution === true ? {} : request.config.codeExecution
            });
        }
        if (toolsFromConfig) {
            tools.push(...toolsFromConfig);
        }
        if (googleSearchRetrieval) {
            tools.push({
                googleSearch: googleSearchRetrieval === true ? {} : googleSearchRetrieval
            });
        }
        let toolConfig;
        if (functionCallingConfig) {
            toolConfig = {
                functionCallingConfig: {
                    allowedFunctionNames: functionCallingConfig.allowedFunctionNames,
                    mode: toFunctionModeEnum(functionCallingConfig.mode)
                }
            };
        } else if (request.toolChoice) {
            toolConfig = {
                functionCallingConfig: {
                    mode: toGeminiFunctionModeEnum(request.toolChoice)
                }
            };
        }
        const jsonMode = request.output?.format === "json" || request.output?.contentType === "application/json" && tools.length === 0;
        const generationConfig = {
            ...restOfConfigOptions,
            candidateCount: request.candidates || void 0,
            responseMimeType: jsonMode ? "application/json" : void 0
        };
        if (request.output?.constrained && jsonMode) {
            generationConfig.responseSchema = cleanSchema(request.output.schema);
        }
        const msg = toGeminiMessage(messages[messages.length - 1], model);
        const fromJSONModeScopedGeminiCandidate = (candidate)=>{
            return fromGeminiCandidate(candidate, jsonMode);
        };
        const chatRequest = {
            systemInstruction,
            generationConfig,
            tools: tools.length ? tools : void 0,
            toolConfig,
            history: messages.slice(0, -1).map((message)=>toGeminiMessage(message, model)),
            safetySettings: safetySettingsFromConfig
        };
        const modelVersion = versionFromConfig || model.version || apiModelName;
        const cacheConfigDetails = (0, import_utils.extractCacheConfig)(request);
        const { chatRequest: updatedChatRequest, cache } = await (0, import_context_caching.handleCacheIfNeeded)(apiKey, request, chatRequest, modelVersion, cacheConfigDetails);
        if (!apiKeyFromConfig && !apiKey) {
            throw new import_genkit.GenkitError({
                status: "INVALID_ARGUMENT",
                message: "GoogleAI plugin was initialized with {apiKey: false} but no apiKey configuration was passed at call time."
            });
        }
        const client = new import_generative_ai.GoogleGenerativeAI(apiKeyFromConfig || apiKey);
        let genModel;
        if (cache) {
            genModel = client.getGenerativeModelFromCachedContent(cache, {
                model: modelVersion
            }, options);
        } else {
            genModel = client.getGenerativeModel({
                model: modelVersion
            }, options);
        }
        const callGemini = async ()=>{
            let response;
            if (streamingRequested) {
                const result = await genModel.startChat(updatedChatRequest).sendMessageStream(msg.parts, {
                    ...options,
                    signal: abortSignal
                });
                const chunks = [];
                for await (const item of result.stream){
                    chunks.push(item);
                    item.candidates?.forEach((candidate)=>{
                        const c = fromJSONModeScopedGeminiCandidate(candidate);
                        sendChunk({
                            index: c.index,
                            content: c.message.content
                        });
                    });
                }
                response = aggregateResponses(chunks);
            } else {
                const result = await genModel.startChat(updatedChatRequest).sendMessage(msg.parts, {
                    ...options,
                    signal: abortSignal
                });
                response = result.response;
            }
            const candidates = response.candidates || [];
            if (response.candidates?.["undefined"]) {
                candidates.push(response.candidates["undefined"]);
            }
            if (!candidates.length) {
                throw new import_genkit.GenkitError({
                    status: "FAILED_PRECONDITION",
                    message: "No valid candidates returned."
                });
            }
            const candidateData = candidates.map(fromJSONModeScopedGeminiCandidate) || [];
            const usageMetadata = response.usageMetadata;
            return {
                candidates: candidateData,
                custom: response,
                usage: {
                    ...(0, import_model.getBasicUsageStats)(request.messages, candidateData),
                    inputTokens: usageMetadata?.promptTokenCount,
                    outputTokens: usageMetadata?.candidatesTokenCount,
                    thoughtsTokens: usageMetadata?.thoughtsTokenCount,
                    totalTokens: usageMetadata?.totalTokenCount,
                    cachedContentTokens: usageMetadata?.cachedContentTokenCount
                }
            };
        };
        return debugTraces ? await (0, import_tracing.runInNewSpan)(ai.registry, {
            metadata: {
                name: streamingRequested ? "sendMessageStream" : "sendMessage"
            }
        }, async (metadata)=>{
            metadata.input = {
                sdk: "@google/generative-ai",
                cache,
                model: genModel.model,
                chatOptions: updatedChatRequest,
                parts: msg.parts,
                options
            };
            const response = await callGemini();
            metadata.output = response.custom;
            return response;
        }) : await callGemini();
    });
}
function toFunctionModeEnum(configEnum) {
    if (configEnum === void 0) {
        return void 0;
    }
    switch(configEnum){
        case "MODE_UNSPECIFIED":
            {
                return import_generative_ai.FunctionCallingMode.MODE_UNSPECIFIED;
            }
        case "ANY":
            {
                return import_generative_ai.FunctionCallingMode.ANY;
            }
        case "AUTO":
            {
                return import_generative_ai.FunctionCallingMode.AUTO;
            }
        case "NONE":
            {
                return import_generative_ai.FunctionCallingMode.NONE;
            }
        default:
            throw new Error(`unsupported function calling mode: ${configEnum}`);
    }
}
function toGeminiFunctionModeEnum(genkitMode) {
    if (genkitMode === void 0) {
        return void 0;
    }
    switch(genkitMode){
        case "required":
            {
                return import_generative_ai.FunctionCallingMode.ANY;
            }
        case "auto":
            {
                return import_generative_ai.FunctionCallingMode.AUTO;
            }
        case "none":
            {
                return import_generative_ai.FunctionCallingMode.NONE;
            }
        default:
            throw new Error(`unsupported function calling mode: ${genkitMode}`);
    }
}
function aggregateResponses(responses) {
    const lastResponse = responses[responses.length - 1];
    const aggregatedResponse = {
        promptFeedback: lastResponse?.promptFeedback
    };
    for (const response of responses){
        if (response.candidates) {
            let candidateIndex = 0;
            for (const candidate of response.candidates){
                if (!aggregatedResponse.candidates) {
                    aggregatedResponse.candidates = [];
                }
                if (!aggregatedResponse.candidates[candidateIndex]) {
                    aggregatedResponse.candidates[candidateIndex] = {
                        index: candidateIndex
                    };
                }
                aggregatedResponse.candidates[candidateIndex].citationMetadata = candidate.citationMetadata;
                aggregatedResponse.candidates[candidateIndex].groundingMetadata = candidate.groundingMetadata;
                aggregatedResponse.candidates[candidateIndex].finishReason = candidate.finishReason;
                aggregatedResponse.candidates[candidateIndex].finishMessage = candidate.finishMessage;
                aggregatedResponse.candidates[candidateIndex].safetyRatings = candidate.safetyRatings;
                if (candidate.content && candidate.content.parts) {
                    if (!aggregatedResponse.candidates[candidateIndex].content) {
                        aggregatedResponse.candidates[candidateIndex].content = {
                            role: candidate.content.role || "user",
                            parts: []
                        };
                    }
                    for (const part of candidate.content.parts){
                        const newPart = {};
                        if (part.text) {
                            newPart.text = part.text;
                        }
                        if (part.thought) {
                            newPart.thought = part.thought;
                        }
                        if (part.thoughtSignature) {
                            newPart.thoughtSignature = part.thoughtSignature;
                        }
                        if (part.functionCall) {
                            newPart.functionCall = part.functionCall;
                        }
                        if (part.executableCode) {
                            newPart.executableCode = part.executableCode;
                        }
                        if (part.codeExecutionResult) {
                            newPart.codeExecutionResult = part.codeExecutionResult;
                        }
                        if (Object.keys(newPart).length === 0) {
                            newPart.text = "";
                        }
                        aggregatedResponse.candidates[candidateIndex].content.parts.push(newPart);
                    }
                }
            }
            candidateIndex++;
        }
        if (response.usageMetadata) {
            aggregatedResponse.usageMetadata = response.usageMetadata;
        }
    }
    return aggregatedResponse;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    GENERIC_GEMINI_MODEL,
    GeminiConfigSchema,
    GeminiGemmaConfigSchema,
    GeminiTtsConfigSchema,
    SUPPORTED_GEMINI_MODELS,
    aggregateResponses,
    cleanSchema,
    defineGoogleAIModel,
    fromGeminiCandidate,
    gemini,
    gemini10Pro,
    gemini15Flash,
    gemini15Flash8b,
    gemini15Pro,
    gemini20Flash,
    gemini20FlashExp,
    gemini20FlashLite,
    gemini20ProExp0205,
    gemini25Flash,
    gemini25FlashLite,
    gemini25FlashPreview0417,
    gemini25FlashPreviewTts,
    gemini25Pro,
    gemini25ProExp0325,
    gemini25ProPreview0325,
    gemini25ProPreviewTts,
    gemma312bit,
    gemma31bit,
    gemma327bit,
    gemma34bit,
    gemma3ne4bit,
    toGeminiMessage,
    toGeminiSystemInstruction,
    toGeminiTool
}); //# sourceMappingURL=gemini.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/predict.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toESM = (mod, isNodeMode, target)=>(target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(// If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", {
        value: mod,
        enumerable: true
    }) : target, mod));
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var predict_exports = {};
__export(predict_exports, {
    checkOp: ()=>checkOp,
    predictModel: ()=>predictModel
});
module.exports = __toCommonJS(predict_exports);
var import_common = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
function predictEndpoint(options) {
    return `https://generativelanguage.googleapis.com/${options.apiVersion}/models/${options.model}:${options.method}?key=${options.apiKey}`;
}
function opCheckEndpoint(options) {
    return `https://generativelanguage.googleapis.com/${options.apiVersion}/${options.operation}?key=${options.apiKey}`;
}
function predictModel(model, apiKey, method) {
    return async (instances, parameters)=>{
        const fetch = (await __turbopack_context__.r("[project]/node_modules/node-fetch/src/index.js [app-rsc] (ecmascript, async loader)")(__turbopack_context__.i)).default;
        const req = {
            instances,
            parameters
        };
        const response = await fetch(predictEndpoint({
            model,
            apiVersion: "v1beta",
            apiKey,
            method
        }), {
            method: "POST",
            body: JSON.stringify(req),
            headers: {
                "Content-Type": "application/json",
                "X-Goog-Api-Client": (0, import_common.getGenkitClientHeader)()
            }
        });
        if (!response.ok) {
            throw new Error(`Error from Gemini AI predict: HTTP ${response.status}: ${await response.text()}`);
        }
        return await response.json();
    };
}
async function checkOp(operation, apiKey) {
    const fetch = (await __turbopack_context__.r("[project]/node_modules/node-fetch/src/index.js [app-rsc] (ecmascript, async loader)")(__turbopack_context__.i)).default;
    const response = await fetch(opCheckEndpoint({
        apiVersion: "v1beta",
        operation,
        apiKey
    }), {
        method: "GET",
        headers: {
            "Content-Type": "application/json",
            "X-Goog-Api-Client": (0, import_common.getGenkitClientHeader)()
        }
    });
    if (!response.ok) {
        throw new Error(`Error from operation API: HTTP ${response.status}: ${await response.text()}`);
    }
    return await response.json();
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    checkOp,
    predictModel
}); //# sourceMappingURL=predict.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/imagen.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var imagen_exports = {};
__export(imagen_exports, {
    GENERIC_IMAGEN_INFO: ()=>GENERIC_IMAGEN_INFO,
    ImagenConfigSchema: ()=>ImagenConfigSchema,
    defineImagenModel: ()=>defineImagenModel
});
module.exports = __toCommonJS(imagen_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_common = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
var import_predict = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/predict.js [app-rsc] (ecmascript)");
const ImagenConfigSchema = import_genkit.z.object({
    numberOfImages: import_genkit.z.number().describe("The number of images to generate, from 1 to 4 (inclusive). The default is 1.").optional(),
    aspectRatio: import_genkit.z.enum([
        "1:1",
        "9:16",
        "16:9",
        "3:4",
        "4:3"
    ]).describe("Desired aspect ratio of the output image.").optional(),
    personGeneration: import_genkit.z.enum([
        "dont_allow",
        "allow_adult",
        "allow_all"
    ]).describe("Control if/how images of people will be generated by the model.").optional()
}).passthrough();
function toParameters(request) {
    const out = {
        sampleCount: request.config?.numberOfImages ?? 1,
        ...request?.config
    };
    for(const k in out){
        if (!out[k]) delete out[k];
    }
    return out;
}
function extractText(request) {
    return request.messages.at(-1).content.map((c)=>c.text || "").join("");
}
function extractBaseImage(request) {
    return request.messages.at(-1)?.content.find((p)=>!!p.media)?.media?.url.split(",")[1];
}
const GENERIC_IMAGEN_INFO = {
    label: `Google AI - Generic Imagen`,
    supports: {
        media: true,
        multiturn: false,
        tools: false,
        systemRole: false,
        output: [
            "media"
        ]
    }
};
function defineImagenModel(ai, name, apiKey) {
    if (apiKey !== false) {
        apiKey = apiKey || (0, import_common.getApiKeyFromEnvVar)();
        if (!apiKey) {
            throw new import_genkit.GenkitError({
                status: "FAILED_PRECONDITION",
                message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai"
            });
        }
    }
    const modelName = `googleai/${name}`;
    const model = (0, import_model.modelRef)({
        name: modelName,
        info: {
            ...GENERIC_IMAGEN_INFO,
            label: `Google AI - ${name}`
        },
        configSchema: ImagenConfigSchema
    });
    return ai.defineModel({
        name: modelName,
        ...model.info,
        configSchema: ImagenConfigSchema
    }, async (request)=>{
        const instance = {
            prompt: extractText(request)
        };
        const baseImage = extractBaseImage(request);
        if (baseImage) {
            instance.image = {
                bytesBase64Encoded: baseImage
            };
        }
        const predictClient = (0, import_predict.predictModel)(model.version || name, apiKey, "predict");
        const response = await predictClient([
            instance
        ], toParameters(request));
        if (!response.predictions || response.predictions.length == 0) {
            throw new Error("Model returned no predictions. Possibly due to content filters.");
        }
        const message = {
            role: "model",
            content: []
        };
        response.predictions.forEach((p, i)=>{
            const b64data = p.bytesBase64Encoded;
            const mimeType = p.mimeType;
            message.content.push({
                media: {
                    url: `data:${mimeType};base64,${b64data}`,
                    contentType: mimeType
                }
            });
        });
        return {
            finishReason: "stop",
            message,
            usage: (0, import_model.getBasicUsageStats)(request.messages, message),
            custom: response
        };
    });
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    GENERIC_IMAGEN_INFO,
    ImagenConfigSchema,
    defineImagenModel
}); //# sourceMappingURL=imagen.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/list-models.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var list_models_exports = {};
__export(list_models_exports, {
    listModels: ()=>listModels
});
module.exports = __toCommonJS(list_models_exports);
async function listModels(baseUrl, apiKey) {
    const res = await fetch(`${baseUrl}/v1beta/models?pageSize=1000&key=${apiKey}`, {
        method: "GET",
        headers: {
            "Content-Type": "application/json"
        }
    });
    const modelResponse = JSON.parse(await res.text());
    return modelResponse.models;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    listModels
}); //# sourceMappingURL=list-models.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/veo.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all)=>{
    for(var name in all)__defProp(target, name, {
        get: all[name],
        enumerable: true
    });
};
var __copyProps = (to, from, except, desc)=>{
    if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames(from))if (!__hasOwnProp.call(to, key) && key !== except) __defProp(to, key, {
            get: ()=>from[key],
            enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable
        });
    }
    return to;
};
var __toCommonJS = (mod)=>__copyProps(__defProp({}, "__esModule", {
        value: true
    }), mod);
var veo_exports = {};
__export(veo_exports, {
    GENERIC_VEO_INFO: ()=>GENERIC_VEO_INFO,
    VeoConfigSchema: ()=>VeoConfigSchema,
    defineVeoModel: ()=>defineVeoModel
});
module.exports = __toCommonJS(veo_exports);
var import_genkit = __turbopack_context__.r("[project]/node_modules/genkit/lib/index.js [app-rsc] (ecmascript)");
var import_model = __turbopack_context__.r("[project]/node_modules/genkit/lib/model.js [app-rsc] (ecmascript)");
var import_common = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
var import_predict = __turbopack_context__.r("[project]/node_modules/@genkit-ai/googleai/lib/predict.js [app-rsc] (ecmascript)");
const VeoConfigSchema = import_genkit.z.object({
    // NOTE: Documentation notes numberOfVideos parameter to pick the number of
    // output videos, but this setting does not seem to work
    negativePrompt: import_genkit.z.string().optional(),
    aspectRatio: import_genkit.z.enum([
        "9:16",
        "16:9"
    ]).describe("Desired aspect ratio of the output video.").optional(),
    personGeneration: import_genkit.z.enum([
        "dont_allow",
        "allow_adult",
        "allow_all"
    ]).describe("Control if/how images of people will be generated by the model.").optional(),
    durationSeconds: import_genkit.z.number().step(1).min(5).max(8).describe("Length of each output video in seconds, between 5 and 8.").optional(),
    enhance_prompt: import_genkit.z.boolean().describe("Enable or disable the prompt rewriter. Enabled by default.").optional()
}).passthrough();
function extractText(request) {
    return request.messages.at(-1).content.map((c)=>c.text || "").join("");
}
function toParameters(request) {
    const out = {
        ...request?.config
    };
    for(const k in out){
        if (!out[k]) delete out[k];
    }
    return out;
}
function extractImage(request) {
    const media = request.messages.at(-1)?.content.find((p)=>!!p.media)?.media;
    if (media) {
        const img = media?.url.split(",")[1];
        return {
            bytesBase64Encoded: img,
            mimeType: media.contentType
        };
    }
    return void 0;
}
const GENERIC_VEO_INFO = {
    label: `Google AI - Generic Veo`,
    supports: {
        media: true,
        multiturn: false,
        tools: false,
        systemRole: false,
        output: [
            "media"
        ],
        longRunning: true
    }
};
function defineVeoModel(ai, name, apiKey) {
    if (apiKey !== false) {
        apiKey = apiKey || (0, import_common.getApiKeyFromEnvVar)();
        if (!apiKey) {
            throw new import_genkit.GenkitError({
                status: "FAILED_PRECONDITION",
                message: "Please pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.\nFor more details see https://genkit.dev/docs/plugins/google-genai"
            });
        }
    }
    const modelName = `googleai/${name}`;
    const model = (0, import_model.modelRef)({
        name: modelName,
        info: {
            ...GENERIC_VEO_INFO,
            label: `Google AI - ${name}`
        },
        configSchema: VeoConfigSchema
    });
    return ai.defineBackgroundModel({
        name: modelName,
        ...model.info,
        configSchema: VeoConfigSchema,
        async start (request) {
            const instance = {
                prompt: extractText(request)
            };
            const image = extractImage(request);
            if (image) {
                instance.image = image;
            }
            const predictClient = (0, import_predict.predictModel)(model.version || name, apiKey, "predictLongRunning");
            const response = await predictClient([
                instance
            ], toParameters(request));
            return toGenkitOp(response);
        },
        async check (operation) {
            const newOp = await (0, import_predict.checkOp)(operation.id, apiKey);
            return toGenkitOp(newOp);
        }
    });
}
function toGenkitOp(apiOp) {
    const res = {
        id: apiOp.name
    };
    if (apiOp.done !== void 0) {
        res.done = apiOp.done;
    }
    if (apiOp.error) {
        res.error = {
            message: apiOp.error.message
        };
    }
    if (apiOp.response && apiOp.response.generateVideoResponse && apiOp.response.generateVideoResponse.generatedSamples) {
        res.output = {
            finishReason: "stop",
            raw: apiOp.response,
            message: {
                role: "model",
                content: apiOp.response.generateVideoResponse.generatedSamples.map((s)=>{
                    return {
                        media: {
                            url: s.video.uri
                        }
                    };
                })
            }
        };
    }
    return res;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
    GENERIC_VEO_INFO,
    VeoConfigSchema,
    defineVeoModel
}); //# sourceMappingURL=veo.js.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/index.mjs [app-rsc] (ecmascript) <locals>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({
    "default": (()=>index_default),
    "googleAI": (()=>googleAI),
    "googleAIPlugin": (()=>googleAIPlugin)
});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$index$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/index.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/common.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/logging.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$core$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/core/lib/logging.mjs [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/ai/lib/model.mjs [app-rsc] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$plugin$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/plugin.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$plugin$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/plugin.mjs [app-rsc] (ecmascript) <locals>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/embedder.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/gemini.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$imagen$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/imagen.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$list$2d$models$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/list-models.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$veo$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/veo.js [app-rsc] (ecmascript)");
;
;
;
;
;
;
;
;
;
;
async function initializer(ai, options) {
    let apiVersions = [
        "v1"
    ];
    if (options?.apiVersion) {
        if (Array.isArray(options?.apiVersion)) {
            apiVersions = options?.apiVersion;
        } else {
            apiVersions = [
                options?.apiVersion
            ];
        }
    }
    if (apiVersions.includes("v1beta")) {
        Object.keys(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["SUPPORTED_GEMINI_MODELS"]).forEach((name)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineGoogleAIModel"])({
                ai,
                name,
                apiKey: options?.apiKey,
                apiVersion: "v1beta",
                baseUrl: options?.baseUrl,
                debugTraces: options?.experimental_debugTraces
            }));
    }
    if (apiVersions.includes("v1")) {
        Object.keys(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["SUPPORTED_GEMINI_MODELS"]).forEach((name)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineGoogleAIModel"])({
                ai,
                name,
                apiKey: options?.apiKey,
                apiVersion: void 0,
                baseUrl: options?.baseUrl,
                debugTraces: options?.experimental_debugTraces
            }));
        Object.keys(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["SUPPORTED_MODELS"]).forEach((name)=>(0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineGoogleAIEmbedder"])(ai, name, {
                apiKey: options?.apiKey
            }));
    }
    if (options?.models) {
        for (const modelOrRef of options?.models){
            const modelName = typeof modelOrRef === "string" ? modelOrRef : // strip out the `googleai/` prefix
            modelOrRef.name.split("/")[1];
            const modelRef2 = typeof modelOrRef === "string" ? (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["gemini"])(modelOrRef) : modelOrRef;
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineGoogleAIModel"])({
                ai,
                name: modelName,
                apiKey: options?.apiKey,
                baseUrl: options?.baseUrl,
                info: {
                    ...modelRef2.info,
                    label: `Google AI - ${modelName}`
                },
                debugTraces: options?.experimental_debugTraces
            });
        }
    }
}
async function resolver(ai, actionType, actionName, options) {
    if (actionType === "embedder") {
        resolveEmbedder(ai, actionName, options);
    } else if (actionName.startsWith("veo")) {
        if (actionType === "background-model") {
            (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$veo$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineVeoModel"])(ai, actionName, options?.apiKey);
        }
    } else if (actionType === "model") {
        resolveModel(ai, actionName, options);
    }
}
function resolveModel(ai, actionName, options) {
    if (actionName.startsWith("imagen")) {
        (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$imagen$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineImagenModel"])(ai, actionName, options?.apiKey);
        return;
    }
    const modelRef2 = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["gemini"])(actionName);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineGoogleAIModel"])({
        ai,
        name: modelRef2.name,
        apiKey: options?.apiKey,
        baseUrl: options?.baseUrl,
        info: {
            ...modelRef2.info,
            label: `Google AI - ${actionName}`
        },
        debugTraces: options?.experimental_debugTraces
    });
}
function resolveEmbedder(ai, actionName, options) {
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["defineGoogleAIEmbedder"])(ai, `googleai/${actionName}`, {
        apiKey: options?.apiKey
    });
}
async function listActions(options) {
    const apiKey = options?.apiKey || (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["getApiKeyFromEnvVar"])();
    if (!apiKey) {
        __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$core$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["logger"].error("Pass in the API key or set the GEMINI_API_KEY or GOOGLE_API_KEY environment variable.");
        return [];
    }
    const models = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$list$2d$models$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["listModels"])(options?.baseUrl || "https://generativelanguage.googleapis.com", apiKey);
    return [
        // Imagen
        ...models.filter((m)=>m.supportedGenerationMethods.includes("predict") && m.name.includes("imagen")).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
            const name = m.name.split("/").at(-1);
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["modelActionMetadata"])({
                name: `googleai/${name}`,
                info: {
                    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$imagen$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["GENERIC_IMAGEN_INFO"]
                },
                configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$imagen$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["ImagenConfigSchema"]
            });
        }),
        // Veo
        ...models.filter((m)=>m.supportedGenerationMethods.includes("predictLongRunning") && m.name.includes("veo")).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
            const name = m.name.split("/").at(-1);
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["modelActionMetadata"])({
                name: `googleai/${name}`,
                info: {
                    ...__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$veo$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["GENERIC_VEO_INFO"]
                },
                configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$veo$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["VeoConfigSchema"],
                background: true
            });
        }),
        // Models
        ...models.filter((m)=>m.supportedGenerationMethods.includes("generateContent")).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
            const ref = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["gemini"])(m.name.startsWith("models/") ? m.name.substring("models/".length) : m.name);
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["modelActionMetadata"])({
                name: ref.name,
                info: ref.info,
                configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["GeminiConfigSchema"]
            });
        }),
        // Embedders
        ...models.filter((m)=>m.supportedGenerationMethods.includes("embedContent")).filter((m)=>!m.description || !m.description.includes("deprecated")).map((m)=>{
            const name = "googleai/" + (m.name.startsWith("models/") ? m.name.substring("models/".length) : m.name);
            return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["embedderActionMetadata"])({
                name,
                configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["GeminiEmbeddingConfigSchema"],
                info: {
                    dimensions: 768,
                    label: `Google Gen AI - ${name}`,
                    supports: {
                        input: [
                            "text"
                        ]
                    }
                }
            });
        })
    ];
}
function googleAIPlugin(options) {
    let listActionsCache;
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$plugin$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__["genkitPlugin"])("googleai", async (ai)=>await initializer(ai, options), async (ai, actionType, actionName)=>await resolver(ai, actionType, actionName, options), async ()=>{
        if (listActionsCache) return listActionsCache;
        listActionsCache = await listActions(options);
        return listActionsCache;
    });
}
const googleAI = googleAIPlugin;
googleAI.model = (name, config)=>{
    if (name.startsWith("imagen")) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__["modelRef"])({
            name: `googleai/${name}`,
            config,
            configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$imagen$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["ImagenConfigSchema"]
        });
    }
    if (name.startsWith("veo")) {
        return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__["modelRef"])({
            name: `googleai/${name}`,
            config,
            configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$veo$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["VeoConfigSchema"]
        });
    }
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$ai$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__["modelRef"])({
        name: `googleai/${name}`,
        config,
        configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["GeminiConfigSchema"]
    });
};
googleAI.embedder = (name, config)=>{
    return (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["embedderRef"])({
        name: `googleai/${name}`,
        config,
        configSchema: __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["GeminiEmbeddingConfigSchema"]
    });
};
var index_default = googleAI;
;
 //# sourceMappingURL=index.mjs.map
}}),
"[project]/node_modules/@genkit-ai/googleai/lib/index.mjs [app-rsc] (ecmascript) <module evaluation>": ((__turbopack_context__) => {
"use strict";

var { g: global, __dirname } = __turbopack_context__;
{
__turbopack_context__.s({});
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$index$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/index.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$logging$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/logging.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$model$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/model.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$genkit$2f$lib$2f$plugin$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$module__evaluation$3e$__ = __turbopack_context__.i("[project]/node_modules/genkit/lib/plugin.mjs [app-rsc] (ecmascript) <module evaluation>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$common$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/common.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$embedder$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/embedder.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$gemini$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/gemini.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$imagen$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/imagen.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$list$2d$models$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/list-models.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$veo$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/veo.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f40$genkit$2d$ai$2f$googleai$2f$lib$2f$index$2e$mjs__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__$3c$locals$3e$__ = __turbopack_context__.i("[project]/node_modules/@genkit-ai/googleai/lib/index.mjs [app-rsc] (ecmascript) <locals>");
}}),
"[project]/node_modules/@google/generative-ai/dist/index.js [app-rsc] (ecmascript)": (function(__turbopack_context__) {

var { g: global, __dirname, m: module, e: exports } = __turbopack_context__;
{
'use strict';
/**
 * Contains the list of OpenAPI data types
 * as defined by https://swagger.io/docs/specification/data-models/data-types/
 * @public
 */ exports.SchemaType = void 0;
(function(SchemaType) {
    /** String type. */ SchemaType["STRING"] = "string";
    /** Number type. */ SchemaType["NUMBER"] = "number";
    /** Integer type. */ SchemaType["INTEGER"] = "integer";
    /** Boolean type. */ SchemaType["BOOLEAN"] = "boolean";
    /** Array type. */ SchemaType["ARRAY"] = "array";
    /** Object type. */ SchemaType["OBJECT"] = "object";
})(exports.SchemaType || (exports.SchemaType = {}));
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ /**
 * @public
 */ exports.ExecutableCodeLanguage = void 0;
(function(ExecutableCodeLanguage) {
    ExecutableCodeLanguage["LANGUAGE_UNSPECIFIED"] = "language_unspecified";
    ExecutableCodeLanguage["PYTHON"] = "python";
})(exports.ExecutableCodeLanguage || (exports.ExecutableCodeLanguage = {}));
/**
 * Possible outcomes of code execution.
 * @public
 */ exports.Outcome = void 0;
(function(Outcome) {
    /**
     * Unspecified status. This value should not be used.
     */ Outcome["OUTCOME_UNSPECIFIED"] = "outcome_unspecified";
    /**
     * Code execution completed successfully.
     */ Outcome["OUTCOME_OK"] = "outcome_ok";
    /**
     * Code execution finished but with a failure. `stderr` should contain the
     * reason.
     */ Outcome["OUTCOME_FAILED"] = "outcome_failed";
    /**
     * Code execution ran for too long, and was cancelled. There may or may not
     * be a partial output present.
     */ Outcome["OUTCOME_DEADLINE_EXCEEDED"] = "outcome_deadline_exceeded";
})(exports.Outcome || (exports.Outcome = {}));
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ /**
 * Possible roles.
 * @public
 */ const POSSIBLE_ROLES = [
    "user",
    "model",
    "function",
    "system"
];
/**
 * Harm categories that would cause prompts or candidates to be blocked.
 * @public
 */ exports.HarmCategory = void 0;
(function(HarmCategory) {
    HarmCategory["HARM_CATEGORY_UNSPECIFIED"] = "HARM_CATEGORY_UNSPECIFIED";
    HarmCategory["HARM_CATEGORY_HATE_SPEECH"] = "HARM_CATEGORY_HATE_SPEECH";
    HarmCategory["HARM_CATEGORY_SEXUALLY_EXPLICIT"] = "HARM_CATEGORY_SEXUALLY_EXPLICIT";
    HarmCategory["HARM_CATEGORY_HARASSMENT"] = "HARM_CATEGORY_HARASSMENT";
    HarmCategory["HARM_CATEGORY_DANGEROUS_CONTENT"] = "HARM_CATEGORY_DANGEROUS_CONTENT";
    HarmCategory["HARM_CATEGORY_CIVIC_INTEGRITY"] = "HARM_CATEGORY_CIVIC_INTEGRITY";
})(exports.HarmCategory || (exports.HarmCategory = {}));
/**
 * Threshold above which a prompt or candidate will be blocked.
 * @public
 */ exports.HarmBlockThreshold = void 0;
(function(HarmBlockThreshold) {
    /** Threshold is unspecified. */ HarmBlockThreshold["HARM_BLOCK_THRESHOLD_UNSPECIFIED"] = "HARM_BLOCK_THRESHOLD_UNSPECIFIED";
    /** Content with NEGLIGIBLE will be allowed. */ HarmBlockThreshold["BLOCK_LOW_AND_ABOVE"] = "BLOCK_LOW_AND_ABOVE";
    /** Content with NEGLIGIBLE and LOW will be allowed. */ HarmBlockThreshold["BLOCK_MEDIUM_AND_ABOVE"] = "BLOCK_MEDIUM_AND_ABOVE";
    /** Content with NEGLIGIBLE, LOW, and MEDIUM will be allowed. */ HarmBlockThreshold["BLOCK_ONLY_HIGH"] = "BLOCK_ONLY_HIGH";
    /** All content will be allowed. */ HarmBlockThreshold["BLOCK_NONE"] = "BLOCK_NONE";
})(exports.HarmBlockThreshold || (exports.HarmBlockThreshold = {}));
/**
 * Probability that a prompt or candidate matches a harm category.
 * @public
 */ exports.HarmProbability = void 0;
(function(HarmProbability) {
    /** Probability is unspecified. */ HarmProbability["HARM_PROBABILITY_UNSPECIFIED"] = "HARM_PROBABILITY_UNSPECIFIED";
    /** Content has a negligible chance of being unsafe. */ HarmProbability["NEGLIGIBLE"] = "NEGLIGIBLE";
    /** Content has a low chance of being unsafe. */ HarmProbability["LOW"] = "LOW";
    /** Content has a medium chance of being unsafe. */ HarmProbability["MEDIUM"] = "MEDIUM";
    /** Content has a high chance of being unsafe. */ HarmProbability["HIGH"] = "HIGH";
})(exports.HarmProbability || (exports.HarmProbability = {}));
/**
 * Reason that a prompt was blocked.
 * @public
 */ exports.BlockReason = void 0;
(function(BlockReason) {
    // A blocked reason was not specified.
    BlockReason["BLOCKED_REASON_UNSPECIFIED"] = "BLOCKED_REASON_UNSPECIFIED";
    // Content was blocked by safety settings.
    BlockReason["SAFETY"] = "SAFETY";
    // Content was blocked, but the reason is uncategorized.
    BlockReason["OTHER"] = "OTHER";
})(exports.BlockReason || (exports.BlockReason = {}));
/**
 * Reason that a candidate finished.
 * @public
 */ exports.FinishReason = void 0;
(function(FinishReason) {
    // Default value. This value is unused.
    FinishReason["FINISH_REASON_UNSPECIFIED"] = "FINISH_REASON_UNSPECIFIED";
    // Natural stop point of the model or provided stop sequence.
    FinishReason["STOP"] = "STOP";
    // The maximum number of tokens as specified in the request was reached.
    FinishReason["MAX_TOKENS"] = "MAX_TOKENS";
    // The candidate content was flagged for safety reasons.
    FinishReason["SAFETY"] = "SAFETY";
    // The candidate content was flagged for recitation reasons.
    FinishReason["RECITATION"] = "RECITATION";
    // The candidate content was flagged for using an unsupported language.
    FinishReason["LANGUAGE"] = "LANGUAGE";
    // Token generation stopped because the content contains forbidden terms.
    FinishReason["BLOCKLIST"] = "BLOCKLIST";
    // Token generation stopped for potentially containing prohibited content.
    FinishReason["PROHIBITED_CONTENT"] = "PROHIBITED_CONTENT";
    // Token generation stopped because the content potentially contains Sensitive Personally Identifiable Information (SPII).
    FinishReason["SPII"] = "SPII";
    // The function call generated by the model is invalid.
    FinishReason["MALFORMED_FUNCTION_CALL"] = "MALFORMED_FUNCTION_CALL";
    // Unknown reason.
    FinishReason["OTHER"] = "OTHER";
})(exports.FinishReason || (exports.FinishReason = {}));
/**
 * Task type for embedding content.
 * @public
 */ exports.TaskType = void 0;
(function(TaskType) {
    TaskType["TASK_TYPE_UNSPECIFIED"] = "TASK_TYPE_UNSPECIFIED";
    TaskType["RETRIEVAL_QUERY"] = "RETRIEVAL_QUERY";
    TaskType["RETRIEVAL_DOCUMENT"] = "RETRIEVAL_DOCUMENT";
    TaskType["SEMANTIC_SIMILARITY"] = "SEMANTIC_SIMILARITY";
    TaskType["CLASSIFICATION"] = "CLASSIFICATION";
    TaskType["CLUSTERING"] = "CLUSTERING";
})(exports.TaskType || (exports.TaskType = {}));
/**
 * @public
 */ exports.FunctionCallingMode = void 0;
(function(FunctionCallingMode) {
    // Unspecified function calling mode. This value should not be used.
    FunctionCallingMode["MODE_UNSPECIFIED"] = "MODE_UNSPECIFIED";
    // Default model behavior, model decides to predict either a function call
    // or a natural language repspose.
    FunctionCallingMode["AUTO"] = "AUTO";
    // Model is constrained to always predicting a function call only.
    // If "allowed_function_names" are set, the predicted function call will be
    // limited to any one of "allowed_function_names", else the predicted
    // function call will be any one of the provided "function_declarations".
    FunctionCallingMode["ANY"] = "ANY";
    // Model will not predict any function call. Model behavior is same as when
    // not passing any function declarations.
    FunctionCallingMode["NONE"] = "NONE";
})(exports.FunctionCallingMode || (exports.FunctionCallingMode = {}));
/**
 * The mode of the predictor to be used in dynamic retrieval.
 * @public
 */ exports.DynamicRetrievalMode = void 0;
(function(DynamicRetrievalMode) {
    // Unspecified function calling mode. This value should not be used.
    DynamicRetrievalMode["MODE_UNSPECIFIED"] = "MODE_UNSPECIFIED";
    // Run retrieval only when system decides it is necessary.
    DynamicRetrievalMode["MODE_DYNAMIC"] = "MODE_DYNAMIC";
})(exports.DynamicRetrievalMode || (exports.DynamicRetrievalMode = {}));
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ /**
 * Basic error type for this SDK.
 * @public
 */ class GoogleGenerativeAIError extends Error {
    constructor(message){
        super(`[GoogleGenerativeAI Error]: ${message}`);
    }
}
/**
 * Errors in the contents of a response from the model. This includes parsing
 * errors, or responses including a safety block reason.
 * @public
 */ class GoogleGenerativeAIResponseError extends GoogleGenerativeAIError {
    constructor(message, response){
        super(message);
        this.response = response;
    }
}
/**
 * Error class covering HTTP errors when calling the server. Includes HTTP
 * status, statusText, and optional details, if provided in the server response.
 * @public
 */ class GoogleGenerativeAIFetchError extends GoogleGenerativeAIError {
    constructor(message, status, statusText, errorDetails){
        super(message);
        this.status = status;
        this.statusText = statusText;
        this.errorDetails = errorDetails;
    }
}
/**
 * Errors in the contents of a request originating from user input.
 * @public
 */ class GoogleGenerativeAIRequestInputError extends GoogleGenerativeAIError {
}
/**
 * Error thrown when a request is aborted, either due to a timeout or
 * intentional cancellation by the user.
 * @public
 */ class GoogleGenerativeAIAbortError extends GoogleGenerativeAIError {
}
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const DEFAULT_BASE_URL = "https://generativelanguage.googleapis.com";
const DEFAULT_API_VERSION = "v1beta";
/**
 * We can't `require` package.json if this runs on web. We will use rollup to
 * swap in the version number here at build time.
 */ const PACKAGE_VERSION = "0.24.0";
const PACKAGE_LOG_HEADER = "genai-js";
var Task;
(function(Task) {
    Task["GENERATE_CONTENT"] = "generateContent";
    Task["STREAM_GENERATE_CONTENT"] = "streamGenerateContent";
    Task["COUNT_TOKENS"] = "countTokens";
    Task["EMBED_CONTENT"] = "embedContent";
    Task["BATCH_EMBED_CONTENTS"] = "batchEmbedContents";
})(Task || (Task = {}));
class RequestUrl {
    constructor(model, task, apiKey, stream, requestOptions){
        this.model = model;
        this.task = task;
        this.apiKey = apiKey;
        this.stream = stream;
        this.requestOptions = requestOptions;
    }
    toString() {
        var _a, _b;
        const apiVersion = ((_a = this.requestOptions) === null || _a === void 0 ? void 0 : _a.apiVersion) || DEFAULT_API_VERSION;
        const baseUrl = ((_b = this.requestOptions) === null || _b === void 0 ? void 0 : _b.baseUrl) || DEFAULT_BASE_URL;
        let url = `${baseUrl}/${apiVersion}/${this.model}:${this.task}`;
        if (this.stream) {
            url += "?alt=sse";
        }
        return url;
    }
}
/**
 * Simple, but may become more complex if we add more versions to log.
 */ function getClientHeaders(requestOptions) {
    const clientHeaders = [];
    if (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.apiClient) {
        clientHeaders.push(requestOptions.apiClient);
    }
    clientHeaders.push(`${PACKAGE_LOG_HEADER}/${PACKAGE_VERSION}`);
    return clientHeaders.join(" ");
}
async function getHeaders(url) {
    var _a;
    const headers = new Headers();
    headers.append("Content-Type", "application/json");
    headers.append("x-goog-api-client", getClientHeaders(url.requestOptions));
    headers.append("x-goog-api-key", url.apiKey);
    let customHeaders = (_a = url.requestOptions) === null || _a === void 0 ? void 0 : _a.customHeaders;
    if (customHeaders) {
        if (!(customHeaders instanceof Headers)) {
            try {
                customHeaders = new Headers(customHeaders);
            } catch (e) {
                throw new GoogleGenerativeAIRequestInputError(`unable to convert customHeaders value ${JSON.stringify(customHeaders)} to Headers: ${e.message}`);
            }
        }
        for (const [headerName, headerValue] of customHeaders.entries()){
            if (headerName === "x-goog-api-key") {
                throw new GoogleGenerativeAIRequestInputError(`Cannot set reserved header name ${headerName}`);
            } else if (headerName === "x-goog-api-client") {
                throw new GoogleGenerativeAIRequestInputError(`Header name ${headerName} can only be set using the apiClient field`);
            }
            headers.append(headerName, headerValue);
        }
    }
    return headers;
}
async function constructModelRequest(model, task, apiKey, stream, body, requestOptions) {
    const url = new RequestUrl(model, task, apiKey, stream, requestOptions);
    return {
        url: url.toString(),
        fetchOptions: Object.assign(Object.assign({}, buildFetchOptions(requestOptions)), {
            method: "POST",
            headers: await getHeaders(url),
            body
        })
    };
}
async function makeModelRequest(model, task, apiKey, stream, body, requestOptions = {}, // Allows this to be stubbed for tests
fetchFn = fetch) {
    const { url, fetchOptions } = await constructModelRequest(model, task, apiKey, stream, body, requestOptions);
    return makeRequest(url, fetchOptions, fetchFn);
}
async function makeRequest(url, fetchOptions, fetchFn = fetch) {
    let response;
    try {
        response = await fetchFn(url, fetchOptions);
    } catch (e) {
        handleResponseError(e, url);
    }
    if (!response.ok) {
        await handleResponseNotOk(response, url);
    }
    return response;
}
function handleResponseError(e, url) {
    let err = e;
    if (err.name === "AbortError") {
        err = new GoogleGenerativeAIAbortError(`Request aborted when fetching ${url.toString()}: ${e.message}`);
        err.stack = e.stack;
    } else if (!(e instanceof GoogleGenerativeAIFetchError || e instanceof GoogleGenerativeAIRequestInputError)) {
        err = new GoogleGenerativeAIError(`Error fetching from ${url.toString()}: ${e.message}`);
        err.stack = e.stack;
    }
    throw err;
}
async function handleResponseNotOk(response, url) {
    let message = "";
    let errorDetails;
    try {
        const json = await response.json();
        message = json.error.message;
        if (json.error.details) {
            message += ` ${JSON.stringify(json.error.details)}`;
            errorDetails = json.error.details;
        }
    } catch (e) {
    // ignored
    }
    throw new GoogleGenerativeAIFetchError(`Error fetching from ${url.toString()}: [${response.status} ${response.statusText}] ${message}`, response.status, response.statusText, errorDetails);
}
/**
 * Generates the request options to be passed to the fetch API.
 * @param requestOptions - The user-defined request options.
 * @returns The generated request options.
 */ function buildFetchOptions(requestOptions) {
    const fetchOptions = {};
    if ((requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.signal) !== undefined || (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeout) >= 0) {
        const controller = new AbortController();
        if ((requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.timeout) >= 0) {
            setTimeout(()=>controller.abort(), requestOptions.timeout);
        }
        if (requestOptions === null || requestOptions === void 0 ? void 0 : requestOptions.signal) {
            requestOptions.signal.addEventListener("abort", ()=>{
                controller.abort();
            });
        }
        fetchOptions.signal = controller.signal;
    }
    return fetchOptions;
}
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ /**
 * Adds convenience helper methods to a response object, including stream
 * chunks (as long as each chunk is a complete GenerateContentResponse JSON).
 */ function addHelpers(response) {
    response.text = ()=>{
        if (response.candidates && response.candidates.length > 0) {
            if (response.candidates.length > 1) {
                console.warn(`This response had ${response.candidates.length} ` + `candidates. Returning text from the first candidate only. ` + `Access response.candidates directly to use the other candidates.`);
            }
            if (hadBadFinishReason(response.candidates[0])) {
                throw new GoogleGenerativeAIResponseError(`${formatBlockErrorMessage(response)}`, response);
            }
            return getText(response);
        } else if (response.promptFeedback) {
            throw new GoogleGenerativeAIResponseError(`Text not available. ${formatBlockErrorMessage(response)}`, response);
        }
        return "";
    };
    /**
     * TODO: remove at next major version
     */ response.functionCall = ()=>{
        if (response.candidates && response.candidates.length > 0) {
            if (response.candidates.length > 1) {
                console.warn(`This response had ${response.candidates.length} ` + `candidates. Returning function calls from the first candidate only. ` + `Access response.candidates directly to use the other candidates.`);
            }
            if (hadBadFinishReason(response.candidates[0])) {
                throw new GoogleGenerativeAIResponseError(`${formatBlockErrorMessage(response)}`, response);
            }
            console.warn(`response.functionCall() is deprecated. ` + `Use response.functionCalls() instead.`);
            return getFunctionCalls(response)[0];
        } else if (response.promptFeedback) {
            throw new GoogleGenerativeAIResponseError(`Function call not available. ${formatBlockErrorMessage(response)}`, response);
        }
        return undefined;
    };
    response.functionCalls = ()=>{
        if (response.candidates && response.candidates.length > 0) {
            if (response.candidates.length > 1) {
                console.warn(`This response had ${response.candidates.length} ` + `candidates. Returning function calls from the first candidate only. ` + `Access response.candidates directly to use the other candidates.`);
            }
            if (hadBadFinishReason(response.candidates[0])) {
                throw new GoogleGenerativeAIResponseError(`${formatBlockErrorMessage(response)}`, response);
            }
            return getFunctionCalls(response);
        } else if (response.promptFeedback) {
            throw new GoogleGenerativeAIResponseError(`Function call not available. ${formatBlockErrorMessage(response)}`, response);
        }
        return undefined;
    };
    return response;
}
/**
 * Returns all text found in all parts of first candidate.
 */ function getText(response) {
    var _a, _b, _c, _d;
    const textStrings = [];
    if ((_b = (_a = response.candidates) === null || _a === void 0 ? void 0 : _a[0].content) === null || _b === void 0 ? void 0 : _b.parts) {
        for (const part of (_d = (_c = response.candidates) === null || _c === void 0 ? void 0 : _c[0].content) === null || _d === void 0 ? void 0 : _d.parts){
            if (part.text) {
                textStrings.push(part.text);
            }
            if (part.executableCode) {
                textStrings.push("\n```" + part.executableCode.language + "\n" + part.executableCode.code + "\n```\n");
            }
            if (part.codeExecutionResult) {
                textStrings.push("\n```\n" + part.codeExecutionResult.output + "\n```\n");
            }
        }
    }
    if (textStrings.length > 0) {
        return textStrings.join("");
    } else {
        return "";
    }
}
/**
 * Returns functionCall of first candidate.
 */ function getFunctionCalls(response) {
    var _a, _b, _c, _d;
    const functionCalls = [];
    if ((_b = (_a = response.candidates) === null || _a === void 0 ? void 0 : _a[0].content) === null || _b === void 0 ? void 0 : _b.parts) {
        for (const part of (_d = (_c = response.candidates) === null || _c === void 0 ? void 0 : _c[0].content) === null || _d === void 0 ? void 0 : _d.parts){
            if (part.functionCall) {
                functionCalls.push(part.functionCall);
            }
        }
    }
    if (functionCalls.length > 0) {
        return functionCalls;
    } else {
        return undefined;
    }
}
const badFinishReasons = [
    exports.FinishReason.RECITATION,
    exports.FinishReason.SAFETY,
    exports.FinishReason.LANGUAGE
];
function hadBadFinishReason(candidate) {
    return !!candidate.finishReason && badFinishReasons.includes(candidate.finishReason);
}
function formatBlockErrorMessage(response) {
    var _a, _b, _c;
    let message = "";
    if ((!response.candidates || response.candidates.length === 0) && response.promptFeedback) {
        message += "Response was blocked";
        if ((_a = response.promptFeedback) === null || _a === void 0 ? void 0 : _a.blockReason) {
            message += ` due to ${response.promptFeedback.blockReason}`;
        }
        if ((_b = response.promptFeedback) === null || _b === void 0 ? void 0 : _b.blockReasonMessage) {
            message += `: ${response.promptFeedback.blockReasonMessage}`;
        }
    } else if ((_c = response.candidates) === null || _c === void 0 ? void 0 : _c[0]) {
        const firstCandidate = response.candidates[0];
        if (hadBadFinishReason(firstCandidate)) {
            message += `Candidate was blocked due to ${firstCandidate.finishReason}`;
            if (firstCandidate.finishMessage) {
                message += `: ${firstCandidate.finishMessage}`;
            }
        }
    }
    return message;
}
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */ /* global Reflect, Promise, SuppressedError, Symbol */ function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}
function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function() {
        return this;
    }, i;
    "TURBOPACK unreachable";
    function verb(n) {
        if (g[n]) i[n] = function(v) {
            return new Promise(function(a, b) {
                q.push([
                    n,
                    v,
                    a,
                    b
                ]) > 1 || resume(n, v);
            });
        };
    }
    function resume(n, v) {
        try {
            step(g[n](v));
        } catch (e) {
            settle(q[0][3], e);
        }
    }
    function step(r) {
        r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r);
    }
    function fulfill(value) {
        resume("next", value);
    }
    function reject(value) {
        resume("throw", value);
    }
    function settle(f, v) {
        if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]);
    }
}
typeof SuppressedError === "function" ? SuppressedError : function(error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ const responseLineRE = /^data\: (.*)(?:\n\n|\r\r|\r\n\r\n)/;
/**
 * Process a response.body stream from the backend and return an
 * iterator that provides one complete GenerateContentResponse at a time
 * and a promise that resolves with a single aggregated
 * GenerateContentResponse.
 *
 * @param response - Response from a fetch call
 */ function processStream(response) {
    const inputStream = response.body.pipeThrough(new TextDecoderStream("utf8", {
        fatal: true
    }));
    const responseStream = getResponseStream(inputStream);
    const [stream1, stream2] = responseStream.tee();
    return {
        stream: generateResponseSequence(stream1),
        response: getResponsePromise(stream2)
    };
}
async function getResponsePromise(stream) {
    const allResponses = [];
    const reader = stream.getReader();
    while(true){
        const { done, value } = await reader.read();
        if (done) {
            return addHelpers(aggregateResponses(allResponses));
        }
        allResponses.push(value);
    }
}
function generateResponseSequence(stream) {
    return __asyncGenerator(this, arguments, function* generateResponseSequence_1() {
        const reader = stream.getReader();
        while(true){
            const { value, done } = yield __await(reader.read());
            if (done) {
                break;
            }
            yield yield __await(addHelpers(value));
        }
    });
}
/**
 * Reads a raw stream from the fetch response and join incomplete
 * chunks, returning a new stream that provides a single complete
 * GenerateContentResponse in each iteration.
 */ function getResponseStream(inputStream) {
    const reader = inputStream.getReader();
    const stream = new ReadableStream({
        start (controller) {
            let currentText = "";
            return pump();
            "TURBOPACK unreachable";
            function pump() {
                return reader.read().then(({ value, done })=>{
                    if (done) {
                        if (currentText.trim()) {
                            controller.error(new GoogleGenerativeAIError("Failed to parse stream"));
                            return;
                        }
                        controller.close();
                        return;
                    }
                    currentText += value;
                    let match = currentText.match(responseLineRE);
                    let parsedResponse;
                    while(match){
                        try {
                            parsedResponse = JSON.parse(match[1]);
                        } catch (e) {
                            controller.error(new GoogleGenerativeAIError(`Error parsing JSON response: "${match[1]}"`));
                            return;
                        }
                        controller.enqueue(parsedResponse);
                        currentText = currentText.substring(match[0].length);
                        match = currentText.match(responseLineRE);
                    }
                    return pump();
                }).catch((e)=>{
                    let err = e;
                    err.stack = e.stack;
                    if (err.name === "AbortError") {
                        err = new GoogleGenerativeAIAbortError("Request aborted when reading from the stream");
                    } else {
                        err = new GoogleGenerativeAIError("Error reading from the stream");
                    }
                    throw err;
                });
            }
        }
    });
    return stream;
}
/**
 * Aggregates an array of `GenerateContentResponse`s into a single
 * GenerateContentResponse.
 */ function aggregateResponses(responses) {
    const lastResponse = responses[responses.length - 1];
    const aggregatedResponse = {
        promptFeedback: lastResponse === null || lastResponse === void 0 ? void 0 : lastResponse.promptFeedback
    };
    for (const response of responses){
        if (response.candidates) {
            let candidateIndex = 0;
            for (const candidate of response.candidates){
                if (!aggregatedResponse.candidates) {
                    aggregatedResponse.candidates = [];
                }
                if (!aggregatedResponse.candidates[candidateIndex]) {
                    aggregatedResponse.candidates[candidateIndex] = {
                        index: candidateIndex
                    };
                }
                // Keep overwriting, the last one will be final
                aggregatedResponse.candidates[candidateIndex].citationMetadata = candidate.citationMetadata;
                aggregatedResponse.candidates[candidateIndex].groundingMetadata = candidate.groundingMetadata;
                aggregatedResponse.candidates[candidateIndex].finishReason = candidate.finishReason;
                aggregatedResponse.candidates[candidateIndex].finishMessage = candidate.finishMessage;
                aggregatedResponse.candidates[candidateIndex].safetyRatings = candidate.safetyRatings;
                /**
                 * Candidates should always have content and parts, but this handles
                 * possible malformed responses.
                 */ if (candidate.content && candidate.content.parts) {
                    if (!aggregatedResponse.candidates[candidateIndex].content) {
                        aggregatedResponse.candidates[candidateIndex].content = {
                            role: candidate.content.role || "user",
                            parts: []
                        };
                    }
                    const newPart = {};
                    for (const part of candidate.content.parts){
                        if (part.text) {
                            newPart.text = part.text;
                        }
                        if (part.functionCall) {
                            newPart.functionCall = part.functionCall;
                        }
                        if (part.executableCode) {
                            newPart.executableCode = part.executableCode;
                        }
                        if (part.codeExecutionResult) {
                            newPart.codeExecutionResult = part.codeExecutionResult;
                        }
                        if (Object.keys(newPart).length === 0) {
                            newPart.text = "";
                        }
                        aggregatedResponse.candidates[candidateIndex].content.parts.push(newPart);
                    }
                }
            }
            candidateIndex++;
        }
        if (response.usageMetadata) {
            aggregatedResponse.usageMetadata = response.usageMetadata;
        }
    }
    return aggregatedResponse;
}
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ async function generateContentStream(apiKey, model, params, requestOptions) {
    const response = await makeModelRequest(model, Task.STREAM_GENERATE_CONTENT, apiKey, /* stream */ true, JSON.stringify(params), requestOptions);
    return processStream(response);
}
async function generateContent(apiKey, model, params, requestOptions) {
    const response = await makeModelRequest(model, Task.GENERATE_CONTENT, apiKey, /* stream */ false, JSON.stringify(params), requestOptions);
    const responseJson = await response.json();
    const enhancedResponse = addHelpers(responseJson);
    return {
        response: enhancedResponse
    };
}
/**
 * @license
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ function formatSystemInstruction(input) {
    // null or undefined
    if (input == null) {
        return undefined;
    } else if (typeof input === "string") {
        return {
            role: "system",
            parts: [
                {
                    text: input
                }
            ]
        };
    } else if (input.text) {
        return {
            role: "system",
            parts: [
                input
            ]
        };
    } else if (input.parts) {
        if (!input.role) {
            return {
                role: "system",
                parts: input.parts
            };
        } else {
            return input;
        }
    }
}
function formatNewContent(request) {
    let newParts = [];
    if (typeof request === "string") {
        newParts = [
            {
                text: request
            }
        ];
    } else {
        for (const partOrString of request){
            if (typeof partOrString === "string") {
                newParts.push({
                    text: partOrString
                });
            } else {
                newParts.push(partOrString);
            }
        }
    }
    return assignRoleToPartsAndValidateSendMessageRequest(newParts);
}
/**
 * When multiple Part types (i.e. FunctionResponsePart and TextPart) are
 * passed in a single Part array, we may need to assign different roles to each
 * part. Currently only FunctionResponsePart requires a role other than 'user'.
 * @private
 * @param parts Array of parts to pass to the model
 * @returns Array of content items
 */ function assignRoleToPartsAndValidateSendMessageRequest(parts) {
    const userContent = {
        role: "user",
        parts: []
    };
    const functionContent = {
        role: "function",
        parts: []
    };
    let hasUserContent = false;
    let hasFunctionContent = false;
    for (const part of parts){
        if ("functionResponse" in part) {
            functionContent.parts.push(part);
            hasFunctionContent = true;
        } else {
            userContent.parts.push(part);
            hasUserContent = true;
        }
    }
    if (hasUserContent && hasFunctionContent) {
        throw new GoogleGenerativeAIError("Within a single message, FunctionResponse cannot be mixed with other type of part in the request for sending chat message.");
    }
    if (!hasUserContent && !hasFunctionContent) {
        throw new GoogleGenerativeAIError("No content is provided for sending chat message.");
    }
    if (hasUserContent) {
        return userContent;
    }
    return functionContent;
}
function formatCountTokensInput(params, modelParams) {
    var _a;
    let formattedGenerateContentRequest = {
        model: modelParams === null || modelParams === void 0 ? void 0 : modelParams.model,
        generationConfig: modelParams === null || modelParams === void 0 ? void 0 : modelParams.generationConfig,
        safetySettings: modelParams === null || modelParams === void 0 ? void 0 : modelParams.safetySettings,
        tools: modelParams === null || modelParams === void 0 ? void 0 : modelParams.tools,
        toolConfig: modelParams === null || modelParams === void 0 ? void 0 : modelParams.toolConfig,
        systemInstruction: modelParams === null || modelParams === void 0 ? void 0 : modelParams.systemInstruction,
        cachedContent: (_a = modelParams === null || modelParams === void 0 ? void 0 : modelParams.cachedContent) === null || _a === void 0 ? void 0 : _a.name,
        contents: []
    };
    const containsGenerateContentRequest = params.genera